/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.alibaba.fastjson.JSON;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.bean.HelpCate;
import com.qianjiang.system.service.HelpCateService;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class HelpCateController {
    private static final MyLogger LOGGER = new MyLogger(HelpCateController.class);
    private String page = "tohelpcate.htm";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    @Resource(name="helpCateService")
    private HelpCateService helpCateService;

    @RequestMapping(value={"/tohelpcate"})
    public ModelAndView toHelpCate(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        request.setAttribute("selectBean", (Object)selectBean);
        return new ModelAndView("jsp/system/helpcate", "pageBean", (Object)this.helpCateService.findByPageBean(pb, selectBean));
    }

    @RequestMapping(value={"/tohelpfl"})
    public ModelAndView toHelpCateMobile(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        ModelAndView modelAndView = new ModelAndView();
        ArrayList<HelpCate> cates = new ArrayList<HelpCate>();
        PageBean pbBean = this.helpCateService.findByPageBean(pb, selectBean);
        for (int i = 0; i < pbBean.getList().size(); ++i) {
            HelpCate cate = (HelpCate)pbBean.getList().get(i);
            cates.add(cate);
        }
        modelAndView.addObject("cates", cates);
        modelAndView.setViewName("mobileNew/helpFL");
        return modelAndView;
    }

    @RequestMapping(value={"/findhelpcateByName"}, produces={"text/json;charset=UTF-8"})
    @ResponseBody
    public String findHelpCateOneByName(HttpServletRequest request, String helpcateName) {
        LOGGER.debug(helpcateName);
        List list = this.helpCateService.findByHelpcateName(helpcateName);
        return JSON.toJSONString((Object)list);
    }

    @RequestMapping(value={"/addhelpcate"})
    public ModelAndView addHelpCate(MultipartHttpServletRequest request, HttpServletResponse response, @Valid HelpCate helpCate, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(this.page));
        }
        try {
            MultipartFile file = request.getFile("netLogo");
            if (file != null && !file.isEmpty()) {
                helpCate.setHelpcateImg(UploadUtil.uploadFileOne((MultipartFile)file));
            }
            this.helpCateService.insertHelpCate(helpCate);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u5e2e\u52a9\u5206\u7c7b", (String)(request.getSession().getAttribute(OPERAPATH) + ", \u6dfb\u52a0\u7528\u6237\u540d:" + customerName));
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u5e2e\u52a9\u5206\u7c7b\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(this.page));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/delhelpcate"})
    public ModelAndView delHelpCate(HttpServletRequest request, HttpServletResponse response) {
        try (PrintWriter pr = null;){
            pr = response.getWriter();
            pr.print(this.helpCateService.deleteHelpCate(request.getParameterValues("cateIds[]")));
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u5e2e\u52a9\u5206\u7c7b", (String)(request.getSession().getAttribute(OPERAPATH) + ", \u5220\u9664\u7528\u6237\u540d:" + customerName));
        }
        return null;
    }

    @RequestMapping(value={"/findhelpcateone"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public HelpCate findHelpCateOne(Long helpcateId) {
        return this.helpCateService.findByHelpcateId(helpcateId);
    }

    @RequestMapping(value={"/updatehelpcate"})
    public ModelAndView updateHelpCate(MultipartHttpServletRequest request, HttpServletResponse response, @Valid HelpCate helpCate, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(this.page));
        }
        try {
            MultipartFile file = request.getFile("netLogo");
            if (file != null && !file.isEmpty()) {
                helpCate.setHelpcateImg(UploadUtil.uploadFileOne((MultipartFile)file));
            }
            this.helpCateService.updateHelpCate(helpCate);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u5e2e\u52a9\u5206\u7c7b", (String)(request.getSession().getAttribute(OPERAPATH) + ", \u4fee\u6539\u7528\u6237\u540d:" + customerName));
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u5e2e\u52a9\u5206\u7c7b\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(this.page));
    }
}

