/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.bean.SMSConf;
import com.qianjiang.system.bean.SMSModel;
import com.qianjiang.system.controller.BaseController;
import com.qianjiang.system.service.SMSConfService;
import com.qianjiang.system.service.SMSModelService;
import com.qianjiang.util.MyLogger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SMSController
extends BaseController {
    private static final MyLogger logger = new MyLogger(SMSController.class);
    @Autowired
    private SMSConfService smsConfService;
    @Autowired
    private SMSModelService smsModelService;
    private static final String UPDATE_SMSCONF_JSP = "jsp/system/sms/sms_update";

    @RequestMapping(value={"/initSmsConf"})
    public ModelAndView initSmsConf(HttpServletRequest req, HttpServletResponse resp) {
        ModelAndView mav = new ModelAndView();
        try {
            SMSConf smsConf = this.smsConfService.querySmsConf();
            List smsConfList = this.smsModelService.querySmsModel();
            mav.addObject("smsConf", (Object)smsConf);
            mav.addObject("smsConfList", (Object)smsConfList);
            mav.setViewName(UPDATE_SMSCONF_JSP);
            logger.info((Object)"\u963f\u91cc\u5927\u4e8e\u77ed\u4fe1\u63a5\u53e3\u8bbe\u7f6e\u521d\u59cb\u5316\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u963f\u91cc\u5927\u4e8e\u77ed\u4fe1\u63a5\u53e3\u8bbe\u7f6e\u521d\u59cb\u5316\u5931\u8d25");
        }
        return mav;
    }

    @RequestMapping(value={"/updateSmsConf"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> updateSmsConf(HttpServletRequest req, HttpServletResponse resp, SMSConf smsConf) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Integer userId = ((Long)req.getSession().getAttribute("loginUserId")).intValue();
        String userName = (String)req.getSession().getAttribute("name");
        Date smsModifyTime = new Date();
        try {
            String[] ids = req.getParameterValues("id");
            String[] modelIds = req.getParameterValues("smsModelId");
            String[] modelContents = req.getParameterValues("smsModelContent");
            smsConf.setSmsModifyId(userId);
            smsConf.setSmsModifyName(userName);
            smsConf.setSmsModifyTime(smsModifyTime);
            int smsResult = this.smsConfService.updateSmsConf(smsConf);
            int smsModelResult = 0;
            for (int i = 0; i < ids.length; ++i) {
                SMSModel smsModel = new SMSModel();
                smsModel.setId(Integer.valueOf(Integer.parseInt(ids[i])));
                smsModel.setSmsModelId(modelIds[i].trim());
                smsModel.setSmsModelContent(modelContents[i].trim());
                smsModel.setSmsModelModifyId(userId);
                smsModel.setSmsModelModifyName(userName);
                smsModel.setSmsModelModifyTime(smsModifyTime);
                smsModelResult = this.smsModelService.updateSmsModel(smsModel);
            }
            if (smsResult > 0 && smsModelResult > 0) {
                OperaLogUtil.addOperaLog((HttpServletRequest)req, (String)userName, (String)"\u4fee\u6539\u963f\u91cc\u5927\u4e8e\u77ed\u4fe1\u901a\u77e5\u8bbe\u7f6e", (String)(req.getSession().getAttribute("operaPath") + ",\u7528\u6237\u540d:" + userName));
                logger.error("\u66f4\u65b0\u963f\u91cc\u5927\u4e8e\u77ed\u4fe1\u63a5\u53e3\u8bbe\u7f6e\u6210\u529f");
                resultMap.put("result", true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u66f4\u65b0\u963f\u91cc\u5927\u4e8e\u77ed\u4fe1\u63a5\u53e3\u8bbe\u7f6e\u5931\u8d25");
            resultMap.put("result", false);
        }
        return resultMap;
    }

    @RequestMapping(value={"/queryByVersion"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryByVersion(HttpServletRequest req, Long smsId, String smsVersion) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("smsId", smsId);
            paramMap.put("smsVersion", smsVersion);
            SMSConf smsConf = this.smsConfService.queryByVersion(paramMap);
            if (smsConf != null) {
                List smsConfList = this.smsModelService.querySmsModel();
                resultMap.put("smsConfList", smsConfList);
            } else {
                resultMap.put("smsConfList", null);
            }
            resultMap.put("smsConf", smsConf);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6839\u636e\u4e3b\u952e\u548c\u77ed\u4fe1\u7248\u672c\u67e5\u8be2\u77ed\u4fe1\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }
}

