/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.util;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class HttpRequest {
    public static String addUrl(String head, String tail) {
        if (head.endsWith("/")) {
            if (tail.startsWith("/")) {
                return head.substring(0, head.length() - 1) + tail;
            }
            return head + tail;
        }
        if (tail.startsWith("/")) {
            return head + tail;
        }
        return head + "/" + tail;
    }

    public static synchronized String postData(String url, Map<String, String> params, String codePage) throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(25000);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(30000);
        PostMethod method = new PostMethod(url);
        if (params != null) {
            method.getParams().setParameter("http.protocol.content-charset", (Object)codePage);
            method.setRequestBody(HttpRequest.assembleRequestParams(params));
        }
        String result = "";
        try {
            httpClient.executeMethod((HttpMethod)method);
            result = new String(method.getResponseBody(), codePage);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    public static synchronized String postData(String url, String codePage) throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(10000);
        GetMethod method = new GetMethod(url);
        String result = "";
        try {
            httpClient.executeMethod((HttpMethod)method);
            result = new String(method.getResponseBody(), codePage);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    private static synchronized NameValuePair[] assembleRequestParams(Map<String, String> data) {
        ArrayList<NameValuePair> nameValueList = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            nameValueList.add(new NameValuePair(entry.getKey(), entry.getValue()));
        }
        return nameValueList.toArray(new NameValuePair[nameValueList.size()]);
    }
}

