/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.controller;

import com.qianjiang.customer.bean.ChargeWithdraw;
import com.qianjiang.customer.bean.DepositInfo;
import com.qianjiang.customer.bean.TradeInfo;
import com.qianjiang.customer.service.ChargeWithdrawService;
import com.qianjiang.customer.service.DepositInfoService;
import com.qianjiang.customer.service.TradeInfoService;
import com.qianjiang.customer.vo.DepositInfoVo;
import com.qianjiang.deposit.service.impl.WithdrawService;
import com.qianjiang.manager.bean.Manager;
import com.qianjiang.manager.service.ManagerServiceInterface;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ChargeWithdrawController {
    private static final String PAGEBEAN = "pageBean";
    public static final MyLogger LOGGER = new MyLogger(ChargeWithdrawController.class);
    @Autowired
    private ChargeWithdrawService chargeWithdrawService;
    @Autowired
    private TradeInfoService tradeInfoService;
    @Autowired
    private DepositInfoService depositInfoService;
    @Autowired
    private WithdrawService withdrawService;
    @Autowired
    private ManagerServiceInterface managerMapper;

    @RequestMapping(value={"/initChargeWithdrawList"})
    public ModelAndView selectChargeWithdrawList(HttpServletRequest request, DepositInfoVo depositInfo, PageBean pageBean) {
        String status = "";
        try {
            depositInfo.setOrderStatus(null);
            status = request.getParameter("status");
            if (StringUtils.isNotEmpty((String)status)) {
                depositInfo.setOrderStatus(status);
            }
            pageBean.setUrl("initChargeWithdrawList.htm");
            LOGGER.info((Object)"\u67e5\u8be2\u4f1a\u5458\u63d0\u73b0\u8bb0\u5f55\uff01");
            pageBean = this.chargeWithdrawService.selectChargeWithdrawList(depositInfo, pageBean);
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        return new ModelAndView("jsp/customer/chargeWithdrawList", PAGEBEAN, (Object)pageBean).addObject("status", (Object)status);
    }

    @ResponseBody
    @RequestMapping(value={"/batchUpdateChargeWithdrawStatus"}, produces={"application/json;charset=UTF-8"})
    public int batchUpdateChargeWithdrawStatus(HttpServletRequest request) {
        int result = 0;
        try {
            String orderStatus = request.getParameter("orderStatus");
            String sendBack = request.getParameter("sendBack");
            String[] tags = request.getParameterValues("withdrawIds[]");
            if (orderStatus.equals("1")) {
                if (tags.length > 0 && tags != null) {
                    for (int i = 0; i < tags.length; ++i) {
                        Long tradeInfoId = Long.valueOf(tags[i]);
                        TradeInfo tradeInfo = this.tradeInfoService.getTradeInfoById(tradeInfoId);
                        tradeInfo.setOrderStatus(orderStatus);
                        tradeInfo.setReviewedRemark(sendBack);
                        tradeInfo.setPreOrderStatus("0");
                        result = this.tradeInfoService.updateTradeInfo(tradeInfo);
                        if (result != 1) continue;
                        result = this.updateDepositInfo(tradeInfo);
                    }
                }
            } else {
                Long[] withdrawIds = null;
                if (tags.length > 0 && tags != null) {
                    withdrawIds = new Long[tags.length];
                    for (int i = 0; i < tags.length; ++i) {
                        withdrawIds[i] = Long.valueOf(tags[i]);
                    }
                }
                TradeInfo tradeInfo = new TradeInfo();
                tradeInfo.setOrderStatus(orderStatus);
                tradeInfo.setTradeInfoIds(withdrawIds);
                tradeInfo.setReviewedRemark(sendBack);
                result = this.tradeInfoService.batchUpdateTradeInfo(tradeInfo);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/updateChargeWithdrawStatus"}, produces={"application/json;charset=UTF-8"})
    public int updateChargeWithdrawStatus(HttpServletRequest request) {
        int result = 0;
        try {
            String orderStatus = request.getParameter("orderStatus");
            String sendBack = request.getParameter("sendBack");
            String tradeInfoId = request.getParameter("tradeInfoId");
            TradeInfo tradeInfo = this.tradeInfoService.getTradeInfoById(Long.valueOf(Long.parseLong(tradeInfoId)));
            tradeInfo.setOrderStatus(orderStatus);
            tradeInfo.setReviewedRemark(sendBack);
            tradeInfo.setPreOrderStatus("0");
            if (orderStatus.equals("1")) {
                result = this.tradeInfoService.updateTradeInfo(tradeInfo);
                if (result == 1) {
                    result = this.updateDepositInfo(tradeInfo);
                }
            } else {
                result = this.tradeInfoService.updateTradeInfo(tradeInfo);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/selectChargeWithdrawById"}, produces={"application/json;charset=UTF-8"})
    public ChargeWithdraw selectChargeWithdrawById(Long withdrawId) {
        ChargeWithdraw chargeWithdraw = null;
        try {
            chargeWithdraw = this.chargeWithdrawService.selectChargeWithdrawById(withdrawId);
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        return chargeWithdraw;
    }

    @ResponseBody
    @RequestMapping(value={"/updateWithdrawPayStatus"}, produces={"application/json;charset=UTF-8"})
    public int updateWithdrawPayStatus(MultipartHttpServletRequest request, @Valid ChargeWithdraw chargeWithdraw) {
        LOGGER.debug("==========\u7ebf\u4e0b\u6253\u6b3e==========");
        int result = 0;
        try {
            TradeInfo tradeInfo = this.tradeInfoService.getTradeInfoById(chargeWithdraw.getTradeInfoId());
            MultipartFile file = request.getFile("payImg");
            if (file != null && !file.isEmpty()) {
                tradeInfo.setCertificateImg(UploadUtil.uploadFileOne((MultipartFile)file));
            }
            tradeInfo.setPayBillNum(chargeWithdraw.getPayBillNum());
            tradeInfo.setPayRemark(chargeWithdraw.getPayRemark());
            tradeInfo.setOrderStatus("3");
            tradeInfo.setPreOrderStatus("2");
            result = this.tradeInfoService.updateTradeInfo(tradeInfo);
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        return result;
    }

    public int updateDepositInfo(TradeInfo tradeInfo) {
        DepositInfo depositInfo = this.depositInfoService.selectDepositByCustId(tradeInfo.getCustomerId());
        depositInfo.setPreDeposit(depositInfo.getPreDeposit().add(tradeInfo.getOrderPrice()));
        depositInfo.setFreezePreDeposit(depositInfo.getFreezePreDeposit().subtract(tradeInfo.getOrderPrice()));
        int result = this.depositInfoService.updateDeposit(depositInfo);
        return result;
    }

    public Long getManagerId(String userName) {
        Long managerId = null;
        Manager manager = this.managerMapper.selectByName(userName);
        if (manager != null) {
            managerId = manager.getId();
        }
        return managerId;
    }
}

