/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.customer.controller;

import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.freight.bean.SysCity;
import com.qianjiang.freight.service.SysDistrictService;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.other.bean.CityBean;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.other.bean.DistrictBean;
import com.qianjiang.other.bean.ProvinceBean;
import com.qianjiang.other.bean.StreetBean;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class AddressSiteController {
    private static final MyLogger LOGGER = new MyLogger(AddressSiteController.class);
    private static final String ADDRESSURL = "customer/address.html";
    private static final String LOGIN = "/login";
    private static final String INDEX = "index.html";
    private static final String LOGGERINFO1 = "\u65b0\u6dfb\u52a0\u7684\u5730\u5740\u6536\u8d27\u4eba\u4e3a\u3010";
    private static final String LOGGERINFO2 = "\u65b0\u589e\u6536\u8d27\u5730\u5740";
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="TopAndBottomService")
    private TopAndBottomService topAndBottomService;
    @Resource(name="SysDistrictService")
    private SysDistrictService sysDistrictService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceInterface;

    private Long getLoginUserId(HttpServletRequest request) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        return customerId;
    }

    private boolean checkLoginStatus(HttpServletRequest request) {
        Long customerId = this.getLoginUserId(request);
        return customerId != null;
    }

    @RequestMapping(value={"/queryCustomerAddress"})
    public ModelAndView queryCustomerAddress(HttpServletRequest request, PageBean pb) {
        ModelAndView mav = new ModelAndView();
        pb.setUrl("queryCustomerAddress");
        try {
            if (this.checkLoginStatus(request)) {
                Long customerId = this.getLoginUserId(request);
                CustomerAllInfo customerAllInfo = this.customerServiceInterface.queryAddressByCustomerId(customerId);
                if (null != customerAllInfo.getCustomerUsername()) {
                    LOGGER.info((Object)("\u67e5\u8be2\u4f1a\u5458\u3010" + customerAllInfo.getCustomerUsername() + "\u3011\u6536\u8d27\u5730\u5740"));
                }
                mav.addObject("pb", (Object)this.customerServiceInterface.queryAddressByCustomerId(customerId, pb));
                mav.addObject("customer", (Object)customerAllInfo);
                mav.addObject("basicSet", (Object)this.basicSetService.findBasicSet());
                mav.setViewName("customer/newaddress");
            } else {
                mav.addObject("url", (Object)"/customerqueryCustomerAddress.htm");
                mav.setViewName("/login/redirect");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u6536\u8d27\u5730\u5740\u5931\u8d25" + e.getMessage());
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/queryCustAddressByCustId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public CustomerAllInfo queryCustAddressByCustId(String customerId, HttpServletRequest request) {
        CustomerAllInfo customerAllInfo = new CustomerAllInfo();
        try {
            if (this.checkLoginStatus(request) && this.getLoginUserId(request).equals(Long.valueOf(customerId)) && null != (customerAllInfo = this.customerServiceInterface.queryAddressByCustomerId(Long.valueOf(customerId))).getCustomerUsername()) {
                LOGGER.info((Object)("\u67e5\u8be2\u4f1a\u5458\u3010" + customerAllInfo.getCustomerUsername() + "\u3011\u6536\u8d27\u5730\u5740"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u524d\u53f0\u6240\u4f20\u7f16\u53f7\u67e5\u627e\u4f1a\u5458\u5730\u5740\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return customerAllInfo;
    }

    @RequestMapping(value={"/addCustomerAddress"})
    public ModelAndView addCustomerAddress(HttpServletRequest request, @Valid CustomerAddress address, BindingResult bindingResult) {
        ModelAndView mav = new ModelAndView();
        if (bindingResult.hasErrors()) {
            mav.setView((View)new RedirectView(request.getContextPath() + "/" + INDEX));
            return this.topAndBottomService.getTopAndBottom(mav);
        }
        try {
            if (this.checkLoginStatus(request)) {
                Long customerId = this.getLoginUserId(request);
                address.setCustomerId(customerId);
                this.customerServiceInterface.addCustomerAddress(address);
                CustomerAllInfo customerAllInfo = this.customerServiceInterface.queryAddressByCustomerId(customerId);
                if (null != customerAllInfo.getCustomerUsername()) {
                    OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)LOGGERINFO2, (String)(LOGGERINFO1 + address.getAddressName() + "\u3011"));
                    LOGGER.info((Object)("\u4f1a\u5458\u3010" + customerAllInfo.getCustomerUsername() + "\u3011\u65b0\u589e\u6536\u8d27\u4fe1\u606f\u6210\u529f\uff01"));
                }
                mav.setView((View)new RedirectView(request.getContextPath() + "/" + ADDRESSURL));
            } else {
                mav.setView((View)new RedirectView(request.getContextPath() + LOGIN));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6dfb\u52a0\u4f1a\u5458\u6536\u8d27\u5730\u5740\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @ResponseBody
    @RequestMapping(value={"/ajaxAddCustomerAddress"}, produces={"application/json;charset=UTF-8"})
    public boolean ajaxAddCustomerAddress(@Valid CustomerAddress address, BindingResult bindingResult, HttpServletRequest request) {
        boolean flag = false;
        if (bindingResult.hasErrors()) {
            return flag;
        }
        try {
            if (this.checkLoginStatus(request)) {
                Long customerId = this.getLoginUserId(request);
                address.setCustomerId(customerId);
                address.setAddressName(new String(address.getAddressName().getBytes("ISO-8859-1"), "utf-8"));
                address.setAddressDetail(new String(address.getAddressDetail().getBytes("ISO-8859-1"), "utf-8"));
                if (null != address.getAddressAlias()) {
                    address.setAddressAlias(new String(address.getAddressAlias().getBytes("ISO-8859-1"), "utf-8"));
                }
                this.customerServiceInterface.addCustomerAddress(address);
                flag = true;
                CustomerAllInfo customerAllInfo = this.customerServiceInterface.queryAddressByCustomerId(customerId);
                if (null != customerAllInfo.getCustomerUsername()) {
                    OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)LOGGERINFO2, (String)(LOGGERINFO1 + address.getAddressName() + "\u3011"));
                    LOGGER.info((Object)("\u4f1a\u5458\u3010" + customerAllInfo.getCustomerUsername() + "\u3011\u65b0\u589e\u6536\u8d27\u4fe1\u606f\u6210\u529f\uff01"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Ajax\u6dfb\u52a0\u4f1a\u5458\u6536\u8d27\u5730\u5740\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return flag;
    }

    @ResponseBody
    @RequestMapping(value={"/ajaxAddCustomerAddressFromOrder"}, produces={"application/json;charset=UTF-8"})
    public boolean ajaxAddCustomerAddressFromOrder(HttpServletRequest request, @Valid CustomerAddress address, BindingResult bindingResult) {
        boolean flag = false;
        if (bindingResult.hasErrors()) {
            return flag;
        }
        try {
            if (this.checkLoginStatus(request)) {
                Long customerId = this.getLoginUserId(request);
                address.setCustomerId(customerId);
                PageBean pb = new PageBean();
                if (this.customerServiceInterface.queryAddressByCustomerId(customerId, pb).getRows() == 0) {
                    address.setIsDefault("1");
                }
                this.customerServiceInterface.addCustomerAddress(address);
                flag = true;
                CustomerAllInfo customerAllInfo = this.customerServiceInterface.queryAddressByCustomerId(customerId);
                if (null != customerAllInfo.getCustomerUsername()) {
                    OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)LOGGERINFO2, (String)(LOGGERINFO1 + address.getAddressName() + "\u3011"));
                    LOGGER.info((Object)("\u4f1a\u5458\u3010" + customerAllInfo.getCustomerUsername() + "\u3011\u4fdd\u5b58\u5730\u5740\u6210\u529f\uff01"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Ajax\u6dfb\u52a0\u4f1a\u5458\u6536\u8d27\u5730\u5740\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return flag;
    }

    @RequestMapping(value={"/deleteCustAddress"})
    public ModelAndView deleteCustAddress(HttpServletRequest request, Long addressId) {
        ModelAndView mav = new ModelAndView();
        try {
            if (this.checkLoginStatus(request)) {
                CustomerAddress address = this.customerServiceInterface.queryCustAddress(addressId);
                if (address != null && this.getLoginUserId(request).equals(address.getCustomerId())) {
                    this.customerServiceInterface.deleteCustAddress(addressId);
                    Long customerId = this.getLoginUserId(request);
                    CustomerAllInfo customerAllInfo = this.customerServiceInterface.queryAddressByCustomerId(customerId);
                    if (null != customerAllInfo.getCustomerUsername() && null != address.getAddressName()) {
                        OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)"\u5220\u9664\u6536\u8d27\u5730\u5740", (String)("\u5220\u9664\u7684\u5730\u5740\u6536\u8d27\u4eba\u4e3a\u3010" + address.getAddressName() + "\u3011"));
                    }
                }
                mav.setView((View)new RedirectView(request.getContextPath() + "/" + ADDRESSURL));
            } else {
                mav.setView((View)new RedirectView(request.getContextPath() + LOGIN));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5220\u9664\u6536\u83b7\u5730\u5740\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/queryCustAddress"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public CustomerAddress queryCustAddress(Long addressId, HttpServletRequest request) {
        CustomerAddress address = new CustomerAddress();
        try {
            Long customerId;
            if (this.checkLoginStatus(request) && (customerId = this.getLoginUserId(request)).equals(address.getCustomerId())) {
                address = this.customerServiceInterface.queryCustAddress(addressId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u627e\u6536\u8d27\u5730\u5740\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return address;
    }

    @RequestMapping(value={"/queryCustAddressForSubOrder"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryCustAddressByCustId(HttpServletRequest request) {
        HashMap<String, List> result = null;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            List addresses = this.customerServiceInterface.selectAddressByCustomerId(customerId);
            if (CollectionUtils.isNotEmpty((Collection)addresses)) {
                result = new HashMap<String, List>();
                result.put("addresses", addresses);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u4f1a\u5458id\u67e5\u8be2\u4f1a\u5458\u5730\u5740\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/modifyCustAddress"})
    public ModelAndView modifyCustAddress(HttpServletRequest request, @Valid CustomerAddress address, BindingResult bindingResult) {
        ModelAndView mav = new ModelAndView();
        if (bindingResult.hasErrors()) {
            mav.setView((View)new RedirectView(request.getContextPath() + "/" + INDEX));
            return this.topAndBottomService.getTopAndBottom(mav);
        }
        try {
            if (this.checkLoginStatus(request)) {
                if (this.getLoginUserId(request).equals(address.getCustomerId())) {
                    this.customerServiceInterface.modifyCustAddress(address);
                    mav.setView((View)new RedirectView(request.getContextPath() + "/" + ADDRESSURL));
                    Long customerId = this.getLoginUserId(request);
                    CustomerAllInfo customerAllInfo = this.customerServiceInterface.queryAddressByCustomerId(customerId);
                    if (null != customerAllInfo.getCustomerUsername() && null != address.getAddressName()) {
                        OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)"\u4fee\u6539\u6536\u8d27\u5730\u5740", (String)("\u66f4\u65b0\u7684\u5730\u5740\u6536\u8d27\u4eba\u4e3a\u3010" + address.getAddressName() + "\u3011"));
                    }
                } else {
                    mav.setView((View)new RedirectView(request.getContextPath() + LOGIN));
                }
            } else {
                mav.setView((View)new RedirectView(request.getContextPath() + LOGIN));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4fee\u6539\u6536\u8d27\u5730\u5740\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @ResponseBody
    @RequestMapping(value={"/modifyIsDefaultAddressForOrder"}, produces={"application/json;charset=UTF-8"})
    public void modifyIsDefaultAddressForOrder(HttpServletRequest request, String addressId) {
        Long customerId = this.getLoginUserId(request);
        this.customerServiceInterface.modifyIsDefaultAddress(request, customerId, addressId);
    }

    @RequestMapping(value={"/modifyIsDefaultAddress"})
    public ModelAndView modifyIsDefaultAddress(HttpServletRequest request, Long customerId, String addressId) {
        ModelAndView mav = new ModelAndView();
        try {
            if (this.checkLoginStatus(request)) {
                CustomerAddress address = this.customerServiceInterface.queryCustAddress(Long.valueOf(addressId));
                if (this.getLoginUserId(request).equals(address.getCustomerId())) {
                    this.customerServiceInterface.modifyIsDefaultAddress(request, customerId, addressId);
                    mav.setView((View)new RedirectView(request.getContextPath() + "/" + ADDRESSURL));
                } else {
                    mav.setView((View)new RedirectView(request.getContextPath() + LOGIN));
                }
            } else {
                mav.setView((View)new RedirectView(request.getContextPath() + LOGIN));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4fee\u6539\u9ed8\u8ba4\u5730\u5740\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/getSiteAllProvince"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<ProvinceBean> getAllProvince() {
        return this.customerServiceInterface.selectAllProvince();
    }

    @RequestMapping(value={"/getSiteAllCityByPid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<CityBean> getAllCityByPid(Long provinceId) {
        ProvinceBean province = this.customerServiceInterface.selectprovinceByPid(provinceId);
        if (null != province.getProvinceName()) {
            LOGGER.info((Object)("\u67e5\u8be2\u3010" + province.getProvinceName() + "\u3011\u7701\u4e0b\u9762\u6240\u5bf9\u5e94\u7684\u57ce\u5e02\uff01"));
        }
        return this.customerServiceInterface.selectAllCityByPid(provinceId);
    }

    @RequestMapping(value={"/getSiteAllDistrictByCid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<DistrictBean> getAllDistrictByCid(Long cityId) {
        SysCity sysCity;
        if (null != cityId && null != (sysCity = this.sysDistrictService.selectCityById(cityId)).getCityName()) {
            LOGGER.info((Object)("\u83b7\u53d6\u3010" + sysCity.getCityName() + "\u3011\u4e0b\u9762\u6240\u6709\u7684\u533a\u53bf"));
        }
        return this.customerServiceInterface.selectAllDistrictByCid(cityId);
    }

    @RequestMapping(value={"/getSiteAllStreetByDid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<StreetBean> getAllStreetByDid(Long dId) {
        DistrictBean districtBean = this.customerServiceInterface.selectDistrictBeanById(dId);
        if (null != districtBean.getDistrictName()) {
            LOGGER.info((Object)("\u83b7\u53d6\u3010" + districtBean.getDistrictName() + "\u3011\u4e0b\u9762\u6240\u6709\u7684\u8857\u9053\u4fe1\u606f"));
        }
        return this.customerServiceInterface.getAllStreetByDid(dId);
    }

    @RequestMapping(value={"/iscusaddslegal"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean isCusAddsLegal(HttpServletRequest request) {
        boolean flag = false;
        try {
            if (this.checkLoginStatus(request)) {
                Long customerId = this.getLoginUserId(request);
                flag = this.customerServiceInterface.isCustomerAddressNumLegal(customerId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u5224\u65ad\u7528\u6237\u662f\u5426\u53ef\u4ee5\u65b0\u589e\u5730\u5740\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return flag;
    }
}

