/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.customer.deposit.controller;

import com.qianjiang.deposit.bean.Deposit;
import com.qianjiang.deposit.service.impl.DepositService;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.system.service.PayService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class RechargeController {
    private static final String PAYLIST = "payList";
    @Autowired
    TopAndBottomService topAndBottomService;
    @Resource(name="payService")
    private PayService payService;
    @Autowired
    DepositService depositService;

    @RequestMapping(value={"/deposit/rechargeview"})
    public ModelAndView rechargeView(HttpServletRequest request) {
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        if (customerId == null) {
            ModelAndView mav = new ModelAndView("/login/redirect");
            return this.topAndBottomService.getTopAndBottom(mav);
        }
        ModelAndView mav = new ModelAndView("deposit/recharge");
        mav.addObject("customerId", (Object)customerId);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(PAYLIST, this.payService.queryAllPaySet());
        mav.addObject("map", paramMap);
        paramMap.put("customerId", customerId);
        List list = this.depositService.depositList(paramMap);
        int size = 0;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            size = list.size();
        }
        Deposit tDeposit = null;
        BigDecimal total = BigDecimal.valueOf(0.0);
        for (int i = 0; i < size; ++i) {
            tDeposit = (Deposit)list.get(i);
            if (tDeposit.getPreDeposit() != null) {
                total = total.add(tDeposit.getPreDeposit());
            }
            if (tDeposit.getFreezePreDeposit() == null) continue;
            total = total.add(tDeposit.getFreezePreDeposit());
        }
        mav.addObject("totalDeposit", (Object)total);
        return this.topAndBottomService.getTopAndBottom(mav);
    }
}

