/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.customer.controller;

import com.qianjiang.coupon.bean.Coupon;
import com.qianjiang.coupon.bean.CouponNo;
import com.qianjiang.coupon.service.CouponNoService;
import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.system.bean.BasicSet;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class CouponSiteController {
    private static final MyLogger LOGGER = new MyLogger(CouponSiteController.class);
    private static final String CUSTOMERID = "customerId";
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceInterface;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    private CouponService couponService;
    private CouponNoService couponNoService;
    private TopAndBottomService topAndBottomService;

    @RequestMapping(value={"coupon/queryCouponList"})
    public ModelAndView queryMyCoupon(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        mav.addObject("couponLists", (Object)this.couponService.selectCouponList_site());
        mav.setViewName("coupon/couponlist");
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/queryMyCoupon"})
    public ModelAndView queryMyCoupon(HttpServletRequest request, PageBean pageBean, String codeStatus) {
        ModelAndView mav = new ModelAndView();
        Long cId = (Long)request.getSession().getAttribute(CUSTOMERID);
        try {
            if (this.checkLoginStatus(request)) {
                if (StringUtils.isEmpty((String)codeStatus)) {
                    codeStatus = "1";
                }
                pageBean.setUrl("mycoupon-" + Integer.valueOf(codeStatus));
                PageBean myCouponList = this.couponService.myCouponList(pageBean, cId, codeStatus);
                BasicSet findBasicSet = this.basicSetService.findBasicSet();
                mav.addObject("pb", (Object)myCouponList);
                mav.addObject("basicSet", (Object)findBasicSet);
                mav.addObject("codeStatus", (Object)codeStatus);
                mav.setViewName("customer/newmycoupon");
            } else {
                mav.addObject("url", (Object)"/mycoupon/1");
                mav.setViewName("/login/redirect");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u67e5\u8be2\u6211\u7684\u4f18\u60e0\u5238\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"getOffCoupon"})
    public ModelAndView getOffCoupon(HttpServletRequest request, Long couponId) {
        ModelAndView mav = new ModelAndView();
        Coupon coupon = this.couponService.searchCouponById(couponId);
        try {
            Long cId = (Long)request.getSession().getAttribute(CUSTOMERID);
            if (cId == null) {
                mav = new ModelAndView((View)new RedirectView("login.html"));
            } else {
                CustomerAllInfo customer = this.customerServiceInterface.queryCustomerById(cId);
                if (null != customer.getCustomerUsername() && null != coupon.getCouponName()) {
                    OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customer.getCustomerUsername(), (String)"\u9886\u53d6\u4f18\u60e0\u5238", (String)("\u4f18\u60e0\u5238\u540d\u79f0\u3010" + coupon.getCouponName() + "\u3011"));
                    LOGGER.info((Object)("\u4f1a\u5458\u3010" + customer.getCustomerUsername() + "\u3011\u9886\u53d6\u4f18\u60e0\u5238\u6210\u529f\uff01"));
                }
                int counts = this.couponNoService.selectReadyGet(couponId, cId);
                int countAll = this.couponNoService.selectCountAllByCouponId(couponId);
                if (counts < coupon.getCouponGetNo().intValue()) {
                    if (countAll - this.couponNoService.queryUsedCountByCouponId(couponId).intValue() > 0) {
                        Date d = new Date();
                        if (coupon.getCouponStartTime().before(d) && coupon.getCouponEndTime().after(d)) {
                            CouponNo couponNo = this.couponNoService.selectNoByCouponIdByStatus(couponId);
                            if (couponNo != null) {
                                int count = this.couponNoService.updateCouponCustomer(couponNo.getCodeId(), cId);
                                if (count > 0) {
                                    mav.setViewName("customer/couponpage");
                                } else {
                                    mav.setViewName("customer/couponwrongpage");
                                }
                            } else {
                                mav = new ModelAndView((View)new RedirectView("login.html"));
                            }
                        } else {
                            mav.setViewName("customer/couponstart");
                        }
                    } else {
                        mav.setViewName("customer/couponwrongpage");
                    }
                } else {
                    mav.setViewName("customer/coupongotpage");
                }
            }
            ModelAndView modelAndView = this.topAndBottomService.getTopAndBottom(mav);
            return modelAndView;
        }
        finally {
            mav = null;
        }
    }

    private boolean checkLoginStatus(HttpServletRequest request) {
        return request.getSession().getAttribute(CUSTOMERID) != null;
    }

    public CouponNoService getCouponNoService() {
        return this.couponNoService;
    }

    @Resource(name="CouponNoService")
    public void setCouponNoService(CouponNoService couponNoService) {
        this.couponNoService = couponNoService;
    }

    public CouponService getCouponService() {
        return this.couponService;
    }

    @Resource(name="CouponService")
    public void setCouponService(CouponService couponService) {
        this.couponService = couponService;
    }

    public TopAndBottomService getTopAndBottomService() {
        return this.topAndBottomService;
    }

    @Resource(name="TopAndBottomService")
    public void setTopAndBottomService(TopAndBottomService topAndBottomService) {
        this.topAndBottomService = topAndBottomService;
    }
}

