/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.customer.controller;

import com.qianjiang.common.util.EmailUtils;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.redis.RedisAdapter;
import com.qianjiang.redis.RedisUtil;
import com.qianjiang.temp.service.MegawizardService;
import com.qianjiang.temp.service.TempService;
import com.qianjiang.util.MyLogger;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class FindPwdController {
    private static final MyLogger LOGGER = new MyLogger(FindPwdController.class);
    private CustomerServiceMapper customerServiceInterface;
    private EmailUtils emailUtils;
    private TopAndBottomService topAndBottomService;
    private MegawizardService megawizardSerivce;
    private TempService tempService;

    @RequestMapping(value={"/findpwd"})
    public ModelAndView toFindPwd() {
        return this.topAndBottomService.getBottom(new ModelAndView("/customer/find_code1").addObject("type", (Object)"mobile"));
    }

    @RequestMapping(value={"/validuser"})
    public ModelAndView validUser(HttpServletRequest request, String type, String msg, String enterValue) {
        String patchca;
        request.getSession().setAttribute("flg", (Object)"0");
        if (enterValue != null && !enterValue.equals(patchca = (String)RedisAdapter.getNew((String)RedisUtil.getRedisKeyByKeyAndParameter((String)RedisUtil.CAPTCHA, (String)request.getSession().getId())))) {
            return new ModelAndView((View)new RedirectView(request.getContextPath() + "/validuser-1.html"));
        }
        try {
            CustomerAllInfo cust = this.customerServiceInterface.selectCustomerByUname((String)request.getSession().getAttribute("uname"));
            request.getSession().setAttribute("user", (Object)cust);
            request.getSession().setAttribute("uId", (Object)cust.getCustomerId());
            if (type == null) {
                request.getSession().setAttribute("utype", (Object)"mobile");
            } else {
                request.getSession().setAttribute("utype", (Object)type);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u9a8c\u8bc1\u7528\u6237\u9519\u8bef", (Throwable)e);
            return this.topAndBottomService.getBottom(new ModelAndView("/customer/find_code2")).addObject("explain", (Object)this.megawizardSerivce.selectByType(4, Long.valueOf(Long.parseLong(this.tempService.getCurrTemp().getTempId() + ""))));
        }
        String message = null;
        if ("1".equals(msg)) {
            message = "\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef";
        } else if ("2".equals(msg)) {
            message = "\u624b\u673a\u9a8c\u8bc1\u7801\u5df2\u7ecf\u5931\u6548";
        } else if ("3".equals(msg)) {
            message = "\u8bf7\u8f93\u5165\u624b\u673a\u9a8c\u8bc1\u7801";
        }
        return this.topAndBottomService.getBottom(new ModelAndView("/customer/find_code2")).addObject("explain", (Object)this.megawizardSerivce.selectByType(4, Long.valueOf(Long.parseLong(this.tempService.getCurrTemp().getTempId() + "")))).addObject("msg", (Object)message);
    }

    @RequestMapping(value={"/resetpwd"})
    public ModelAndView toReSetPwd(HttpServletRequest request, String code, String emailCode) {
        if (StringUtils.isBlank((CharSequence)code) && StringUtils.isBlank((CharSequence)emailCode)) {
            return new ModelAndView((View)new RedirectView(request.getContextPath() + "/validuser-1.html"));
        }
        int result = 0;
        result = StringUtils.isNotBlank((CharSequence)code) ? this.customerServiceInterface.getMCode(request, code) : this.validEmailCode(request, emailCode);
        if (result == 0) {
            return new ModelAndView((View)new RedirectView(request.getContextPath() + "/validuser-1.html"));
        }
        if (result == -1) {
            return new ModelAndView((View)new RedirectView(request.getContextPath() + "/validuser-2.html"));
        }
        if (result == -2) {
            return new ModelAndView((View)new RedirectView(request.getContextPath() + "/validuser-3.html"));
        }
        request.getSession().setAttribute("flg", (Object)"1");
        return this.topAndBottomService.getBottom(new ModelAndView("/customer/find_code3"));
    }

    private int validEmailCode(HttpServletRequest request, String emailCode) {
        Object code = request.getSession().getAttribute("email_checkCode");
        if (code == null) {
            return 0;
        }
        if (Objects.equals(String.valueOf(code), emailCode)) {
            request.getSession().setAttribute("email_checkCode", null);
            return 1;
        }
        return 0;
    }

    @RequestMapping(value={"/updatesucess"})
    public ModelAndView updateSucess(HttpServletRequest request) {
        return this.topAndBottomService.getBottom(new ModelAndView("/customer/find_code4"));
    }

    @RequestMapping(value={"/checkusernameflag"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Long checkUsernameFlag(HttpServletRequest request, String username, String enterValue) {
        String patchca = (String)RedisAdapter.getNew((String)RedisUtil.getRedisKeyByKeyAndParameter((String)RedisUtil.CAPTCHA, (String)request.getSession().getId()));
        if (null != enterValue) {
            LOGGER.info((Object)("code in session is :" + patchca));
            if (!enterValue.equals(patchca)) {
                return 2L;
            }
        }
        if (null != username) {
            LOGGER.info((Object)("\u9a8c\u8bc1\u7528\u6237\u540d\u3010" + username + "\u3011\u662f\u5426\u5b58\u5728\uff01"));
        }
        request.getSession().setAttribute("uname", (Object)username);
        return this.customerServiceInterface.checkUsernameFlag(username);
    }

    @RequestMapping(value={"/sendeamil"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int sendEamil(HttpServletRequest request, String email) {
        if (request.getSession().getAttribute("customerId") != null) {
            CustomerAllInfo user = (CustomerAllInfo)request.getSession().getAttribute("cust");
            user.setCustomerId((Long)request.getSession().getAttribute("customerId"));
            user.setInfoEmail(email);
            request.setAttribute("email", (Object)email);
            if (this.emailUtils.sendBindEmail(request, user) == 1) {
                return this.customerServiceInterface.updateFindPwdCode(user);
            }
            return 0;
        }
        return -1;
    }

    @RequestMapping(value={"/newsendeamil"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int newsendeamil(HttpServletRequest request) {
        CustomerAllInfo user = (CustomerAllInfo)request.getSession().getAttribute("user");
        if (null != user) {
            request.setAttribute("email", (Object)user.getInfoEmail());
            if (this.emailUtils.forgetsendBindEmail(request, user) == 1) {
                return this.customerServiceInterface.updateFindPwdCode(user);
            }
            return 0;
        }
        return -1;
    }

    @RequestMapping(value={"/sendsuccess"})
    public ModelAndView sendSucess(HttpServletRequest request, String email) {
        return this.topAndBottomService.getBottom(new ModelAndView("/customer/sendemailsucc"));
    }

    @RequestMapping(value={"/validpwdemail"})
    public ModelAndView validPwdEmail(HttpServletRequest request, String checkCode, Long d) {
        int result = this.customerServiceInterface.validPwdEmail(request, checkCode, d);
        if (result == 1) {
            return this.topAndBottomService.getBottom(new ModelAndView("redirect:resetpwd.htm"));
        }
        return this.topAndBottomService.getBottom(new ModelAndView("/customer/sendsuccess").addObject("eFlag", (Object)result));
    }

    public CustomerServiceMapper getCustomerServiceInterface() {
        return this.customerServiceInterface;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceInterface(CustomerServiceMapper customerServiceInterface) {
        this.customerServiceInterface = customerServiceInterface;
    }

    public TopAndBottomService getTopAndBottomService() {
        return this.topAndBottomService;
    }

    @Resource(name="TopAndBottomService")
    public void setTopAndBottomService(TopAndBottomService topAndBottomService) {
        this.topAndBottomService = topAndBottomService;
    }

    public EmailUtils getEmailUtils() {
        return this.emailUtils;
    }

    @Resource(name="emailUtils")
    public void setEmailUtils(EmailUtils emailUtils) {
        this.emailUtils = emailUtils;
    }

    public MegawizardService getMegawizardSerivce() {
        return this.megawizardSerivce;
    }

    @Resource(name="MegawizardService")
    public void setMegawizardSerivce(MegawizardService megawizardSerivce) {
        this.megawizardSerivce = megawizardSerivce;
    }

    public TempService getTempService() {
        return this.tempService;
    }

    @Resource(name="TempService")
    public void setTempService(TempService tempService) {
        this.tempService = tempService;
    }
}

