/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.order.controller;

import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.order.bean.OrderVice;
import com.qianjiang.order.service.OrderViceService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.site.groupon.service.GrouponService;
import com.qianjiang.temp.service.MegawizardService;
import com.qianjiang.temp.service.TempService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class MarketOrderController {
    public static final MyLogger LOGGER = new MyLogger(MarketOrderController.class);
    public static final String OTYPE = "oType";
    @Resource(name="OrderViceService")
    private OrderViceService service;
    @Resource(name="GrouponService")
    private GrouponService grouponservice;
    private TempService tempService;
    private MegawizardService megawizardSerivce;
    private CustomerServiceMapper customerServiceInterface;
    private TopAndBottomService topAndBottomService;

    @RequestMapping(value={"marketorders"})
    public ModelAndView orderViceListByRush(HttpServletRequest request, PageBean pb, String date, String type) {
        ModelAndView mav;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (this.checkLoginStatus(request)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("customerId", (Long)request.getSession().getAttribute("customerId"));
            paramMap.put("date", date);
            paramMap.put("type", type);
            paramMap.put(OTYPE, "1");
            pb.setUrl("customer/marketorders");
            resultMap.put("type", type);
            resultMap.put(OTYPE, "1");
            resultMap.put("date", date);
            resultMap.put("pb", (String)this.grouponservice.selectOrderList(paramMap, pb));
            mav = new ModelAndView("customer/newmarketorder").addAllObjects(resultMap);
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/marketorders.html");
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"marketordergrounp"})
    public ModelAndView orderViceListByGroup(HttpServletRequest request, PageBean pb, String date, String type, String oType) {
        ModelAndView mav;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (this.checkLoginStatus(request)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("customerId", (Long)request.getSession().getAttribute("customerId"));
            paramMap.put("date", date);
            paramMap.put("type", type);
            paramMap.put(OTYPE, "0");
            pb.setUrl("customer/marketordergrounp");
            resultMap.put("type", type);
            resultMap.put(OTYPE, "0");
            resultMap.put("date", date);
            resultMap.put("pb", (String)this.grouponservice.selectOrderList(paramMap, pb));
            mav = new ModelAndView("customer/newgrouponorder").addAllObjects(resultMap);
        } else {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/marketordergrounp.html");
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"selectrushdetails"})
    public ModelAndView selectDetails(Long orderId, HttpServletRequest request) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (this.checkLoginStatus(request)) {
            OrderVice orderVice = this.service.selectDetails(orderId);
            if (null != orderVice.getOrderCode()) {
                LOGGER.info((Object)("\u83b7\u53d6\u8ba2\u5355\u3010" + orderVice.getOrderCode() + "\u3011\u8be6\u60c5"));
            }
            ModelAndView mav = new ModelAndView("customer/marketdetails");
            resultMap.put("order", orderVice);
            resultMap.put("unpay", this.megawizardSerivce.selectByType(5, Long.valueOf(Long.parseLong(this.tempService.getCurrTemp().getTempId() + ""))));
            resultMap.put("pay", this.megawizardSerivce.selectByType(0, Long.valueOf(Long.parseLong(this.tempService.getCurrTemp().getTempId() + ""))));
            mav.addAllObjects(resultMap);
            return this.topAndBottomService.getTopAndBottom(mav);
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/login.html?url=customer/selectrushdetails-" + orderId + ".html"));
    }

    @RequestMapping(value={"/comfirmofmarkertorder"})
    public ModelAndView comfirmomarket(HttpServletRequest request, Long orderId, String fromUrl) {
        ModelAndView mav = null;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        CustomerAllInfo customerAllInfo = this.customerServiceInterface.selectByPrimaryKey(customerId);
        if (customerId == null) {
            mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/giftorder.html");
        } else {
            int result = this.service.updateOrderViceByOrderId(orderId);
            OrderVice orderVice = this.service.selectDetails(orderId);
            if (null != orderVice.getOrderCode() && 1 == result) {
                OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)"\u66f4\u6539\u8ba2\u5355\u72b6\u6001", (String)("\u6539\u8ba2\u5355\u72b6\u6001-->\u786e\u8ba4\u6536\u8d27-->\u8ba2\u5355\u53f7\u3010" + orderVice.getOrderCode() + "\u3011-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername()));
            }
            if ("index".equals(fromUrl)) {
                mav = new ModelAndView((View)new RedirectView(request.getContextPath() + "/customer" + "/index.html"));
            } else if ("marketorders".equals(fromUrl)) {
                mav = new ModelAndView((View)new RedirectView(request.getContextPath() + "/customer" + "/marketorders.html"));
            } else if ("marketordergrounp".equals(fromUrl)) {
                mav = new ModelAndView((View)new RedirectView(request.getContextPath() + "/customer" + "/marketordergrounp.html"));
            }
        }
        return mav;
    }

    private boolean checkLoginStatus(HttpServletRequest request) {
        return request.getSession().getAttribute("cust") != null || request.getSession().getAttribute("user") != null;
    }

    public TopAndBottomService getTopAndBottomService() {
        return this.topAndBottomService;
    }

    @Resource(name="TopAndBottomService")
    public void setTopAndBottomService(TopAndBottomService topAndBottomService) {
        this.topAndBottomService = topAndBottomService;
    }

    public MegawizardService getMegawizardSerivce() {
        return this.megawizardSerivce;
    }

    @Resource(name="MegawizardService")
    public void setMegawizardSerivce(MegawizardService megawizardSerivce) {
        this.megawizardSerivce = megawizardSerivce;
    }

    public TempService getTempService() {
        return this.tempService;
    }

    @Resource(name="TempService")
    public void setTempService(TempService tempService) {
        this.tempService = tempService;
    }

    public CustomerServiceMapper getCustomerServiceInterface() {
        return this.customerServiceInterface;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceInterface(CustomerServiceMapper customerServiceInterface) {
        this.customerServiceInterface = customerServiceInterface;
    }
}

