/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.shoppingcart.controller;

import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.promotion.bean.Promotion;
import com.qianjiang.promotion.bean.PromotionRush;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.promotion.service.RushCustomerService;
import com.qianjiang.site.shoppingcart.bean.ShoppingCart;
import com.qianjiang.site.shoppingcart.service.ShoppingCartService;
import com.qianjiang.system.address.bean.ShoppingCartWareUtil;
import com.qianjiang.system.address.service.ShoppingCartAddressService;
import com.qianjiang.system.bean.BasicSet;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ShoppingCartController {
    private static final MyLogger LOGGER = new MyLogger(ShoppingCartController.class);
    private static final String REDIRECT = "myshoppingcart.html";
    private static final String PROINFO = "110012";
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="ShoppingCartService1")
    private ShoppingCartService shoppingCartService;
    @Resource(name="MarketingService")
    private PromotionService marketingService;
    @Resource(name="rushCustomerService")
    private RushCustomerService rushCustomerService;
    @Resource(name="TopAndBottomService")
    private TopAndBottomService topAndBottomService;
    @Resource(name="GoodsProductService")
    private GoodsProductService productService;
    @Resource(name="OrderService")
    private OrderService orderService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceInterface;
    @Autowired
    private ShoppingCartAddressService shoppingCartAddressService;

    @RequestMapping(value={"/myshoppingcart"})
    public ModelAndView shoppingCart(HttpServletRequest request, PageBean pageBean, HttpServletResponse response) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        request.getSession().setAttribute("tok", (Object)UUID.randomUUID().toString());
        try {
            Map shopMap = this.shoppingCartService.shopCartMap(customerId, request, response);
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            BasicSet findBasicSet = this.basicSetService.findBasicSet();
            mav.addObject("cartMap", (Object)shopMap);
            mav.addObject("wareUtil", (Object)wareUtil);
            mav.addObject("basicSet", (Object)findBasicSet);
            mav.addObject("sx", (Object)request.getSession().getAttribute("tok").toString());
            mav.addObject("indexUrl", (Object)this.getIndexViewUrl(request));
            mav.addObject("list", (Object)request.getParameter("list"));
            response.setHeader("Cache-Control", "no-store");
            response.setDateHeader("Expires", 0L);
            response.setHeader("Pragma", "no-cache");
            mav.setViewName("shoppingcart/shoppingcart");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u8d2d\u7269\u8f66\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.topAndBottomService.getSimpleTopAndBottom(mav);
    }

    @RequestMapping(value={"/addProductToShopCarNew"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int addProductToShopCarNew(HttpServletRequest request, HttpServletResponse response, Long goodsNum, Long productId, Long distinctId) {
        int result = 0;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            if (customerId != null) {
                Integer num = 0;
                Integer cartgoodsNum = 0;
                List marketingList = this.marketingService.selectMarketingByGoodsInfoId(productId, null, null);
                if (marketingList != null && marketingList.size() == 1 && "11".equals(((Promotion)marketingList.get(0)).getCodexType())) {
                    Integer allNum;
                    List shoppingCarts = this.shoppingCartService.selectShoppingCartListByCustomerId(customerId);
                    if (shoppingCarts != null && shoppingCarts.size() > 0) {
                        for (ShoppingCart sc : shoppingCarts) {
                            if (sc.getGoodsInfoId().intValue() != productId.intValue()) continue;
                            cartgoodsNum = sc.getGoodsNum().intValue();
                        }
                    }
                    if ((allNum = Integer.valueOf(num + cartgoodsNum + goodsNum.intValue())) > ((PromotionRush)((Promotion)marketingList.get(0)).getRushs().get(0)).getRushLimitation()) {
                        result = -2;
                        return result;
                    }
                }
            }
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            ShoppingCart shoppingCart = new ShoppingCart();
            shoppingCart.setDistinctId(distinctId == null ? wareUtil.getDistrictId() : distinctId);
            shoppingCart.setGoodsInfoId(productId);
            shoppingCart.setGoodsNum(goodsNum);
            shoppingCart.setCustomerId(customerId);
            shoppingCart.setShoppingCartTime(new Date());
            shoppingCart.setDelFlag("0");
            result = this.shoppingCartService.addShoppingCart(shoppingCart, request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6dfb\u52a0\u8d2d\u7269\u8f66\u5931\u8d25" + e.getMessage());
        }
        return result;
    }

    @RequestMapping(value={"/goBuy"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int goBuy(HttpServletRequest request, HttpServletResponse response, Long goodsNum, Long productId, Long distinctId) {
        int result = 0;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            if (customerId == null) {
                result = -1;
                return result;
            }
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            ShoppingCart shoppingCart = new ShoppingCart();
            shoppingCart.setDistinctId(distinctId == null ? wareUtil.getDistrictId() : distinctId);
            shoppingCart.setGoodsInfoId(productId);
            shoppingCart.setGoodsNum(goodsNum);
            shoppingCart.setCustomerId(customerId);
            shoppingCart.setShoppingCartTime(new Date());
            shoppingCart.setDelFlag("0");
            result = this.shoppingCartService.goBuy(request, response, shoppingCart);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u7acb\u5373\u8d2d\u4e70\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/changeshopstatus"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String changeShopStatus(Long shoppingId, String status, HttpServletRequest request, HttpServletResponse response) {
        return this.shoppingCartService.changeShopStatus(shoppingId, status, request, response);
    }

    @RequestMapping(value={"/changeshopstatusbyparams"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String changeShopStatusByParams(Long[] shoppingId, String status, HttpServletRequest request, HttpServletResponse response) {
        return this.shoppingCartService.changeShopStatusByParam(shoppingId, status, request, response);
    }

    @RequestMapping(value={"/delshoppingcartbyid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int delShoppingCartById(Long shoppingCartId, Long goodsInfoId, HttpServletRequest request, HttpServletResponse response) {
        int result = 0;
        try {
            result = this.shoppingCartService.delShoppingCartById(shoppingCartId, goodsInfoId, request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/delShoppingCartByCustomerId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int delShoppingCartByCustomerId(HttpServletRequest request, HttpServletResponse response) {
        int result = 0;
        try {
            result = this.shoppingCartService.delShoppingCartByCustomerId(request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u6e05\u7a7a\u8d2d\u7269\u8f66\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/changeshoppingcartbyid"}, produces={"application/json;charset=UTF-8"})
    public int changeShoppingCartById(HttpServletRequest request, Long shoppingCartId, Long num) {
        int result = 0;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            if (customerId != null) {
                result = this.shoppingCartService.changeShoppingCartById(shoppingCartId, num);
                CustomerAllInfo customerAllInfo = this.customerServiceInterface.selectByPrimaryKey(customerId);
                OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)"\u4fee\u6539\u8d2d\u7269\u6570\u91cf", (String)("\u4fee\u6539\u8d2d\u7269\u6570\u91cf-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername()));
                LOGGER.info((Object)("\u4fee\u6539\u8d2d\u7269\u8f66ID\u4e3a\uff1a" + shoppingCartId + "\u7684\u8d2d\u7269\u6570\u91cf\uff01"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u4fee\u6539\u8d2d\u7269\u8f66\u6570\u91cf\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/changeshoppingcartmarket"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int changeShoppingCartMarket(Long shoppingCartId, Long marketingActivityId, Long marketingId) {
        return -1;
    }

    @RequestMapping(value={"/changeshoppingcartmarts"})
    public ModelAndView changeShoppingCartMarts(Long shoppingCartId, Long marketingActivityId, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView mav = new ModelAndView();
        try {
            this.shoppingCartService.changeShoppingCartMarket(shoppingCartId, marketingActivityId, request, response);
            mav.setView((View)new RedirectView("myshoppingcart.html?list=" + request.getParameter("checkList")));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("PC\u7aef\u8d2d\u7269\u8f66\u5207\u6362\u5546\u54c1\u4f18\u60e0\u66f4\u65b0\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/addProductToShopCar"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean addProductToShopCar(Long goodsNum, Long productId, HttpServletRequest request, Long distinctId, HttpServletResponse response, Long fitId) {
        boolean flag = false;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            ShoppingCart shoppingCart = new ShoppingCart();
            shoppingCart.setDistinctId(distinctId == null ? wareUtil.getDistrictId() : distinctId);
            shoppingCart.setGoodsInfoId(productId);
            shoppingCart.setGoodsNum(goodsNum);
            shoppingCart.setCustomerId(customerId);
            shoppingCart.setShoppingCartTime(new Date());
            shoppingCart.setDelFlag("0");
            int result = this.shoppingCartService.addShoppingCart(shoppingCart, request, response);
            if (result > 0) {
                flag = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    @RequestMapping(value={"/againBuy"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Object> againBuy(HttpServletRequest request, HttpServletResponse response, Long orderId) {
        ArrayList<Object> productList = new ArrayList<Object>();
        try {
            List orderGoodsList = this.orderService.queryOrderGoodsAndProductInfo(orderId);
            for (OrderGoods orderGoods : orderGoodsList) {
                if (null != orderGoods.getIsPresent() && (null == orderGoods.getIsPresent() || !orderGoods.getIsPresent().equals("0"))) continue;
                GoodsProductVo productinfo = this.productService.querySimpleProductByProductId(orderGoods.getGoodsInfoId());
                if (null != productinfo && productinfo.getGoodsInfoAdded().equals("1")) {
                    ShoppingCart shoppingCart = new ShoppingCart();
                    Long distinctId = this.orderService.queryRepositoryId(orderId);
                    if (null == distinctId) {
                        shoppingCart.setDistinctId(749L);
                    } else {
                        shoppingCart.setDistinctId(distinctId);
                    }
                    shoppingCart.setGoodsInfoId(productinfo.getGoodsInfoId());
                    shoppingCart.setGoodsNum(1L);
                    this.shoppingCartService.addShoppingCart(shoppingCart, request, response);
                    continue;
                }
                productList.add(productinfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return productList;
    }

    @RequestMapping(value={"/buyPackProduct"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int buyPackPro(Long[] productIds, Long groupId, Long distinctId, HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        int result = 0;
        Long custId = (Long)request.getSession().getAttribute("customerId");
        try {
            if (null != custId) {
                ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
                ShoppingCart shoppingCart = new ShoppingCart();
                shoppingCart.setDistinctId(distinctId == null ? wareUtil.getDistrictId() : distinctId);
                shoppingCart.setFitId(groupId);
                shoppingCart.setCustomerId(custId);
                shoppingCart.setShoppingCartTime(new Date());
                shoppingCart.setDelFlag("0");
                if (null != productIds && productIds.length > 0) {
                    for (int i = 0; i < productIds.length; ++i) {
                        shoppingCart.setGoodsInfoId(productIds[i]);
                        shoppingCart.setGoodsNum(1L);
                        this.shoppingCartService.addShoppingCart(shoppingCart, request, response);
                    }
                }
                result = 1;
            } else {
                result = -1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @RequestMapping(value={"/buyPrePackage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int buyaPrePackage(Long fitId, Long distinctId, HttpServletRequest request, HttpServletResponse response) {
        int result = 0;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            if (null != fitId && fitId > 0L) {
                ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
                ShoppingCart shoppingCart = new ShoppingCart();
                shoppingCart.setDistinctId(distinctId == null ? wareUtil.getDistrictId() : distinctId);
                shoppingCart.setGoodsInfoId(Long.parseLong(PROINFO + fitId));
                shoppingCart.setGoodsNum(1L);
                shoppingCart.setFitId(fitId);
                shoppingCart.setCustomerId(customerId);
                shoppingCart.setShoppingCartTime(new Date());
                shoppingCart.setDelFlag("0");
                result = this.shoppingCartService.addShoppingCart(shoppingCart, request, response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8d2d\u4e70\u4f18\u60e0\u5957\u88c5\u7ec4\u5408\u52a0\u5165\u8d2d\u7269\u8f66\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/updateprovince"})
    public ModelAndView updateProvince(Long distinctId, String chAddress, String chProvince, String chCity, String chDistinct, HttpServletRequest request) {
        request.getSession().setAttribute("chProvince", (Object)chProvince);
        request.getSession().setAttribute("chAddress", (Object)chAddress);
        request.getSession().setAttribute("chCity", (Object)chCity);
        request.getSession().setAttribute("chDistinct", (Object)chDistinct);
        request.getSession().setAttribute("distinctId", (Object)distinctId);
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    @RequestMapping(value={"/delshoppingcatgoodsgroup"})
    public ModelAndView delShoppingCatGoodsGroup(Long shoppingCartId, Long goodsInfoId, Long fitId, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView mav = new ModelAndView();
        try {
            this.shoppingCartService.delGoodsGroupByS(shoppingCartId, goodsInfoId, fitId, request, response);
            mav.setView((View)new RedirectView(REDIRECT));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mav;
    }

    @RequestMapping(value={"/addproducttoshoppingcar"})
    public ModelAndView addProductToShoppingCar(Long goodsNum, Long productId, HttpServletRequest request, Long distinctId, HttpServletResponse response, Long fitId) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        try {
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            ShoppingCart shoppingCart = new ShoppingCart();
            shoppingCart.setDistinctId(distinctId == null ? wareUtil.getDistrictId() : distinctId);
            shoppingCart.setGoodsInfoId(productId);
            shoppingCart.setGoodsNum(goodsNum);
            shoppingCart.setCustomerId(customerId);
            shoppingCart.setShoppingCartTime(new Date());
            shoppingCart.setDelFlag("0");
            int result = this.shoppingCartService.addShoppingCart(shoppingCart, request, response);
            if (result > 0) {
                mav.setViewName(REDIRECT);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mav;
    }

    private String getIndexViewUrl(HttpServletRequest request) {
        return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/";
    }
}

