/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.index;

import com.qianjiang.index.service.ThirdIndexSiteService;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.ThirdTempService;
import com.qianjiang.thirdaudit.bean.StoreInfo;
import com.qianjiang.thirdaudit.service.AuditService;
import com.qianjiang.util.MyLogger;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ThirdIndexSiteController {
    private static final String INDEX_VIEW = "index/main1";
    private static final MyLogger LOGGER = new MyLogger(ThirdIndexSiteController.class);
    @Resource(name="ThirdTempService")
    private ThirdTempService tempService;
    @Resource(name="ThirdIndexSiteService")
    private ThirdIndexSiteService indexSiteService;
    @Resource(name="auditService")
    private AuditService auditService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;

    @ResponseBody
    @RequestMapping(value={"/indexThirdViewText"}, produces={"application/json;charset=UTF-8"})
    public Object indexThirdViewText(HttpServletRequest request, Long tempId, String thirdId) {
        return this.indexSiteService.getClassifyBar(tempId, thirdId);
    }

    @ResponseBody
    @RequestMapping(value={"/getThirdIndex"}, produces={"application/json;charset=UTF-8"})
    public boolean getThirdIndex(HttpServletRequest request, String thirdId) {
        StoreInfo storeinfo = this.auditService.selectNameAndIsStoreBySId(Long.valueOf(thirdId));
        if (null == storeinfo) {
            return false;
        }
        return "0".equals(storeinfo.getIsStoreIndex());
    }

    @RequestMapping(value={"/indexThirdView"})
    public ModelAndView indexThirdView(HttpServletRequest request, String thirdId) {
        ModelAndView mav = new ModelAndView();
        StoreInfo storeinfo = this.auditService.selectNameAndIsStoreBySId(Long.valueOf(thirdId));
        SysTemp thirdTemp = this.getIndexDefalutTemp(thirdId);
        mav.setViewName(INDEX_VIEW);
        mav.addObject("thirdTemp", (Object)thirdTemp);
        mav.addObject("storeinfo", (Object)storeinfo);
        mav.addObject("sys", (Object)this.basicSetService.findBasicSet());
        return mav;
    }

    private SysTemp getIndexDefalutTemp(String thirdId) {
        try {
            return this.tempService.getCurrTemp();
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7d\u9996\u9875\u9ed8\u8ba4\u6a21\u677f\u5f02\u5e38\uff01", (Throwable)e);
            return null;
        }
    }
}

