/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.goods.controller;

import com.alibaba.fastjson.JSON;
import com.qianjiang.comment.bean.Comment;
import com.qianjiang.comment.bean.CommentReplay;
import com.qianjiang.comment.service.CommentReplayServiceMapper;
import com.qianjiang.comment.service.CommentServiceMapper;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.service.CustomerFollowServiceMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.goods.bean.ArrivalNotice;
import com.qianjiang.goods.bean.GoodsCate;
import com.qianjiang.goods.bean.GoodsDetailBean;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.bean.SolrGoodsInfo;
import com.qianjiang.goods.service.ArrivalNoticeService;
import com.qianjiang.goods.service.BrowserecordService;
import com.qianjiang.goods.service.GetOnOffService;
import com.qianjiang.goods.service.GoodsAtteService;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.goods.service.GoodsOpenSpecService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.GoodsReleTagService;
import com.qianjiang.goods.service.GoodsService;
import com.qianjiang.goods.service.GoodsSolrSearchService;
import com.qianjiang.goods.service.GoodsTypeService;
import com.qianjiang.goods.service.WareHouseService;
import com.qianjiang.goods.util.SearchPageBean;
import com.qianjiang.goods.vo.GoodsBreadCrumbVo;
import com.qianjiang.goods.vo.GoodsCateVo;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.goods.vo.GoodsSiteSearchBean;
import com.qianjiang.goods.vo.GoodsTypeVo;
import com.qianjiang.goods.vo.ListFinalBuyVo;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.promotion.bean.CustomerAddress;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.site.goods.service.BrowerService;
import com.qianjiang.site.shoppingcart.service.ShoppingCartService;
import com.qianjiang.system.address.bean.ShoppingCartWareUtil;
import com.qianjiang.system.address.service.ShoppingCartAddressService;
import com.qianjiang.system.bean.BasicSet;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.DefaultAddressService;
import com.qianjiang.system.service.DistrictService;
import com.qianjiang.system.service.IOnLineServiceBiz;
import com.qianjiang.system.service.IOnLineServiceItemBiz;
import com.qianjiang.system.util.AddressUtil;
import com.qianjiang.util.IPAddress;
import com.qianjiang.util.MyLogger;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public final class GoodsSiteController {
    private static final MyLogger LOGGER = new MyLogger(GoodsSiteController.class);
    private static final String DISTINCTID = "distinctId";
    private static final String NOWCATE = "nowcate";
    private static final String HOTPRODUCT = "hotProduct";
    private static final String HOTSALES = "hotSales";
    private static final String PRICEHOTSALES = "pricehotSales";
    private static final String BRANDHOTSALES = "brandhotSales";
    private static final String FINALBUY = "finalBuy";
    private static final String PROVINCE = "province";
    private static final String CHPROVINCE = "chProvince";
    private static final String SEARCHBEAN = "searchBean";
    private static final String PARAMS = "params";
    private static final String CHADDRESS = "chAddress";
    private static final String CHCITY = "chCity";
    private static final String CHDISTINCT = "chDistinct";
    private static final String DETAILBEAN = "detailBean";
    private static final String LOGGERINFO = "\u67e5\u8be2\u8d27\u54c1\u3010";
    private static final String CUSTOMERID = "customerId";
    private static final String GOODSNOEXIT = "/goods/no_exit";
    private static final String GOODSINFOID = "goodsInfoId";
    private static final String INFOMOBILE = "infoMobile";
    private static final String INFOEMAIL = "infoEmail";
    private static final String NOTICESTURTS = "noticeSturts";
    private static final String WAREID = "wareId";
    @Autowired
    private ShoppingCartAddressService shoppingCartAddressService;
    @Resource(name="GoodsCateService")
    private GoodsCateService goodsCateService;
    @Resource(name="GoodsTypeService")
    private GoodsTypeService goodsTypeService;
    @Resource(name="GoodsService")
    private GoodsService goodsService;
    @Resource(name="MarketingService")
    private PromotionService marketingService;
    @Resource(name="GoodsAtteService")
    private GoodsAtteService goodsAtteService;
    @Resource(name="browserecordServiceMix")
    private BrowserecordService browserecordService;
    @Resource(name="commentServiceMapper")
    private CommentServiceMapper commentServiceMapper;
    @Resource(name="commentReplayServiceMapper")
    private CommentReplayServiceMapper commentReplayServiceMapper;
    @Resource(name="GoodsOpenSpecService")
    private GoodsOpenSpecService goodsOpenSpecService;
    @Resource(name="GoodsReleTagService")
    private GoodsReleTagService goodsReleTagService;
    @Resource(name="ShoppingCartService1")
    private ShoppingCartService cartService;
    @Resource(name="DefaultAddressService")
    private DefaultAddressService addressService;
    @Resource(name="DistrictService")
    private DistrictService districtService;
    @Resource(name="WareHouseService")
    private WareHouseService wareHouseService;
    @Resource(name="GoodsSolrSearchService")
    private GoodsSolrSearchService goodsSolrSearchServivice;
    @Resource(name="TopAndBottomService")
    private TopAndBottomService topAndBottomService;
    @Resource(name="customerFollowServiceMapper")
    private CustomerFollowServiceMapper customerFollowService;
    @Resource(name="ArrivalNoticeService")
    private ArrivalNoticeService arrivalNoticeMapper;
    @Resource(name="onLineServiceItemBizImpl")
    private IOnLineServiceItemBiz onLineServiceItemService;
    @Resource(name="onLineServiceBizImpl")
    private IOnLineServiceBiz onLineServiceBiz;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceInterface;
    @Resource(name="GetOnOffService")
    private GetOnOffService getOnOffService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="BrowerService")
    private BrowerService browerService;
    @Resource(name="GoodsProductService")
    private GoodsProductService productService;

    public ModelAndView goodsList(Long cid, Long pid, PageBean pb, GoodsSiteSearchBean searchBean, String[] params, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        pb.setPageSize(20);
        Long cidNew = cid;
        try {
            int grade = this.goodsCateService.findCatGrade(cidNew);
            GoodsCateVo cateVo = this.goodsCateService.queryCateByCatId(cidNew);
            GoodsCateVo gcv = null;
            gcv = cateVo.getCatGrade() == null ? this.goodsCateService.queryCateById(cidNew) : this.goodsCateService.queryCateById(pid);
            if (gcv != null && gcv.getCateVos() != null && !gcv.getCateVos().isEmpty() && ((GoodsCateVo)gcv.getCateVos().get(0)).getCateVos() != null && ((GoodsCateVo)gcv.getCateVos().get(0)).getCateVos().get(0) != null) {
                for (int j = 0; j < gcv.getCateVos().size(); ++j) {
                    for (int i = 0; i < ((GoodsCateVo)gcv.getCateVos().get(j)).getCateVos().size(); ++i) {
                        String ppId = null;
                        if (((GoodsCateVo)((GoodsCateVo)gcv.getCateVos().get(j)).getCateVos().get(i)).getCatParentId() != null) {
                            ppId = ((GoodsCateVo)((GoodsCateVo)gcv.getCateVos().get(j)).getCateVos().get(i)).getCatParentId().toString();
                        }
                        if (!cidNew.toString().equals(ppId)) continue;
                        cidNew = ((GoodsCateVo)((GoodsCateVo)gcv.getCateVos().get(j)).getCateVos().get(i)).getCatId();
                    }
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            if ((long)cateVo.getCatGrade().intValue() == 1L || (long)cateVo.getCatGrade().intValue() == 3L) {
                map.put(NOWCATE, this.goodsCateService.queryCateByCatId(cidNew));
            } else {
                cidNew = cateVo.getCatId();
                map.put(NOWCATE, this.goodsCateService.queryCateByCatId(cidNew));
            }
            if (grade == 1) {
                GoodsCate c = this.goodsCateService.findCid(pid);
                cidNew = c.getCatId();
            }
            GoodsTypeVo typeVo = this.goodsTypeService.queryGoodsTypeByCatId(cidNew);
            List screenVo = this.goodsService.calcScreenParam(params, typeVo);
            GoodsTypeVo calcTypeVo = this.goodsService.calcTypeVo(screenVo, typeVo);
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            Long distinctId = wareUtil.getDistrictId();
            map.put("pb", this.goodsService.searchGoods3(pb, searchBean, cidNew, params, distinctId.toString()));
            map.put(DISTINCTID, distinctId);
            map.put(PROVINCE, wareUtil.getProvinceName());
            map.put("cate", gcv);
            map.put("type", calcTypeVo);
            map.put(HOTPRODUCT, this.productService.queryTopSalesByCatIds(cidNew, Integer.valueOf(4)));
            map.put(HOTSALES, this.productService.queryHotSalesTopSix(cidNew, Integer.valueOf(6)));
            map.put(FINALBUY, this.productService.browCatFinalBuyAndPrecent(cidNew, Long.valueOf(4L)));
            map.put("browserProduct", this.browerService.loadBrowHist(request));
            map.put(SEARCHBEAN, searchBean);
            map.put(PARAMS, screenVo);
            mav.addObject("map", map);
            mav.setViewName("goods/list");
            LOGGER.info((Object)("\u6839\u636e\u5206\u7c7b\u3010" + gcv.getCatName() + "\u3011\u67e5\u8be2\u5546\u54c1\u5217\u8868"));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u5206\u7c7b\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/list"})
    public ModelAndView esGoodsList(Long cid, Long pid, HttpServletRequest request, HttpServletResponse response, SearchPageBean<SolrGoodsInfo> pageBean, String[] brands, String[] params, String sort, String showStock, String isThird, String inMarketing) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        pageBean.setPageSize(20);
        Long cidNew = cid;
        try {
            GoodsCate c;
            Long[] longArray;
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            Long distinctId = wareUtil.getDistrictId();
            Long wareId = this.productService.selectWareIdByDistinctId(distinctId);
            if (wareId == null) {
                longArray = null;
            } else {
                Long[] longArray2 = new Long[1];
                longArray = longArray2;
                longArray2[0] = wareId;
            }
            Long[] wares = longArray;
            BasicSet basicSet = this.basicSetService.findBasicSet();
            showStock = basicSet.getShowStock();
            int grade = this.goodsCateService.findCatGrade(cidNew);
            GoodsCateVo cateVo = this.goodsCateService.queryCateByCatId(cidNew);
            GoodsCateVo gcv = null;
            gcv = cateVo.getCatGrade() == null ? this.goodsCateService.queryCateById(cidNew) : this.goodsCateService.queryCateById(pid);
            if (gcv != null && gcv.getCateVos() != null && !gcv.getCateVos().isEmpty() && ((GoodsCateVo)gcv.getCateVos().get(0)).getCateVos() != null && !((GoodsCateVo)gcv.getCateVos().get(0)).getCateVos().isEmpty() && ((GoodsCateVo)gcv.getCateVos().get(0)).getCateVos().get(0) != null) {
                for (int j = 0; j < gcv.getCateVos().size(); ++j) {
                    for (int i = 0; i < ((GoodsCateVo)gcv.getCateVos().get(j)).getCateVos().size(); ++i) {
                        String ppId = null;
                        if (((GoodsCateVo)((GoodsCateVo)gcv.getCateVos().get(j)).getCateVos().get(i)).getCatParentId() != null) {
                            ppId = ((GoodsCateVo)((GoodsCateVo)gcv.getCateVos().get(j)).getCateVos().get(i)).getCatParentId().toString();
                        }
                        if (!cidNew.toString().equals(ppId)) continue;
                        cidNew = ((GoodsCateVo)((GoodsCateVo)gcv.getCateVos().get(j)).getCateVos().get(i)).getCatId();
                    }
                }
            }
            if ((long)cateVo.getCatGrade().intValue() == 1L || (long)cateVo.getCatGrade().intValue() == 3L) {
                mav.addObject(NOWCATE, (Object)this.goodsCateService.queryCateByCatId(cidNew));
            } else {
                cidNew = cateVo.getCatId();
                mav.addObject(NOWCATE, (Object)this.goodsCateService.queryCateByCatId(cidNew));
            }
            if (grade == 1 && (c = this.goodsCateService.findCid(pid)) != null) {
                cidNew = c.getCatId();
            }
            Map resultMap = this.goodsSolrSearchServivice.searchGoods(pageBean, wares, null, brands, new String[]{String.valueOf(cidNew)}, params, sort, null, null, null, null, showStock, null, isThird, inMarketing);
            if (customerId != null) {
                HashMap<String, Long> followMap = new HashMap<String, Long>();
                followMap.put(CUSTOMERID, customerId);
                List goodsIds = this.customerFollowService.selectCustomerFollowForList(followMap);
                mav.addObject("goodsIds", (Object)goodsIds);
            }
            mav.addObject("map", (Object)resultMap);
            mav.addObject("cate", (Object)gcv);
            mav.addObject(HOTPRODUCT, (Object)this.productService.queryTopSalesByCatIds(cidNew, Integer.valueOf(4)));
            mav.addObject(HOTSALES, (Object)this.productService.queryHotSalesTopSixRandom(gcv, cateVo, Integer.valueOf(6)));
            mav.addObject(FINALBUY, (Object)this.productService.browCatFinalBuyAndPrecentRandom(gcv, cateVo, Integer.valueOf(4)));
            mav.addObject(PARAMS, (Object)params);
            mav.addObject("brands", (Object)brands);
            mav.addObject("sort", (Object)sort);
            mav.addObject("showStock", (Object)showStock);
            mav.addObject("isThird", (Object)isThird);
            mav.addObject(WAREID, (Object)wareId);
            mav.addObject("inMarketing", (Object)inMarketing);
            mav.addObject("browserProduct", (Object)this.browerService.loadBrowHist(request));
            LOGGER.info((Object)("\u6839\u636e\u5206\u7c7b\u3010" + gcv.getCatName() + "\u3011\u67e5\u8be2\u5546\u54c1\u5217\u8868"));
            mav.setViewName("goods/es_list");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u5546\u54c1\u5217\u8868\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/product"})
    public ModelAndView goodsDetail(HttpServletRequest request, HttpServletResponse response, Long productId, Long distinctId, String chAddress) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long distinctId1 = distinctId;
        try {
            GoodsDetailBean detailBean;
            if (null == productId) {
                return this.topAndBottomService.getTopAndBottom(new ModelAndView(GOODSNOEXIT));
            }
            GoodsProductVo good = this.productService.querySimpleProductByProductId(productId);
            if (good == null) {
                return this.topAndBottomService.getTopAndBottom(new ModelAndView(GOODSNOEXIT));
            }
            if (this.productService.queryProductByGoodsInfoId(productId) == 0) {
                return this.topAndBottomService.getTopAndBottom(new ModelAndView(GOODSNOEXIT));
            }
            if (null == distinctId1) {
                if (null != request.getSession().getAttribute("address") && null == request.getSession().getAttribute(CHADDRESS)) {
                    distinctId1 = ((CustomerAddress)request.getSession().getAttribute("address")).getDistrict().getDistrictId();
                    map.put(CHADDRESS, ((CustomerAddress)request.getSession().getAttribute("address")).getProvince().getProvinceName() + ((CustomerAddress)request.getSession().getAttribute("address")).getCity().getCityName() + ((CustomerAddress)request.getSession().getAttribute("address")).getDistrict().getDistrictName());
                    map.put(CHPROVINCE, ((CustomerAddress)request.getSession().getAttribute("address")).getProvince().getProvinceName());
                    map.put(CHCITY, ((CustomerAddress)request.getSession().getAttribute("address")).getCity().getCityName());
                    map.put(CHDISTINCT, ((CustomerAddress)request.getSession().getAttribute("address")).getDistrict().getDistrictName());
                } else if (null == request.getSession().getAttribute(CHADDRESS)) {
                    Long dId = this.addressService.getDefaultIdService();
                    if (dId == null) {
                        dId = 749L;
                        distinctId1 = (long)dId;
                        map.put(CHADDRESS, "\u4e0a\u6d77\u5e02\u5f90\u6c47\u533a");
                        map.put(CHPROVINCE, "\u4e0a\u6d77");
                        map.put(CHCITY, "\u4e0a\u6d77\u5e02");
                        map.put(CHDISTINCT, "\u5f90\u6c47\u533a");
                    } else {
                        distinctId1 = (long)dId;
                        AddressUtil addressUtil = this.districtService.queryAddressNameByDistrictId(dId);
                        map.put(CHADDRESS, addressUtil.getProvinceName() + addressUtil.getCityName() + addressUtil.getDistrictName());
                        map.put(CHPROVINCE, addressUtil.getProvinceName());
                        map.put(CHCITY, addressUtil.getCityName());
                        map.put(CHDISTINCT, addressUtil.getDistrictName());
                    }
                } else {
                    map.put(CHPROVINCE, request.getSession().getAttribute(CHPROVINCE));
                    map.put(CHADDRESS, request.getSession().getAttribute(CHADDRESS));
                    map.put(CHCITY, request.getSession().getAttribute(CHCITY));
                    map.put(CHDISTINCT, request.getSession().getAttribute(CHDISTINCT));
                    distinctId1 = Long.parseLong(request.getSession().getAttribute(DISTINCTID).toString());
                }
            } else {
                map.put(CHADDRESS, chAddress);
                map.put(CHPROVINCE, request.getParameter(CHPROVINCE));
                map.put(CHCITY, request.getParameter(CHCITY));
                map.put(CHDISTINCT, request.getParameter(CHDISTINCT));
            }
            map.put(DISTINCTID, distinctId1);
            request.getSession().setAttribute(CHPROVINCE, map.get(CHPROVINCE));
            request.getSession().setAttribute(CHADDRESS, map.get(CHADDRESS));
            request.getSession().setAttribute(CHCITY, map.get(CHCITY));
            request.getSession().setAttribute(CHDISTINCT, map.get(CHDISTINCT));
            request.getSession().setAttribute(DISTINCTID, map.get(DISTINCTID));
            response.setHeader("Cache-Control", "no-store");
            response.setDateHeader("Expires", 0L);
            response.setHeader("Pragma", "no-cache");
            if (customerId != null) {
                boolean checkAtte = this.goodsAtteService.checkAtte(customerId, productId);
                if (checkAtte) {
                    map.put("isFollow", "1");
                } else {
                    map.put("isFollow", "0");
                }
            }
            if ((detailBean = this.productService.queryDetailBeanByProductId(productId, distinctId1)) != null && detailBean.getProductVo() != null) {
                detailBean = this.cartService.forPurchasing(detailBean, (Long)request.getSession().getAttribute(CUSTOMERID));
                map.put(DETAILBEAN, detailBean);
                map.put("QQs", this.onLineServiceItemService.selectItemsByType(0));
                map.put("customerService", this.onLineServiceBiz.selectSetting());
                map.put("openSpec", this.goodsOpenSpecService.queryOpenListByGoodsId(detailBean.getProductVo().getGoodsId()));
                map.put("tags", this.goodsReleTagService.queryreleListByProductId(detailBean.getProductVo().getGoodsInfoId()));
                this.browerService.saveBrowerHis(request, response, productId);
                mav.addObject("map", map);
                mav.setViewName("goods/newdetail");
            } else {
                mav.setViewName(GOODSNOEXIT);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u67e5\u770b\u5546\u54c1\u5546\u54c1\u5931\u8d25" + e.getMessage());
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/getRelativeCatAndBrandByProductCatId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> getRelativeCatAndBrandByProductCatId(Long catId) {
        Map<String, Object> result = new HashMap<String, Object>();
        try {
            if (catId == null) {
                return null;
            }
            result = this.goodsCateService.queryGoodsCateAndBrandsByCatId(catId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @RequestMapping(value={"/getFinalBuyVosByProductCatId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<ListFinalBuyVo> getFinalBuyVosByProductCatId(Long catId) {
        List result = null;
        try {
            if (catId == null) {
                return result;
            }
            result = this.productService.browCatFinalBuyAndPrecent(catId, Long.valueOf(4L));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @RequestMapping(value={"/getHotSalesRank"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> getHotSalesRank(Long catId, BigDecimal price, Long brandId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(HOTSALES, this.productService.queryHotSalesTopSix(catId, Integer.valueOf(6)));
        map.put(PRICEHOTSALES, this.productService.queryHotSalesByCatIdandPrice(catId, Integer.valueOf(6), price));
        map.put(BRANDHOTSALES, this.productService.queryHotSalesByCatIdandBrand(catId, Integer.valueOf(6), brandId));
        return map;
    }

    @RequestMapping(value={"/queryProductListByGoodsId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Object> queryAllProductByGoodsId(Long goodsId) {
        return this.productService.queryAllProductListByGoodsId(goodsId);
    }

    @RequestMapping(value={"/saveAtte"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int saveAtte(Long productId, Long districtId, BigDecimal goodsprice, HttpServletRequest request) {
        int result = 0;
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        try {
            if (null != customerId) {
                result = this.goodsAtteService.newsaveGoodsAtte(customerId, productId, districtId, goodsprice);
                if (null != productId && null != districtId) {
                    GoodsProductVo goodsProductVo = this.productService.queryProductByProductId(productId);
                    CustomerAllInfo customerAllInfo = this.customerServiceInterface.queryCustomerById(customerId);
                    AddressUtil addressUtil = this.districtService.queryAddressNameByDistrictId(districtId);
                    if (null != productId && null != districtId && null != goodsprice && null != addressUtil) {
                        OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)"\u5173\u6ce8\u8d27\u54c1", (String)("\u5173\u6ce8\u8d27\u54c1-->\u8d27\u54c1\u5730\u533a\uff1a\u3010" + addressUtil.getProvinceName() + "-" + addressUtil.getCityName() + "-" + addressUtil.getDistrictName() + "\u3011\u8d27\u54c1\u540d\u79f0:\u3010" + goodsProductVo.getGoodsInfoName() + "\u3011\u8d27\u54c1\u4ef7\u683c\uff1a\u3010" + goodsprice + "\u3011-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername()));
                        LOGGER.info((Object)("\u5173\u6ce8\u8d27\u54c1\uff1a\u5730\u533a\u3010" + addressUtil.getProvinceName() + "-" + addressUtil.getCityName() + "-" + addressUtil.getDistrictName() + "\u3011\u8d27\u54c1\u540d\u79f0:\u3010" + goodsProductVo.getGoodsInfoName() + "\u3011\u8d27\u54c1\u4ef7\u683c\uff1a\u3010" + goodsprice + "\u3011"));
                    }
                }
            } else {
                result = -2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("app\u7aef\u5173\u6ce8\u8d27\u54c1\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/searchProduct"})
    public ModelAndView searchProduct(PageBean pb, GoodsSiteSearchBean searchBean, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        pb.setPageSize(20);
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            String title = searchBean.getTitle();
            if (StringUtils.isNotEmpty((String)title)) {
                title = new String(title.getBytes("ISO-8859-1"), "utf-8");
                searchBean.setTitle(title);
                map.put("titleArray", searchBean.getTitle().split(""));
            } else {
                map.put("titleArray", null);
            }
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            Long distinctId = wareUtil.getDistrictId();
            searchBean.setDistinctId(distinctId);
            map.put("pb", this.goodsService.searchGoods1(pb, searchBean));
            map.put(SEARCHBEAN, searchBean);
            map.put(DISTINCTID, distinctId);
            map.put("browserProduct", this.browerService.loadBrowHist(request));
            mav.addObject("map", map);
            mav.setViewName("goods/search");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/searchProduct2"})
    public ModelAndView esearchProduct(HttpServletRequest request, HttpServletResponse response, SearchPageBean<SolrGoodsInfo> pageBean, @RequestParam(value="title") String keyWords, String[] brands, String[] cats, String[] params, String sort, String priceMin, String priceMax, String showStock, String isThird, String inMarketing) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        Pattern scriptPattern = Pattern.compile("<script>(.*?)</script>", 2);
        String keyWords1 = keyWords;
        keyWords1 = scriptPattern.matcher(keyWords1).replaceAll("");
        scriptPattern = Pattern.compile("[<>\"]+");
        keyWords1 = scriptPattern.matcher(keyWords1).replaceAll("");
        pageBean.setPageSize(20);
        try {
            Long[] longArray;
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            Long distinctId = wareUtil.getDistrictId();
            Long wareId = this.productService.selectWareIdByDistinctId(distinctId);
            if (wareId == null) {
                longArray = null;
            } else {
                Long[] longArray2 = new Long[1];
                longArray = longArray2;
                longArray2[0] = wareId;
            }
            Long[] wares = longArray;
            BasicSet basicSet = this.basicSetService.findBasicSet();
            showStock = basicSet.getShowStock();
            Map resultMap = this.goodsSolrSearchServivice.searchGoods(pageBean, wares, keyWords1, brands, cats, params, sort, priceMin, priceMax, null, null, showStock, null, isThird, inMarketing);
            if (customerId != null) {
                HashMap<String, Long> followMap = new HashMap<String, Long>();
                followMap.put(CUSTOMERID, customerId);
                List goodsIds = this.customerFollowService.selectCustomerFollowForList(followMap);
                mav.addObject("goodsIds", (Object)goodsIds);
            }
            mav.addObject("map", (Object)resultMap);
            mav.addObject("keyWorlds", (Object)keyWords1);
            mav.addObject(PARAMS, (Object)params);
            mav.addObject("brands", (Object)brands);
            mav.addObject("sort", (Object)sort);
            mav.addObject("priceMin", (Object)priceMin);
            mav.addObject("priceMax", (Object)priceMax);
            mav.addObject("showStock", (Object)showStock);
            mav.addObject("isThird", (Object)isThird);
            mav.addObject(WAREID, (Object)wareId);
            mav.addObject("inMarketing", (Object)inMarketing);
            mav.addObject(DISTINCTID, (Object)distinctId);
            mav.addObject("browserProduct", (Object)this.browerService.loadBrowHist(request));
            mav.setViewName("goods/esearch");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u901a\u8fc7solr\u5f15\u64ce\u641c\u7d22\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/queryProducCommentForDetail"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public com.qianjiang.util.PageBean queryProductComment(com.qianjiang.util.PageBean pb, Long productId, String title, Character type, String askType) {
        if (null != askType && !"".equals(askType)) {
            LOGGER.info((Object)(LOGGERINFO + productId + "\u3011\u7684\u8bc4\u8bba"));
            return this.commentServiceMapper.selectCommByGoodsId(pb, productId, type, title, askType);
        }
        return this.commentServiceMapper.selectCommByGoodsId(pb, productId, type, title);
    }

    @RequestMapping(value={"/saveCommentAsk"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int saveCommentAsk(HttpServletRequest request, String askComment, int type, Long productId) {
        int result = 0;
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        try {
            result = null != customerId ? this.productService.saveProductCommentAsk(type, askComment, customerId, productId, request) : -1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @RequestMapping(value={"/loadGoodsBreadCrumb"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public GoodsBreadCrumbVo queryGoodsBreadCrumbByCatId(Long catId) {
        GoodsBreadCrumbVo goodsBreadCrumbVo = null;
        try {
            goodsBreadCrumbVo = this.goodsCateService.queryBreadCrubByCatId(catId);
            if (null != goodsBreadCrumbVo.getCatName()) {
                LOGGER.info((Object)("\u67e5\u8be2\u5206\u7c7b\u540d\u79f0\u4e3a\u3010" + goodsBreadCrumbVo.getCatName() + "\u3011\u7684\u9762\u5305\u5c51\u4fe1\u606f\uff01"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u6839\u636e\u5206\u7c7bid\u67e5\u8be2\u9762\u5305\u5c51\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return goodsBreadCrumbVo;
    }

    @RequestMapping(value={"/queryCommentReplay"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<CommentReplay> queryCommentReplayList(Long commentId) {
        LOGGER.info((Object)("\u6839\u636e\u8bc4\u8bba\u7f16\u53f7\u67e5\u8be2\u56de\u590d\u5217\u8868,\u8bc4\u8bbaID\u4e3a" + commentId));
        return this.commentReplayServiceMapper.selectByCommentId(commentId);
    }

    @RequestMapping(value={"/jumpList"})
    public ModelAndView jumpList(Long catId, String level) {
        return new ModelAndView((View)new RedirectView("../list/" + this.goodsCateService.calcCatUrl(catId, level) + ".html"));
    }

    @RequestMapping(value={"/uploadCommentReplay"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int uploadCommentReplay(String replayContent, Long commentId, HttpServletRequest request) {
        int result = 0;
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        try {
            if (customerId != null) {
                if (StringUtils.isNotEmpty((String)replayContent)) {
                    String regEx = "[`~<>]";
                    Pattern p = Pattern.compile(regEx);
                    Matcher m = p.matcher(replayContent);
                    if (m.find()) {
                        result = 0;
                        return result;
                    }
                    result = this.commentReplayServiceMapper.addCommentRepaly((Customer)JSON.parseObject((String)JSON.toJSONString((Object)request.getSession().getAttribute("cust")), Customer.class), Integer.parseInt(request.getSession().getAttribute(CUSTOMERID).toString()), IPAddress.getIpAddr((HttpServletRequest)request), commentId, replayContent);
                    Comment comment = this.commentServiceMapper.selectByCommentId(commentId);
                    if (null != comment.getGoodsName()) {
                        LOGGER.info((Object)("\u56de\u590d\u5546\u54c1\u3010" + comment.getGoodsName() + "\u3011\u7684\u8bc4\u8bba"));
                    }
                }
            } else {
                result = -1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u53d1\u8868\u8bc4\u8bba\u56de\u590d\u63a7\u5236\u5668\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/allComment"})
    public ModelAndView allComment(Long productId, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            Long distinctId = wareUtil.getDistrictId();
            GoodsDetailBean detailBean = this.productService.queryDetailBeanByProductId(productId, distinctId);
            if (detailBean != null && detailBean.getProductVo() != null) {
                map.put(DETAILBEAN, detailBean);
                List queryreleListByProductId = this.goodsReleTagService.queryreleListByProductId(detailBean.getProductVo().getGoodsInfoId());
                map.put("tags", queryreleListByProductId);
            } else {
                map.put(DETAILBEAN, null);
            }
            map.put(DISTINCTID, distinctId);
            mav.addObject("map", map);
            mav.setViewName("comment/comment");
            GoodsProductVo goodsProductVo = this.productService.queryProductByProductId(productId);
            if (null != goodsProductVo.getGoodsInfoName()) {
                LOGGER.info((Object)(LOGGERINFO + goodsProductVo.getGoodsInfoName() + "\u3011\u4e0b\u9762\u6240\u6709\u7684\u5546\u54c1\u8bc4\u8bba"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/allCosult"})
    public ModelAndView allCosult(Long productId, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (customerId == null) {
                mav.setView((View)new RedirectView(request.getContextPath() + "/login.html?url=cosult/" + productId + ".html"));
                return this.topAndBottomService.getTopAndBottom(mav);
            }
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            Long distinctId = wareUtil.getDistrictId();
            GoodsDetailBean detailBean = this.productService.queryDetailBeanByProductId(productId, distinctId);
            if (detailBean != null && detailBean.getProductVo() != null) {
                map.put(DETAILBEAN, detailBean);
            } else {
                map.put(DETAILBEAN, null);
            }
            map.put(DISTINCTID, distinctId);
            mav.addObject("map", map);
            mav.setViewName("comment/cosult");
            GoodsProductVo goodsProductVo = this.productService.queryProductByProductId(productId);
            if (null != goodsProductVo.getGoodsInfoName()) {
                LOGGER.info((Object)(LOGGERINFO + goodsProductVo.getGoodsInfoName() + "\u3011\u4e0b\u9762\u6240\u6709\u7684\u5546\u54c1\u54a8\u8be2\u3002"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/brandProductsList"})
    public ModelAndView brandProductsList(PageBean pageBean, Long brandId, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        HashMap<String, Object> map = new HashMap<String, Object>();
        pageBean.setPageSize(20);
        try {
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            Long distinctId = wareUtil.getDistrictId();
            pageBean = this.goodsService.selectProductsByBrandId(pageBean, brandId, distinctId);
            map.put("pb", pageBean);
            List list = this.goodsService.selectCatIdByBrandId(brandId);
            if (list != null && !list.isEmpty()) {
                map.put(HOTPRODUCT, this.productService.queryTopSalesByCatIds((Long)list.get(0), Integer.valueOf(4)));
                map.put(HOTSALES, this.productService.queryHotSalesTopSix((Long)list.get(0), Integer.valueOf(4)));
                map.put(FINALBUY, this.productService.browCatFinalBuyAndPrecent((Long)list.get(0), Long.valueOf(4L)));
            }
            map.put("browserProduct", this.browerService.loadBrowHist(request));
            map.put(DISTINCTID, distinctId);
            map.put("brandId", brandId);
            mav.addObject("map", map);
            mav.setViewName("goods/brandproductlist");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/addArrivalNotice"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int addArrivalNotice(HttpServletRequest request, ArrivalNotice notice) {
        int result = 0;
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        try {
            if (customerId == null) {
                result = 4;
                return result;
            }
            Long wareId = this.wareHouseService.selectWareIdByDistinctId(notice.getDistrictId());
            if (!notice.getInfoMobile().equals(null) && !notice.getInfoMobile().equals("")) {
                HashMap<String, Object> paraMapMbile = new HashMap<String, Object>();
                paraMapMbile.put(NOTICESTURTS, "0");
                paraMapMbile.put(GOODSINFOID, notice.getGoodsInfoId());
                paraMapMbile.put(INFOMOBILE, notice.getInfoMobile());
                paraMapMbile.put(WAREID, wareId);
                Long resultMoblie = this.arrivalNoticeMapper.slelctArrivalNotice(paraMapMbile);
                if (resultMoblie == 1L) {
                    result = 2;
                    return result;
                }
            }
            if (!notice.getInfoEmail().equals(null) && !notice.getInfoEmail().equals("")) {
                HashMap<String, Object> paraMapEmail = new HashMap<String, Object>();
                paraMapEmail.put(NOTICESTURTS, "0");
                paraMapEmail.put(GOODSINFOID, notice.getGoodsInfoId());
                paraMapEmail.put(INFOEMAIL, notice.getInfoEmail());
                paraMapEmail.put(WAREID, wareId);
                Long resultEmail = this.arrivalNoticeMapper.slelctArrivalNotice(paraMapEmail);
                if (resultEmail == 1L) {
                    return 3;
                }
            }
            notice.setWareId(wareId);
            result = this.arrivalNoticeMapper.insertSelective(notice);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u6dfb\u52a0\u5230\u8d27\u901a\u77e5\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/loginArrivalNotice"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int loginArrivalNotice(HttpServletRequest request) {
        int result = 0;
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        try {
            if (customerId != null) {
                result = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("pc\u7aef\u9a8c\u8bc1\u5230\u8d27\u901a\u77e5\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/completionWords"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<String> autoCompletionWords(@RequestParam(value="keyWords") String q) {
        return this.goodsSolrSearchServivice.getCompletionSuggest(q);
    }
}

