/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.help;

import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.system.bean.HelpCate;
import com.qianjiang.system.bean.HelpCenter;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.HelpCateService;
import com.qianjiang.system.service.HelpCenterService;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class HelpSiteController {
    private static final MyLogger LOGGER = new MyLogger(HelpSiteController.class);
    private static final String HELPCATES = "helpCates";
    private static final String INDEX_HTML = "../index.html";
    @Resource(name="helpCateService")
    private HelpCateService helpCateService;
    @Resource(name="helpCenterService")
    private HelpCenterService helpCenterService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="TopAndBottomService")
    private TopAndBottomService topAndBottomService;

    @RequestMapping(value={"/queryHelpList"})
    public ModelAndView queryHelpList(HttpServletRequest request, HttpServletResponse response, PageBean pb, Long typeId) throws UnsupportedEncodingException {
        HashMap map = new HashMap();
        SelectBean selectBean = new SelectBean();
        selectBean.setCondition("");
        selectBean.setSearchText("");
        List list = this.helpCateService.findAll();
        for (HelpCate helpCate : list) {
            helpCate.setChilds(this.helpCenterService.findByCateId(helpCate.getHelpcateId()));
        }
        map.put(HELPCATES, list);
        if (null != typeId && typeId != -1L) {
            HelpCate cHelpCate = this.helpCateService.findByHelpcateId(typeId);
            if (null != cHelpCate && "0".equals(cHelpCate.getDelFlag())) {
                map.put("cHelpCate", cHelpCate);
                map.put("pb", this.helpCenterService.findByPageBean(pb, selectBean, typeId));
                map.put("basicSet", this.basicSetService.findBasicSet());
                pb.setUrl("help/list/" + typeId);
                return this.topAndBottomService.getTopAndBottom(new ModelAndView("help/helplist", "map", map));
            }
            return new ModelAndView((View)new RedirectView("index.html"));
        }
        return new ModelAndView((View)new RedirectView("index.html"));
    }

    @RequestMapping(value={"/helpfirstpage"})
    public ModelAndView toHelpFirstPage(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, List> map = new HashMap<String, List>();
        List list = this.helpCateService.findAll();
        for (HelpCate helpCate : list) {
            helpCate.setChilds(this.helpCenterService.findByCateId(helpCate.getHelpcateId()));
        }
        map.put(HELPCATES, list);
        List help = this.helpCenterService.selectAll();
        map.put("help", help);
        return this.topAndBottomService.getTopAndBottom(new ModelAndView("help/helpfirstpage").addObject("map", map));
    }

    @RequestMapping(value={"/helpcenter"})
    public ModelAndView toHelpCenter(HttpServletRequest request, HttpServletResponse response, Long helpId, String thirdId) {
        if (helpId == 112L && thirdId == null) {
            return new ModelAndView((View)new RedirectView(INDEX_HTML));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = this.helpCateService.findAll();
        for (HelpCate helpCate : list) {
            helpCate.setChilds(this.helpCenterService.findByCateId(helpCate.getHelpcateId()));
        }
        map.put(HELPCATES, list);
        if (helpId != null) {
            HelpCenter help = this.helpCenterService.findByHelpId(helpId);
            if (null != help) {
                HelpCate cHelpCate = this.helpCateService.findByHelpcateId(help.getHelpcateId());
                map.put("help", help);
                map.put("cHelpCate", cHelpCate);
                map.put("basicSet", this.basicSetService.findBasicSet());
                map.put("thirdId", thirdId);
                if (null != help.getHelpTitle()) {
                    LOGGER.info((Object)("\u663e\u793a\u5e2e\u52a9\u3010" + help.getHelpTitle() + "\u3011"));
                }
                return this.topAndBottomService.getTopAndBottom(new ModelAndView("help/newhelpdetail", "map", map));
            }
            return new ModelAndView((View)new RedirectView(INDEX_HTML));
        }
        return new ModelAndView((View)new RedirectView(INDEX_HTML));
    }
}

