/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.sld.filter;

import com.qianjiang.site.sld.filter.Constants;
import com.qianjiang.third.sld.bean.DomainCustom;
import com.qianjiang.third.sld.service.DomainCustomService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class URLFilter
implements Filter {
    private static final String DOMAIN_END = "." + Constants.DOMAIN;
    private static final Map<String, Object> NAME_MAP = new HashMap<String, Object>();
    @Autowired
    private DomainCustomService domainCustomService;

    public void init(FilterConfig filterConfig) throws ServletException {
        NAME_MAP.put("demo", "view/brand_list.html");
        NAME_MAP.put("shop", "view/help_list.html");
        this.domainCustomService = (DomainCustomService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext()).getBean("domainCustomMapper");
        List dcList = this.domainCustomService.findAll();
        for (DomainCustom dc : dcList) {
            String name = dc.getDomain();
            if (!StringUtils.isNotEmpty((String)name)) continue;
            NAME_MAP.put(name, dc.getCustomerId());
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        servletRequest.setCharacterEncoding("utf-8");
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String requestURI = request.getRequestURI();
        String serverName = request.getServerName().toLowerCase();
        String realURI = this.getRealRequestURI(serverName, requestURI);
        request.getRequestDispatcher(realURI).forward((ServletRequest)request, response);
    }

    private String getRealRequestURI(String serverName, String requestURI) {
        if (Constants.WWW_DOMAIN.equals(serverName) || requestURI.startsWith("/static/") || Constants.DOMAIN.equals(serverName)) {
            return requestURI;
        }
        if (serverName.endsWith(DOMAIN_END)) {
            String secondDomain = serverName.substring(0, serverName.indexOf("."));
            if (NumberUtils.isNumber((String)secondDomain)) {
                return URLFilter.getURI(secondDomain, requestURI);
            }
            Object siteId = NAME_MAP.get(secondDomain);
            if (siteId == null) {
                if (Constants.isPrivateSecondDomain(secondDomain)) {
                    return requestURI;
                }
                throw new RuntimeException("do not exist second domain: " + secondDomain);
            }
            return URLFilter.getURI(siteId + "", requestURI);
        }
        return requestURI;
    }

    private static String getURI(String siteId, String requestURI) {
        if (requestURI.endsWith(".html") || requestURI.endsWith(".htm")) {
            if (requestURI.indexOf("?") == -1) {
                return requestURI + "?cid=" + siteId;
            }
            return requestURI + "&cid=" + siteId;
        }
        return requestURI;
    }
}

