/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.customer.controller;

import com.qianjiang.comment.bean.Comment;
import com.qianjiang.comment.bean.Share;
import com.qianjiang.comment.bean.ShareReply;
import com.qianjiang.comment.service.CommentServiceMapper;
import com.qianjiang.comment.service.ShareService;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.other.util.IPAddress;
import com.qianjiang.other.util.LoginUtil;
import com.qianjiang.site.order.service.SiteOrderService;
import com.qianjiang.temp.service.MegawizardService;
import com.qianjiang.temp.service.TempService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.UploadUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ShareController {
    private static final MyLogger logger = new MyLogger(ShareController.class);
    private static final String ERRORINFO = "{error:-1}";
    private CustomerServiceMapper customerServiceMapper;
    private ShareService shareServiceMapper;
    private MegawizardService megawizardSerivce;
    private TempService tempService;
    private TopAndBottomService topAndBottomService;
    private CustomerServiceMapper customerServiceInterface;
    @Resource(name="commentServiceMapper")
    private CommentServiceMapper goodsCommentService;
    @Resource(name="SiteOrderService")
    private SiteOrderService siteOrderService;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;

    @RequestMapping(value={"/toshare"})
    public ModelAndView toShare(HttpServletRequest request, Long orderId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ModelAndView mav = null;
        if (LoginUtil.checkLoginStatus((HttpServletRequest)request)) {
            resultMap.put("order", this.customerServiceInterface.queryOrderByCustIdAndOrderId(orderId, (Long)request.getSession().getAttribute("customerId")));
            resultMap.put("explain", this.megawizardSerivce.selectByType(2, Long.valueOf(Long.parseLong(this.tempService.getCurrTemp().getTempId() + ""))));
            mav = new ModelAndView("/customer/share");
            mav.addAllObjects(resultMap);
            return this.topAndBottomService.getTopAndBottom(mav);
        }
        return new ModelAndView((View)new RedirectView("login.html?url=customer/myorder.html"));
    }

    @RequestMapping(value={"/saveShareReply"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveShareReply(HttpServletRequest request, ShareReply reply) {
        if (LoginUtil.checkLoginStatus((HttpServletRequest)request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            reply.setCustomerId(customerId);
            this.shareServiceMapper.saveShareReply(reply);
            return "ok";
        }
        return "timeout";
    }

    @RequestMapping(value={"/saveShare"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String saveShare(@Valid Share share, Comment comment, Long orderGoodsId, Long orderId, String imageNames, HttpServletRequest request) throws Exception {
        if (LoginUtil.checkLoginStatus((HttpServletRequest)request)) {
            try {
                Long customerId = (Long)request.getSession().getAttribute("customerId");
                Order order = this.siteOrderService.queryOrderByCustomerIdAndOrderId(customerId, orderId);
                if (order == null) {
                    return ERRORINFO;
                }
                OrderGoods orderGoods = this.siteOrderService.queryOrderGoodsByOrderIdAndOrderGoodsId(orderId, orderGoodsId);
                if (orderGoods == null || !orderGoods.getGoodsInfoId().equals(share.getGoodsId())) {
                    return ERRORINFO;
                }
                CustomerAllInfo customer = this.customerServiceInterface.selectByPrimaryKey(customerId);
                comment.setCustomerId(customerId);
                comment.setCustomerNickname(customer.getCustomerNickname());
                if (comment.getCommentScore() != null) {
                    if (!this.goodsCommentService.checkCommGoodIsUser(orderGoodsId, customerId, "1")) {
                        return ERRORINFO;
                    }
                    Long commentId = this.goodsCommentService.addGoodsComment(IPAddress.getIpAddr((HttpServletRequest)request), comment);
                    if (commentId == null) {
                        return ERRORINFO;
                    }
                    comment.setCommentId(commentId);
                }
                if (!"".equals(imageNames)) {
                    if (!this.goodsCommentService.checkCommGoodIsUser(orderGoodsId, customerId, "2")) {
                        return ERRORINFO;
                    }
                    share.setCommentId(comment.getCommentId());
                    share.setShareContent(comment.getCommentContent());
                    this.shareServiceMapper.saveShare(comment.getGoodsId(), share, customerId, orderGoodsId, imageNames);
                    if (null != share.getShareTitle()) {
                        OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customer.getCustomerUsername(), (String)"\u4fdd\u5b58\u6652\u5355\u4fe1\u606f", (String)("\u4fdd\u5b58\u6652\u5355\u4fe1\u606f-->\u6652\u5355\u6807\u9898\u3010" + share.getShareTitle() + "\u3011-->\u7528\u6237 \u540d\uff1a" + customer.getCustomerUsername()));
                        logger.info((Object)("\u4fdd\u5b58\u6652\u5355\u4fe1\u606f\u6210\u529f\uff01\u6652\u5355\u6807\u9898\u3010" + share.getShareTitle()));
                    }
                }
                return "ok";
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("saveShare error", (Throwable)e);
                return ERRORINFO;
            }
        }
        return ERRORINFO;
    }

    @RequestMapping(value={"share/upload"})
    public void uploadShareImg(MultipartHttpServletRequest request, HttpServletResponse resp, Long orderGoodsId) throws IOException {
        PrintWriter out = resp.getWriter();
        String msg = null;
        MultipartFile file = request.getFile("shareFile");
        file.getOriginalFilename();
        msg = file.getSize() > 0x400000L ? "101" : (!this.checkExtendsName(file.getOriginalFilename()) ? "102" : UploadUtil.uploadFileOne((MultipartFile)request.getFile("shareFile"), (HttpServletRequest)request) + "," + orderGoodsId);
        out.append("<script>parent.callback('" + msg + "');</script>");
    }

    private boolean checkExtendsName(String fileName) {
        String[] extendNames;
        if (null != fileName) {
            logger.info((Object)("\u68c0\u67e5\u6587\u4ef6\u6269\u5c55\u540d\u3010" + fileName + "\u3011\u662f\u5426\u4e3a\u56fe\u7247"));
        }
        if (fileName.indexOf(".") < 0) {
            return false;
        }
        String extend = fileName.substring(fileName.lastIndexOf(".") + 1);
        for (String extendName : extendNames = new String[]{"jpg", "jpeg", "bmp", "png", "gif"}) {
            if (!extend.equals(extendName)) continue;
            return true;
        }
        return false;
    }

    @RequestMapping(value={"/share"})
    public ModelAndView shareList(Long productId, Long distinctId, Long shareId) {
        Long emp = distinctId;
        if (null == distinctId) {
            emp = 1L;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("distinctId", emp);
        map.put("share", this.shareServiceMapper.queryShareById(shareId));
        map.put("topShare", this.shareServiceMapper.getTopShare(24));
        return this.topAndBottomService.getTopAndBottom(new ModelAndView("goods/share").addObject("map", map));
    }

    public CustomerServiceMapper getCustomerServiceMapper() {
        return this.customerServiceMapper;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceMapper(CustomerServiceMapper customerServiceMapper) {
        this.customerServiceMapper = customerServiceMapper;
    }

    public ShareService getShareServiceMapper() {
        return this.shareServiceMapper;
    }

    @Resource(name="shareServiceNew")
    public void setShareServiceMapper(ShareService shareServiceMapper) {
        this.shareServiceMapper = shareServiceMapper;
    }

    public MegawizardService getMegawizardSerivce() {
        return this.megawizardSerivce;
    }

    @Resource(name="MegawizardService")
    public void setMegawizardSerivce(MegawizardService megawizardSerivce) {
        this.megawizardSerivce = megawizardSerivce;
    }

    public TempService getTempService() {
        return this.tempService;
    }

    @Resource(name="TempService")
    public void setTempService(TempService tempService) {
        this.tempService = tempService;
    }

    public TopAndBottomService getTopAndBottomService() {
        return this.topAndBottomService;
    }

    @Resource(name="TopAndBottomService")
    public void setTopAndBottomService(TopAndBottomService topAndBottomService) {
        this.topAndBottomService = topAndBottomService;
    }

    public CustomerServiceMapper getCustomerServiceInterface() {
        return this.customerServiceInterface;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceInterface(CustomerServiceMapper customerServiceInterface) {
        this.customerServiceInterface = customerServiceInterface;
    }
}

