/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.index;

import com.qianjiang.channel.bean.Channel;
import com.qianjiang.channel.bean.GoodsSiteSearchBean;
import com.qianjiang.channel.service.ChannelAdverService;
import com.qianjiang.channel.service.ChannelSalesGoodsService;
import com.qianjiang.channel.service.SysChannelService;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.goods.vo.GoodsCateVo;
import com.qianjiang.index.bean.IndexFloor;
import com.qianjiang.index.bean.IndexGoodsBean;
import com.qianjiang.index.service.ChannelSiteService;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.information.service.InformationService;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.DefaultAddressService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ChannelSiteController {
    private static final MyLogger LOGGER = new MyLogger(ChannelSiteController.class);
    private static final String DISTINCTID = "distinctId";
    private static final String CHANNEL_VIEW = "subtopic/cateChannel";
    private static final Long ATID1 = 157L;
    private static final Long ATID2 = 159L;
    private static final Long ATID3 = 161L;
    private static final Long ADVERTTYPE = 151L;
    private static final int ADVERTNUM = 3;
    @Resource(name="SysChannelService")
    private SysChannelService channelService;
    @Resource(name="GoodsCateService")
    private GoodsCateService goodsCateService;
    @Resource(name="ChannelSiteService")
    private ChannelSiteService channelSiteService;
    @Resource(name="ChannelAdverService")
    private ChannelAdverService channelAdverService;
    @Resource(name="InformationService")
    private InformationService infoService;
    @Resource(name="ChannelSalesGoodsService")
    private ChannelSalesGoodsService channelSalesGoodsService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="TopAndBottomService")
    private TopAndBottomService topAndBottomService;
    @Resource(name="DefaultAddressService")
    private DefaultAddressService addressService;

    @ResponseBody
    @RequestMapping(value={"/channelCateNavViewText"}, produces={"application/json;charset=UTF-8"})
    public Object channelCateNavViewText(HttpServletRequest request, Long channelId, Long tempId) {
        return this.channelSiteService.getClassifyBar(channelId, tempId);
    }

    @ResponseBody
    @RequestMapping(value={"/channelStoreyViewText"}, produces={"application/json;charset=UTF-8"})
    public Object channelStoreyViewText(HttpServletRequest request, Long channelId, Long tempId) {
        return this.channelSiteService.getStoreys(channelId, tempId);
    }

    @RequestMapping(value={"/channelViewByAjax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map channelViewByAjax(HttpServletRequest request, Long goodsCateId, GoodsSiteSearchBean searchBean, PageBean pageBean) {
        HashMap<String, Object> maps = new HashMap<String, Object>();
        Channel channel = this.getChannel(goodsCateId);
        Long distinctId = null;
        if (null != request.getSession().getAttribute(DISTINCTID)) {
            distinctId = Long.parseLong(request.getSession().getAttribute(DISTINCTID).toString());
        }
        if (null == distinctId) {
            Long dId = this.addressService.getDefaultIdService();
            if (dId == null && (distinctId = this.addressService.getDefaultIdService()) == null) {
                distinctId = 749L;
            }
            maps.put(DISTINCTID, dId);
        } else {
            maps.put(DISTINCTID, distinctId);
        }
        pageBean.setPageSize(8);
        maps.put("searchBean", searchBean);
        IndexFloor indexFloor = this.channelSiteService.getChannelStoreys(distinctId, channel.getChannelId(), channel.getTempId(), searchBean, pageBean);
        maps.put("indexFloor", indexFloor);
        maps.put("goodsCateId", goodsCateId);
        return maps;
    }

    @RequestMapping(value={"/channelView"})
    public ModelAndView channelView(HttpServletRequest request, Long goodsCateId, GoodsSiteSearchBean searchBean, PageBean pageBean) {
        ModelAndView mav = new ModelAndView();
        Channel channel = this.getChannel(goodsCateId);
        GoodsCateVo cate = this.goodsCateService.queryCateByCatId(goodsCateId);
        if (null == channel) {
            String goodsListView = cate.getCatGrade() == 1 ? request.getContextPath() + "/list/" + cate.getCatId() + "-" + cate.getCatId() + ".html" : request.getContextPath() + "/list/" + cate.getCatId() + "-" + cate.getCatParentId() + ".html";
            mav.setView((View)new RedirectView(goodsListView));
            return mav;
        }
        mav.setViewName(CHANNEL_VIEW);
        mav.addObject("cate", (Object)cate);
        mav.addObject("sys", (Object)this.basicSetService.findBasicSet());
        mav.addObject("channel", (Object)channel);
        pageBean.setPageSize(8);
        Long distinctId = null;
        if (null != request.getSession().getAttribute(DISTINCTID)) {
            distinctId = Long.parseLong(request.getSession().getAttribute(DISTINCTID).toString());
        }
        if (null == distinctId) {
            Long dId = this.addressService.getDefaultIdService();
            if (dId == null && (distinctId = this.addressService.getDefaultIdService()) == null) {
                distinctId = 749L;
            }
            mav.addObject(DISTINCTID, (Object)dId);
        } else {
            mav.addObject(DISTINCTID, distinctId);
        }
        mav.addObject("searchBean", (Object)searchBean);
        mav.addObject("goodsCateId", (Object)goodsCateId);
        mav.addObject("floor", (Object)this.channelSiteService.getChannelStoreys(distinctId, channel.getChannelId(), channel.getTempId(), searchBean, pageBean));
        String infoName = channel.getInfoName();
        mav.addObject("infoName", (Object)infoName);
        mav.addObject("infoList", (Object)this.infoService.selectByInfoType(channel.getInfoTypeId()));
        mav.addObject("avc", (Object)this.channelAdverService.selectchannelAdverByParamForSite(channel.getChannelId(), channel.getTempId(), null, null, ATID1, ADVERTTYPE, null, "0", null, null));
        mav.addObject("avs", (Object)this.channelAdverService.selectchannelAdverByParamForSite(channel.getChannelId(), channel.getTempId(), null, null, ATID2, ADVERTTYPE, null, "0", null, null));
        mav.addObject("pageAdvs", (Object)this.channelAdverService.selectchannelAdverByParamForSite(channel.getChannelId(), channel.getTempId(), null, null, ATID3, ADVERTTYPE, null, "0", null, null));
        mav.addObject("classifyBar", (Object)this.channelSiteService.getClassifyBar(channel.getChannelId(), channel.getTempId()));
        mav.addObject("channelGoodsFlag0", (Object)this.channelSalesGoodsService.selectChannelGoodsByFlag(channel.getChannelId(), "0", 3));
        mav.addObject("channelGoodsFlag1", (Object)this.channelSalesGoodsService.selectChannelGoodsByFlag(channel.getChannelId(), "1", 3));
        mav.addObject("channelGoodsFlag2", (Object)this.channelSalesGoodsService.selectChannelGoodsByFlag(channel.getChannelId(), "2", 3));
        return this.topAndBottomService.getTopAndBottom(mav);
    }

    @RequestMapping(value={"/loadstoreytagproduct"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<IndexGoodsBean> loadStoreyTagProduct(Long tagId) {
        return this.channelSiteService.selectStoreyTagProductsByTagId(tagId);
    }

    private Channel getChannel(Long goodsCateId) {
        try {
            GoodsCateVo cate = this.goodsCateService.queryCateByCatId(goodsCateId);
            if (cate.getCatGrade() == 1) {
                return this.channelService.selectByCateId(cate.getCatId());
            }
            if (cate.getCatGrade() == 2) {
                return this.channelService.selectByCateId(cate.getCatParentId());
            }
            LOGGER.debug("==============================\u5546\u54c1\u5206\u7c7b\u4e0d\u662f\u4e00\u7ea7\u3001\u4e8c\u7ea7\u5206\u7c7b");
            return null;
        }
        catch (Exception e) {
            LOGGER.error("==============================\u52a0\u8f7d\u9891\u9053\u6a21\u677f\u5f02\u5e38\uff01", (Throwable)e);
            return new Channel();
        }
    }
}

