/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.order.controller;

import com.qianjiang.order.bean.Order;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.site.order.service.SiteOrderService;
import com.qianjiang.site.order.util.HttpUtil;
import com.qianjiang.site.order.util.PayCommonUtil;
import com.qianjiang.site.order.util.PayConfigUtil;
import com.qianjiang.site.order.util.XMLUtil;
import com.qianjiang.system.bean.Pay;
import com.qianjiang.system.bean.Receivables;
import com.qianjiang.system.service.PayService;
import com.qianjiang.system.service.ReceivablesService;
import com.qianjiang.util.MyLogger;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Resource;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WeChatPayController {
    private static final MyLogger logger = new MyLogger(WeChatPayController.class);
    @Resource(name="OrderService")
    private OrderService orderService;
    @Resource(name="payService")
    private PayService payService;
    @Resource(name="SiteOrderService")
    private SiteOrderService siteOrderService;
    @Resource(name="receivablesService")
    private ReceivablesService receivablesService;

    @RequestMapping(value={"/weixinCode"})
    @ResponseBody
    public String weiXinCode(Long orderId, HttpServletRequest request, Long payId, Long orderCount) throws Exception {
        if (orderId != null && !"".equals(orderId)) {
            request.getSession().setAttribute("oldOrderCode", (Object)orderId);
        }
        String weiXinCode = this.weixin_pay(orderId, payId, request);
        return weiXinCode;
    }

    @RequestMapping(value={"/queryOrderStatus"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String queryOrderStatus(HttpServletRequest request, Long orderId) {
        if (orderId == 0L || orderId == null) {
            return "0";
        }
        Order order = this.siteOrderService.getPayOrder(orderId);
        if (order != null && "1".equals(order.getOrderStatus())) {
            return order.getOrderId().toString();
        }
        return "0";
    }

    @RequestMapping(value={"/weiXinNotify"})
    public void weixin_notify(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String s;
        System.out.println("************\u5fae\u4fe1\u56de\u8c03****************");
        StringBuffer sb = new StringBuffer();
        ServletInputStream inputStream = request.getInputStream();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)inputStream, "UTF-8"));
        while ((s = in.readLine()) != null) {
            sb.append(s);
        }
        in.close();
        inputStream.close();
        Map m = new HashMap();
        m = XMLUtil.doXMLParse(sb.toString());
        TreeMap<Object, Object> packageParams = new TreeMap<Object, Object>();
        for (String parameter : m.keySet()) {
            String parameterValue = (String)m.get(parameter);
            String v = "";
            if (null != parameterValue) {
                v = parameterValue.trim();
            }
            packageParams.put(parameter, v);
        }
        String key = PayConfigUtil.API_KEY;
        logger.info(packageParams);
        if (PayCommonUtil.isTenpaySign("UTF-8", packageParams, key)) {
            String resXml = "";
            if ("SUCCESS".equals((String)packageParams.get("result_code"))) {
                String orderCode = (String)packageParams.get("out_trade_no");
                Order or = this.siteOrderService.getPayOrderByCode(orderCode);
                logger.info((Object)("=================\u5fae\u4fe1\u652f\u4ed8===========" + or.getOrderId()));
                this.siteOrderService.payOrder(or.getOrderId());
                Receivables receivables = this.receivablesService.queryByOrderCode(orderCode);
                this.receivablesService.updatePayStatus(receivables);
                String mch_id = (String)packageParams.get("mch_id");
                String openid = (String)packageParams.get("openid");
                String is_subscribe = (String)packageParams.get("is_subscribe");
                String out_trade_no = (String)packageParams.get("out_trade_no");
                String total_fee = (String)packageParams.get("total_fee");
                logger.info((Object)("mch_id:" + mch_id));
                logger.info((Object)("openid:" + openid));
                logger.info((Object)("is_subscribe:" + is_subscribe));
                logger.info((Object)("out_trade_no:" + out_trade_no));
                logger.info((Object)("total_fee:" + total_fee));
                logger.info((Object)"\u652f\u4ed8\u6210\u529f");
                resXml = "<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg></xml> ";
            } else {
                logger.info((Object)("\u652f\u4ed8\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a" + packageParams.get("err_code")));
                resXml = "<xml><return_code><![CDATA[FAIL]]></return_code><return_msg><![CDATA[\u62a5\u6587\u4e3a\u7a7a]]></return_msg></xml> ";
            }
            PrintWriter writer = response.getWriter();
            writer.write(resXml);
            writer.flush();
            writer.close();
        } else {
            logger.info((Object)"\u901a\u77e5\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    public String weixin_pay(Long orderId, Long payId, HttpServletRequest request) throws Exception {
        Order order = this.siteOrderService.getPayOrder(orderId);
        Pay p = this.payService.findByPayId(payId);
        this.orderService.updateOrderPayType(orderId, payId.intValue());
        String appid = p.getApiKey();
        String mch_id = p.getPartner();
        String key = p.getPartnerKey();
        request.getSession().setAttribute("apiKey", (Object)key);
        String currTime = PayCommonUtil.getCurrTime();
        String strTime = currTime.substring(8, currTime.length());
        String strRandom = PayCommonUtil.buildRandom(4) + "";
        String nonce_str = strTime + strRandom;
        String order_price = "1";
        String body = "\u5fae\u4fe1\u626b\u7801\u6d4b\u8bd5";
        String out_trade_no = order.getOrderCode();
        String spbill_create_ip = p.getPayAccount();
        String notify_url = p.getBackUrl();
        String trade_type = "NATIVE";
        TreeMap<Object, Object> packageParams = new TreeMap<Object, Object>();
        packageParams.put("appid", appid);
        packageParams.put("mch_id", mch_id);
        packageParams.put("nonce_str", nonce_str);
        packageParams.put("body", body);
        packageParams.put("out_trade_no", out_trade_no);
        packageParams.put("total_fee", order_price);
        packageParams.put("spbill_create_ip", spbill_create_ip);
        packageParams.put("notify_url", notify_url);
        packageParams.put("trade_type", trade_type);
        String sign = PayCommonUtil.createSign("UTF-8", packageParams, key);
        packageParams.put("sign", sign);
        String requestXML = PayCommonUtil.getRequestXml(packageParams);
        System.out.println(requestXML);
        String resXml = HttpUtil.postData(p.getPayUrl(), requestXML);
        logger.info((Object)("\u5fae\u4fe1\u4e8c\u7ef4\u7801\uff1a" + resXml));
        Map map = XMLUtil.doXMLParse(resXml);
        String return_code = (String)map.get("return_code");
        String prepay_id = (String)map.get("prepay_id");
        String urlCode = (String)map.get("code_url");
        System.out.println("**********************************");
        System.out.println(map.get("return_msg"));
        System.out.println(return_code);
        System.out.println(prepay_id);
        System.out.println(urlCode);
        return urlCode;
    }
}

