/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.customer.controller;

import com.qianjiang.customer.service.CustomerConsumeServiceMapper;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.index.service.TopAndBottomService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ConsumeSiteController {
    private static final MyLogger LOGGER = new MyLogger(ConsumeSiteController.class);
    @Resource(name="customerConsumeServiceMapper")
    private CustomerConsumeServiceMapper customerConsumeService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceInterface;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;
    private TopAndBottomService topAndBottomService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/queryMyConsume"})
    public ModelAndView queryMyConsume(HttpServletRequest request, PageBean pb, Integer date) {
        ModelAndView mav = new ModelAndView();
        try {
            if (this.checkLoginStatus(request)) {
                Long customerId = (Long)request.getSession().getAttribute("customerId");
                CustomerAllInfo customer = this.customerServiceInterface.queryCustomerById(customerId);
                CustomerAllInfo customerAllInfo = this.customerServiceInterface.queryCustomerById((Long)request.getSession().getAttribute("customerId"));
                customerAllInfo.setInfoPointSum(Integer.valueOf(customerAllInfo.getInfoPointSum() - this.customerPointServiceMapper.getCustomerReducePoint((Long)request.getSession().getAttribute("customerId") + "")));
                mav.addObject("customer", (Object)customerAllInfo);
                if (null != customer.getCustomerUsername()) {
                    LOGGER.info((Object)("\u67e5\u8be2\u4f1a\u5458\u3010" + customer.getCustomerUsername() + "\u3011\u7684\u6d88\u8d39\u8bb0\u5f55"));
                }
                mav.addObject("date", (Object)date);
                mav.addObject("totalNum", (Object)this.customerConsumeService.selectTotalNumByCid(customerId));
                pb.setList(null);
                mav.addObject("pb", (Object)this.customerConsumeService.queryAllConsumeByCid(pb, customerId, date));
                pb.setUrl("customer/consume/" + date);
                mav.setViewName("customer/newpurchasehistory");
            } else {
                mav = new ModelAndView("/login/redirect").addObject("url", (Object)"/customer/consume/");
            }
            ModelAndView modelAndView = this.topAndBottomService.getTopAndBottom(mav);
            return modelAndView;
        }
        finally {
            mav = null;
        }
    }

    private boolean checkLoginStatus(HttpServletRequest request) {
        return request.getSession().getAttribute("customerId") != null;
    }

    public TopAndBottomService getTopAndBottomService() {
        return this.topAndBottomService;
    }

    @Resource(name="TopAndBottomService")
    public void setTopAndBottomService(TopAndBottomService topAndBottomService) {
        this.topAndBottomService = topAndBottomService;
    }
}

