/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.site.threepart.controller;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.service.CustomerService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.other.util.IPAddress;
import com.qianjiang.site.threepart.util.AlipayMessage;
import com.qianjiang.site.threepart.util.StringUtil;
import com.qianjiang.system.bean.Auth;
import com.qianjiang.system.service.AuthService;
import com.qianjiang.threepart.bean.ThreePart;
import com.qianjiang.threepart.service.ThreePartService;
import com.qianjiang.util.MyLogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class AfterLoginAlipayController {
    private static final MyLogger LOGGER = new MyLogger(AfterLoginAlipayController.class);
    private AuthService authService;
    @Resource(name="customerService")
    private CustomerService customerServiceMapper;
    private ThreePartService threePartService;

    @RequestMapping(value={"afterloginalipay"})
    public ModelAndView afterLoginQQ(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html; charset=utf-8");
        try {
            Auth auth = this.authService.findAuthByAuthType("4");
            if (auth != null) {
                String appID = auth.getAuthClientId();
                String code = request.getParameter("code");
                String url = "https://openapi.alipay.com/gateway.do?grant_type=authorization_code&code=" + code;
                GetMethod getMethod = new GetMethod(url);
                HttpClient client = new HttpClient();
                Map<String, String> pmap = null;
                client.executeMethod((HttpMethod)getMethod);
                String userInfo = getMethod.getResponseBodyAsString();
                pmap = StringUtil.formatString(userInfo);
                if (pmap == null) {
                    return new ModelAndView((View)new RedirectView("404.html"));
                }
                String accessToken = pmap.get("access_token");
                String openid = pmap.get("alipay_user_id");
                ThreePart tp = this.threePartService.selectThreePart(openid);
                if (tp != null) {
                    Customer cus = this.customerServiceMapper.queryCustomerById(tp.getThreePartMemberId());
                    request.getSession().setAttribute("cust", (Object)cus);
                    request.getSession().setAttribute("customerId", (Object)cus.getCustomerId());
                } else {
                    Map<String, String> userData = AlipayMessage.getAlipayMessage("alipay.user.get", accessToken, appID, "sign", openid);
                    CustomerAllInfo allInfo = new CustomerAllInfo();
                    allInfo.setLoginIp(IPAddress.getIpAddr((HttpServletRequest)request));
                    allInfo.setPointLevelId(Long.valueOf(2L));
                    allInfo.setCustomerUsername(userData.get("nickname"));
                    allInfo.setCustomerPassword("");
                    allInfo.setCustomerNickname(userData.get("nickname"));
                    allInfo.setInfoGender("\u7537".equals(userData.get("gender")) ? "1" : "2");
                    int f = this.customerServiceMapper.addCustomer(allInfo);
                    if (f == 1) {
                        HashMap<String, String> paramMap = new HashMap<String, String>();
                        paramMap.put("username", userData.get("nickname"));
                        paramMap.put("password", "");
                        Customer customer = this.customerServiceMapper.selectCustomerByNamePwd(paramMap);
                        tp = new ThreePart();
                        tp.setThreePartUid(openid);
                        tp.setThreePartToken(accessToken);
                        tp.setThreePartMemberId(customer.getCustomerId());
                        this.threePartService.insertThreePart(tp);
                        Customer cus = this.customerServiceMapper.queryCustomerById(tp.getThreePartMemberId());
                        request.getSession().setAttribute("cust", (Object)cus);
                        request.getSession().setAttribute("customerId", (Object)cus.getCustomerId());
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u652f\u4ed8\u5b9d\u56de\u8c03\u9519\u8bef" + e);
        }
        return new ModelAndView((View)new RedirectView("index.html"));
    }

    public AuthService getAuthService() {
        return this.authService;
    }

    @Resource(name="authService")
    public void setAuthService(AuthService authService) {
        this.authService = authService;
    }

    public ThreePartService getThreePartService() {
        return this.threePartService;
    }

    @Resource(name="ThreePartService")
    public void setThreePartService(ThreePartService threePartService) {
        this.threePartService = threePartService;
    }
}

