/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.promotion.controller;

import com.qianjiang.promotion.bean.PromotionRushTime;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.util.PageBean;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PromotionRushController {
    private static final String REDIRECT = "redirect:queryrushtimelist.htm";
    @Resource(name="MarketingService")
    private PromotionService marketingService;

    @RequestMapping(value={"queryrushtimelist"})
    public ModelAndView queryRushTimeList(PageBean pageBean, HttpServletRequest request) {
        return new ModelAndView("jsp/marketing/rushtimelist").addObject("pageBean", (Object)this.marketingService.queryRushTime(pageBean));
    }

    @RequestMapping(value={"addmarketrushtime"})
    public ModelAndView addMarketRushTime(PromotionRushTime rushTime) {
        this.marketingService.addRushTime(rushTime);
        return new ModelAndView(REDIRECT);
    }

    @RequestMapping(value={"updatemarketrushtime"})
    public ModelAndView updateMarketRushTime(PromotionRushTime rushTime) {
        this.marketingService.updateRushTime(rushTime);
        return new ModelAndView(REDIRECT);
    }

    @RequestMapping(value={"delrushtime"})
    public ModelAndView delRushTime(Long tId) {
        this.marketingService.delRushTime(tId);
        return new ModelAndView(REDIRECT);
    }

    @RequestMapping(value={"delrushtimes"})
    public ModelAndView delRushTimes(Long[] tId) {
        this.marketingService.delRushTimes(tId);
        return new ModelAndView(REDIRECT);
    }

    @RequestMapping(value={"queryrushtimebyfalg"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<PromotionRushTime> queryRushTimeByFalg() {
        return this.marketingService.queryRushByFlag();
    }
}

