/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.coupon.controller;

import com.qianjiang.common.util.DateUtil;
import com.qianjiang.coupon.bean.Coupon;
import com.qianjiang.coupon.bean.CouponNo;
import com.qianjiang.coupon.bean.Customer;
import com.qianjiang.coupon.service.CouponLelevlService;
import com.qianjiang.coupon.service.CouponNoService;
import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.customer.service.PointLevelServiceMapper;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogBean;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.bean.BasicSet;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.util.BasicSetUtil;
import com.qianjiang.util.FileUploadForm;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class CouponController {
    private static final MyLogger LOGGER = new MyLogger(CouponController.class);
    private static final String PAGEBEAN = "pageBean";
    private static final String COUPON = "coupon";
    private static final String PRODUCTCATE = "productcate";
    private static final String SKULIST = "skulist";
    private static final String COUPONID = "couponId";
    private static final String PRODUCTBRAND = "productbrand";
    private static final String DATETIME = "yyyy-MM-dd HH:mm:ss";
    private static final String LOGGERINFO1 = "-->\u4f18\u60e0\u5238\u540d\u79f0\u3010";
    private static final String LOGGERINFO2 = "\u3011,\u7528\u6237\u540d\uff1a";
    private static final String LOGGERINFO3 = "\u6dfb\u52a0\u4f18\u60e0\u52b5\u51fa\u9519";
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="CouponService")
    private CouponService couponService;
    @Resource(name="GoodsBrandService")
    private GoodsBrandService goodsBrandService;
    @Resource(name="CouponNoService")
    private CouponNoService couponNoService;
    @Resource(name="CouponLelevlService")
    private CouponLelevlService couponLelevlService;
    @Resource(name="pointLevelServiceMapper")
    private PointLevelServiceMapper pointLevelServiceMapper;

    @RequestMapping(value={"addcouponpx"})
    public ModelAndView addCouponPx(HttpServletRequest request) {
        Coupon coupon = this.couponService.selectOneCouponNoByCouponIdAndUpdateNoIsGet(Long.valueOf(166L), (Long)request.getSession().getAttribute("customerId"));
        if (coupon == null) {
            this.couponService.addCouponC(Long.valueOf(166L));
            coupon = this.couponService.selectOneCouponNoByCouponIdAndUpdateNoIsGet(Long.valueOf(166L), (Long)request.getSession().getAttribute("customerId"));
        }
        this.couponService.giveCusCoupon(coupon.getCodeNo(), (Long)request.getSession().getAttribute("customerId"));
        return new ModelAndView("redirect:/item/3291.html");
    }

    @RequestMapping(value={"addcounponpxc"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int addCounponPxC(Long couponId) {
        try {
            this.couponService.addCouponC(couponId);
        }
        catch (Exception e) {
            LOGGER.error("" + e.getMessage(), (Throwable)e);
            return 1;
        }
        return 0;
    }

    @RequestMapping(value={"/couponlist"})
    public ModelAndView searchCouponList(Coupon coupon, PageBean pageBean, String startTime, String endTime, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        pageBean.setUrl("couponlist.htm");
        try {
            coupon.setBusinessId(0L);
            PageBean searchCouponList = this.couponService.searchCouponList(coupon, pageBean, startTime, endTime);
            mav.addObject(PAGEBEAN, (Object)searchCouponList);
            mav.setViewName("jsp/coupon/couponlist");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5e73\u53f0\u7aef\u521d\u59cb\u5316\u4f18\u60e0\u5238\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/querycouponlistall"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean queryCouponListAll(HttpServletRequest request, Coupon coupon, PageBean pageBean, String startTime, String endTime, String couponSearchName) {
        PageBean searchCouponList = null;
        try {
            if (couponSearchName != null && !"".equals(couponSearchName)) {
                coupon.setCouponName(URLDecoder.decode(couponSearchName, "UTF-8"));
            }
            coupon.setBusinessId((Long)request.getSession().getAttribute("thirdId"));
            searchCouponList = this.couponService.searchCouponList(coupon, pageBean, startTime, endTime);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u4f18\u60e0\u5238\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return searchCouponList;
    }

    @RequestMapping(value={"/toupdatecoupon"})
    public ModelAndView toUpdateCoupon(Long couponId, HttpServletRequest request) {
        return new ModelAndView("jsp/coupon/updatecoupon", COUPON, (Object)this.couponService.searchCouponById(couponId)).addObject(PRODUCTCATE, this.couponService.selectCouponRange(couponId, "0")).addObject(PRODUCTBRAND, this.couponService.selectCouponRange(couponId, "1")).addObject(SKULIST, this.couponService.selectCouponRange(couponId, "2")).addObject("brandlist", (Object)this.goodsBrandService.queryAllBrandList()).addObject("customerLevel", (Object)this.pointLevelServiceMapper.selectAllPointLevel()).addObject("listLevel", (Object)this.couponLelevlService.selectCouponLelvel(couponId));
    }

    @RequestMapping(value={"/searchcouponbyid"})
    public ModelAndView searchCouponById(Long couponId) {
        return new ModelAndView("jsp/coupon/coupondetail", COUPON, (Object)this.couponService.searchCouponById(couponId)).addObject(PRODUCTCATE, this.couponService.selectCouponRange(couponId, "0")).addObject(PRODUCTBRAND, this.couponService.selectCouponRange(couponId, "1")).addObject(SKULIST, this.couponService.selectCouponRange(couponId, "2")).addObject("couponNo", (Object)this.couponNoService.selectNoByCouponId(couponId)).addObject("levelNamelist", (Object)this.couponLelevlService.queryLevelNameByCouponId(couponId));
    }

    @RequestMapping(value={"/searchCouponByIdAjax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> searchCouponByIdAjax(Long couponId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(COUPON, this.couponService.searchCouponById(couponId));
        map.put(PRODUCTCATE, this.couponService.selectCouponRange(couponId, "0"));
        map.put(PRODUCTBRAND, this.couponService.selectCouponRange(couponId, "1"));
        map.put(SKULIST, this.couponService.selectCouponRange(couponId, "2"));
        map.put("couponNo", this.couponNoService.selectNoByCouponId(couponId));
        map.put("levelNamelist", this.couponLelevlService.queryLevelNameByCouponId(couponId));
        return map;
    }

    @RequestMapping(value={"/doupdatecouponbyid"})
    public ModelAndView doUpdateCouponById(HttpServletRequest request, @ModelAttribute(value="uploadForm") FileUploadForm uploadForm, Coupon coupon, String couponSTime, String couponETime, Long[] lelvelId, String status) {
        SimpleDateFormat formatDate = new SimpleDateFormat(DATETIME);
        try {
            coupon.setCouponStartTime(formatDate.parse(couponSTime));
            coupon.setCouponEndTime(formatDate.parse(couponETime));
        }
        catch (ParseException e) {
            LOGGER.info((Object)"\u66f4\u65b0\u4f18\u60e0\u5238\uff01");
        }
        String couponPic = UploadUtil.uploadFileOne((MultipartFile)uploadForm.getCouponImg());
        coupon.setCouponPic(couponPic);
        this.couponService.doUpdateCouponById(coupon, request, lelvelId, status);
        if (null != coupon.getCouponName()) {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u4fee\u6539\u4f18\u60e0\u52b5", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + coupon.getCouponName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
        }
        return new ModelAndView((View)new RedirectView("couponlist.htm"));
    }

    @RequestMapping(value={"/selectcouponnolist"})
    public ModelAndView selectCouponNoList(PageBean pageBean, Long couponId, CouponNo couponNo, HttpServletRequest request) {
        pageBean.setUrl("selectcouponnolist.htm");
        return new ModelAndView("jsp/coupon/codexlist").addObject(PAGEBEAN, (Object)this.couponNoService.selectList(pageBean, couponId, couponNo)).addObject(COUPONID, (Object)couponId);
    }

    @RequestMapping(value={"/selectcouponnolistajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> selectcouponnolistajax(PageBean pageBean, Long couponId, CouponNo couponNo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(PAGEBEAN, this.couponNoService.selectList(pageBean, couponId, couponNo));
        map.put(COUPONID, couponId);
        return map;
    }

    @RequestMapping(value={"/newselectcouponnolistajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> newselectcouponnolistajax(PageBean pageBean, Long couponId, CouponNo couponNo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(PAGEBEAN, this.couponNoService.selectCouponList(couponId, couponNo));
        map.put(COUPONID, couponId);
        return map;
    }

    @RequestMapping(value={"/toaddcoupon"})
    public ModelAndView toAddCoupon(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            List queryAllBrandList = this.goodsBrandService.queryAllBrandList();
            List selectAllPointLevel = this.pointLevelServiceMapper.selectAllPointLevel();
            mav.addObject("brandlist", (Object)queryAllBrandList);
            mav.addObject("customerLevel", (Object)selectAllPointLevel);
            mav.setViewName("jsp/coupon/addcoupon");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8df3\u8f6c\u4f18\u60e0\u5238\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/doaddcoupon"})
    public ModelAndView doAddCoupon(HttpServletRequest request, @ModelAttribute(value="uploadForm") FileUploadForm uploadForm, @Valid Coupon coupon, String couponSTime, String couponETime, Long[] lelvelId, String status, String csrFToken, BindingResult result) {
        ModelAndView mav = new ModelAndView();
        try {
            coupon.setBusinessId(0L);
            coupon.setCouponStartTime(DateUtil.stringToDate((String)couponSTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            coupon.setCouponEndTime(DateUtil.stringToDate((String)couponETime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            String couponPic = UploadUtil.uploadFileOne((MultipartFile)uploadForm.getCouponImg());
            if (couponPic != null && !couponPic.isEmpty()) {
                coupon.setCouponPic(couponPic);
            }
            this.couponService.doAddCoupon(coupon, request, lelvelId, status);
            if (null != coupon.getCouponName()) {
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6dfb\u52a0\u4f18\u60e0\u5238", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + coupon.getCouponName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
            }
            mav.setView((View)new RedirectView("couponlist.htm"));
        }
        catch (Exception e) {
            String operaCode = LOGGERINFO3;
            String operaContent = request.getSession().getAttribute("operaPath") + LOGGERINFO3;
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)request.getSession().getAttribute("name").toString(), (String)operaCode, (String)operaContent);
        }
        return mav;
    }

    @RequestMapping(value={"/doaddcouponnew"})
    public ModelAndView doAddCouponNew(HttpServletRequest request, @Valid Coupon coupon, String couponSTime, String couponETime, Long[] lelvelId, String status, String csrFToken, BindingResult result) {
        ModelAndView mav = new ModelAndView();
        try {
            coupon.setBusinessId(0L);
            coupon.setCouponStartTime(DateUtil.stringToDate((String)couponSTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            coupon.setCouponEndTime(DateUtil.stringToDate((String)couponETime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            this.couponService.doAddCoupon(coupon, request, lelvelId, status);
            if (null != coupon.getCouponName()) {
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6dfb\u52a0\u4f18\u60e0\u5238", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + coupon.getCouponName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
            }
            mav.setView((View)new RedirectView("couponlist.htm"));
        }
        catch (Exception e) {
            String operaCode = LOGGERINFO3;
            String operaContent = request.getSession().getAttribute("operaPath") + LOGGERINFO3;
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)request.getSession().getAttribute("name").toString(), (String)operaCode, (String)operaContent);
        }
        return mav;
    }

    @RequestMapping(value={"/delcoupon"})
    public ModelAndView delCoupon(HttpServletRequest request, Long couponId) {
        Coupon coupon = this.couponService.searchCouponById(couponId);
        int result = this.couponService.delCoupon(couponId);
        if (1 == result && null != coupon.getCouponName()) {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u5220\u9664\u4f18\u60e0\u5238", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + coupon.getCouponName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
        }
        return new ModelAndView((View)new RedirectView("couponlist.htm"));
    }

    @RequestMapping(value={"/delallcoupon"})
    public ModelAndView delAllCoupon(HttpServletRequest request, Long[] couponId) {
        this.couponService.delAllCoupon(couponId);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u66f4\u65b0\u4ed3\u5e93\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + ",\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("couponlist.htm"));
    }

    @RequestMapping(value={"/getCouponNoByCouponId"})
    public void getCouponNoByCouponId(Long couponId, HttpServletResponse response, HttpServletRequest request) {
        Coupon coupon = this.couponService.searchCouponById(couponId);
        try {
            PrintWriter pw = response.getWriter();
            Date d = new Date();
            if (coupon.getCouponEndTime().after(d)) {
                BasicSet bs = this.basicSetService.findBasicSet();
                String bsetAddress = BasicSetUtil.getAddress((String)bs.getBsetAddress());
                pw.print(bsetAddress + "/getOffCoupon-" + couponId + ".html");
            } else {
                pw.print("0");
            }
        }
        catch (IOException e) {
            Customer cust = (Customer)request.getSession().getAttribute("cust");
            OperaLogBean operaLogBean = new OperaLogBean((Exception)e, cust.getCustomerUsername());
            operaLogBean.setIp(IPAddress.getIpAddr((HttpServletRequest)request));
            operaLogBean.setLoginUserId((Long)request.getSession().getAttribute("loginUserId"));
            operaLogBean.setName((String)request.getSession().getAttribute("name"));
            OperaLogUtil.addOperaException((OperaLogBean)operaLogBean);
        }
    }

    @RequestMapping(value={"exportCouponCodeNo"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void exportCouponCodeNo(HttpServletResponse response, Long couponId) {
        LOGGER.info((Object)"\u5bfc\u51fa\u4f18\u60e0\u5238\u5238\u7801");
        this.couponNoService.exportCouponCodeNo(response, couponId);
    }

    @RequestMapping(value={"openGetCouponPage"})
    public ModelAndView openGetCouponPage(Long couponId, String flag, String url, Long codeId) {
        Coupon coupon = this.couponService.searchCouponById(couponId);
        int num = this.couponNoService.getCouponGetNoByCouponId(couponId);
        if (coupon.getCouponGetNo() > (long)num) {
            this.couponNoService.changeCouponGetAndStatus(codeId);
        }
        if (Integer.parseInt(flag) == 0) {
            return new ModelAndView("jsp/coupon/openfaildialog");
        }
        if (Integer.parseInt(flag) == 1) {
            return new ModelAndView("jsp/coupon/opendialog").addObject("url", (Object)url);
        }
        return new ModelAndView("jsp/coupon/openfaildialog");
    }
}

