/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.gift.controller;

import com.qianjiang.gift.bean.GiftCate;
import com.qianjiang.gift.service.GiftCateService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class GiftCateController {
    private static final MyLogger LOGGER = new MyLogger(GiftCateController.class);
    private static final String LOGGERINFO1 = "-->\u8d60\u54c1\u5206\u7c7b\u540d\u79f0\u3010";
    private static final String LOGGERINFO2 = "\u3011,\u7528\u6237\u540d\uff1a";
    private GiftCateService giftCateService;

    @RequestMapping(value={"/searchgiftcatelist"})
    public ModelAndView toSearchGiftCateList() {
        return new ModelAndView("jsp/gift/giftcatelist");
    }

    @RequestMapping(value={"/dosearchgiftcatelist"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean doSearchGiftCateList(PageBean pageBean, GiftCate giftCate) {
        if (null != giftCate.getGiftCateName()) {
            LOGGER.info((Object)("\u83b7\u53d6\u5206\u7c7b\u540d\u79f0\u4e3a\uff1a" + giftCate.getGiftCateName() + "\u7684\u4fe1\u606f\uff01"));
        }
        pageBean.setUrl("dosearchgiftcatelist.htm");
        return this.giftCateService.searchGiftCateList(giftCate, pageBean);
    }

    @RequestMapping(value={"/searchgiftcatelistNopage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Object> searchgiftcatelistNopage(GiftCate giftCate) {
        if (null != giftCate.getGiftCateName()) {
            LOGGER.info((Object)("\u83b7\u53d6\u5206\u7c7b\u540d\u79f0\u4e3a\uff1a" + giftCate.getGiftCateName() + "\u7684\u4fe1\u606f\uff01"));
        }
        return this.giftCateService.searchGiftCateListNoPage(giftCate);
    }

    @RequestMapping(value={"/querygiftcate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<GiftCate> giftCateList(Long giftCateId) {
        if (null != giftCateId) {
            return this.giftCateService.searchGiftCateList(giftCateId);
        }
        return this.giftCateService.searchGiftCateList();
    }

    @RequestMapping(value={"/searchgiftcatebyid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public GiftCate searchGiftCateById(Long giftCateId) {
        GiftCate giftCate = this.giftCateService.searchGiftCateById(giftCateId);
        if (null != giftCate.getGiftCateName()) {
            LOGGER.info((Object)("\u67e5\u8be2\u8d60\u54c1\u5206\u7c7b\u3010" + giftCate.getGiftCateName() + "\u3011\u8be6\u7ec6\u4fe1\u606f"));
        }
        return giftCate;
    }

    @RequestMapping(value={"addgiftcate"})
    public ModelAndView addGiftCate(HttpServletRequest request, GiftCate giftCate) {
        if (1 == this.giftCateService.addGiftCate(giftCate) && null != giftCate.getGiftCateName()) {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6dfb\u52a0\u8d60\u54c1\u5206\u7c7b", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + giftCate.getGiftCateName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
            LOGGER.info((Object)("\u65b0\u589e\u8d60\u54c1\u5206\u7c7b\u3010" + giftCate.getGiftCateName() + "\u3011\u6210\u529f"));
        }
        return new ModelAndView((View)new RedirectView("searchgiftcatelist.htm"));
    }

    @RequestMapping(value={"/updategiftcate"})
    public ModelAndView updateGiftCate(HttpServletRequest request, GiftCate giftCate) {
        if (null != giftCate.getGiftCateName()) {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u4fee\u6539\u8d60\u54c1\u5206\u7c7b", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + giftCate.getGiftCateName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
            LOGGER.info((Object)("\u4fee\u6539\u8d60\u54c1\u5206\u7c7b\u3010" + giftCate.getGiftCateName() + "\u3011\u6210\u529f"));
        }
        this.giftCateService.updateGiftCate(giftCate);
        return new ModelAndView((View)new RedirectView("searchgiftcatelist.htm"));
    }

    @RequestMapping(value={"/delgiftcate"})
    public ModelAndView delGiftCate(HttpServletRequest request, Long giftCateId) {
        GiftCate giftCate;
        if (1 == this.giftCateService.delGiftCate(giftCateId) && null != (giftCate = this.giftCateService.searchGiftCateById(giftCateId)).getGiftCateName()) {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u5220\u9664\u8d60\u54c1\u5206\u7c7b", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + giftCate.getGiftCateName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
            LOGGER.info((Object)("\u5220\u9664\u8d60\u54c1\u5206\u7c7b\u3010" + giftCate.getGiftCateName() + "\u3011\u6210\u529f"));
        }
        return new ModelAndView((View)new RedirectView("searchgiftcatelist.htm"));
    }

    @RequestMapping(value={"/delallgiftcate"})
    public ModelAndView delAllGiftCate(HttpServletRequest request, Long[] giftCateIds) {
        this.giftCateService.delAllGiftCate(giftCateIds);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u5220\u9664\u8d60\u54c1\u5206\u7c7b", (String)((String)request.getSession().getAttribute("operaPath") + ",\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("searchgiftcatelist.htm"));
    }

    @RequestMapping(value={"/checkgiftcate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkGIftCate(Long cateId) {
        GiftCate giftCate = this.giftCateService.searchGiftCateById(cateId);
        if (null != giftCate.getGiftCateName()) {
            LOGGER.info((Object)("\u5206\u7c7b\u4fe1\u606f\u3010" + giftCate.getGiftCateName() + "\u3011\u5b58\u5728\u5b50\u5206\u7c7b,\u4e0d\u53ef\u5220\u9664"));
        } else {
            LOGGER.info((Object)"\u9a8c\u8bc1\u5206\u7c7b\u662f\u5426\u5b58\u5728\u5b50\u5206\u7c7b,\u5982\u679c\u5b58\u5728\u5c31\u4e0d\u53ef\u5220\u9664");
        }
        return this.giftCateService.checkDelGiftCate(cateId);
    }

    public GiftCateService getGiftCateService() {
        return this.giftCateService;
    }

    @Resource(name="GiftCateService")
    public void setGiftCateService(GiftCateService giftCateService) {
        this.giftCateService = giftCateService;
    }
}

