/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.templet.controller;

import com.qianjiang.information.service.ThirdInforTypeService;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.ThirdTempService;
import com.qianjiang.third.seller.bean.StoreInfo;
import com.qianjiang.third.seller.service.SellerService;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.third.util.StringCommonUtil;
import com.qianjiang.util.UploadUtil;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ThirdTempController {
    @Resource(name="ThirdTempService")
    private ThirdTempService tempService;
    @Resource(name="ThirdInforTypeService")
    private ThirdInforTypeService thirdInforTypeService;
    @Resource(name="sellerService")
    private SellerService sellerService;
    private static final String TEMP = "temp";

    @ResponseBody
    @RequestMapping(value={"/checkThirdIndex"}, produces={"application/json;charset=UTF-8"})
    public boolean checkThirdIndex(HttpServletRequest request) {
        StoreInfo storeInfo = this.sellerService.selectByCustomerId((Long)request.getSession().getAttribute("customerId"));
        if (storeInfo == null) {
            storeInfo = this.sellerService.selectByEmployeeId((Long)request.getSession().getAttribute("customerId"));
        }
        return !"0".equals(storeInfo.getIsStoreIndex());
    }

    @RequestMapping(value={"/updateStoreIndex"})
    public ModelAndView updateStoreIndex(StoreInfo storeInfo) {
        this.sellerService.updateStoreIndexState(storeInfo);
        return new ModelAndView((View)new RedirectView("sellerinfo.html?n=2&l=17"));
    }

    @RequestMapping(value={"/queryThirdTempByType"})
    public ModelAndView queryTempByType(HttpServletRequest request, String n, String l) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        List indexList = this.tempService.querySystempByType(Long.valueOf(137L));
        return new ModelAndView("/temp/temp_list", "indexList", (Object)indexList).addObject("info", (Object)this.sellerService.selectByCustomerId((Long)request.getSession().getAttribute("customerId")));
    }

    @RequestMapping(value={"/showThirdTempInfo"})
    public ModelAndView showTempInfo(Long tempId) {
        return new ModelAndView("temp/show_temp", TEMP, (Object)this.tempService.getSystempById(tempId));
    }

    @RequestMapping(value={"/toUpdateThirdTempInfo"})
    public ModelAndView toUpdateTempInfo(Long tempId) {
        return new ModelAndView("temp/update_temp", TEMP, (Object)this.tempService.getSystempById(tempId));
    }

    @RequestMapping(value={"/updateThirdTempInfo"})
    public ModelAndView updateTempInfo(MultipartHttpServletRequest request, SysTemp temp) throws UnsupportedEncodingException {
        MultipartFile muFile = request.getFile("imgSrc");
        if (muFile.getSize() > 0L) {
            temp.setTempImageUrl(UploadUtil.uploadFileOne((MultipartFile)muFile));
        }
        temp.setTempName(StringCommonUtil.charsetConversion(temp.getTempName(), "ISO-8859-1", "utf-8"));
        temp.setDes(StringCommonUtil.charsetConversion(temp.getDes(), "ISO-8859-1", "utf-8"));
        temp.setVersion(StringCommonUtil.charsetConversion(temp.getVersion(), "ISO-8859-1", "utf-8"));
        this.tempService.updateSystemp(temp);
        return new ModelAndView((View)new RedirectView("queryThirdTempByType.htm"));
    }

    @RequestMapping(value={"/toUpdateThirdTempInfoType"})
    public ModelAndView toUpdateThirdTempInfoType(HttpServletRequest request, Long tempId) {
        String thirdId = ((Long)request.getSession().getAttribute("thirdId")).toString();
        List infoTypes = this.thirdInforTypeService.selectInfoTypeByAttr(thirdId);
        return new ModelAndView("temp/temp_news", TEMP, (Object)this.tempService.getSystempById(tempId)).addObject("infoTypes", (Object)infoTypes);
    }

    @RequestMapping(value={"/updateThirdTempInfoType"})
    public ModelAndView updateTempInfoType(SysTemp temp, HttpServletRequest request) throws UnsupportedEncodingException {
        temp.setExpFleid2(StringCommonUtil.charsetConversion(temp.getExpFleid2(), "ISO-8859-1", "utf-8"));
        this.tempService.updateSystemp(temp);
        return new ModelAndView((View)new RedirectView("toUpdateThirdTempInfoType.htm?tempId=" + temp.getTempId()));
    }

    @RequestMapping(value={"/setThirdTemp"})
    public ModelAndView setTemp(Long tempId) {
        return new ModelAndView("temp/temp_nav_list", TEMP, (Object)this.tempService.getSystempById(tempId));
    }
}

