/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.auth.controller;

import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.third.auth.bean.ThirdAuthority;
import com.qianjiang.third.auth.bean.ThirdManagerAuthority;
import com.qianjiang.third.auth.service.ThirdAuthorityService;
import com.qianjiang.third.logger.util.OperateLogUtil;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.third.util.PageBean;
import com.qianjiang.util.MyLogger;
import com.qianjiang.utils.SecurityUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public final class ThirdAuthorityController {
    private static final MyLogger LOGGER = new MyLogger(ThirdAuthorityController.class);
    private static final String THIRDID = "thirdId";
    private static final String ROLES = "roles";
    private ThirdAuthorityService thirdAuthorityService;
    private CustomerServiceMapper customerServiceMapper;

    @RequestMapping(value={"third/managerlist"})
    public ModelAndView managerList(HttpServletRequest request, String n, String l) {
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        return new ModelAndView("seller/managerlist").addObject(ROLES, (Object)this.thirdAuthorityService.queryThirdAuthorityByStotreId((Long)request.getSession().getAttribute(THIRDID)));
    }

    @RequestMapping(value={"/loadmanager"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> loadmanager(HttpServletRequest request) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(ROLES, this.thirdAuthorityService.queryThirdAuthorityByStotreId((Long)request.getSession().getAttribute(THIRDID)));
        return resultMap;
    }

    @RequestMapping(value={"third/employeelist"})
    public ModelAndView employeeList(HttpServletRequest request, String n, String l, PageBean pb) {
        String nNew = n;
        String lNew = l;
        if (nNew == null) {
            nNew = String.valueOf(request.getSession().getAttribute("n"));
        }
        if (lNew == null) {
            lNew = String.valueOf(request.getSession().getAttribute("l"));
        }
        MenuOperationUtil.fillSessionMenuIndex(request, nNew, lNew);
        pb.setUrl("employeelist.html?n=" + nNew + "&l=" + lNew);
        return new ModelAndView("seller/employeelist").addObject("pb", (Object)this.thirdAuthorityService.queryEmployeeListByStotreId((Long)request.getSession().getAttribute(THIRDID), pb)).addObject(ROLES, (Object)this.thirdAuthorityService.queryThirdAuthorityByStotreId((Long)request.getSession().getAttribute(THIRDID)));
    }

    @RequestMapping(value={"/modifyemptodisable"})
    public ModelAndView modifyEmpToDisable(HttpServletRequest request, Long custId, String flag) {
        this.customerServiceMapper.modifyEmpToDisableThird(custId, flag, (Long)request.getSession().getAttribute(THIRDID));
        if (request.getSession().getAttribute("customerId") != null) {
            CustomerAllInfo customer = this.customerServiceMapper.selectByPrimaryKey(custId);
            CustomerAllInfo customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"));
            if (customerAllInfo != null && customerAllInfo.getCustomerUsername() != null) {
                if ("disable".equals(flag)) {
                    OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u7981\u7528\u5546\u5bb6\u5458\u5de5", "\u7981\u7528\u5458\u5de5\uff1a" + customer.getCustomerUsername() + "-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
                    LOGGER.info((Object)"\u7981\u7528\u5546\u5bb6\u5458\u5de5");
                } else {
                    OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u542f\u7528\u5546\u5bb6\u5458\u5de5", "\u542f\u7528\u5458\u5de5\uff1a" + customer.getCustomerUsername() + "-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
                    LOGGER.info((Object)"\u542f\u7528\u5546\u5bb6\u5458\u5de5");
                }
            }
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/employeelist.html"));
    }

    @RequestMapping(value={"/updatebycustid"})
    public ModelAndView updateBycustId(HttpServletRequest request, ThirdManagerAuthority author) {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        author.setModTime(new Date());
        if (request.getSession().getAttribute("customerId") != null) {
            CustomerAllInfo customer = this.customerServiceMapper.selectByPrimaryKey(author.getManagerId());
            CustomerAllInfo customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"));
            if (customerAllInfo != null && customerAllInfo.getCustomerUsername() != null) {
                OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u4fee\u6539\u5458\u5de5\u6743\u9650", "\u4fee\u6539\u5458\u5de5:" + customer.getCustomerUsername() + "\u7684\u6743\u9650-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
                LOGGER.info((Object)"\u4fee\u6539\u5458\u5de5\u6743\u9650");
            }
        }
        this.thirdAuthorityService.updateByPrimaryKeySelective(author, thirdId);
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/employeelist.html"));
    }

    @RequestMapping(value={"/delemp"})
    public ModelAndView delCustomer(HttpServletRequest request, String[] custId) {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        if (request.getSession().getAttribute("customerId") != null) {
            CustomerAllInfo customer = this.customerServiceMapper.selectByPrimaryKey(Long.valueOf(custId[0]));
            CustomerAllInfo customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"));
            if (customerAllInfo != null && customerAllInfo.getCustomerUsername() != null) {
                OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u5220\u9664\u5546\u5bb6\u5458\u5de5", "\u5220\u9664\u5458\u5de5\uff1a" + customer.getCustomerUsername() + "-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
                LOGGER.info((Object)"\u5220\u9664\u5546\u5bb6\u5458\u5de5");
            }
        }
        this.customerServiceMapper.deleteCustomerThird(custId, thirdId);
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/employeelist.html"));
    }

    @RequestMapping(value={"/addemp"})
    public ModelAndView addEmp(HttpServletRequest request, com.qianjiang.third.other.bean.CustomerAllInfo allInfo, Long authId) {
        if (null != allInfo.getCustomerUsername() && 0L == this.customerServiceMapper.selectCustomerByName(allInfo.getCustomerUsername())) {
            CustomerAllInfo customerAllInfo;
            Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
            this.thirdAuthorityService.addEmp(thirdId, allInfo, authId);
            if (request.getSession().getAttribute("customerId") != null && (customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"))) != null && customerAllInfo.getCustomerUsername() != null) {
                OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u6dfb\u52a0\u5546\u5bb6\u5458\u5de5", "\u6dfb\u52a0\u5458\u5de5\uff1a" + allInfo.getCustomerUsername() + "-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
                LOGGER.info((Object)"\u6dfb\u52a0\u5546\u5bb6\u5458\u5de5");
            }
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/employeelist.html"));
    }

    @RequestMapping(value={"/toaddemp"})
    public ModelAndView toAddEmp() {
        return new ModelAndView("seller/addemp");
    }

    @RequestMapping(value={"/updatePwd"})
    public ModelAndView updatePwd(HttpServletRequest request, CustomerAllInfo allInfo) {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        Long custId = allInfo.getCustomerId();
        if (request.getSession().getAttribute("customerId") != null) {
            CustomerAllInfo customer = this.customerServiceMapper.selectByPrimaryKey(Long.valueOf(custId));
            CustomerAllInfo customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"));
            if (customerAllInfo != null && customerAllInfo.getCustomerUsername() != null) {
                OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u4fee\u6539\u5176\u4ed6\u64cd\u4f5c\u5458\u7684\u767b\u5f55\u5bc6\u7801", "\u4fee\u6539\u5458\u5de5\uff1a" + customer.getCustomerUsername() + "-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
                LOGGER.info((Object)"\u4fee\u6539\u5176\u4ed6\u64cd\u4f5c\u5458\u7684\u767b\u5f55\u5bc6\u7801");
            }
            String userCode = custId.toString();
            String saltVal = SecurityUtil.getNewPsw();
            String pwd = SecurityUtil.getStoreLogpwd((String)userCode, (String)allInfo.getCustomerPassword(), (String)saltVal);
            UUID uuid = UUID.randomUUID();
            LOGGER.info((Object)("\u751f\u6210\u52a0\u5bc6\u4e4b\u540e\u7684\u5bc6\u7801\u3002\u3002\u3002" + pwd));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("customerPassword", pwd);
            map.put("saltVal", saltVal);
            map.put("customerId", custId);
            map.put("loginKey", uuid.toString());
            map.put("uniqueCode", userCode);
            map.put(THIRDID, thirdId);
            int number = this.thirdAuthorityService.updatePassword(map);
            if (number > 0) {
                LOGGER.info((Object)"\u4fee\u6539\u6210\u529f");
            }
        }
        return new ModelAndView((View)new RedirectView(request.getContextPath() + "/employeelist.html"));
    }

    @RequestMapping(value={"third/addauthority"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int addAuthority(HttpServletRequest request, ThirdAuthority thirdAuthority) {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        int result = this.thirdAuthorityService.checkAuthorityExist(thirdId, thirdAuthority);
        if (result == 0) {
            CustomerAllInfo customerAllInfo;
            if (request.getSession().getAttribute("customerId") != null && (customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"))) != null && customerAllInfo.getCustomerUsername() != null) {
                OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u65b0\u589e\u804c\u4f4d", "\u65b0\u589e\u804c\u4f4d\uff1a" + thirdAuthority.getDesignation() + "-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
                LOGGER.info((Object)"\u65b0\u589e\u804c\u4f4d");
            }
            return this.thirdAuthorityService.addAuthority(thirdId, thirdAuthority);
        }
        return 0;
    }

    @RequestMapping(value={"third/delauthority"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int delAuthority(HttpServletRequest request, ThirdAuthority thirdAuthority) {
        CustomerAllInfo customerAllInfo;
        ThirdAuthority detail = this.thirdAuthorityService.selectAuthorById(thirdAuthority.getId());
        if (request.getSession().getAttribute("customerId") != null && (customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"))) != null && customerAllInfo.getCustomerUsername() != null) {
            OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u5220\u9664\u804c\u4f4d\u540d\u79f0", "\u5220\u9664\u804c\u4f4d\uff1a" + detail.getDesignation() + "-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
            LOGGER.info((Object)"\u5220\u9664\u804c\u4f4d\u540d\u79f0");
        }
        return this.thirdAuthorityService.delAuthority(thirdAuthority, (Long)request.getSession().getAttribute(THIRDID));
    }

    @RequestMapping(value={"third/checkauthorityexist"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int checkAuthorityExist(HttpServletRequest request, ThirdAuthority thirdAuthority) {
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        return this.thirdAuthorityService.checkAuthorityExist(thirdId, thirdAuthority);
    }

    @RequestMapping(value={"/updateauthorityname"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateAuthorityName(HttpServletRequest request, ThirdAuthority thirdAuthority) {
        ThirdAuthority authority = this.thirdAuthorityService.selectAuthorById(thirdAuthority.getId());
        if (!authority.getDesignation().equals(thirdAuthority.getDesignation())) {
            int result = this.checkAuthorityExist(request, thirdAuthority);
            if (result == 0) {
                CustomerAllInfo customerAllInfo;
                Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
                thirdAuthority.setStoreId(thirdId);
                int i = this.thirdAuthorityService.updateAuthorityName(thirdAuthority);
                if (i == 0) {
                    i = -1;
                } else if (request.getSession().getAttribute("customerId") != null && (customerAllInfo = this.customerServiceMapper.selectByPrimaryKey((Long)request.getSession().getAttribute("customerId"))) != null && customerAllInfo.getCustomerUsername() != null) {
                    OperateLogUtil.addOperaLog(request, customerAllInfo.getCustomerUsername(), "\u4fee\u6539\u804c\u4f4d\u540d\u79f0", "\u4fee\u6539\u804c\u4f4d\uff1a" + authority.getDesignation() + "\u540d\u79f0\u4e3a\uff1a" + thirdAuthority.getDesignation() + "-->\u7528\u6237\u540d\uff1a" + customerAllInfo.getCustomerUsername());
                    LOGGER.info((Object)"\u4fee\u6539\u804c\u4f4d\u540d\u79f0");
                }
                return i;
            }
            return 0;
        }
        return 1;
    }

    @RequestMapping(value={"checkUsernameExitOrNot"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Long checkUsernameExitOrNot(String customerUsername) {
        return this.customerServiceMapper.selectCustomerByName(customerUsername);
    }

    public ThirdAuthorityService getThirdAuthorityService() {
        return this.thirdAuthorityService;
    }

    @Resource(name="thirdAuthorityService")
    public void setThirdAuthorityService(ThirdAuthorityService thirdAuthorityService) {
        this.thirdAuthorityService = thirdAuthorityService;
    }

    public CustomerServiceMapper getCustomerServiceMapper() {
        return this.customerServiceMapper;
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceMapper(CustomerServiceMapper customerServiceMapper) {
        this.customerServiceMapper = customerServiceMapper;
    }
}

