/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.market.controller;

import com.qianjiang.common.util.DateUtil;
import com.qianjiang.coupon.bean.Coupon;
import com.qianjiang.coupon.service.CouponLelevlService;
import com.qianjiang.coupon.service.CouponNoService;
import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.service.PointLevelServiceMapper;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.third.logger.util.OperateLogUtil;
import com.qianjiang.third.market.service.ThirdCouponService;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class CouponThirdController {
    private static final MyLogger LOGGER = new MyLogger(CouponThirdController.class);
    private static final String THIRDID = "thirdId";
    private static final String CUSTOMERLEVEL = "customerLevel";
    private static final String COUPON = "coupon";
    private static final String SKULIST = "skulist";
    @Resource(name="CouponService")
    private CouponService couponService;
    @Resource(name="GoodsBrandService")
    private GoodsBrandService goodsBrandService;
    @Resource(name="CouponNoService")
    private CouponNoService couponNoService;
    @Resource(name="CouponLelevlService")
    private CouponLelevlService couponLelevlService;
    @Resource(name="pointLevelServiceMapper")
    private PointLevelServiceMapper pointLevelServiceMapper;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="ThirdCouponService")
    private ThirdCouponService thirdCouponService;

    @RequestMapping(value={"/thirdcouponlist"})
    public ModelAndView thirdCouponList(Coupon coupon, PageBean pageBean, HttpServletRequest request, String n, String l, String startTime, String endTime) {
        ModelAndView mav = new ModelAndView();
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        pageBean.setUrl("thirdcouponlist.html");
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        Date date = new Date();
        try {
            coupon.setBusinessId(thirdId);
            PageBean searchCouponList = this.couponService.searchCouponList(coupon, pageBean, startTime, endTime);
            String nowdate = DateUtil.dateToString((Date)date, (String)DateUtil.DEFAULT_TIME_PATTERN);
            mav.addObject("pb", (Object)searchCouponList);
            mav.addObject("nowdate", (Object)nowdate);
            mav.setViewName("/coupon/thirdcouponlist");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u521d\u59cb\u5316\u4f18\u60e0\u5238\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/toaddcouponthird"})
    public ModelAndView toAddCouponThird(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            List queryProductForMarketing = this.goodsProductService.queryProductForMarketing(thirdId);
            List selectAllPointLevel = this.pointLevelServiceMapper.selectAllPointLevel();
            mav.addObject("prolist", (Object)queryProductForMarketing);
            mav.addObject(CUSTOMERLEVEL, (Object)selectAllPointLevel);
            mav.setViewName("/coupon/addthirdcoupon");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u8df3\u8f6c\u4f18\u60e0\u5238\u9875\u9762\u9519\u8bef");
        }
        return mav;
    }

    @RequestMapping(value={"/addcouponthird"})
    public ModelAndView addCouponThird(HttpServletRequest request, Coupon coupon, String sTime, String eTime, Long[] lelvelId, String status, MultipartHttpServletRequest multipartRequest) {
        ModelAndView mav = new ModelAndView();
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            Customer cust;
            MultipartFile imageFile;
            coupon.setBusinessId(thirdId);
            coupon.setCouponStartTime(DateUtil.stringToDate((String)sTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            coupon.setCouponEndTime(DateUtil.stringToDate((String)eTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            if (null != coupon.getCouponRemark()) {
                coupon.setCouponRemark(this.getStr(coupon.getCouponRemark()));
            }
            if ((imageFile = multipartRequest.getFile("couponImg")) == null) {
                imageFile = multipartRequest.getFile("picFile");
            }
            if (imageFile != null && !imageFile.isEmpty()) {
                coupon.setCouponPic((String)UploadUtil.uploadFile((MultipartFile)imageFile).get("oldimg"));
            }
            this.couponService.doAddCoupon(coupon, request, lelvelId, status);
            if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u6dfb\u52a0\u4f18\u60e0\u5238", "\u6dfb\u52a0\u4f18\u60e0\u5238\uff0c\u540d\u79f0\u3010" + coupon.getCouponName() + "\u3011-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                LOGGER.info((Object)"\u6dfb\u52a0\u4f18\u60e0\u5238");
            }
            mav.setView((View)new RedirectView("thirdcouponlist.html"));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u6dfb\u52a0\u4f18\u60e0\u5238\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/delcouponthird"})
    public ModelAndView delCouponThird(Long couponId) {
        ModelAndView mav = new ModelAndView();
        try {
            this.couponService.delCoupon(couponId);
            mav.setView((View)new RedirectView("thirdcouponlist.html"));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u5220\u9664\u4f18\u60e0\u5238\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/newdelcouponthird"})
    public ModelAndView newDelCouponThird(Long couponId, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            Customer cust;
            this.couponService.newdelCoupon(couponId, thirdId);
            if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u5220\u9664\u4f18\u60e0\u5238", "-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                LOGGER.info((Object)"\u5220\u9664\u4f18\u60e0\u5238");
            }
            mav.setView((View)new RedirectView("thirdcouponlist.html"));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u65b0\u5220\u9664\u7b2c\u4e09\u65b9\u5e97\u94fa\u4f18\u60e0\u5238\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/newdelcouponlist"})
    public ModelAndView newdelCouponList(Long[] couponId, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            Customer cust;
            this.couponService.delAllCoupon(couponId, thirdId);
            if (request.getSession().getAttribute("cust") != null && (cust = (Customer)request.getSession().getAttribute("cust")).getCustomerUsername() != null) {
                OperateLogUtil.addOperaLog(request, cust.getCustomerUsername(), "\u6279\u91cf\u5220\u9664\u4f18\u60e0\u5238", "-->\u7528\u6237\u540d\uff1a" + cust.getCustomerUsername());
                LOGGER.info((Object)"\u6279\u91cf\u5220\u9664\u4f18\u60e0\u5238");
            }
            mav.setView((View)new RedirectView("thirdcouponlist.html"));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u65b0\u6279\u91cf\u5220\u9664\u4f18\u60e0\u5238\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/tocoupondetailthird"})
    public ModelAndView toCouponDetatilThird(Long couponId, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            Coupon searchCouponById = this.couponService.searchCouponById(couponId);
            Object skulist = this.couponService.selectCouponRange(couponId, "2");
            List brandlist = this.goodsBrandService.queryAllBrandList();
            List selectAllPointLevel = this.pointLevelServiceMapper.selectAllPointLevel();
            List selectCouponLelvel = this.couponLelevlService.selectCouponLelvel(couponId);
            mav.addObject(COUPON, (Object)searchCouponById);
            mav.addObject(SKULIST, skulist);
            mav.addObject("brandlist", (Object)brandlist);
            mav.addObject(CUSTOMERLEVEL, (Object)selectAllPointLevel);
            mav.addObject("listLevel", (Object)selectCouponLelvel);
            mav.setViewName("coupon/coupondetailthird");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8df3\u8f6c\u4f18\u60e0\u5238\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/toupdatecouponthird"})
    public ModelAndView toUpdateCouponThird(Long couponId, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            Coupon searchCouponById = this.couponService.searchCouponById(couponId);
            List queryProductForMarketing = this.goodsProductService.queryProductForMarketing(thirdId);
            List catelist = this.thirdCouponService.selectThirdMarketingScope(couponId, "0");
            List brandlist = this.thirdCouponService.selectThirdMarketingScope(couponId, "1");
            Object skulist = this.couponService.selectCouponRange(couponId, "2");
            List selectAllPointLevel = this.pointLevelServiceMapper.selectAllPointLevel();
            List selectCouponLelvel = this.couponLelevlService.selectCouponLelvel(couponId);
            mav.addObject(COUPON, (Object)searchCouponById);
            mav.addObject("prolist", (Object)queryProductForMarketing);
            mav.addObject("catelist", (Object)catelist);
            mav.addObject("brandlist", (Object)brandlist);
            mav.addObject(SKULIST, skulist);
            mav.addObject(CUSTOMERLEVEL, (Object)selectAllPointLevel);
            mav.addObject("listLevel", (Object)selectCouponLelvel);
            mav.setViewName("/coupon/updatethirdcoupon");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u8df3\u8f6c\u4fee\u6539\u4f18\u60e0\u5238\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    public Map<String, Object> seachThirdCounponDetail(Long couponId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put(COUPON, this.couponService.searchCouponById(couponId));
            map.put("productcate", this.thirdCouponService.selectThirdMarketingScope(couponId, "0"));
            map.put("productbrand", this.thirdCouponService.selectThirdMarketingScope(couponId, "1"));
            map.put(SKULIST, this.couponService.selectCouponRange(couponId, "2"));
            map.put("couponNo", this.couponNoService.selectNoByCouponId(couponId));
            map.put("levelNamelist", this.couponLelevlService.queryLevelNameByCouponId(couponId));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u5bb6\u7aef\u67e5\u770b\u4f18\u60e0\u5238\u8be6\u60c5\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return map;
    }

    @RequestMapping(value={"/doupdatethirdcouponbyid"})
    public ModelAndView doUpdateThirdCouponById(HttpServletRequest request, Coupon coupon, String sTime, String eTime, Long[] lelvelId, MultipartHttpServletRequest multipartRequest, String status) {
        ModelAndView mav = new ModelAndView();
        Long thirdId = (Long)request.getSession().getAttribute(THIRDID);
        try {
            coupon.setBusinessId(thirdId);
            coupon.setCouponStartTime(DateUtil.stringToDate((String)sTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            coupon.setCouponEndTime(DateUtil.stringToDate((String)eTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
            MultipartFile imageFile = multipartRequest.getFile("couponImg");
            if (imageFile == null) {
                imageFile = multipartRequest.getFile("picFile");
            }
            if (imageFile != null && !imageFile.isEmpty()) {
                coupon.setCouponPic((String)UploadUtil.uploadFile((MultipartFile)imageFile).get("oldimg"));
            }
            this.couponService.doUpdateCouponById(coupon, request, lelvelId, status);
            mav.setView((View)new RedirectView("thirdcouponlist.html"));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4fee\u6539\u4f18\u60e0\u52b5\u65f6\u65f6\u95f4\u8f6c\u6362\u9519\u8bef\uff1a" + e);
        }
        return mav;
    }

    private String getStr(String str) {
        String strNew = str;
        strNew = strNew.replace("<p>", "");
        strNew = strNew.replace("</p>", "");
        strNew = strNew.replace("<br>", "");
        strNew = strNew.replace("&nbsp;", "");
        return strNew;
    }
}

