/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.third.analysis.controller;

import com.qianjiang.third.analysis.bean.EchartsBean;
import com.qianjiang.third.analysis.bean.OCustomerFollow;
import com.qianjiang.third.analysis.bean.OOrder;
import com.qianjiang.third.analysis.service.AnalysisService;
import com.qianjiang.third.util.MenuOperationUtil;
import com.qianjiang.util.UtilDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AnalysisController {
    private static final String THIRDID = "thirdId";
    private static final String STARTTIME = "startTime";
    private static final String SELECTINDEX = "selectindex";
    private static final String ISTHIRD = "isthird";
    private static final String ENDTIME = "endTime";
    @Resource(name="AnalysisService")
    private AnalysisService analysisService;

    @RequestMapping(value={"followanalysis"})
    public ModelAndView followAnalysis(HttpServletRequest request, String n, String l, String startTime, String endTime, String isthird, Long catId, Long selectIndex, String oneSelectCategoryValue, String twoSelectCategoryValue) {
        String startTimeNew = startTime;
        String endTimeNew = endTime;
        Long selectIndexNew = selectIndex;
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        Long thirdId = null;
        if (isthird == null || "".equals(isthird)) {
            thirdId = (Long)request.getSession().getAttribute(THIRDID);
        }
        ArrayList<String> timelist = new ArrayList<String>();
        if (startTimeNew == null || endTimeNew == null || "".equals(startTimeNew) || "".equals(endTimeNew)) {
            endTimeNew = UtilDate.todayFormat((Date)new Date());
            startTimeNew = UtilDate.addDay((String)endTimeNew, (int)-7);
        }
        String searchStartTime = startTimeNew;
        String searchEndTime = endTimeNew;
        List list = this.analysisService.selectThirdFollowGoods(thirdId, startTimeNew, endTimeNew, catId);
        while (UtilDate.compare_date((String)startTimeNew, (String)endTimeNew)) {
            timelist.add(startTimeNew);
            startTimeNew = UtilDate.addDay((String)startTimeNew, (int)1);
        }
        JSONArray times = JSONArray.fromObject(timelist);
        ArrayList<EchartsBean> el = new ArrayList<EchartsBean>();
        if (list != null) {
            for (OCustomerFollow g : list) {
                ArrayList<Long> longList = new ArrayList<Long>();
                EchartsBean e = new EchartsBean();
                e.setName(g.getGoodsInfoName());
                e.setStack("\u6570\u91cf");
                e.setType("line");
                for (int j = 0; j < timelist.size(); ++j) {
                    longList.add(g.getTimeMap().get(timelist.get(j)) == null ? 0L : g.getTimeMap().get(timelist.get(j)));
                }
                e.setData(longList);
                el.add(e);
            }
        }
        JSONArray json = JSONArray.fromObject(el);
        if (selectIndexNew == null) {
            selectIndexNew = 0L;
        }
        ModelAndView mav = new ModelAndView("analysis/followanalysis");
        mav.addObject("el", (Object)json.toString());
        mav.addObject("times", (Object)times.toString());
        mav.addObject("goodsList", (Object)list);
        mav.addObject(STARTTIME, (Object)searchStartTime);
        mav.addObject(STARTTIME, (Object)searchStartTime);
        mav.addObject(ENDTIME, (Object)searchEndTime);
        mav.addObject(ISTHIRD, (Object)isthird);
        mav.addObject(SELECTINDEX, (Object)selectIndexNew);
        mav.addObject("oneCategoryValue", (Object)oneSelectCategoryValue);
        mav.addObject("twoCategoryValue", (Object)twoSelectCategoryValue);
        mav.addObject("threeCategoryValue", (Object)catId);
        return mav;
    }

    @RequestMapping(value={"queryOrderCountByDay"})
    public ModelAndView queryOrderCountByDay(HttpServletRequest request, String n, String l, String startTime, String endTime, String isthird, Long selectIndex) {
        String startTimeNew = startTime;
        String endTimeNew = endTime;
        Long selectIndexNew = selectIndex;
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        Long thirdId = null;
        if (isthird == null || "".equals(isthird)) {
            thirdId = (Long)request.getSession().getAttribute(THIRDID);
        }
        if (startTimeNew == null || endTimeNew == null || "".equals(startTimeNew) || "".equals(endTimeNew)) {
            endTimeNew = UtilDate.todayFormat((Date)new Date());
            startTimeNew = UtilDate.addDay((String)endTimeNew, (int)-7);
        }
        String sttime = startTimeNew;
        String entime = endTimeNew;
        List ooderList = this.analysisService.queryCountByDay(thirdId);
        ArrayList<String> ctime = new ArrayList<String>();
        while (UtilDate.compare_date((String)startTimeNew, (String)endTimeNew)) {
            ctime.add(startTimeNew);
            startTimeNew = UtilDate.addDay((String)startTimeNew, (int)1);
        }
        JSONArray times = JSONArray.fromObject(ctime);
        ArrayList<Long> ccount = new ArrayList<Long>();
        for (int i = 0; i < ctime.size(); ++i) {
            boolean flg = true;
            for (int j = 0; j < ooderList.size(); ++j) {
                OOrder oOder = (OOrder)ooderList.get(j);
                if (!((String)ctime.get(i)).equals(oOder.getCtime())) continue;
                ccount.add(oOder.getCountSum());
                flg = false;
                break;
            }
            if (!flg) continue;
            ccount.add(0L);
        }
        JSONArray counts = JSONArray.fromObject(ccount);
        if (selectIndexNew == null) {
            selectIndexNew = 0L;
        }
        return new ModelAndView("analysis/ordercount").addObject("orderList", (Object)ooderList).addObject("times", (Object)times.toString()).addObject("ccounts", (Object)counts.toString()).addObject(STARTTIME, (Object)sttime).addObject(ENDTIME, (Object)entime).addObject(ISTHIRD, (Object)isthird).addObject(SELECTINDEX, (Object)selectIndexNew);
    }

    @RequestMapping(value={"queryTakeRates"})
    public ModelAndView queryTakeRates(HttpServletRequest request, String n, String l, String startTime, String endTime, String isthird, Long selectIndex) {
        Long selectIndexNew = selectIndex;
        String startTimeNew = startTime;
        String endTimeNew = endTime;
        MenuOperationUtil.fillSessionMenuIndex(request, n, l);
        Long thirdId = null;
        if (isthird == null || "".equals(isthird)) {
            thirdId = (Long)request.getSession().getAttribute(THIRDID);
        }
        if (startTimeNew == null || endTimeNew == null || "".equals(startTimeNew) || "".equals(endTimeNew)) {
            endTimeNew = UtilDate.todayFormat((Date)new Date());
            startTimeNew = UtilDate.addDay((String)endTimeNew, (int)-7);
        }
        String sttime = startTimeNew;
        String entime = endTimeNew;
        OOrder succOrder = this.analysisService.querySuccCountByTime(startTimeNew, endTimeNew, thirdId);
        OOrder noSuccOrder = this.analysisService.queryNoSuccCountByDay(startTimeNew, endTimeNew, thirdId);
        if (selectIndexNew == null) {
            selectIndexNew = 0L;
        }
        return new ModelAndView("analysis/querytakerates").addObject("succOrder", (Object)succOrder).addObject("noSuccOrder", (Object)noSuccOrder).addObject(STARTTIME, (Object)sttime).addObject(ENDTIME, (Object)entime).addObject(ISTHIRD, (Object)isthird).addObject(SELECTINDEX, (Object)selectIndexNew);
    }
}

