/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.other.bean;

import com.qianjiang.wap.other.bean.MD5Util;
import com.qianjiang.wap.other.bean.TenpayUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestHandler {
    private String gateUrl;
    private String key;
    private SortedMap parameters;
    private String debugInfo;
    private HttpServletRequest request;
    private HttpServletResponse response;

    public RequestHandler(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.gateUrl = "https://gw.tenpay.com/gateway/pay.htm";
        this.key = "";
        this.parameters = new TreeMap();
        this.debugInfo = "";
    }

    public void init() {
    }

    public String getGateUrl() {
        return this.gateUrl;
    }

    public void setGateUrl(String gateUrl) {
        this.gateUrl = gateUrl;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getParameter(String parameter) {
        String s = (String)this.parameters.get(parameter);
        return null == s ? "" : s;
    }

    public void setParameter(String parameter, String parameterValue) {
        String v = "";
        if (null != parameterValue) {
            v = parameterValue.trim();
        }
        this.parameters.put(parameter, v);
    }

    public SortedMap getAllParameters() {
        return this.parameters;
    }

    public String getDebugInfo() {
        return this.debugInfo;
    }

    public String getRequestURL() throws UnsupportedEncodingException {
        this.createSign();
        StringBuilder sb = new StringBuilder();
        String enc = TenpayUtil.getCharacterEncoding(this.request, this.response);
        Set es = this.parameters.entrySet();
        for (Map.Entry entry : es) {
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            if (!"spbill_create_ip".equals(k)) {
                sb.append(k + "=" + URLEncoder.encode(v, enc) + "&");
                continue;
            }
            sb.append(k + "=" + v.replace(".", "%2E") + "&");
        }
        String reqPars = sb.substring(0, sb.lastIndexOf("&"));
        return this.getGateUrl() + "?" + reqPars;
    }

    public void doSend() throws IOException {
        this.response.sendRedirect(this.getRequestURL());
    }

    protected void createSign() {
        StringBuilder sb = new StringBuilder();
        Set es = this.parameters.entrySet();
        for (Map.Entry entry : es) {
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            if (null == v || "".equals(v) || "sign".equals(k) || "key".equals(k)) continue;
            sb.append(k + "=" + v + "&");
        }
        sb.append("key=" + this.getKey());
        String enc = TenpayUtil.getCharacterEncoding(this.request, this.response);
        String sign = MD5Util.MD5Encode(sb.toString(), enc).toLowerCase();
        this.setParameter("sign", sign);
    }

    protected void setDebugInfo(String debugInfo) {
        this.debugInfo = debugInfo;
    }

    protected HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    protected HttpServletResponse getHttpServletResponse() {
        return this.response;
    }
}

