/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.backorder.controller;

import com.alibaba.fastjson.JSON;
import com.qianjiang.common.service.SeoService;
import com.qianjiang.customer.service.CustomerService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.vo.GoodsProductDetailViewVo;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.order.bean.BackOrder;
import com.qianjiang.order.bean.BackOrderGeneral;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.service.BackOrderLogService;
import com.qianjiang.order.service.BackOrderService;
import com.qianjiang.order.service.OrderMService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.order.service.ReturnGoodsService;
import com.qianjiang.orderrepaircost.service.RepairCostService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.other.bean.GoodsBean;
import com.qianjiang.other.bean.OrderInfoBean;
import com.qianjiang.system.bean.SystemsSet;
import com.qianjiang.system.service.IsBackOrderService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.wap.util.LoginUtil;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class MBackOrderController {
    private static final MyLogger LOGGER = new MyLogger(MBackOrderController.class);
    private static final String URLREDIRECT = "redirect:/loginm.html?url=/myaccount.html";
    private static final String LOGGERINFO1 = "\u3011-->\u7528\u6237\u540d\uff1a";
    @Resource(name="OrderMService")
    private OrderMService orderMService;
    @Resource(name="customerService")
    private CustomerService customerService;
    @Resource(name="repairCostService")
    private RepairCostService repairCostService;
    @Resource(name="IsBackOrderService")
    private IsBackOrderService isbackOrderService;
    @Resource(name="SeoService")
    private SeoService seoService;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="BackOrderService")
    private BackOrderService backOrderService;
    @Resource(name="BackOrderLogService")
    private BackOrderLogService backOrderLogService;
    @Resource(name="OrderService")
    private OrderService orderService;
    @Resource(name="ReturnGoodsService")
    private ReturnGoodsService goodsService;
    @Autowired
    private GoodsProductService GoodsProductService;
    @Resource(name="IsBackOrderService")
    private IsBackOrderService isBackOrderService;

    @RequestMapping(value={"customer/applybartergoods"})
    public ModelAndView applyBarterGoods(HttpServletRequest request, Long orderId) {
        ModelAndView mav = null;
        Order order = this.orderMService.getPayOrder(orderId);
        mav = new ModelAndView("customer/applybackmoney");
        BigDecimal price = new BigDecimal(0);
        String staCheck = "0";
        String isUseCoupon = "0";
        if (!"0.00".equals(order.getOrderPrePrice().toString()) || order.getOrderIntegral() != null && !"".equals(order.getOrderIntegral()) && order.getOrderIntegral() > 0L) {
            price = order.getOrderPrice().subtract(order.getExpressPrice());
            staCheck = "1";
        }
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            OrderInfoBean backorder = this.customerService.queryOrderByCustIdAndOrderId(orderId, customerId);
            for (int i = 0; i < backorder.getGoods().size(); ++i) {
                GoodsProductDetailViewVo goodsProductDetailViewVo = this.goodsProductService.queryViewVoByProductId(((GoodsBean)backorder.getGoods().get(i)).getGoodsId());
                ((GoodsBean)backorder.getGoods().get(i)).setSpecVo((List)JSON.parseObject((String)JSON.toJSONString((Object)goodsProductDetailViewVo.getSpecVo()), List.class));
            }
            Map map = this.isbackOrderService.queryBackInfoRemark();
            String backInfoRemark = (String)map.get("queryBackInfoRemark");
            BigDecimal orderPrice = order.getOrderPrice();
            BigDecimal expressPrice = order.getExpressPrice();
            BigDecimal newprice = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)backorder.getGoods())) {
                for (GoodsBean gb : backorder.getGoods()) {
                    newprice = newprice.add(gb.getGoodsBackPrice());
                }
            }
            if (BigDecimal.ZERO.compareTo(newprice) >= 0) {
                newprice = new BigDecimal(0.01).setScale(2, 4);
            }
            mav = new ModelAndView("customer/apply_barter_goods").addObject("order", (Object)order).addObject("backorder", (Object)backorder).addObject("backInfoRemark", (Object)backInfoRemark).addObject("price", (Object)price).addObject("staCheck", (Object)staCheck).addObject("cusId", (Object)customerId).addObject("newprice", (Object)newprice).addObject("isUseCoupon", (Object)isUseCoupon).addObject("goodsProductLists", (Object)this.GoodsProductService.selectAll());
        } else {
            mav = new ModelAndView(URLREDIRECT);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"customer/applybackgoods"})
    public ModelAndView applyBackGoods(HttpServletRequest request, Long orderId) {
        ModelAndView mav = null;
        Order order = this.orderMService.getPayOrder(orderId);
        mav = new ModelAndView("customer/applybackmoney");
        BigDecimal price = new BigDecimal(0);
        String staCheck = "0";
        String isUseCoupon = "0";
        if (!"0.00".equals(order.getOrderPrePrice().toString()) || order.getOrderIntegral() != null && !"".equals(order.getOrderIntegral()) && order.getOrderIntegral() > 0L) {
            price = order.getOrderPrice().subtract(order.getExpressPrice());
            staCheck = "1";
        }
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            OrderInfoBean backorder = this.customerService.queryOrderByCustIdAndOrderId(orderId, customerId);
            for (int i = 0; i < backorder.getGoods().size(); ++i) {
                GoodsProductDetailViewVo goodsProductDetailViewVo = this.goodsProductService.queryViewVoByProductId(((GoodsBean)backorder.getGoods().get(i)).getGoodsId());
                ((GoodsBean)backorder.getGoods().get(i)).setSpecVo((List)JSON.parseObject((String)JSON.toJSONString((Object)goodsProductDetailViewVo.getSpecVo()), List.class));
            }
            Map map = this.isbackOrderService.queryBackInfoRemark();
            String backInfoRemark = (String)map.get("queryBackInfoRemark");
            BigDecimal orderPrice = order.getOrderPrice();
            BigDecimal expressPrice = order.getExpressPrice();
            BigDecimal newprice = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)backorder.getGoods())) {
                for (GoodsBean gb : backorder.getGoods()) {
                    newprice = newprice.add(gb.getGoodsBackPrice());
                }
            }
            if (BigDecimal.ZERO.compareTo(newprice) >= 0) {
                newprice = new BigDecimal(0.01).setScale(2, 4);
            }
            mav = new ModelAndView("customer/apply_back_goods").addObject("order", (Object)order).addObject("backorder", (Object)backorder).addObject("backInfoRemark", (Object)backInfoRemark).addObject("price", (Object)price).addObject("staCheck", (Object)staCheck).addObject("cusId", (Object)customerId).addObject("newprice", (Object)newprice).addObject("isUseCoupon", (Object)isUseCoupon);
        } else {
            mav = new ModelAndView(URLREDIRECT);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/backorderpricedetail"})
    public ModelAndView backOrderPriceDetail(HttpServletRequest request, Long orderId) {
        ModelAndView mav = new ModelAndView();
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                String preUrl = request.getHeader("Referer");
                if (preUrl != null) {
                    preUrl = URLDecoder.decode(preUrl, "utf-8");
                }
                Order order = this.orderMService.getPayOrder(orderId);
                BackOrder backOrder = this.backOrderService.queryBackOrderByOrderCodeAndIsback(order.getOrderCode(), "2");
                ArrayList<String> imglist = null;
                if (backOrder != null && backOrder.getUploadDocuments() != null && !"".equals(backOrder.getUploadDocuments())) {
                    imglist = new ArrayList<String>();
                    String[] imgs = backOrder.getUploadDocuments().split(",");
                    for (int i = 0; i < imgs.length; ++i) {
                        imglist.add(imgs[i]);
                    }
                }
                List backOrderLogs = this.backOrderLogService.queryByBackId(backOrder.getBackOrderId());
                mav.addObject("order", (Object)order);
                mav.addObject("backOrder", (Object)backOrder);
                mav.addObject("backOrderLogs", (Object)backOrderLogs);
                mav.addObject("imglist", imglist);
                mav.addObject("url", (Object)preUrl);
                mav.setViewName("customer/back_order_detail");
            } else {
                mav = new ModelAndView(URLREDIRECT);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u770b\u9000\u6b3e\u8be6\u60c5\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/backordergoodsdetail"})
    public ModelAndView backOrderGoodsDetail(HttpServletRequest request, Long orderId) {
        ModelAndView mav = new ModelAndView();
        try {
            if (LoginUtil.checkLoginStatus(request)) {
                String[] goods;
                String preUrl = request.getHeader("Referer");
                if (preUrl != null) {
                    preUrl = URLDecoder.decode(preUrl, "utf-8");
                }
                Order order = this.orderMService.getPayOrder(orderId);
                LOGGER.info((Object)("\u6839\u636e\u8ba2\u5355id\u67e5\u8be2\u6240\u6709\u9000\u8d27\u5546\u54c1\uff1a" + order.getOrderGoodsList().toString()));
                BackOrder backOrder = this.backOrderService.queryBackOrderByOrderCodeAndIsback(order.getOrderCode(), "1");
                String backStr = backOrder.getBackGoodsIdAndSum();
                ArrayList<Long> orderGoodIds = new ArrayList<Long>();
                if (StringUtils.isNotEmpty((CharSequence)backStr) && (goods = backStr.split("-")).length > 0) {
                    for (int i = 0; i < goods.length; ++i) {
                        if (goods[i].indexOf(",") == goods[i].lastIndexOf(",")) continue;
                        orderGoodIds.add(Long.valueOf(goods[i].substring(goods[i].lastIndexOf(",") + 1, goods[i].length())));
                    }
                }
                LOGGER.info((Object)("\u6240\u6709\u9000\u8d27\u5546\u54c1id\u96c6\u5408\uff1a" + ((Object)orderGoodIds).toString()));
                if (null != order && CollectionUtils.isNotEmpty((Collection)order.getOrderGoodsList())) {
                    for (int i = 0; i < order.getOrderGoodsList().size(); ++i) {
                        OrderGoods og = (OrderGoods)order.getOrderGoodsList().get(i);
                        if (orderGoodIds.contains(og.getOrderGoodsId())) continue;
                        order.getOrderGoodsList().remove(i);
                        --i;
                    }
                }
                LOGGER.info((Object)("\u90e8\u5206\u9000\u8d27\u5546\u54c1\u96c6\u5408:" + order.getOrderGoodsList().toString()));
                ArrayList<String> imglist = null;
                if (backOrder != null && backOrder.getUploadDocuments() != null && !"".equals(backOrder.getUploadDocuments())) {
                    imglist = new ArrayList<String>();
                    String[] imgs = backOrder.getUploadDocuments().split(",");
                    for (int i = 0; i < imgs.length; ++i) {
                        imglist.add(imgs[i]);
                    }
                }
                BackOrderGeneral general = this.backOrderService.queryBackOrderGeneral(backOrder.getBackOrderId());
                List backOrderLogs = this.backOrderLogService.queryByBackId(backOrder.getBackOrderId());
                mav.addObject("order", (Object)order);
                mav.addObject("backOrder", (Object)backOrder);
                mav.addObject("backOrderLogs", (Object)backOrderLogs);
                mav.addObject("general", (Object)general);
                mav.addObject("imglist", imglist);
                mav.addObject("url", (Object)preUrl);
                mav.setViewName("customer/back_order_detail");
            } else {
                mav = new ModelAndView(URLREDIRECT);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u8ba2\u5355id\u67e5\u8be2\u9000\u5355\u8be6\u60c5\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/saveMBackOrderGeneral"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int saveBackOrderGeneral(HttpServletRequest request, String wlname, String wlno, String orderNo) {
        if (LoginUtil.checkLoginStatus(request)) {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            CustomerAllInfo customerAllInfo = this.customerService.selectByPrimaryKey(customerId);
            if (null != orderNo) {
                LOGGER.info((Object)"\u65b0\u589e\u4e00\u6761\u9000\u8d27\u7684\u7269\u6d41\u4fe1\u606f");
                OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)customerAllInfo.getCustomerUsername(), (String)"\u65b0\u589e\u9000\u5355\u7269\u6d41\u4fe1\u606f", (String)("\u65b0\u589e\u9000\u5355\u7269\u6d41\u4fe1\u606f-->\u9700\u8981\u6267\u884c\u9000\u5355\u64cd\u4f5c\u7684\u8ba2\u5355\u53f7\u3010" + orderNo + "\u3011,\u7269\u6d41\u4fe1\u606f\uff1a\u540d\u79f0\u3010" + wlname + "\u3011,\u7269\u6d41\u5355\u53f7\u3010" + wlno + LOGGERINFO1 + customerAllInfo.getCustomerUsername()));
            }
            return this.goodsService.saveBackOrderGeneral(wlname, wlno, orderNo);
        }
        return 0;
    }

    @RequestMapping(value={"customer/timeBackOrderByIdM"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int timeBackOrderById(HttpServletRequest request, Long orderId) {
        int time = 1;
        Long customerId = (Long)request.getSession().getAttribute("customerId");
        Order order = this.orderService.getPayOrder(orderId);
        SystemsSet systemsSet = this.isBackOrderService.getIsBackOrder();
        Long day = systemsSet.getLimitOrderTime();
        time = order.getGetGoodsTime() != null && new Date().getTime() - order.getGetGoodsTime().getTime() < day * 60L * 60L * 24L * 1000L ? 1 : 0;
        return time;
    }
}

