/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.shoppingcart.controller;

import com.alibaba.fastjson.JSON;
import com.qianjiang.common.service.SeoService;
import com.qianjiang.customer.service.CustomerOrderService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.other.bean.GoodsBean;
import com.qianjiang.promotion.bean.Promotion;
import com.qianjiang.promotion.bean.PromotionRush;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.shoppingcart.bean.ShoppingCart;
import com.qianjiang.shoppingcart.service.ShoppingCartService;
import com.qianjiang.system.address.bean.ShoppingCartWareUtil;
import com.qianjiang.system.address.service.ShoppingCartAddressService;
import com.qianjiang.system.service.DefaultAddressService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.wap.shoppingcart.bean.GoodsStockBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ShoppingCartMController {
    public static final MyLogger LOGGER = new MyLogger(ShoppingCartMController.class);
    private static final String PROINFO = "110012";
    private static final String CUSTOMERID = "customerId";
    @Resource(name="ShoppingCartService")
    private ShoppingCartService shoppingCartService;
    @Resource(name="MarketingService")
    private PromotionService marketingService;
    @Resource(name="customerOrderService")
    private CustomerOrderService customerOrderService;
    @Resource(name="DefaultAddressService")
    private DefaultAddressService addressService;
    @Resource(name="SeoService")
    private SeoService seoService;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Autowired
    private ShoppingCartAddressService shoppingCartAddressService;
    private static final String REDIRECT = "myshoppingmcart.html";

    @RequestMapping(value={"/myshoppingmcart"})
    public ModelAndView shoppingCart(HttpServletRequest request, HttpServletResponse response, String stockinfos) {
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        request.getSession().setAttribute("tok", (Object)UUID.randomUUID().toString());
        try {
            Map storeShopMap = this.shoppingCartService.shopCartMap(customerId, request, response);
            List list = new ArrayList();
            if (StringUtils.isNotEmpty((String)stockinfos)) {
                list = JSON.parseArray((String)stockinfos, GoodsStockBean.class);
            }
            mav.addObject("storeShopMap", (Object)storeShopMap);
            mav.addObject("stockinfos", list);
            mav.addObject("sx", (Object)request.getSession().getAttribute("tok").toString());
            mav.setViewName("shoppingcart/shoppingcart");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("App\u7aef\u67e5\u8be2\u8d2d\u7269\u8f66\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/addproducttoshopcarnew"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int addProductToShopCarNew(HttpServletRequest request, HttpServletResponse response, Long goodsNum, Long productId, Long distinctId) {
        int result = 0;
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        try {
            GoodsProductVo productVo;
            if (customerId != null) {
                Integer num = 0;
                Integer cartgoodsNum = 0;
                List marketingList = this.marketingService.selectMarketingByGoodsInfoId(productId, null, null);
                if (marketingList != null && marketingList.size() == 1 && "11".equals(((Promotion)marketingList.get(0)).getCodexType())) {
                    Integer allNum;
                    List shoppingCarts = this.shoppingCartService.selectShoppingCartListByCustomerId(customerId);
                    if (shoppingCarts != null && shoppingCarts.size() > 0) {
                        for (ShoppingCart sc : shoppingCarts) {
                            if (sc.getGoodsInfoId().intValue() != productId.intValue()) continue;
                            cartgoodsNum = sc.getGoodsNum().intValue();
                        }
                    }
                    if ((allNum = Integer.valueOf(num + cartgoodsNum + goodsNum.intValue())) > ((PromotionRush)((Promotion)marketingList.get(0)).getRushs().get(0)).getRushLimitation()) {
                        result = -2;
                        return result;
                    }
                }
            }
            if ((productVo = this.goodsProductService.findProductById(productId, distinctId)) != null) {
                if ("0".equals(productVo.getGoodsInfoAdded())) {
                    result = -3;
                    return result;
                }
                if (productVo.getGoodsInfoStock() <= 0L) {
                    result = -4;
                    return result;
                }
                if (productVo.getGoodsInfoStock() <= goodsNum) {
                    result = -5;
                    return result;
                }
            }
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            ShoppingCart shoppingCart = new ShoppingCart();
            shoppingCart.setDistinctId(distinctId == null ? wareUtil.getDistrictId() : distinctId);
            shoppingCart.setGoodsInfoId(productId);
            shoppingCart.setGoodsNum(goodsNum);
            shoppingCart.setCustomerId(customerId);
            shoppingCart.setShoppingCartTime(new Date());
            shoppingCart.setDelFlag("0");
            result = this.shoppingCartService.addShoppingCart(shoppingCart, request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("App\u7aef\u6dfb\u52a0\u5230\u8d2d\u7269\u8f66\u5931\u8d25" + e.getMessage());
        }
        return result;
    }

    @RequestMapping(value={"/buyNowBarter"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int buyNowBarter(HttpServletRequest request, HttpServletResponse response, Long goodsNum, Long productId, Long distinctId) {
        int result = 0;
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        try {
            if (customerId == null) {
                result = -1;
                return result;
            }
            result = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("app\u7aef\u6362\u8d27\u8f6c\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/buyNow"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int buyNow(HttpServletRequest request, HttpServletResponse response, Long goodsNum, Long productId, Long distinctId) {
        int result = 0;
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        try {
            if (customerId == null) {
                result = -1;
                return result;
            }
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            ShoppingCart shoppingCart = new ShoppingCart();
            shoppingCart.setDistinctId(distinctId == null ? wareUtil.getDistrictId() : distinctId);
            shoppingCart.setGoodsInfoId(productId);
            shoppingCart.setGoodsNum(goodsNum);
            shoppingCart.setCustomerId(customerId);
            shoppingCart.setShoppingCartTime(new Date());
            shoppingCart.setDelFlag("0");
            result = this.shoppingCartService.buyNow(request, response, shoppingCart);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("app\u7aef\u7acb\u5373\u8d2d\u4e70\u8df3\u8f6c\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/myshoppingmcartNum"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Integer shoppingCartNum(HttpServletRequest request, HttpServletResponse response) {
        Integer result = 0;
        request.getSession().setAttribute("tok", (Object)UUID.randomUUID().toString());
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        try {
            result = customerId != null ? this.shoppingCartService.countCart(customerId) : this.shoppingCartService.countCartInCookie(request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u79fb\u52a8\u7aef\u52a0\u8f7d\u8d2d\u7269\u8f66\u6570\u91cf\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/changeshoppingcartmarts"})
    public ModelAndView changeShoppingCartMarts(HttpServletRequest request, HttpServletResponse response, Long shoppingCartId, Long marketingActivityId) {
        ModelAndView mav = new ModelAndView();
        try {
            this.shoppingCartService.changeShoppingCartMarket(shoppingCartId, marketingActivityId, request, response);
            mav.setView((View)new RedirectView(REDIRECT));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("App\u7aef\u8d2d\u7269\u888b\u5207\u6362\u5546\u54c1\u4f18\u60e0\u66f4\u65b0\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"changeshoppingmcartbyid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int changeShoppingCartById(Long shoppingCartId, Long num) {
        return this.shoppingCartService.changeShoppingCartById(shoppingCartId, num);
    }

    @RequestMapping(value={"delshoppingcartbyid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int delShoppingCartById(Long shoppingCartId, Long goodsInfoId, HttpServletRequest request, HttpServletResponse response) {
        int result = 0;
        try {
            result = this.shoppingCartService.delShoppingCartById(shoppingCartId, goodsInfoId, request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("app\u7aef\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u5931\u8d25" + e.getMessage());
        }
        return result;
    }

    @RequestMapping(value={"/buyPrePackage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int buyPrePackage(Long fitId, Long distinctId, HttpServletRequest request, HttpServletResponse response) {
        int result = 0;
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        try {
            if (null != fitId && fitId > 0L) {
                ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
                ShoppingCart shoppingCart = new ShoppingCart();
                shoppingCart.setDistinctId(distinctId == null ? wareUtil.getDistrictId() : distinctId);
                shoppingCart.setGoodsInfoId(Long.valueOf(Long.parseLong(PROINFO + fitId)));
                shoppingCart.setGoodsNum(Long.valueOf(1L));
                shoppingCart.setFitId(fitId);
                shoppingCart.setCustomerId(customerId);
                shoppingCart.setShoppingCartTime(new Date());
                shoppingCart.setDelFlag("0");
                result = this.shoppingCartService.addShoppingCart(shoppingCart, request, response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("app\u7aef\u8d2d\u4e70\u4f18\u60e0\u5957\u88c5\u6dfb\u52a0\u8d2d\u7269\u8f66\u5931\u8d25" + e.getMessage() + e);
        }
        return result;
    }

    @RequestMapping(value={"/addproducttoshopcarbyorderid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int addProductToShopCarByOrderId(HttpServletRequest request, HttpServletResponse response, Long orderId) {
        int result = 0;
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        try {
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            List goodsBeans = this.customerOrderService.selectByOrderId(orderId);
            if (CollectionUtils.isNotEmpty((Collection)goodsBeans)) {
                Iterator iterator = goodsBeans.iterator();
                while (iterator.hasNext()) {
                    GoodsBean goodsBean = (GoodsBean)JSON.parseObject((String)JSON.toJSONString(iterator.next()), GoodsBean.class);
                    ShoppingCart shoppingCart = new ShoppingCart();
                    shoppingCart.setDistinctId(wareUtil.getDistrictId());
                    shoppingCart.setGoodsInfoId(goodsBean.getGoodsId());
                    shoppingCart.setGoodsNum(goodsBean.getGoodsNum());
                    shoppingCart.setCustomerId(customerId);
                    shoppingCart.setShoppingCartTime(new Date());
                    shoppingCart.setDelFlag("0");
                    result = this.shoppingCartService.addShoppingCart(shoppingCart, request, response);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.info((Object)"\u6dfb\u52a0\u8d2d\u7269\u8f66\u5931\u8d25");
        }
        return result;
    }
}

