/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.threepart.controller;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.service.CustomerService;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.other.util.IPAddress;
import com.qianjiang.shoppingcart.service.ShoppingCartService;
import com.qianjiang.system.bean.Auth;
import com.qianjiang.system.service.AuthService;
import com.qianjiang.threepart.bean.ThreePart;
import com.qianjiang.threepart.service.ThreePartService;
import com.qianjiang.wap.threepart.util.SinaMessage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class RegisterSinaLoginController {
    @Resource(name="authService")
    private AuthService authService;
    @Resource(name="customerService")
    private CustomerService customerService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    @Resource(name="ThreePartService")
    private ThreePartService threePartService;
    @Resource(name="ShoppingCartService")
    private ShoppingCartService shoppingCartService;

    @RequestMapping(value={"afterloginsina"})
    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response, String[] args) throws IOException {
        response.setContentType("text/html; charset=utf-8");
        String preurl = request.getParameter("myurl");
        Auth auth = this.authService.findAuthByAuthType("13");
        if (auth != null) {
            String appID = auth.getAuthClientId();
            String appKEY = auth.getAuthClientSecret();
            String redirectURI = auth.getAuthRedirectUri();
            String code = request.getParameter("code");
            String url = "https://api.weibo.com/oauth2/access_token?client_id=" + appID + "&client_secret=" + appKEY + "&grant_type=authorization_code&redirect_uri=" + redirectURI + "&code=" + code;
            PostMethod getMethod = new PostMethod(url);
            HttpClient client = new HttpClient();
            client.executeMethod((HttpMethod)getMethod);
            String userInfo = getMethod.getResponseBodyAsString();
            JSONObject jsonData = JSONObject.fromObject((Object)userInfo);
            if (jsonData == null) {
                return new ModelAndView((View)new RedirectView("404.html"));
            }
            if (jsonData.get("access_token") == null) {
                return new ModelAndView("redirect:/");
            }
            String accessToken = jsonData.get("access_token").toString();
            String uid = jsonData.get("uid").toString();
            ThreePart tp = this.threePartService.selectThreePart(uid);
            if (tp != null) {
                CustomerAllInfo cus = this.customerServiceMapper.selectByPrimaryKey(tp.getThreePartMemberId());
                request.getSession().setAttribute("cust", (Object)cus);
                request.getSession().setAttribute("isThirdLogin", (Object)"1");
                request.getSession().setAttribute("customerId", (Object)cus.getCustomerId());
            } else {
                Map<String, String> userData = SinaMessage.getSinaMessage(accessToken, uid);
                CustomerAllInfo allInfo = new CustomerAllInfo();
                allInfo.setLoginIp(IPAddress.getIpAddr((HttpServletRequest)request));
                allInfo.setPointLevelId(Long.valueOf(2L));
                allInfo.setCustomerUsername(userData.get("screen_name"));
                allInfo.setCustomerPassword("");
                allInfo.setCustomerNickname(userData.get("screen_name"));
                allInfo.setInfoGender("m".equals(userData.get("gender")) ? "1" : "2");
                allInfo.setCustomerImg(userData.get("headimg").toString());
                int f = this.customerServiceMapper.addCustomer(allInfo);
                if (f == 1) {
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    paramMap.put("username", userData.get("screen_name"));
                    paramMap.put("password", "");
                    Customer customer = this.customerService.selectCustomerByNamePwd(paramMap);
                    tp = new ThreePart();
                    tp.setThreePartUid(uid);
                    tp.setThreePartToken(accessToken);
                    tp.setThreePartMemberId(customer.getCustomerId());
                    this.threePartService.insertThreePart(tp);
                    CustomerAllInfo cus = this.customerServiceMapper.selectByPrimaryKey(tp.getThreePartMemberId());
                    request.getSession().setAttribute("cust", (Object)cus);
                    request.getSession().setAttribute("isThirdLogin", (Object)"1");
                    request.getSession().setAttribute("customerId", (Object)cus.getCustomerId());
                }
            }
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            this.shoppingCartService.loadCoodeShopping(customerId, request);
            Cookie cook = new Cookie("_mall_store_shopcar", null);
            cook.setMaxAge(-1);
            cook.setPath("/");
            response.addCookie(cook);
        }
        if (StringUtils.isNotEmpty((String)preurl) && preurl.indexOf("myshoppingcart") != -1) {
            return new ModelAndView((View)new RedirectView(request.getContextPath() + "/myshoppingcart.html"));
        }
        return new ModelAndView("redirect:/");
    }
}

