/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.jewelry.controller;

import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.service.BackOrderService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.other.bean.CustomerAllInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class JewelryBoxController {
    @Autowired
    private CustomerServiceMapper customerServiceMapper;
    @Autowired
    private BackOrderService backOrderService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private GoodsProductService goodsProductService;

    @RequestMapping(value={"/selectAllJewelry"})
    public ModelAndView selectAllJewelry(HttpServletRequest request, HttpServletResponse response) {
        ModelAndView mv = new ModelAndView();
        try {
            Long customerId = (Long)request.getSession().getAttribute("customerId");
            if (customerId == null) {
                mv.setViewName("mobileNew/JewelryBox");
            } else {
                CustomerAllInfo customerAllInfo = this.customerServiceMapper.selectByPrimaryKey(customerId);
                BigDecimal orderPrice = this.orderService.countOrderPrice(customerId);
                ArrayList new_order = new ArrayList();
                List order = this.orderService.orderDetailList(customerId);
                if (order.size() != 0 && order != null) {
                    ArrayList new_order_goodsList = new ArrayList();
                    for (int i = 0; i < order.size(); ++i) {
                        List goodsList = ((Order)order.get(i)).getOrderGoodsList();
                        new_order_goodsList.addAll(goodsList);
                    }
                    ArrayList<OrderGoods> new_goodsList = new ArrayList<OrderGoods>();
                    for (OrderGoods goods : new_order_goodsList) {
                        goods.setGoodsName(goods.getGoodsInfoNum().toString());
                        Long goodsInfoId = goods.getGoodsInfoId();
                        Long backGoodsNum = goods.getBackGoodsNum();
                        String goodsInfoItemNoS = goods.getGoodsInfoItemNoS();
                        if (goodsInfoItemNoS == null) {
                            goodsInfoItemNoS = "";
                        }
                        if (backGoodsNum != null && !"".equals(backGoodsNum)) {
                            goods.setGoodsInfoNum(Long.valueOf(goods.getGoodsInfoNum() - backGoodsNum));
                        }
                        if (this.isExistGoodsInfoId(new_goodsList, goodsInfoId, goods.getGoodsInfoNum(), goodsInfoItemNoS)) continue;
                        String[] goodsInfoItemNoSArr = goodsInfoItemNoS.split(",");
                        ArrayList<String> goodsInfoItemNoSList = new ArrayList<String>();
                        for (int a = 0; a < goodsInfoItemNoSArr.length; ++a) {
                            goodsInfoItemNoSList.add(goodsInfoItemNoSArr[a]);
                        }
                        goods.setGoodsInfoItemNoSList(goodsInfoItemNoSList);
                        new_goodsList.add(goods);
                    }
                    new_order.add(order.get(0));
                    ((Order)new_order.get(0)).setOrderGoodsList(new_goodsList);
                }
                mv.addObject("new_order", new_order);
                mv.addObject("customerAllInfo", (Object)customerAllInfo);
                mv.addObject("orderPriceSum", (Object)orderPrice);
                mv.addObject("order", (Object)order);
                mv.setViewName("mobileNew/JewelryBox");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mv;
    }

    private boolean isExistGoodsInfoId(List<OrderGoods> goodsList, Long goodsInfoId, Long goodsNum, String goodsInfoItemNoS) {
        for (OrderGoods orderGoods : goodsList) {
            if (goodsInfoId != orderGoods.getGoodsInfoId() && !orderGoods.equals(orderGoods.getGoodsInfoId())) continue;
            orderGoods.setGoodsInfoNum(Long.valueOf(orderGoods.getGoodsInfoNum() + goodsNum));
            String[] goodsInfoItemNoSArr = goodsInfoItemNoS.split(",");
            for (int a = 0; a < goodsInfoItemNoSArr.length; ++a) {
                orderGoods.getGoodsInfoItemNoSList().add(goodsInfoItemNoSArr[a]);
            }
            return true;
        }
        return false;
    }
}

