/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.wap.goods.controller;

import com.alibaba.fastjson.JSON;
import com.qianjiang.comment.service.CommentServiceMapper;
import com.qianjiang.common.service.SeoService;
import com.qianjiang.coupon.bean.Coupon;
import com.qianjiang.coupon.bean.ParamIds;
import com.qianjiang.coupon.service.CouponNoService;
import com.qianjiang.coupon.service.CouponRangeService;
import com.qianjiang.coupon.service.CouponService;
import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.customer.service.BrowserecordService;
import com.qianjiang.customer.service.CustomerOrderService;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.goods.bean.GoodsDetailBean;
import com.qianjiang.goods.bean.GoodsImage;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.bean.SolrGoodsInfo;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.goods.service.GoodsOpenSpecService;
import com.qianjiang.goods.service.GoodsOpenSpecValueService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.GoodsService;
import com.qianjiang.goods.service.GoodsSolrSearchService;
import com.qianjiang.goods.service.GoodsSpecService;
import com.qianjiang.goods.service.GoodsTypeService;
import com.qianjiang.goods.service.SiteGoodsAtteService;
import com.qianjiang.goods.util.GoodsIndexConstant;
import com.qianjiang.goods.util.SearchPageBean;
import com.qianjiang.goods.vo.GoodsOpenSpecValueVo;
import com.qianjiang.goods.vo.GoodsSiteSearchBean;
import com.qianjiang.goods.vo.GoodsSpecVo;
import com.qianjiang.goods.vo.GoodsTypeVo;
import com.qianjiang.mobile.bean.MobCateBar;
import com.qianjiang.mobile.service.MobCateBarService;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.shoppingcart.service.ShoppingCartService;
import com.qianjiang.system.address.bean.ShoppingCartWareUtil;
import com.qianjiang.system.address.service.ShoppingCartAddressService;
import com.qianjiang.system.bean.OnLineService;
import com.qianjiang.system.service.DefaultAddressService;
import com.qianjiang.system.service.DistrictService;
import com.qianjiang.system.service.IOnLineServiceBiz;
import com.qianjiang.system.service.IOnLineServiceItemBiz;
import com.qianjiang.system.util.AddressUtil;
import com.qianjiang.third.supplier.service.StoreInfoService;
import com.qianjiang.thirdaudit.bean.StoreInfo;
import com.qianjiang.util.MyLogger;
import com.qianjiang.wap.goods.vo.GoodsCateVo;
import com.qianjiang.wap.goods.vo.GoodsProductVo;
import com.qianjiang.wap.util.CateCacheUtil;
import com.qianjiang.wap.util.CateCashUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public final class GoodsSiteController {
    public static final Long SYSTEM_STARUP_TIME = System.currentTimeMillis();
    public static final MyLogger LOGGER = new MyLogger(GoodsSiteController.class);
    private static final String DISTINCTID = "distinctId";
    private static final String SEARCHBEAN = "searchBean";
    private static final String PARAMS = "params";
    private static final String GOODS_LIST = "goods/pro_list";
    private static final String STOREID = "storeId";
    private static final String WIDTH = "width";
    private static final String CHADDRESS = "chAddress";
    private static final String CHPROVINCE = "chProvince";
    private static final String CHCITY = "chCity";
    private static final String CHDISTINCT = "chDistinct";
    private static final String COOKIE = "_mall_browpro";
    private static final String CUSTOMERID = "customerId";
    @Resource(name="GoodsCateService")
    private GoodsCateService goodsCateService;
    @Resource(name="GoodsTypeService")
    private GoodsTypeService goodsTypeService;
    @Resource(name="GoodsService")
    private GoodsService goodsService;
    @Resource(name="GoodsProductService")
    private GoodsProductService productService;
    @Resource(name="MarketingService")
    private PromotionService marketingService;
    @Resource(name="SiteGoodsAtteService")
    private SiteGoodsAtteService goodsAtteService;
    @Resource(name="commentServiceMapper")
    private CommentServiceMapper commentServiceMapper;
    @Resource(name="GoodsOpenSpecService")
    private GoodsOpenSpecService goodsOpenSpecService;
    @Resource(name="SeoService")
    private SeoService seoService;
    @Resource(name="DefaultAddressService")
    private DefaultAddressService addressService;
    @Resource(name="ShoppingCartService")
    private ShoppingCartService cartService;
    @Resource(name="GoodsSolrSearchService")
    private GoodsSolrSearchService goodsSolrSearchServivice;
    @Resource(name="browserecordService")
    private BrowserecordService browserecordService;
    @Resource(name="CouponRangeService")
    private CouponRangeService couponRangeService;
    @Resource(name="CouponService")
    private CouponService couponService;
    @Resource(name="DistrictService")
    private DistrictService districtService;
    @Resource(name="CouponNoService")
    private CouponNoService couponNoService;
    @Resource(name="onLineServiceItemBizImpl")
    private IOnLineServiceItemBiz onLineServiceItemService;
    @Resource(name="onLineServiceBizImpl")
    private IOnLineServiceBiz onLineServiceBiz;
    @Resource(name="StoreServiceMix")
    private StoreInfoService storeInfoService;
    @Resource(name="MobCateBarService")
    private MobCateBarService mobCateBarService;
    @Resource(name="CateCashUtil")
    private CateCashUtil cateCashUtil;
    @Autowired
    private ShoppingCartAddressService shoppingCartAddressService;
    @Resource(name="GoodsOpenSpecValueService")
    private GoodsOpenSpecValueService goodsOpenSpecValueService;
    @Resource(name="CateCacheUtil")
    private CateCacheUtil cateCacheUtil;
    @Resource(name="GoodsSpecService")
    private GoodsSpecService goodsSpecService;
    @Autowired
    private OrderService orderService;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Autowired
    private CustomerOrderService customerOrderService;

    @RequestMapping(value={"/list"})
    public ModelAndView goodsList(Long cid, SearchPageBean<SolrGoodsInfo> pb, GoodsSiteSearchBean searchBean, String[] params, HttpServletRequest request, String showStatus) {
        ModelAndView mav = new ModelAndView();
        pb.setPageSize(20);
        Map<String, Object> resultMap = null;
        try {
            if (searchBean.getCateBarId() != null) {
                MobCateBar mobCateBar = this.mobCateBarService.selectMobcateBarById(searchBean.getCateBarId());
                cid = mobCateBar != null && mobCateBar.getCateId() != null ? mobCateBar.getCateId() : Long.valueOf(-1L);
            }
            GoodsCateVo goodsCateVo = null;
            if (cid != null && cid > 0L && (goodsCateVo = (GoodsCateVo)JSON.parseObject((String)JSON.toJSONString((Object)this.goodsCateService.queryCateByCatId(cid)), GoodsCateVo.class)) == null) {
                cid = -1L;
            }
            GoodsTypeVo typeVo = null;
            List screenVo = (List)JSON.parseObject((String)JSON.toJSONString((Object)this.goodsService.calcScreenParam(params, typeVo)), List.class);
            GoodsTypeVo calcTypeVo = this.goodsService.calcTypeVo(screenVo, typeVo);
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            Long distinctId = wareUtil.getDistrictId();
            resultMap = this.cateCacheUtil.queryCateGoods(pb, searchBean, cid, distinctId);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("nowcate", goodsCateVo);
            map.put(PARAMS, screenVo);
            map.put("type", calcTypeVo);
            map.put(SEARCHBEAN, searchBean);
            map.put("resultMap", resultMap);
            map.put(DISTINCTID, distinctId.toString());
            mav.addObject("map", map);
            mav.addObject("showStatus", (Object)showStatus);
            if (searchBean.getStoreId() == null) {
                mav.addObject(STOREID, (Object)0);
            } else {
                mav.addObject(STOREID, (Object)searchBean.getStoreId());
            }
            mav.setViewName(GOODS_LIST);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/cateList"})
    public ModelAndView cateGoodsList(Long cateBarId, SearchPageBean<SolrGoodsInfo> pb, GoodsSiteSearchBean searchBean, String showStatus, HttpServletRequest request, String sort, Long caizhiMix, Long categoryMix, Long colorMix, String minPrice, String maxPrice) {
        ModelAndView mav = new ModelAndView();
        String px = request.getParameter("px");
        if (StringUtils.isEmpty((String)px)) {
            px = "0";
        }
        pb.setPageSize(20);
        Map<String, Object> resultMap = null;
        try {
            List<MobCateBar> lists = this.cateCashUtil.queryRootCates();
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            Long distinctId = wareUtil.getDistrictId();
            Long cateId = this.mobCateBarService.selectMobcateBarById(cateBarId).getCateId();
            resultMap = this.cateCacheUtil.queryCateGoods(pb, searchBean, cateId, distinctId, sort, caizhiMix, categoryMix, colorMix, minPrice, maxPrice);
            HashMap<String, GoodsSiteSearchBean> map = new HashMap<String, GoodsSiteSearchBean>();
            if (resultMap != null && resultMap.get("pb") != null && (Integer)resultMap.get("dataNum") > 0) {
                mav.addObject("dataNum", (Object)((Integer)resultMap.get("dataNum")));
            } else {
                mav.addObject("dataNum", (Object)0);
            }
            GoodsSpecVo caizhi = this.goodsSpecService.queryBySpecPrimaryKey(Long.valueOf(606L));
            GoodsSpecVo category = this.goodsSpecService.queryBySpecPrimaryKey(Long.valueOf(607L));
            GoodsSpecVo color = this.goodsSpecService.queryBySpecPrimaryKey(Long.valueOf(608L));
            map.put(SEARCHBEAN, searchBean);
            mav.addObject("map", map);
            mav.addObject("lists", lists);
            mav.addObject("resultMap", resultMap);
            mav.addObject("cateBarId", (Object)cateBarId);
            mav.addObject("showStatus", (Object)showStatus);
            mav.addObject("px", (Object)px);
            mav.addObject("sort", (Object)(sort == null ? "" : sort));
            mav.addObject("caizhi", (Object)caizhi);
            mav.addObject("category", (Object)category);
            mav.addObject("color", (Object)color);
            if (searchBean.getStoreId() == null) {
                mav.addObject(STOREID, (Object)0);
            } else {
                mav.addObject(STOREID, (Object)searchBean.getStoreId());
            }
            mav.setViewName("mobileNew/cateGoodsList");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u5206\u7c7b\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/allGoodsListByStoreId"})
    public ModelAndView allGoodsListByStoreId(PageBean pb, GoodsSiteSearchBean searchBean, String[] params, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        pb.setPageSize(20);
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            GoodsTypeVo typeVo = null;
            List screenVo = this.goodsService.calcScreenParam(params, typeVo);
            GoodsTypeVo calcTypeVo = this.goodsService.calcTypeVo(screenVo, typeVo);
            map.put("type", calcTypeVo);
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            Long distinctId = wareUtil.getDistrictId();
            map.put("pb", this.goodsService.searchGoods3(pb, searchBean, null, params, distinctId.toString()));
            map.put(DISTINCTID, distinctId.toString());
            map.put(SEARCHBEAN, searchBean);
            map.put(PARAMS, screenVo);
            mav.addObject("map", map);
            if (searchBean.getStoreId() == null) {
                mav.addObject(STOREID, (Object)0);
            } else {
                mav.addObject(STOREID, (Object)searchBean.getStoreId());
            }
            mav.setViewName(GOODS_LIST);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/searchproductnew"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> esearchProductNew(HttpServletRequest request, SearchPageBean<SolrGoodsInfo> pageBean, String[] params, String keyWords, String sort, Long storeId, String showStatus, String showStock, String isThird) {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        String[] indices = new String[]{GoodsIndexConstant.PRODUCT_INDEX_NAME()};
        String[] types = new String[]{GoodsIndexConstant.PRODUCT_TYPE};
        pageBean.setPageSize(20);
        try {
            Long[] longArray;
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            Long distinctId = wareUtil.getDistrictId();
            Long wareId = this.productService.selectWareIdByDistinctId(distinctId);
            if (wareId == null) {
                longArray = null;
            } else {
                Long[] longArray2 = new Long[1];
                longArray = longArray2;
                longArray2[0] = wareId;
            }
            Long[] wares = longArray;
            resultMap = this.goodsSolrSearchServivice.searchGoods(pageBean, wares, indices, types, keyWords, null, null, params, sort, null, null, (Long)(storeId != null && 0L == storeId ? null : storeId), null, showStock, "1", isThird);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u57fa\u4e8esolr\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    @RequestMapping(value={"/searchProduct"})
    public ModelAndView esearchProduct(HttpServletRequest request, SearchPageBean<SolrGoodsInfo> pageBean, String[] params, String keyWords, String sort, Long storeId, String showStatus, String showStock, String isThird) {
        ModelAndView mav = new ModelAndView();
        String[] indices = new String[]{GoodsIndexConstant.PRODUCT_INDEX_NAME()};
        String[] types = new String[]{GoodsIndexConstant.PRODUCT_TYPE};
        pageBean.setPageSize(20);
        try {
            Long[] longArray;
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            Long distinctId = wareUtil.getDistrictId();
            Long wareId = this.productService.selectWareIdByDistinctId(distinctId);
            if (wareId == null) {
                longArray = null;
            } else {
                Long[] longArray2 = new Long[1];
                longArray = longArray2;
                longArray2[0] = wareId;
            }
            Long[] wares = longArray;
            Map resultMap = this.goodsSolrSearchServivice.searchGoods(pageBean, wares, indices, types, keyWords, null, null, params, sort, null, null, (Long)(storeId != null && 0L == storeId ? null : storeId), null, showStock, "1", isThird);
            mav.addObject("map", (Object)resultMap);
            mav.addObject("keyWords", (Object)keyWords);
            mav.addObject("sort", (Object)(sort == null ? "" : sort));
            mav.addObject(STOREID, (Object)(storeId == null ? 0L : storeId));
            mav.addObject("wareId", (Object)wareId);
            mav.addObject("showStatus", showStatus == null ? Integer.valueOf(2) : showStatus);
            mav.setViewName("goods/pro_es_list");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u54c1\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/allproajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> allGoodsListAjax(Long cid, SearchPageBean<SolrGoodsInfo> pb, GoodsSiteSearchBean searchBean, String[] params, HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        pb.setPageSize(20);
        Map<String, Object> resultMap = null;
        try {
            if (searchBean.getCateBarId() != null) {
                MobCateBar mobCateBar = this.mobCateBarService.selectMobcateBarById(searchBean.getCateBarId());
                cid = mobCateBar != null && mobCateBar.getCateId() != null ? mobCateBar.getCateId() : Long.valueOf(-1L);
            }
            GoodsTypeVo typeVo = null;
            List screenVo = this.goodsService.calcScreenParam(params, typeVo);
            GoodsTypeVo calcTypeVo = this.goodsService.calcTypeVo(screenVo, typeVo);
            map.put("type", calcTypeVo);
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            Long distinctId = wareUtil.getDistrictId();
            MobCateBar twoCateBar = this.mobCateBarService.selectMobcateBarById(cid);
            Long catId = twoCateBar.getCateId();
            resultMap = this.cateCacheUtil.queryCateGoods(pb, searchBean, catId, distinctId);
            map.put("dataNum", resultMap.get("dataNum"));
            map.put("pb", resultMap.get("pb"));
            map.put(DISTINCTID, distinctId.toString());
            map.put(SEARCHBEAN, searchBean);
            map.put(PARAMS, screenVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u79fb\u52a8\u7aef\u6839\u636e\u5206\u7c7bid\u67e5\u8be2\u5546\u54c1\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return map;
    }

    @RequestMapping(value={"/allpro"})
    public ModelAndView allGoodsList(PageBean pb, GoodsSiteSearchBean searchBean, String[] params, HttpServletRequest request, String showStatus) {
        ModelAndView mav = new ModelAndView();
        pb.setPageSize(20);
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            GoodsTypeVo typeVo = null;
            List screenVo = this.goodsService.calcScreenParam(params, typeVo);
            GoodsTypeVo calcTypeVo = this.goodsService.calcTypeVo(screenVo, typeVo);
            map.put("type", calcTypeVo);
            ShoppingCartWareUtil wareUtil = this.shoppingCartAddressService.loadAreaFromRequest(request);
            Long distinctId = wareUtil.getDistrictId();
            map.put("pb", this.goodsService.searchGoods3(pb, searchBean, null, params, distinctId.toString()));
            map.put(DISTINCTID, distinctId.toString());
            map.put(SEARCHBEAN, searchBean);
            map.put(PARAMS, screenVo);
            mav.addObject("map", map);
            if (searchBean.getStoreId() == null) {
                mav.addObject(STOREID, (Object)0);
            } else {
                mav.addObject(STOREID, (Object)searchBean.getStoreId());
            }
            mav.addObject("showStatus", (Object)showStatus);
            mav.setViewName(GOODS_LIST);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/productdetail"})
    public ModelAndView goodsDetail(Long productId, Long distinctId, String chAddress, HttpServletRequest request, HttpServletResponse response) {
        String isAjax;
        String preUrl;
        List order;
        ModelAndView mav = new ModelAndView();
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        if (customerId != null && (order = this.orderService.orderDetailList(customerId, "")).size() > 0) {
            ArrayList new_order_goodsList = new ArrayList();
            for (int i = 0; i < order.size(); ++i) {
                System.out.println("backgoodsnum--------------------" + ((Order)order.get(i)).getOrderGoodsList());
                List goodsList = ((Order)order.get(i)).getOrderGoodsList();
                new_order_goodsList.addAll(goodsList);
            }
            com.qianjiang.goods.vo.GoodsProductVo goodsProductVo = this.productService.selectByPrimaryKey(productId);
            System.out.println(goodsProductVo + "!!!!!!!!!!!!!");
            if (goodsProductVo == null) {
                System.out.println("continue!!!!!!!!");
            } else if ("1".equals(goodsProductVo.getIsCard())) {
                mav.addObject("ifBarterOrder", (Object)0);
                System.out.println("break!!!!!!!!");
            } else {
                for (OrderGoods goods : new_order_goodsList) {
                    Long backGoodsNum;
                    System.out.println("backgoodsnum---------------" + goods.getBackGoodsNum() + "\u8ba2\u5355\u5546\u54c1\u7f16\u53f7\u662f\uff01\uff01\uff01\uff01" + goods.getOrderGoodsId() + "\u8ba2\u5355\u7f16\u53f7" + goods.getOrderId());
                    System.out.println("goodsnum---------------" + goods.getGoodsInfoNum());
                    String goodsInfoItemNoS = goods.getGoodsInfoItemNoS();
                    if (goodsInfoItemNoS == null) {
                        goodsInfoItemNoS = "";
                    }
                    if ((backGoodsNum = goods.getBackGoodsNum()) == null || "".equals(backGoodsNum)) continue;
                    System.out.println("\u8d27\u54c1\u7684\u6570\u91cf" + goods.getGoodsInfoNum());
                    System.out.println("\u9000\u8d27\u7684\u6570\u91cf" + backGoodsNum);
                    if (goods.getGoodsInfoNum() - backGoodsNum <= 0L) continue;
                    System.out.println("\u53ef\u4ee5\u6362\u8d27\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
                    mav.addObject("ifBarterOrder", (Object)1);
                    break;
                }
            }
        }
        if ((preUrl = request.getHeader("Referer")) != null && !"".equals(preUrl)) {
            preUrl = URLDecoder.decode(preUrl);
        }
        if (null == (isAjax = request.getParameter("isAjax")) || "".equals(isAjax)) {
            isAjax = "0";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long distinctId1 = distinctId;
        try {
            if (null == productId) {
                mav.setViewName("goods/no_exit");
                return this.seoService.getCurrSeo(mav);
            }
            GoodsProductVo good = (GoodsProductVo)JSON.parseObject((String)JSON.toJSONString((Object)this.productService.queryProductByProductId(productId)), GoodsProductVo.class);
            if (good == null) {
                mav.setViewName("goods/no_exit");
                return this.seoService.getCurrSeo(mav);
            }
            if (this.productService.queryProductByGoodsInfoId(productId) == 0) {
                mav.setViewName("goods/no_exit");
                return this.seoService.getCurrSeo(mav);
            }
            if (null == distinctId1) {
                if (null != request.getSession().getAttribute("address") && null == request.getSession().getAttribute(CHADDRESS)) {
                    distinctId1 = ((CustomerAddress)request.getSession().getAttribute("address")).getDistrict().getDistrictId();
                    map.put(CHADDRESS, ((CustomerAddress)request.getSession().getAttribute("address")).getProvince().getProvinceName() + ((CustomerAddress)request.getSession().getAttribute("address")).getCity().getCityName() + ((CustomerAddress)request.getSession().getAttribute("address")).getDistrict().getDistrictName());
                    map.put(CHPROVINCE, ((CustomerAddress)request.getSession().getAttribute("address")).getProvince().getProvinceName());
                    map.put(CHCITY, ((CustomerAddress)request.getSession().getAttribute("address")).getCity().getCityName());
                    map.put(CHDISTINCT, ((CustomerAddress)request.getSession().getAttribute("address")).getDistrict().getDistrictName());
                } else if (null == request.getSession().getAttribute(CHADDRESS)) {
                    Long dId = this.addressService.getDefaultIdService();
                    if (dId == null) {
                        dId = 749L;
                        distinctId1 = (long)dId;
                        map.put(CHADDRESS, "\u4e0a\u6d77\u5e02\u5f90\u6c47\u533a");
                        map.put(CHPROVINCE, "\u4e0a\u6d77");
                        map.put(CHCITY, "\u4e0a\u6d77\u5e02");
                        map.put(CHDISTINCT, "\u5f90\u6c47\u533a");
                    } else {
                        distinctId1 = (long)dId;
                        AddressUtil addressUtil = this.districtService.queryAddressNameByDistrictId(dId);
                        map.put(CHADDRESS, addressUtil.getProvinceName() + addressUtil.getCityName() + addressUtil.getDistrictName());
                        map.put(CHPROVINCE, addressUtil.getProvinceName());
                        map.put(CHCITY, addressUtil.getCityName());
                        map.put(CHDISTINCT, addressUtil.getDistrictName());
                    }
                } else {
                    map.put(CHPROVINCE, request.getSession().getAttribute(CHPROVINCE));
                    map.put(CHADDRESS, request.getSession().getAttribute(CHADDRESS));
                    map.put(CHCITY, request.getSession().getAttribute(CHCITY));
                    map.put(CHDISTINCT, request.getSession().getAttribute(CHDISTINCT));
                    distinctId1 = Long.parseLong(request.getSession().getAttribute(DISTINCTID).toString());
                }
            } else {
                map.put(CHADDRESS, chAddress);
                map.put(CHPROVINCE, request.getParameter(CHPROVINCE));
                map.put(CHCITY, request.getParameter(CHCITY));
                map.put(CHDISTINCT, request.getParameter(CHDISTINCT));
            }
            map.put(DISTINCTID, distinctId1);
            request.getSession().setAttribute(CHPROVINCE, map.get(CHPROVINCE));
            request.getSession().setAttribute(CHADDRESS, map.get(CHADDRESS));
            request.getSession().setAttribute(CHCITY, map.get(CHCITY));
            request.getSession().setAttribute(CHDISTINCT, map.get(CHDISTINCT));
            request.getSession().setAttribute(DISTINCTID, map.get(DISTINCTID));
            response.setHeader("Cache-Control", "no-store");
            response.setDateHeader("Expires", 0L);
            response.setHeader("Pragma", "no-cache");
            GoodsDetailBean detailBean = this.productService.queryDetailBeanByProductId(productId, distinctId1);
            if (null != detailBean && detailBean.getProductVo() != null) {
                String mobileDesc;
                List imageList;
                if (null != (detailBean = this.cartService.forPurchasing(detailBean, customerId)).getProductVo() && CollectionUtils.isNotEmpty((Collection)(imageList = detailBean.getProductVo().getImageList()))) {
                    for (int i = 0; i < imageList.size(); ++i) {
                        if (!"1".equals(((GoodsImage)JSON.parseObject((String)JSON.toJSONString(imageList.get(i)), GoodsImage.class)).getGoodsImgSort().toString())) continue;
                        GoodsImage go = (GoodsImage)JSON.parseObject((String)JSON.toJSONString(imageList.get(0)), GoodsImage.class);
                        imageList.set(0, JSON.parseObject((String)JSON.toJSONString(imageList.get(i)), GoodsImage.class));
                        imageList.set(i, go);
                    }
                    detailBean.getProductVo().setImageList(imageList);
                }
                if ((mobileDesc = detailBean.getProductVo().getGoods().getMobileDesc()).indexOf(WIDTH) != -1) {
                    mobileDesc = mobileDesc.substring(0, mobileDesc.indexOf(WIDTH)) + mobileDesc.substring(mobileDesc.indexOf(WIDTH) + 6);
                }
                detailBean.getProductVo().getGoods().setMobileDesc(mobileDesc);
                Long storeId = new Long(0L);
                Long thirdId = detailBean.getProductVo().getThirdId();
                if (null != thirdId && storeId.intValue() != thirdId.intValue()) {
                    StoreInfo storeInfo = this.storeInfoService.selectByPrimaryKey(thirdId);
                    map.put("storeInfo", storeInfo);
                }
                List queryOpenListByGoodsId = this.goodsOpenSpecService.queryOpenListByGoodsId(detailBean.getProductVo().getGoodsId());
                OnLineService selectSetting = this.onLineServiceBiz.selectSetting();
                List qqlist = this.onLineServiceItemService.selectItemsByType(0);
                if (qqlist != null && qqlist.size() > 0) {
                    map.put("QQ", qqlist.get(0));
                } else {
                    map.put("QQ", null);
                }
                Long custId = (Long)request.getSession().getAttribute(CUSTOMERID);
                Cookie[] oldCookie = request.getCookies();
                String allBroPro = "";
                String addFlag = this.browserecordService.addBrowerecord(custId, null, productId);
                boolean cookieExits = false;
                if (!"1".equals(addFlag)) {
                    if (null != oldCookie) {
                        for (Cookie cookie2 : oldCookie) {
                            if (null == cookie2 || !COOKIE.equals(cookie2.getName())) continue;
                            allBroPro = URLDecoder.decode(cookie2.getValue(), "utf-8");
                            if (allBroPro.indexOf(",s" + productId + "e") != -1) {
                                allBroPro = allBroPro.replace(",s" + productId + "e", "");
                            }
                            if (allBroPro.indexOf(",s" + productId) != -1) {
                                allBroPro = allBroPro.replace(",s" + productId, "");
                            }
                            cookieExits = true;
                        }
                        allBroPro = allBroPro + ",s" + productId + "e";
                    }
                    if (!cookieExits) {
                        allBroPro = String.valueOf(",s" + productId + "e");
                        Cookie cookie = new Cookie(COOKIE, URLEncoder.encode(allBroPro, "utf-8"));
                        cookie.setMaxAge(1296000);
                        cookie.setPath("/");
                        response.addCookie(cookie);
                    }
                }
                map.put("isAjax", isAjax);
                map.put("detailBean", detailBean);
                map.put("openSpec", queryOpenListByGoodsId);
                map.put("customerService", selectSetting);
                map.put("url", preUrl);
                map.put("zheKouPrice", this.getZhePrice(customerId, detailBean.getProductVo().getGoodsInfoPreferPrice()));
                mav.addObject("map", map);
                mav.setViewName("goods/goods-detail");
            } else {
                mav.setViewName("goods/no_exit");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("App\u7aef\u67e5\u770b\u5546\u54c1\u8be6\u60c5\u9519\u8bef" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    private BigDecimal getZhePrice(Long customerId, BigDecimal goodsInfoPreferPrice) {
        BigDecimal discount = new BigDecimal("0");
        BigDecimal customerDiscount = this.customerPointServiceMapper.selectCustomerDiscountByCustomerId(customerId);
        if (customerDiscount != null && goodsInfoPreferPrice != null) {
            discount = goodsInfoPreferPrice.multiply(customerDiscount);
            return discount.setScale(2, RoundingMode.HALF_UP);
        }
        return goodsInfoPreferPrice.setScale(2, RoundingMode.HALF_UP);
    }

    @RequestMapping(value={"/specification"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map specification(Long id, Long goodsId, HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List goodsproduct = null;
        GoodsOpenSpecValueVo goodsValue = null;
        try {
            goodsValue = this.goodsOpenSpecValueService.queryOpenValueId(id);
            goodsproduct = (List)JSON.parseObject((String)JSON.toJSONString((Object)this.productService.queryAllProductListByGoodsId(goodsId)), List.class);
            if (goodsValue != null) {
                map.put("ke", goodsproduct);
                map.put("key", goodsValue);
                map.put("falg", 0);
            } else {
                map.put("falg", 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    @RequestMapping(value={"/queryProductListByGoodsId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Object> queryAllProductByGoodsId(Long goodsId) {
        return this.productService.queryAllProductListByGoodsId(goodsId);
    }

    @RequestMapping(value={"/saveAtte"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int saveAtte(Long productId, Long districtId, HttpServletRequest request, BigDecimal goodsprice) {
        int result = 0;
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        try {
            if (customerId == null) {
                result = -2;
                return result;
            }
            result = this.goodsAtteService.newsaveGoodsAtte(customerId, productId, districtId, goodsprice);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u7528\u6237\u6536\u85cf\u5546\u54c1\u5931\u8d25" + e.getMessage());
        }
        return result;
    }

    @RequestMapping(value={"/addcollection"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int addCollection(Long productId, Long districtId, HttpServletRequest request, BigDecimal goodsprice) {
        int result = 0;
        Long customerId = (Long)request.getSession().getAttribute(CUSTOMERID);
        try {
            if (customerId == null) {
                result = -2;
                return result;
            }
            result = this.goodsAtteService.addGoodsCollection(customerId, productId, districtId, goodsprice);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u52a0\u5165\u6536\u85cf\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/queryProducCommentForDetail"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public com.qianjiang.util.PageBean queryProductComment(com.qianjiang.util.PageBean pb, Long productId, String title, Character type, String askType) {
        return this.commentServiceMapper.selectCommByGoodsIdHyc(pb, productId, type, title);
    }

    @RequestMapping(value={"/queryProductCommentForType"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Object queryCommentByType(com.qianjiang.util.PageBean pb, Long productId, String hpic) {
        com.qianjiang.util.PageBean pageBean = null;
        try {
            pageBean = this.commentServiceMapper.selectCommByType(pb, productId, hpic);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("App\u7aef\u5546\u54c1\u8be6\u60c5\u5c55\u793a\u5546\u54c1\u54c1\u8bba\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return JSON.toJSON((Object)pageBean);
    }

    @RequestMapping(value={"/queryCouponList"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Coupon> queryCouponListBySpuId(HttpServletRequest request, Long productId, Long cateId, Long brandId, Long thirdId) {
        List<Object> selectCouponListByIdsNew = new ArrayList<Coupon>();
        try {
            ArrayList<ParamIds> paramIdsList = new ArrayList<ParamIds>();
            ParamIds paramIds = new ParamIds();
            paramIds.setCouponRangeFkId(productId);
            paramIds.setCouponRangeType("2");
            ParamIds paramIds1 = new ParamIds();
            paramIds1.setCouponRangeFkId(cateId);
            paramIds1.setCouponRangeType("0");
            ParamIds paramIds2 = new ParamIds();
            paramIds2.setCouponRangeFkId(brandId);
            paramIds2.setCouponRangeType("1");
            paramIdsList.add(paramIds);
            paramIdsList.add(paramIds1);
            paramIdsList.add(paramIds2);
            selectCouponListByIdsNew = this.couponService.selectCouponListByIdsNew(paramIdsList, thirdId, request);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u53c2\u6570\u67e5\u8be2\u4f18\u60e0\u5238\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return selectCouponListByIdsNew;
    }

    @RequestMapping(value={"/goCoupon"})
    public ModelAndView goCoupon(HttpServletRequest request, Long productId, Long cateId, Long brandId, Long thirdId) {
        ModelAndView mav = new ModelAndView();
        Long cId = (Long)request.getSession().getAttribute(CUSTOMERID);
        try {
            ArrayList<ParamIds> paramIdsList = new ArrayList<ParamIds>();
            ParamIds paramIds = new ParamIds();
            paramIds.setCouponRangeFkId(productId);
            paramIds.setCouponRangeType("2");
            ParamIds paramIds1 = new ParamIds();
            paramIds1.setCouponRangeFkId(cateId);
            paramIds1.setCouponRangeType("0");
            ParamIds paramIds2 = new ParamIds();
            paramIds2.setCouponRangeFkId(brandId);
            paramIds2.setCouponRangeType("1");
            paramIdsList.add(paramIds);
            paramIdsList.add(paramIds1);
            paramIdsList.add(paramIds2);
            List couponList = this.couponService.selectCouponListByIdsNew(paramIdsList, thirdId, request);
            ArrayList<Long> cList = new ArrayList<Long>();
            for (int i = 0; i < couponList.size(); ++i) {
                Coupon coupon = (Coupon)couponList.get(i);
                int counts = this.couponNoService.selectReadyGet(coupon.getCouponId(), cId);
                if ((long)counts < coupon.getCouponGetNo()) continue;
                cList.add(coupon.getCouponId());
            }
            mav.addObject("couponList", (Object)couponList);
            mav.addObject("cList", cList);
            mav.addObject("productId", (Object)productId);
            mav.setViewName("coupon/getCoupon_ct");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u79fb\u52a8\u7aef\u524d\u53f0\u5546\u54c1\u8be6\u60c5\u9875\u4f7f\u7528\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        return this.seoService.getCurrSeo(mav);
    }

    @RequestMapping(value={"/showBigImage"})
    public ModelAndView queryBigImage(Long productId) {
        ModelAndView mav = new ModelAndView();
        try {
            List<GoodsImage> imageList;
            com.qianjiang.wap.goods.bean.GoodsDetailBean detailBean = (com.qianjiang.wap.goods.bean.GoodsDetailBean)JSON.parseObject((String)JSON.toJSONString((Object)this.productService.queryDetailBeanByProductId(productId, Long.valueOf(749L))), com.qianjiang.wap.goods.bean.GoodsDetailBean.class);
            if (null != detailBean && null != detailBean.getProductVo() && CollectionUtils.isNotEmpty(imageList = detailBean.getProductVo().getImageList())) {
                for (int i = 0; i < imageList.size(); ++i) {
                    if (!"1".equals(imageList.get(i).getGoodsImgSort().toString())) continue;
                    GoodsImage go = imageList.get(0);
                    imageList.set(0, imageList.get(i));
                    imageList.set(i, go);
                }
                detailBean.getProductVo().setImageList(imageList);
            }
            mav.addObject("detailBean", (Object)detailBean);
            mav.setViewName("/goods/goods_detail_pic");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mav;
    }

    @RequestMapping(value={"/queryProducCommentForDetailHyc"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public com.qianjiang.util.PageBean queryProductCommentHyc(com.qianjiang.util.PageBean pb, Long productId, String title, Character type, String askType) {
        return this.commentServiceMapper.selectCommByGoodsIdHyc(pb, productId, type, title);
    }

    @RequestMapping(value={"/queryCommentCountByType"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int queryCommentCountByType(PageBean pb, Long productId, String title, Character type) {
        return this.commentServiceMapper.queryCommentCountByType(productId, type, title);
    }

    @RequestMapping(value={"/queryProducCommentDetailForDetailHyc"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public com.qianjiang.util.PageBean queryProductCommentDetailHycCount(com.qianjiang.util.PageBean pb, Long productId, String title, Character type, String askType) {
        return this.commentServiceMapper.selectCommDetailByGoodsIdHyc(pb, productId, type, title);
    }

    @RequestMapping(value={"/showPingLun"})
    public ModelAndView showPingLun(Long productId) {
        return new ModelAndView("/goods/allAssess").addObject("productId", (Object)productId);
    }
}

