/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.devdevice.device.controller;

import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.dev.config.model.JsonResult;
import com.yqbsoft.laser.html.devdevice.device.bean.DevicePostBean;
import com.yqbsoft.laser.html.facade.dev.bean.DevDevice;
import com.yqbsoft.laser.html.facade.dev.repository.DevDeviceRepository;
import com.yqbsoft.laser.html.facade.dev.repository.DevPropertyRepository;
import com.yqbsoft.laser.html.facade.mm.bean.MmMbuser;
import com.yqbsoft.laser.html.facade.mm.repository.MmMerberRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/devdevice/deviceManage"})
public class DevDeviceCon
extends SpringmvcController {
    @Autowired
    private DevDeviceRepository devDeviceRepository;
    @Autowired
    private DevPropertyRepository devPropertyRepository;
    @Autowired
    private MmMerberRepository mmMerberRepository;

    @RequestMapping(value={"list"})
    public String listQuery(HttpServletRequest request, ModelMap modelMap) {
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        UserSession userSession = this.getUserSession(request);
        param.put("tenantCode", userSession.getTenantCode());
        SupQueryResult supQueryResult = this.devDeviceRepository.listQueryPage(param);
        if (supQueryResult != null && ListUtil.isNotEmpty((Collection)supQueryResult.getRows())) {
            modelMap.put((Object)"deviceList", (Object)supQueryResult.getRows());
        }
        modelMap.addAttribute("pageTools", (Object)this.buildPage(supQueryResult.getPageTools(), request));
        return String.valueOf(this.getFtlTempPath(request)) + "list";
    }

    @RequestMapping(value={"property/list"})
    public String propertyHistoryListQuery(HttpServletRequest request, ModelMap modelMap) {
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        UserSession userSession = this.getUserSession(request);
        param.put("tenantCode", userSession.getTenantCode());
        param.put("relevantType", 1);
        SupQueryResult supQueryResult = this.devPropertyRepository.listQueryHistoryPage(param);
        if (supQueryResult != null && ListUtil.isNotEmpty((Collection)supQueryResult.getRows())) {
            modelMap.put((Object)"propertyHistoryList", (Object)supQueryResult.getRows());
        }
        modelMap.addAttribute("pageTools", (Object)this.buildPage(supQueryResult.getPageTools(), request));
        return String.valueOf(this.getFtlTempPath(request)) + "property-history";
    }

    @RequestMapping(value={"property/set"})
    public String propertySetListQuery(HttpServletRequest request, ModelMap modelMap) {
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        UserSession userSession = this.getUserSession(request);
        param.put("tenantCode", userSession.getTenantCode());
        SupQueryResult supQueryResult = this.devPropertyRepository.listQueryPage(param);
        if (supQueryResult != null && ListUtil.isNotEmpty((Collection)supQueryResult.getRows())) {
            modelMap.put((Object)"propertyList", (Object)supQueryResult.getRows());
        }
        modelMap.addAttribute("pageTools", (Object)this.buildPage(supQueryResult.getPageTools(), request));
        return String.valueOf(this.getFtlTempPath(request)) + "propertySet";
    }

    @RequestMapping(value={"save.json"})
    @ResponseBody
    public HtmlJsonReBean addDevice(HttpServletRequest request, @RequestBody DevicePostBean devicePostBean, ModelMap modelMap) {
        UserSession userSession = this.getUserSession(request);
        MmMbuser mmMbuser = this.mmMerberRepository.queryMbuser(devicePostBean.getDevicePhone(), userSession.getTenantCode());
        if (mmMbuser == null) {
            return JsonResult.error((String)"\u672a\u627e\u5230\u8be5\u4f1a\u5458");
        }
        DevDevice devDevice = new DevDevice();
        devDevice.setDeviceCode(devicePostBean.getDeviceCode());
        devDevice.setDeviceVersion(devicePostBean.getDeviceVersion());
        devDevice.setMemberCode(mmMbuser.getMerberCode());
        devDevice.setTenantCode(userSession.getTenantCode());
        HtmlJsonReBean htmlJsonReBean = this.devDeviceRepository.saveDeviceInfo(devDevice);
        return htmlJsonReBean;
    }

    protected String getContext() {
        return "device";
    }
}

