/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.devdevice.device.controller;

import com.yqbsoft.laser.html.common.send.PostParamMap;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.repository.DdRepository;
import com.yqbsoft.laser.html.facade.exchange.constant.DisChannelEnum;
import com.yqbsoft.laser.html.facade.exchange.constant.DisChannelType;
import com.yqbsoft.laser.html.facade.exchange.domian.DisChannelDomain;
import com.yqbsoft.laser.html.facade.exchange.repository.impl.DispenseChannelRepositoryImpl;
import com.yqbsoft.laser.html.facade.fm.repository.FileRepository;
import com.yqbsoft.laser.html.facade.mm.bean.MerberBean;
import com.yqbsoft.laser.html.facade.mm.bean.MmMerberDomain;
import com.yqbsoft.laser.html.facade.mm.constant.MmMerberServerTypeEnum;
import com.yqbsoft.laser.html.facade.mm.domain.MmMbuserReDomain;
import com.yqbsoft.laser.html.facade.mm.domain.MmMerberReDomain;
import com.yqbsoft.laser.html.facade.mm.repository.MmMerberRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/devdevice/member"})
public class DevMemberCon
extends SpringmvcController {
    @Autowired
    private MmMerberRepository mmMerberRepository;
    @Autowired
    MmMerberRepository merberRepository;
    @Autowired
    DdRepository ddRepository;
    @Autowired
    FileRepository fileRepository;
    @Autowired
    DispenseChannelRepositoryImpl dispenseChannelRepository;

    @RequestMapping(value={"list"})
    public String listQuery(HttpServletRequest request, ModelMap modelMap) {
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        UserSession userSession = this.getUserSession(request);
        param.put("roleCode", "0000001");
        param.put("tenantCode", userSession.getTenantCode());
        SupQueryResult supQueryResult = this.mmMerberRepository.queryMbuserPage(param);
        if (supQueryResult != null && ListUtil.isNotEmpty((Collection)supQueryResult.getRows())) {
            modelMap.put((Object)"mbuserList", (Object)supQueryResult.getRows());
        }
        modelMap.addAttribute("pageTools", (Object)this.buildPage(supQueryResult.getPageTools(), request));
        return String.valueOf(this.getFtlTempPath(request)) + "mbuserList";
    }

    @RequestMapping(value={"memberList"})
    public String list(HttpServletRequest request, ModelMap map) {
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        param.put("tenantCode", this.getTenantCode(request));
        param.put("whereFlag", true);
        param.put("whereStr", " MERBER_SERVER_TYPE is not null");
        param.put("order", true);
        param.put("partnerCode", "FFJ00001");
        Object merberPhone = param.get("merberPhone");
        if (merberPhone != null && !"".equals(merberPhone)) {
            map.put((Object)"merberPhone", merberPhone);
        } else {
            param.remove("merberPhone");
        }
        SupQueryResult supQueryResult = this.merberRepository.queryMerberRePage(param);
        if (ListUtil.isEmpty((Collection)supQueryResult.getList())) {
            if (merberPhone != null && !merberPhone.equals("")) {
                HashMap<String, String> pmap = new HashMap<String, String>();
                pmap.put("tenantCode", this.getTenantCode(request));
                pmap.put("mbuserPhone", (String)merberPhone);
                List mbuserList = this.merberRepository.queryMbuserPage(pmap).getList();
                if (ListUtil.isNotEmpty((Collection)mbuserList)) {
                    param.put("merberCode", ((MmMbuserReDomain)mbuserList.get(0)).getMerberCode());
                    param.remove("merberPhone");
                }
            }
            supQueryResult = this.merberRepository.queryMerberRePage(param);
        }
        map.addAttribute("merberList", (Object)supQueryResult.getList());
        map.addAttribute("pageTools", (Object)this.buildPage(supQueryResult.getPageTools(), request));
        List dd = this.ddRepository.queryDdList("MmMerber", "merberServerType");
        map.put((Object)"ddList", (Object)dd);
        return String.valueOf(this.getFtlTempPath(request)) + "memberList";
    }

    @RequestMapping(value={"toUpdate"})
    public String toUpdate(HttpServletRequest request, ModelMap map, Integer merberId) {
        MmMerberReDomain merberReDomain = this.merberRepository.getMerberReById(merberId);
        MmMbuserReDomain mbuser = this.merberRepository.getMbuserByMerber(merberReDomain.getMerberCode(), merberReDomain.getTenantCode());
        if (mbuser == null) {
            return String.valueOf(this.getFtlTempPath(request)) + "merberUpdate";
        }
        if (StringUtils.isEmpty((String)merberReDomain.getMerberPhone())) {
            merberReDomain.setMerberPhone(mbuser.getMbuserPhone());
        }
        map.put((Object)"mbuser", (Object)mbuser);
        map.put((Object)"merber", (Object)merberReDomain);
        List dd = this.ddRepository.queryDdList("MmMerber", "merberServerType");
        map.put((Object)"ddList", (Object)dd);
        return String.valueOf(this.getFtlTempPath(request)) + "memberUpdate";
    }

    @RequestMapping(value={"toAdd"})
    public String toAdd(HttpServletRequest request, ModelMap map) {
        List dd = this.ddRepository.queryDdList("MmMerber", "merberServerType");
        map.put((Object)"ddList", (Object)dd);
        return String.valueOf(this.getFtlTempPath(request)) + "memberAdd";
    }

    @RequestMapping(value={"updateMerber.json"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean update(@RequestParam(value="file") MultipartFile[] file, HttpServletRequest request, MmMerberDomain merberDomain) {
        HtmlJsonReBean htmlJsonReBean = null;
        try {
            MmMerberDomain merber = this.merberRepository.getMerberById(merberDomain.getMerberId());
            BeanUtils.copyAllPropertysNotNull((Object)merber, (Object)merberDomain);
            htmlJsonReBean = this.merberRepository.updateMerber(merber);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return htmlJsonReBean;
    }

    @RequestMapping(value={"addMerber.json"})
    @ResponseBody
    public HtmlJsonReBean sendOpenMerber(HttpServletRequest request, MerberBean merberBean) {
        if (merberBean == null) {
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "\u53c2\u6570\u4e3a\u7a7a");
        }
        merberBean.setTenantCode(this.getTenantCode(request));
        if (MmMerberServerTypeEnum.serverType4.getCode().equals(merberBean.getMerberServerType())) {
            merberBean.setRoleCode(SupDisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-vshop-vshop_ts"));
        }
        merberBean.setPartnerCode("FFJ00001");
        PostParamMap pmap = new PostParamMap("mm.merber.sendOpenMerber");
        pmap.putParamToJson("mmMerberDomain", (Object)merberBean);
        String merberCode = (String)this.htmlIBaseService.senReObject(pmap, String.class);
        if (MmMerberServerTypeEnum.serverType4.getCode().equals(merberBean.getMerberServerType())) {
            DisChannelDomain disChannelDomain = new DisChannelDomain();
            disChannelDomain.setChannelCode(DisChannelEnum.TOTAL_STORE.getCode());
            disChannelDomain.setChannelName(String.valueOf(merberBean.getMerberCompname()) + DisChannelEnum.TOTAL_STORE.getDesc());
            disChannelDomain.setMemberCode(merberCode);
            disChannelDomain.setMemberName(merberBean.getMerberCompname());
            disChannelDomain.setChannelType(DisChannelType.Type_ZC.getCode());
            disChannelDomain.setTenantCode(this.getTenantCode(request));
            this.dispenseChannelRepository.saveDisChannel(disChannelDomain);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"deleteMerber.json"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean deleteMerber(HttpServletRequest request, Integer merberId, Integer dataState) {
        Integer olddata = null;
        if (dataState == 0) {
            olddata = -1;
        }
        if (dataState == -1) {
            olddata = 0;
        }
        return this.merberRepository.updateMerberState(merberId, dataState, olddata);
    }

    protected String getContext() {
        return "member";
    }
}

