/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.devdevice.device.controller;

import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.dev.config.DeviceHandleEnum;
import com.yqbsoft.laser.html.dev.config.model.JsonResult;
import com.yqbsoft.laser.html.facade.dev.bean.DeviceMsg;
import com.yqbsoft.laser.html.facade.dev.repository.DeviceHandlerRepository;
import com.yqbsoft.laser.html.facade.fm.domian.FileDomain;
import com.yqbsoft.laser.html.facade.fm.repository.FileRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.SupperSysException;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/devdevice/upgradeManage"})
public class DevUpgradeCon
extends SpringmvcController {
    @Autowired
    private FileRepository fileRepository;
    @Autowired
    private DeviceHandlerRepository deviceHandlerRepository;

    @RequestMapping(value={"upgrade"})
    public String upgrade(HttpServletRequest request, ModelMap modelMap) {
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        UserSession userSession = this.getUserSession(request);
        param.put("tenantCode", userSession.getTenantCode());
        return String.valueOf(this.getFtlTempPath(request)) + "upgrade";
    }

    @ResponseBody
    @RequestMapping(value={"from/save.json"})
    public HtmlJsonReBean saveUploadFileData(HttpServletRequest request, @RequestParam(value="file", required=false) MultipartFile file, String deviceCode, String controllerCode, Integer upgradeType) {
        System.out.println("request = " + request.getParameterMap());
        try {
            UserSession userSession = this.getUserSession(request);
            String tenantCode = userSession.getTenantCode();
            if (file != null) {
                InputStream is = file.getInputStream();
                byte[] b = new byte[(int)file.getSize()];
                is.read(b);
                String stringBuffer = new String(b);
                FileDomain fileDomain = null;
                if (StringUtils.isNotBlank((String)stringBuffer)) {
                    fileDomain = this.fileRepository.saveFile(file, tenantCode, "file_03");
                }
                if (fileDomain != null) {
                    DeviceMsg deviceMsg = new DeviceMsg();
                    deviceMsg.setGreenhouseCode("0");
                    deviceMsg.setDeviceCode(deviceCode);
                    deviceMsg.setControllerCode("0");
                    deviceMsg.setFileCode(String.valueOf(fileDomain.getFileId()));
                    deviceMsg.setUpgradeType(upgradeType);
                    deviceMsg.setMsgType(DeviceHandleEnum.DEVICE_08.getDeviceNum());
                    HtmlJsonReBean htmlJsonReBean = this.deviceHandlerRepository.autoDeviceMsg(deviceMsg);
                    return htmlJsonReBean;
                }
            }
        }
        catch (SupperSysException e) {
            return new HtmlJsonReBean("error", e.getErrMsg());
        }
        catch (IOException e) {
            return new HtmlJsonReBean("error", "\u56fa\u4ef6\u4e0a\u4f20\u51fa\u9519");
        }
        return JsonResult.error((String)"\u4e0b\u53d1\u5347\u7ea7\u6307\u4ee4\u5931\u8d25");
    }

    protected String getContext() {
        return "upgrade";
    }
}

