<#include '/layout/Head.ftl' />
<div class="page_pad">
    <div class="page_bar">
        <i class="fa fa-home"></i>
        <a href="">用户管理</a>
        &nbsp;<i class="fa fa-angle-right"></i>&nbsp;&nbsp;新增用户
    </div>
	<div class="page_content">
		<h2 class="content_title">用户信息</h2>
    	<div class="list_form">
			<form class="form-horizontal" id="updateForm" name="updateForm" method="post" action="addMerber.json" enctype="multipart/form-data">
			<div class="small_field">
				<div class="row">
					<label class="col-xs-12 col-sm-2 col-md-2 col-lg-3">用户名</label>
					<div class="col-xs-12 col-sm-8 col-md-8 col-lg-3">
						<input type="text" id="merberCompname" name="merberCompname" value=""/>
					</div>
				</div>
			</div>
			<div class="small_field">
				<div class="row">
					<label class="col-xs-12 col-sm-2 col-md-2 col-lg-3">用户类型</label>
					<div class="col-xs-12 col-sm-8 col-md-8 col-lg-3">
						<input type="radio"  name="merberType" value="2" checked="checked"/>企业
						<input type="radio"  name="merberType" value="1"/>个人
					</div>
				</div>
			</div>
			<div class="small_field">
				<div class="row">
					<label class="col-xs-12 col-sm-2 col-md-2 col-lg-3">用户属性</label>
					<div class="col-xs-12 col-sm-8 col-md-8 col-lg-3">
						<select name="merberServerType" id="merberServerType">
						<option value="">---请选择---</option>
						<#if ddList?exists>
							<#list ddList as ddVo>
								<option value="${ddVo.ddCode}">${ddVo.ddValue}</option>
							</#list>
						</#if>
						</select>
					</div>
				</div>
			</div>
			<div class="small_field">
				<div class="row">
					<label class="col-xs-12 col-sm-2 col-md-2 col-lg-3">手机号</label>
					<div class="col-xs-12 col-sm-8 col-md-8 col-lg-3">
						<input type="text" id="merberPhone" name="merberPhone"/>
					</div>
				</div>
			</div>
			<div class="small_field">
				<div class="row">
					<label class="col-xs-12 col-sm-2 col-md-2 col-lg-3">邮箱</label>
					<div class="col-xs-12 col-sm-8 col-md-8 col-lg-3">
						<input type="text" id="merberEmail" name="merberEmail"/>
					</div>
				</div>
			</div>
			<div class="small_field">
				<div class="row">
					<label class="col-xs-12 col-sm-2 col-md-2 col-lg-3">登录名</label>
					<div class="col-xs-12 col-sm-8 col-md-8 col-lg-3">
						<input type="text" id="userName" name="userName"/>
					</div>
				</div>
			</div>
			<div class="small_field">
				<div class="row">
					<label class="col-xs-12 col-sm-2 col-md-2 col-lg-3">登录密码</label>
					<div class="col-xs-12 col-sm-8 col-md-8 col-lg-3">
						<input type="text" id="paypw" name="paypw"/>
					</div>
				</div>
			</div>
			<div class="small_field">
				<div class="row">
					<label class="col-xs-12 col-sm-2 col-md-2 col-lg-3"></label>
					<div class="col-xs-12 col-sm-8 col-md-8 col-lg-7">
						<p class="button_p">
							<#if outsiders?exists>
								<#else>
									<a href="JavaScript:;" class="button bg_blue button_keep" onclick="update();">
									 保存
									</a>
							</#if>
							<a href="JavaScript:;" class="button bg_blue button_keep" onclick="history.back();">
								 返回
							</a>
						</p>
					</div>
				</div>
			</div>
			</form>
		</div>
	</div>
</div>

<script>
function update(){
	var msg = checkForm();
	if(msg != ""){
		alert(msg);
		return;
	}
	if(confirm("确定保存?")){
		var hideForm = $('form'); 
		var options = { 
			dataType : "json", 
			success : function(data) { 
				if(data.sysRecode == "error"){
					msg = data.msg;
					alert(msg);
				}else{
					alert("操作成功");
					location.href="${sysAppContextPath}/web/devdevice/member/memberList";
				}
			}
		}; 
		hideForm.ajaxSubmit(options); 
	}
}


function checkForm(){
	 var merberCompname = $("#merberCompname").val();
	 if(merberCompname==""){
	 	return "用户名不能为空";
	 }
	 var merberPhone = $("#merberPhone").val();
	 if(merberPhone==""){
	 	return "手机号不能为空";
	 }
	 if(!(/^1[34578]\d{9}$/.test(merberPhone))){ 
       return "手机号码有误，请重填";  
     } 
	 var merberEmail = $("#merberEmail").val();
	 if(merberEmail==""){
	 	return "邮箱不能为空";
	 }
	  if(!(/^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+)+$/.test(merberEmail))){
	 	return "邮箱格式错误";
	 }
	  var userName = $("#userName").val();
	 if(userName==""){
	 	return "登录名不能为空";
	 }
	 var merberServerType = $("#merberServerType").val();
	 if(merberServerType==""){
	 	return "用户属性不能为空";
	 }
	 var paypw = $("#paypw").val();
	 if(paypw==""){
	 	return "登录密码不能为空";
	 }
	 return "";
}
</script>
<#include '/layout/Foot.ftl' />