/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.file.controller;

import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.fm.domian.FmFchannelDomainBean;
import com.yqbsoft.laser.html.facade.fm.repository.FileRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/fm/fchannel"})
public class FchannelCon
extends SpringmvcController {
    private static String CODE = "fm.fchannel.con";
    @Autowired
    private FileRepository fileRepository;

    protected String getContext() {
        return "fchannel";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(FmFchannelDomainBean fchannelBean) {
        if (null == fchannelBean) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.fileRepository.saveFchannel(fchannelBean);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, String fchannelId, ModelMap modelMap) {
        modelMap.put((Object)"fchannelReBean", (Object)this.getFchannel(fchannelId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, FmFchannelDomainBean fchannelBean) {
        if (null == fchannelBean) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.fileRepository.updateFchannel(fchannelBean);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, String fchannelId) {
        if (StringUtils.isBlank((String)fchannelId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.fileRepository.deleteFchannel(Integer.valueOf(Integer.parseInt(fchannelId)));
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, String fchannelId, String dataState, String oldDataState) {
        if (StringUtils.isBlank((String)fchannelId) || StringUtils.isBlank((String)dataState) || StringUtils.isBlank((String)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.fileRepository.updateFchannelState(fchannelId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, String fchannelId, ModelMap modelMap) {
        modelMap.put((Object)"fchannelReBean", (Object)this.getFchannel(fchannelId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getFchannel(String fchannelId) {
        String rs = "{}";
        if (StringUtils.isBlank((String)fchannelId)) {
            this.logger.error(CODE + ".view", (Object)"adaptationId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.fileRepository.getFchannel(Integer.valueOf(Integer.parseInt(fchannelId))));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.fileRepository.queryFchannelPage(param);
    }
}

