/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.goods.controller;

import com.yqbsoft.laser.html.annotation.Layout;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.bean.BsBrand;
import com.yqbsoft.laser.html.facade.bm.repository.BaseRepository;
import com.yqbsoft.laser.html.facade.esclient.repository.SearchRepository;
import com.yqbsoft.laser.html.facade.exchange.bean.RsResourceGoodsReDomain;
import com.yqbsoft.laser.html.facade.exchange.domian.RsPropertiesDomain;
import com.yqbsoft.laser.html.facade.exchange.domian.RsPropertiesOptionDomain;
import com.yqbsoft.laser.html.facade.exchange.domian.RsSkuReDomain;
import com.yqbsoft.laser.html.facade.exchange.domian.RsSpuDomain;
import com.yqbsoft.laser.html.facade.exchange.repository.PropertiesRepository;
import com.yqbsoft.laser.html.facade.exchange.repository.ResourceRepository;
import com.yqbsoft.laser.html.facade.exchange.repository.SkuRepository;
import com.yqbsoft.laser.html.facade.exchange.repository.SpuRepository;
import com.yqbsoft.laser.html.facade.fm.repository.FileRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.es.AccurateQueryDomain;
import com.yqbsoft.laser.service.suppercore.es.RangeDomain;
import com.yqbsoft.laser.service.suppercore.es.SearchDomain;
import com.yqbsoft.laser.service.suppercore.es.SortDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jsoup.helper.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/goods"})
@Layout(frameName="h5application")
public class GoodsCon
extends SpringmvcController {
    @Autowired
    PropertiesRepository propertiesRepository;
    @Autowired
    ResourceRepository resourceRepository;
    @Autowired
    private SkuRepository skuRepository;
    @Autowired
    private FileRepository fileRepository;
    @Autowired
    private SearchRepository searchRepository;
    @Autowired
    private BaseRepository baseRepository;
    @Autowired
    private SpuRepository spuRepository;

    @Autowired
    protected String getContext() {
        return "goods";
    }

    @RequestMapping(value={"goodsdetil"})
    public String detil(HttpServletRequest request, HttpServletResponse response, ModelMap mmap, String goodsCode, String spuCode, String skuCode) {
        String tenantCode = this.getTenantCodeByURL(request, response);
        RsSkuReDomain rsSkuReDomain = this.skuRepository.getSkuByCode(tenantCode, skuCode);
        RsResourceGoodsReDomain rs = this.resourceRepository.getResourceGoodsByCode(tenantCode, rsSkuReDomain.getGoodsCode());
        HashMap<String, String> spuMap = new HashMap<String, String>();
        spuMap.put("tenantCode", rsSkuReDomain.getTenantCode());
        spuMap.put("spuCode", rsSkuReDomain.getSpuCode());
        RsSpuDomain rsSpuDomain = this.spuRepository.getSpuByCode(spuMap);
        BsBrand bsBrand = null;
        if (rsSpuDomain != null) {
            bsBrand = this.baseRepository.getBrandByCode(rsSpuDomain.getBrandCode(), tenantCode);
        }
        goodsCode = rsSkuReDomain.getGoodsCode();
        mmap.addAttribute("rs", (Object)rs);
        mmap.addAttribute("sku", (Object)rsSkuReDomain);
        mmap.addAttribute("goodsCode", (Object)goodsCode);
        mmap.addAttribute("spuCode", (Object)spuCode);
        mmap.addAttribute("skuCode", (Object)skuCode);
        mmap.addAttribute("bsBrand", (Object)bsBrand);
        Map<String, String> skusMap = this.initProperties(mmap, tenantCode, goodsCode);
        HashMap<String, String> skuMap = new HashMap<String, String>();
        if (skusMap != null && StringUtils.isNotBlank((String)skusMap.get(skuCode))) {
            String skuProperties = skusMap.get(skuCode);
            int i = 0;
            while (i < skuProperties.split(",").length) {
                skuMap.put(skuProperties.split(",")[i].split(":")[0], skuProperties.split(",")[i].split(":")[1]);
                ++i;
            }
            mmap.addAttribute("skuMap", skuMap);
        }
        String code = StringUtils.isBlank((String)rs.getGoodsCodeOld()) ? rs.getGoodsCode() : rs.getGoodsCodeOld();
        mmap.addAttribute("fileList", (Object)this.fileRepository.queryFile("file_03", rs.getTenantCode(), code));
        String showDetail = request.getParameter("showDetail");
        if (StringUtils.isNotBlank((String)showDetail)) {
            return String.valueOf(this.getFtlTempPath(request)) + "detil";
        }
        return String.valueOf(this.getFtlTempPath(request)) + "goodsdetil";
    }

    private Map<String, String> initProperties(ModelMap mmap, String tenantCode, String goodsCode) {
        if (StringUtil.isBlank((String)tenantCode) || StringUtil.isBlank((String)goodsCode)) {
            return null;
        }
        String skusStr = SupDisUtil.get((String)(String.valueOf(tenantCode) + "-" + goodsCode + "-skusStr"));
        String prosStr = SupDisUtil.get((String)(String.valueOf(tenantCode) + "-" + goodsCode + "-prosStr"));
        HashMap<String, String> skusMap = null;
        HashMap<String, RsPropertiesDomain> prosMap = null;
        if (!StringUtil.isBlank((String)skusStr) && !StringUtil.isBlank((String)prosStr)) {
            skusMap = (HashMap<String, String>)JsonUtil.buildNormalBinder().getJsonToMap(skusStr, String.class, String.class);
            prosMap = (HashMap<String, RsPropertiesDomain>)JsonUtil.buildNormalBinder().getJsonToMap(prosStr, String.class, RsPropertiesDomain.class);
        } else {
            List list = this.propertiesRepository.queryPropertiesByGoods(tenantCode, goodsCode);
            if (list == null || list.isEmpty()) {
                return null;
            }
            skusMap = new HashMap<String, String>();
            prosMap = new HashMap<String, RsPropertiesDomain>();
            HashMap<String, String> proMap = new HashMap<String, String>();
            for (Map map : list) {
                ArrayList<RsPropertiesOptionDomain> propertiesOptionList;
                RsPropertiesDomain rsPropertiesDomain;
                String skuCode = (String)map.get("skuCode");
                String propertiesCode = (String)map.get("propertiesCode");
                String propertiesValueValue = (String)map.get("propertiesValueValue");
                String propertiesName = (String)map.get("propertiesName");
                if (StringUtil.isBlank((String)((String)skusMap.get(skuCode)))) {
                    skusMap.put(skuCode, String.valueOf(propertiesCode) + ":" + propertiesValueValue);
                } else {
                    skusMap.put(skuCode, String.valueOf((String)skusMap.get(skuCode)) + "," + propertiesCode + ":" + propertiesValueValue);
                }
                if (prosMap.get(propertiesCode) == null) {
                    rsPropertiesDomain = new RsPropertiesDomain();
                    rsPropertiesDomain.setPropertiesCode(propertiesCode);
                    rsPropertiesDomain.setPropertiesName(propertiesName);
                    propertiesOptionList = new ArrayList<RsPropertiesOptionDomain>();
                } else {
                    rsPropertiesDomain = (RsPropertiesDomain)prosMap.get(propertiesCode);
                    propertiesOptionList = rsPropertiesDomain.getPropertiesOptionList();
                }
                if (StringUtil.isBlank((String)((String)proMap.get(String.valueOf(propertiesCode) + "-" + propertiesValueValue)))) {
                    RsPropertiesOptionDomain propertiesOptionDomain = new RsPropertiesOptionDomain();
                    propertiesOptionDomain.setPropertiesCode(propertiesCode);
                    propertiesOptionDomain.setPropertiesOptionName(propertiesValueValue);
                    propertiesOptionList.add(propertiesOptionDomain);
                    proMap.put(String.valueOf(propertiesCode) + "-" + propertiesValueValue, String.valueOf(propertiesCode) + "-" + propertiesValueValue);
                }
                rsPropertiesDomain.setPropertiesOptionList(propertiesOptionList);
                prosMap.put(propertiesCode, rsPropertiesDomain);
            }
            skusStr = JsonUtil.buildNormalBinder().toJson(skusMap);
            prosStr = JsonUtil.buildNormalBinder().toJson(prosMap);
        }
        mmap.addAttribute("prosMap", prosMap);
        SupDisUtil.set((String)(String.valueOf(tenantCode) + "-" + goodsCode + "-skusStr"), (String)skusStr, (int)600);
        SupDisUtil.set((String)(String.valueOf(tenantCode) + "-" + goodsCode + "-prosStr"), (String)prosStr, (int)600);
        return skusMap;
    }

    @RequestMapping(value={"goodsdetilSku"})
    @ResponseBody
    public HtmlJsonReBean HttpServletRequest(HttpServletRequest request, HttpServletResponse response, ModelMap mmap, String goodsCode, String skuProperties) {
        RsSkuReDomain rsSkuReDomain;
        if (StringUtil.isBlank((String)skuProperties) || StringUtil.isBlank((String)goodsCode)) {
            return new HtmlJsonReBean();
        }
        HashMap<String, String> skuMap = new HashMap<String, String>();
        int i = 0;
        while (i < skuProperties.split(",").length) {
            String key = skuProperties.split(",")[i].split(":")[0];
            String value = skuProperties.split(",")[i].split(":")[1];
            skuMap.put(key, value);
            ++i;
        }
        String tenantCode = this.getTenantCodeByURL(request, response);
        Map<String, String> skusMap = this.initProperties(mmap, tenantCode, goodsCode);
        String skuCode = "";
        if (skusMap != null) {
            for (String key : skusMap.keySet()) {
                String properties = skusMap.get(key);
                boolean flag = true;
                int i2 = 0;
                while (i2 < properties.split(",").length) {
                    String propertiesCode = properties.split(",")[i2].split(":")[0];
                    String optionValue = properties.split(",")[i2].split(":")[1];
                    if (StringUtil.isBlank((String)((String)skuMap.get(propertiesCode))) || !((String)skuMap.get(propertiesCode)).equals(optionValue)) {
                        flag = false;
                    }
                    ++i2;
                }
                if (!flag) continue;
                skuCode = key;
                break;
            }
        }
        if (!(StringUtil.isBlank((String)skuCode) || (rsSkuReDomain = this.skuRepository.getSkuByCode(tenantCode, skuCode)) != null && rsSkuReDomain.getGoodsSupplynum().compareTo(BigDecimal.ZERO) == 1)) {
            skuCode = "";
        }
        return new HtmlJsonReBean((Object)skuCode);
    }

    @RequestMapping(value={"goodslist"})
    public String getgoodslist(HttpServletRequest request, HttpServletResponse response, ModelMap mmap, String pntreeCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pntreeStep", "2");
        map.put("tenantCode", this.getTenantCodeByURL(request, response));
        SupQueryResult rs = this.baseRepository.getPntreePage(map);
        if (rs != null) {
            mmap.addAttribute("pntreelist", (Object)rs.getList());
        }
        if (StringUtils.isNotBlank((String)pntreeCode)) {
            mmap.addAttribute("pntreeCode", (Object)pntreeCode);
        }
        return String.valueOf(this.getFtlTempPath(request)) + "goodslist";
    }

    @RequestMapping(value={"getgoodslist.json"})
    @ResponseBody
    public HtmlJsonReBean getgoodslist(HttpServletRequest request, HttpServletResponse response, String pntreeCode) {
        List list = null;
        SearchDomain searchDomain = new SearchDomain();
        searchDomain.setBizType("sku");
        ArrayList<AccurateQueryDomain> accurateQueryList = new ArrayList<AccurateQueryDomain>();
        AccurateQueryDomain accurateQueryDomain = new AccurateQueryDomain();
        accurateQueryDomain.setAccurateField("tenantCode");
        accurateQueryDomain.setAccurateFieldValue(this.getTenantCodeByURL(request, response));
        accurateQueryList.add(accurateQueryDomain);
        Map pageMap = HtmlUtil.buildPage((HttpServletRequest)request);
        pageMap.put("endRow", 10);
        searchDomain.setPageMap(pageMap);
        if (StringUtils.isNotBlank((String)pntreeCode)) {
            AccurateQueryDomain accurateQueryDomain1 = new AccurateQueryDomain();
            accurateQueryDomain1.setAccurateField("pntreeCode");
            accurateQueryDomain1.setAccurateFieldValue(pntreeCode);
            accurateQueryList.add(accurateQueryDomain1);
        } else {
            SortDomain sortDomain = new SortDomain();
            sortDomain.setSortField("goodsSalesvolume");
            sortDomain.setOrder("desc");
            searchDomain.setSortDomain(sortDomain);
        }
        searchDomain.setAccurateQueryList(accurateQueryList);
        Map result = this.searchRepository.tosearch(null, null, searchDomain);
        if (result != null) {
            for (Map.Entry entry : result.entrySet()) {
                list = (List)entry.getValue();
            }
            return new HtmlJsonReBean(list);
        }
        return new HtmlJsonReBean();
    }

    @RequestMapping(value={"search"})
    public String gosearch(HttpServletRequest request, ModelMap mmap, String url) {
        mmap.addAttribute("url", (Object)url);
        return String.valueOf(this.getFtlTempPath(request)) + "search";
    }

    @RequestMapping(value={"searchlist"})
    public String searchlist(HttpServletRequest request, HttpServletResponse response, ModelMap mmap, String keyword) {
        HashMap<String, String> map = new HashMap<String, String>();
        SupQueryResult province = this.baseRepository.getProvincePage(map);
        if (province != null) {
            mmap.addAttribute("provincelist", (Object)province.getList());
        }
        map.put("pntreeStep", "2");
        map.put("tenantCode", this.getTenantCodeByURL(request, response));
        SupQueryResult rs = this.baseRepository.getPntreePage(map);
        if (rs != null) {
            mmap.addAttribute("pntreelist", (Object)rs.getList());
        }
        mmap.addAttribute("keyword", (Object)keyword);
        return String.valueOf(this.getFtlTempPath(request)) + "searchlist";
    }

    @RequestMapping(value={"searchlist.json"})
    @ResponseBody
    public HtmlJsonReBean searchlist(HttpServletRequest request, HttpServletResponse response, ModelMap mmap, String keyword, String orderStr, String orderType, String pntreeCode, String productareaName, String merberServerType, String pricesetMakepricestart, String pricesetMakepriceend) {
        AccurateQueryDomain accurateQueryDomain;
        SearchDomain searchDomain = new SearchDomain();
        searchDomain.setBizType("sku");
        HashMap<String, Object> pageMap = new HashMap<String, Object>();
        String page = StringUtils.isBlank((String)request.getParameter("page")) ? "1" : request.getParameter("page");
        pageMap.put("page", page);
        HtmlUtil.makePage(pageMap);
        pageMap.put("endRow", 10);
        searchDomain.setPageMap(pageMap);
        ArrayList<AccurateQueryDomain> accurateQueryList = new ArrayList<AccurateQueryDomain>();
        AccurateQueryDomain accurateQueryDomain1 = new AccurateQueryDomain();
        accurateQueryDomain1.setAccurateField("tenantCode");
        accurateQueryDomain1.setAccurateFieldValue(this.getTenantCodeByURL(request, response));
        accurateQueryList.add(accurateQueryDomain1);
        if (StringUtils.isNotBlank((String)pntreeCode)) {
            accurateQueryDomain = new AccurateQueryDomain();
            accurateQueryDomain.setAccurateField("pntreeCode");
            accurateQueryDomain.setAccurateFieldValue(pntreeCode);
            accurateQueryList.add(accurateQueryDomain);
        }
        if (StringUtils.isNotBlank((String)productareaName)) {
            accurateQueryDomain = new AccurateQueryDomain();
            accurateQueryDomain.setAccurateField("productareaName");
            accurateQueryDomain.setAccurateFieldValue(productareaName);
            accurateQueryList.add(accurateQueryDomain);
        }
        if (StringUtils.isNotBlank((String)merberServerType)) {
            accurateQueryDomain = new AccurateQueryDomain();
            accurateQueryDomain.setAccurateField("merberServerType");
            accurateQueryDomain.setAccurateFieldValue(merberServerType);
            accurateQueryList.add(accurateQueryDomain);
        }
        if (accurateQueryList.size() > 0) {
            searchDomain.setAccurateQueryList(accurateQueryList);
        }
        if (StringUtils.isNotBlank((String)pricesetMakepricestart) || StringUtils.isNotBlank((String)pricesetMakepriceend)) {
            ArrayList<RangeDomain> rangeList = new ArrayList<RangeDomain>();
            RangeDomain rangeDomain = new RangeDomain();
            rangeDomain.setRangeField("pricesetMakeprice");
            rangeDomain.setStartIndex(pricesetMakepricestart);
            rangeDomain.setEndIndex(pricesetMakepriceend);
            rangeList.add(rangeDomain);
            searchDomain.setRangeList(rangeList);
        }
        if (StringUtils.isNotBlank((String)orderStr) && StringUtils.isNotBlank((String)orderType)) {
            SortDomain sortDomain = new SortDomain();
            sortDomain.setSortField(orderStr);
            sortDomain.setOrder(orderType);
            searchDomain.setSortDomain(sortDomain);
        }
        Map result = this.searchRepository.tosearch(keyword, "0", searchDomain);
        List list = null;
        if (result != null) {
            for (Map.Entry entry : result.entrySet()) {
                list = (List)entry.getValue();
            }
            return new HtmlJsonReBean(list);
        }
        return new HtmlJsonReBean();
    }
}

