/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.goods.controller;

import com.yqbsoft.laser.html.annotation.Layout;
import com.yqbsoft.laser.html.common.util.ResourceUtil;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.bean.BsBrand;
import com.yqbsoft.laser.html.facade.bm.bean.BsPntree;
import com.yqbsoft.laser.html.facade.bm.bean.CmsAdvertise;
import com.yqbsoft.laser.html.facade.bm.repository.BaseRepository;
import com.yqbsoft.laser.html.facade.bm.repository.CmsRepository;
import com.yqbsoft.laser.html.facade.esclient.repository.SearchRepository;
import com.yqbsoft.laser.html.facade.exchange.bean.OcContract;
import com.yqbsoft.laser.html.facade.exchange.bean.Properties;
import com.yqbsoft.laser.html.facade.exchange.bean.RsResourceGoodsDomain;
import com.yqbsoft.laser.html.facade.exchange.bean.RsResourceGoodsReDomain;
import com.yqbsoft.laser.html.facade.exchange.constant.GoodsProEnum;
import com.yqbsoft.laser.html.facade.exchange.constant.GoodsTypeEnum;
import com.yqbsoft.laser.html.facade.exchange.domian.RsPropertiesDomain;
import com.yqbsoft.laser.html.facade.exchange.domian.RsPropertiesOptionDomain;
import com.yqbsoft.laser.html.facade.exchange.domian.RsPropertiesValueDomain;
import com.yqbsoft.laser.html.facade.exchange.domian.RsSkuDomain;
import com.yqbsoft.laser.html.facade.exchange.domian.RsSkuReDomain;
import com.yqbsoft.laser.html.facade.exchange.domian.RsSpecDomain;
import com.yqbsoft.laser.html.facade.exchange.domian.RsSpecValueDomain;
import com.yqbsoft.laser.html.facade.exchange.domian.RsSpuDomain;
import com.yqbsoft.laser.html.facade.exchange.repository.ContractRepository;
import com.yqbsoft.laser.html.facade.exchange.repository.PropertiesRepository;
import com.yqbsoft.laser.html.facade.exchange.repository.ResourceRepository;
import com.yqbsoft.laser.html.facade.exchange.repository.SkuRepository;
import com.yqbsoft.laser.html.facade.exchange.repository.SpecRepository;
import com.yqbsoft.laser.html.facade.exchange.repository.SpuRepository;
import com.yqbsoft.laser.html.facade.fm.domian.FileDomain;
import com.yqbsoft.laser.html.facade.fm.repository.FileRepository;
import com.yqbsoft.laser.html.facade.mm.bean.MmMberextend;
import com.yqbsoft.laser.html.facade.mm.bean.MmMerber;
import com.yqbsoft.laser.html.facade.mm.repository.MmUserRepository;
import com.yqbsoft.laser.html.goods.bean.RsResourceGoods;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.html.springmvc.authlogin.RequestUtil;
import com.yqbsoft.laser.service.suppercore.SupperSysException;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.es.AccurateQueryDomain;
import com.yqbsoft.laser.service.suppercore.es.HighLightFieldDomain;
import com.yqbsoft.laser.service.suppercore.es.SearchDomain;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jsoup.helper.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/web/rs/resource"})
@Layout(frameName="application")
public class ResourceCon
extends SpringmvcController {
    @Autowired
    FileRepository fileRepository;
    @Autowired
    ResourceRepository repository;
    @Autowired
    private CmsRepository cmsRepository;
    @Autowired
    private SearchRepository searchRepository;
    @Autowired
    private ContractRepository contractRepository;
    @Autowired
    private BaseRepository baseRepository;
    @Autowired
    private MmUserRepository userRepository;
    @Autowired
    private SpuRepository spuRepository;
    @Autowired
    private SpecRepository specRepository;
    @Autowired
    private PropertiesRepository propertiesRepository;
    @Autowired
    private SkuRepository skuRepository;
    @Autowired
    private ResourceRepository resourceRepository;
    private String place_list_one = "de000001";
    private String place_list_two = "de000002";
    private String place_info_one = "de000003";
    private String place_info_two = "de000004";
    private String place_detil_one = "hotdetil001";

    @Autowired
    protected String getContext() {
        return "resource";
    }

    @RequestMapping(value={"index"})
    @Layout(frameName="indexapplication")
    public String goodsList(HttpServletRequest request, String searchParam, ModelMap map, String pntreeCode, String divParam) {
        String tenantCode = ResourceUtil.getOut((String)"laser", (String)"", (String)"tenantCode");
        try {
            if (StringUtils.isNotBlank((String)divParam)) {
                divParam = URLDecoder.decode(divParam, "UTF-8");
            }
            if (StringUtils.isNotBlank((String)searchParam)) {
                searchParam = URLDecoder.decode(searchParam, "UTF-8");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        param.put("dataState", 2);
        param.put("order", true);
        param.put("orderStr", " case when sort_no is null then 1 else 0 end asc ,SORT_NO,SKU_HDATE desc");
        param.put("tenantCode", tenantCode);
        ArrayList<String> saleChannelList = new ArrayList<String>();
        saleChannelList.add("0");
        saleChannelList.add("1");
        param.put("saleChannelList", saleChannelList);
        SupQueryResult queryResult = this.skuRepository.querySkuPage(param);
        List list = queryResult.getList();
        map.addAttribute("skuList", (Object)list);
        if (list != null && !list.isEmpty()) {
            ArrayList<String> goodsCodeList = new ArrayList<String>();
            for (RsSkuReDomain rsSkuReDomain : list) {
                String goodsCode = rsSkuReDomain.getGoodsCode();
                goodsCodeList.add(goodsCode);
            }
            HashMap<String, String> picMap = new HashMap<String, String>();
            List goodsList = this.resourceRepository.queryResourceGoodsByCodes(goodsCodeList, tenantCode);
            if (goodsList != null && !goodsList.isEmpty()) {
                for (RsResourceGoodsReDomain rsResourceGoodsReDomain : goodsList) {
                    picMap.put(rsResourceGoodsReDomain.getGoodsCode(), rsResourceGoodsReDomain.getDataPicpath());
                }
                for (RsSkuReDomain rsSkuReDomain : list) {
                    rsSkuReDomain.setDataPicPath((String)picMap.get(rsSkuReDomain.getGoodsCode()));
                }
            }
        }
        map.addAttribute("pageTools", (Object)this.buildPage(queryResult.getPageTools(), request));
        List pntreelist = this.baseRepository.getClassify(null, "");
        map.addAttribute("pntreelist", (Object)pntreelist);
        if (divParam != null && !divParam.equals("")) {
            map.addAttribute("divList", (Object)divParam);
        }
        map.addAttribute("pntreeCode", (Object)pntreeCode);
        return String.valueOf(this.getFtlTempPath(request)) + "index";
    }

    @RequestMapping(value={"goodsdetil"})
    @Layout(frameName="indexapplication")
    public String detil(HttpServletRequest request, ModelMap mmap, String goodsCode, String skuCode, String spuCode) {
        String tenantCode = ResourceUtil.getOut((String)"laser", (String)"", (String)"tenantCode");
        RsSkuReDomain rsSkuReDomain = this.skuRepository.getSkuByCode(tenantCode, skuCode);
        RsResourceGoodsReDomain rs = this.resourceRepository.getResourceGoodsByCode(tenantCode, rsSkuReDomain.getGoodsCode());
        HashMap<String, String> spuMap = new HashMap<String, String>();
        spuMap.put("tenantCode", rsSkuReDomain.getTenantCode());
        spuMap.put("spuCode", rsSkuReDomain.getSpuCode());
        RsSpuDomain rsSpuDomain = this.spuRepository.getSpuByCode(spuMap);
        BsBrand bsBrand = null;
        if (rsSpuDomain != null) {
            bsBrand = this.baseRepository.getBrandByCode(rsSpuDomain.getBrandCode(), tenantCode);
        }
        goodsCode = rsSkuReDomain.getGoodsCode();
        mmap.addAttribute("rs", (Object)rs);
        mmap.addAttribute("sku", (Object)rsSkuReDomain);
        mmap.addAttribute("goodsCode", (Object)goodsCode);
        mmap.addAttribute("spuCode", (Object)spuCode);
        mmap.addAttribute("skuCode", (Object)skuCode);
        mmap.addAttribute("bsBrand", (Object)bsBrand);
        Map<String, String> skusMap = this.initProperties(mmap, tenantCode, goodsCode);
        HashMap<String, String> skuMap = new HashMap<String, String>();
        if (skusMap != null && StringUtils.isNotBlank((String)skusMap.get(skuCode))) {
            String skuProperties = skusMap.get(skuCode);
            int i = 0;
            while (i < skuProperties.split(",").length) {
                skuMap.put(skuProperties.split(",")[i].split(":")[0], skuProperties.split(",")[i].split(":")[1]);
                ++i;
            }
            mmap.addAttribute("skuMap", skuMap);
        }
        String code = StringUtils.isBlank((String)rs.getGoodsCodeOld()) ? rs.getGoodsCode() : rs.getGoodsCodeOld();
        mmap.addAttribute("fileList", (Object)this.fileRepository.queryFile("file_03", rs.getTenantCode(), code));
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        SupQueryResult oc = this.contractRepository.queryContractByGoodsCode(goodsCode, param);
        if (oc != null) {
            for (OcContract c : oc.getList()) {
                ArrayList<OcContract> list = new ArrayList<OcContract>();
                if (c.getDataState() != 0 && c.getDataState() != 9) {
                    list.add(c);
                    String name = c.getGoodsReceiptMem();
                    c.setGoodsReceiptMem(name.replace(name.substring(1, name.length()), this.getStringLength(name.length() - 1)));
                }
                mmap.addAttribute("oclist", list);
            }
        }
        mmap.put((Object)this.place_detil_one, this.getAdvertise(this.place_detil_one));
        return String.valueOf(this.getFtlTempPath(request)) + "goodsdetil";
    }

    private Map<String, String> initProperties(ModelMap mmap, String tenantCode, String goodsCode) {
        if (StringUtil.isBlank((String)tenantCode) || StringUtil.isBlank((String)goodsCode)) {
            return null;
        }
        String skusStr = SupDisUtil.get((String)(String.valueOf(tenantCode) + "-" + goodsCode + "-skusStr"));
        String prosStr = SupDisUtil.get((String)(String.valueOf(tenantCode) + "-" + goodsCode + "-prosStr"));
        HashMap<String, String> skusMap = null;
        HashMap<String, RsPropertiesDomain> prosMap = null;
        if (!StringUtil.isBlank((String)skusStr) && !StringUtil.isBlank((String)prosStr)) {
            skusMap = (HashMap<String, String>)JsonUtil.buildNormalBinder().getJsonToMap(skusStr, String.class, String.class);
            prosMap = (HashMap<String, RsPropertiesDomain>)JsonUtil.buildNormalBinder().getJsonToMap(prosStr, String.class, RsPropertiesDomain.class);
        } else {
            List list = this.propertiesRepository.queryPropertiesByGoods(tenantCode, goodsCode);
            if (list == null || list.isEmpty()) {
                return null;
            }
            skusMap = new HashMap<String, String>();
            prosMap = new HashMap<String, RsPropertiesDomain>();
            HashMap<String, String> proMap = new HashMap<String, String>();
            for (Map map : list) {
                ArrayList<RsPropertiesOptionDomain> propertiesOptionList;
                RsPropertiesDomain rsPropertiesDomain;
                String skuCode = (String)map.get("skuCode");
                String propertiesCode = (String)map.get("propertiesCode");
                String propertiesValueValue = (String)map.get("propertiesValueValue");
                String propertiesName = (String)map.get("propertiesName");
                if (StringUtil.isBlank((String)((String)skusMap.get(skuCode)))) {
                    skusMap.put(skuCode, String.valueOf(propertiesCode) + ":" + propertiesValueValue);
                } else {
                    skusMap.put(skuCode, String.valueOf((String)skusMap.get(skuCode)) + "," + propertiesCode + ":" + propertiesValueValue);
                }
                if (prosMap.get(propertiesCode) == null) {
                    rsPropertiesDomain = new RsPropertiesDomain();
                    rsPropertiesDomain.setPropertiesCode(propertiesCode);
                    rsPropertiesDomain.setPropertiesName(propertiesName);
                    propertiesOptionList = new ArrayList<RsPropertiesOptionDomain>();
                } else {
                    rsPropertiesDomain = (RsPropertiesDomain)prosMap.get(propertiesCode);
                    propertiesOptionList = rsPropertiesDomain.getPropertiesOptionList();
                }
                if (StringUtil.isBlank((String)((String)proMap.get(String.valueOf(propertiesCode) + "-" + propertiesValueValue)))) {
                    RsPropertiesOptionDomain propertiesOptionDomain = new RsPropertiesOptionDomain();
                    propertiesOptionDomain.setPropertiesCode(propertiesCode);
                    propertiesOptionDomain.setPropertiesOptionName(propertiesValueValue);
                    propertiesOptionList.add(propertiesOptionDomain);
                    proMap.put(String.valueOf(propertiesCode) + "-" + propertiesValueValue, String.valueOf(propertiesCode) + "-" + propertiesValueValue);
                }
                rsPropertiesDomain.setPropertiesOptionList(propertiesOptionList);
                prosMap.put(propertiesCode, rsPropertiesDomain);
            }
            skusStr = JsonUtil.buildNormalBinder().toJson(skusMap);
            prosStr = JsonUtil.buildNormalBinder().toJson(prosMap);
        }
        mmap.addAttribute("prosMap", prosMap);
        SupDisUtil.set((String)(String.valueOf(tenantCode) + "-" + goodsCode + "-skusStr"), (String)skusStr, (int)600);
        SupDisUtil.set((String)(String.valueOf(tenantCode) + "-" + goodsCode + "-prosStr"), (String)prosStr, (int)600);
        return skusMap;
    }

    private String getStringLength(int length) {
        StringBuffer sb = new StringBuffer();
        if (length > 4) {
            length = 4;
        }
        int i = 0;
        while (i < 5) {
            sb.append("*");
            ++i;
        }
        return sb.toString();
    }

    @RequestMapping(value={"demandlist"})
    @Layout(frameName="indexapplication")
    public String demandList(HttpServletRequest request, ModelMap map, String demandStr) {
        try {
            if (StringUtils.isNotBlank((String)demandStr)) {
                demandStr = URLDecoder.decode(demandStr, "UTF-8");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        ArrayList<String> list = new ArrayList<String>();
        list.add(GoodsProEnum.gy.getCode());
        list.add(GoodsProEnum.qg.getCode());
        pmap.put("goodsPros", list);
        pmap.put("order", true);
        SupQueryResult<RsResourceGoodsReDomain> supQueryResult = this.queryResourcePage(request, pmap);
        if (demandStr != null && !demandStr.equals("")) {
            Map demandMap;
            map.addAttribute("searchParam", (Object)demandStr);
            map.addAttribute("searchtype", (Object)"\u4f9b\u6c42");
            SearchDomain searchDomain = new SearchDomain();
            searchDomain.setBizType("0");
            searchDomain.setSearchObj((Object)demandStr);
            Map pageMap = HtmlUtil.buildPage((HttpServletRequest)request);
            searchDomain.setPageMap(pageMap);
            Map result = this.searchRepository.tosearch(null, null, searchDomain);
            if (result != null && !result.isEmpty() && (demandMap = (Map)JsonUtil.buildNormalBinder().getJsonToMapByList(JsonUtil.buildNormalBinder().toJson(result.get("Demand")), String.class, RsResourceGoods.class)) != null && !demandMap.isEmpty()) {
                for (Object key : demandMap.keySet()) {
                    List demandlist = (List)demandMap.get(key);
                    map.addAttribute("resourcelist", (Object)demandlist);
                    SupPageTools page = supQueryResult.getPageTools();
                    page.setPageCount(Integer.parseInt(key.toString()));
                    page.setRecordCount(Integer.parseInt(key.toString()));
                    supQueryResult.setPageTools(page);
                    supQueryResult.setTotal(Long.parseLong(key.toString()));
                }
            }
        } else {
            map.addAttribute("resourcelist", (Object)supQueryResult.getList());
        }
        map.addAttribute("pageTools", (Object)this.buildPage(supQueryResult.getPageTools(), request));
        map.put((Object)this.place_list_one, this.getAdvertise(this.place_list_one));
        map.put((Object)this.place_list_two, this.getAdvertise(this.place_list_two));
        return String.valueOf(this.getFtlTempPath(request)) + "demandlist";
    }

    @RequestMapping(value={"demandinfo"})
    @Layout(frameName="indexapplication")
    public String demandinfo(HttpServletRequest request, ModelMap map, String goodsCode) {
        String tenantCode = ResourceUtil.getOut((String)"laser", (String)"", (String)"tenantCode");
        RsResourceGoodsReDomain goods = this.repository.getResourceGoodsByCode(tenantCode, goodsCode);
        map.addAttribute("goods", (Object)goods);
        MmMerber MmMerber2 = this.userRepository.getMerberByCode(goods.getMemberCode(), tenantCode);
        map.addAttribute("mmMerber", (Object)MmMerber2);
        MmMberextend mberextend = this.userRepository.getMberextendByCode(goods.getMemberCode(), tenantCode);
        map.addAttribute("mberextend", (Object)mberextend);
        map.put((Object)this.place_info_one, this.getAdvertise(this.place_info_one));
        map.put((Object)this.place_info_two, this.getAdvertise(this.place_info_two));
        return String.valueOf(this.getFtlTempPath(request)) + "demandinfo";
    }

    @RequestMapping(value={"getResource"})
    public String getResource(HttpServletRequest request, ModelMap map, Integer goodsId) {
        String saleChannel;
        List fileList;
        map.addAttribute("flag", (Object)request.getParameter("flag"));
        RsResourceGoodsReDomain rsResourceGoods = this.repository.getResourceGoodsById(goodsId);
        if (!this.checkGoodsIds(request, "" + goodsId)) {
            return String.valueOf(this.getFtlTempPath(request)) + "updateResource";
        }
        map.addAttribute("resourceGoods", (Object)rsResourceGoods);
        String tenantCode = this.getTenantCode(request);
        List<BsPntree> list = this.queryPntree(tenantCode);
        map.addAttribute("pntreeList", list);
        map.addAttribute("pntreeListjson", (Object)JsonUtil.buildNormalBinder().toJson(list));
        List skuList = this.skuRepository.querySkuByGoods(rsResourceGoods.getGoodsCode(), rsResourceGoods.getTenantCode(), rsResourceGoods.getDataState());
        if (!skuList.isEmpty()) {
            map.addAttribute("skuList", (Object)skuList);
            map.addAttribute("skulistJson", (Object)JsonUtil.buildNormalBinder().toJson((Object)skuList));
            RsSpuDomain spu = (RsSpuDomain)this.getSpuContainChild(request, null, null, null, ((RsSkuReDomain)skuList.get(0)).getSpuCode());
            map.addAttribute("spu", (Object)spu);
            map.addAttribute("spuJson", (Object)JsonUtil.buildNormalBinder().toJson((Object)spu));
        }
        if ((fileList = this.fileRepository.queryFile("file_03", rsResourceGoods.getTenantCode(), rsResourceGoods.getGoodsCode())) != null && !fileList.isEmpty()) {
            for (FileDomain fileDomain : fileList) {
                String key = "filePath";
                String settingType = "0";
                String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(String.valueOf(tenantCode) + "-" + settingType + "-" + key));
                String fileUrl = fileDomain.getFileUrl();
                if (StringUtils.isNotBlank((String)fileUrl)) {
                    fileDomain.setFileUrl(String.valueOf(httpPath) + System.getProperties().getProperty("file.separator") + fileUrl);
                }
                fileDomain.setFilePath(String.valueOf(fileDomain.getFileUrl()) + "/" + fileDomain.getFileCode() + "." + fileDomain.getFileCtype());
            }
            map.addAttribute("fileList", (Object)fileList);
            map.addAttribute("fileListSize", (Object)fileList.size());
        }
        if (StringUtils.isBlank((String)(saleChannel = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(String.valueOf(this.getTenantCode(request)) + "-exchange-saleChannel"))))) {
            saleChannel = "0";
        }
        map.put((Object)"saleChannel", (Object)saleChannel);
        return String.valueOf(this.getFtlTempPath(request)) + "updateResource";
    }

    @RequestMapping(value={"resourcelist"})
    public String resourcelist(HttpServletRequest request, ModelMap map) {
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("memberCode", this.getUserSession(request).getUserPcode());
        pmap.put("goodsPro", GoodsProEnum.sp.getCode());
        pmap.put("order", true);
        SupQueryResult<RsResourceGoodsReDomain> supQueryResult = this.queryResourcePage(request, pmap);
        map.addAttribute("resourcelist", (Object)supQueryResult.getList());
        map.addAttribute("pageTools", (Object)this.buildPage(supQueryResult.getPageTools(), request));
        String dataOpbillstate = request.getParameter("dataOpbillstate");
        map.addAttribute("dataOpbillstate", (Object)(StringUtils.isBlank((String)dataOpbillstate) ? "" : dataOpbillstate));
        return String.valueOf(this.getFtlTempPath(request)) + "resourcelist";
    }

    public SupQueryResult<RsResourceGoodsReDomain> queryResourcePage(HttpServletRequest request, Map<String, Object> map) {
        Map param = HtmlUtil.buildPage((HttpServletRequest)request);
        String tenantCode = RequestUtil.getTenantCodeByURL((HttpServletRequest)request, null);
        param.putAll(map);
        param.put("tenantCode", tenantCode);
        return this.repository.loadDomain(param);
    }

    @RequestMapping(value={"addResource"})
    public String addResource(HttpServletRequest request, ModelMap map) {
        List<BsPntree> list = this.queryPntree(this.getTenantCode(request));
        map.addAttribute("pntreeList", list);
        map.addAttribute("pntreeListjson", (Object)JsonUtil.buildNormalBinder().toJson(list));
        String saleChannel = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(String.valueOf(this.getTenantCode(request)) + "-exchange-saleChannel"));
        if (StringUtils.isBlank((String)saleChannel)) {
            saleChannel = "0";
        }
        map.put((Object)"saleChannel", (Object)saleChannel);
        return String.valueOf(this.getFtlTempPath(request)) + "addResource";
    }

    private List<BsPntree> queryPntree(String tenantCode) {
        List rs = this.baseRepository.getClassify(tenantCode, null);
        return rs;
    }

    @RequestMapping(value={"saveResource.json"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean saveResource(@RequestParam(value="file") MultipartFile[] file, HttpServletRequest request, RsResourceGoodsDomain rsResourceGoods) {
        try {
            UserSession userSession = this.getUserSession(request);
            String msg = this.checkResourceGoods(rsResourceGoods);
            if (StringUtils.isNotBlank((String)msg)) {
                return new HtmlJsonReBean("error", msg);
            }
            rsResourceGoods.setMemberCode(userSession.getUserPcode());
            rsResourceGoods.setMemberName(userSession.getUserName());
            if (StringUtils.isBlank((String)rsResourceGoods.getMemberCcode())) {
                rsResourceGoods.setMemberCcode(rsResourceGoods.getMemberCode());
                rsResourceGoods.setMemberCname(rsResourceGoods.getMemberName());
            }
            rsResourceGoods.setGoodsPro(GoodsProEnum.sp.getCode());
            rsResourceGoods.setGoodsType(GoodsTypeEnum.type0.getCode());
            rsResourceGoods.setGoodsOneweight(BigDecimal.ZERO);
            rsResourceGoods.setTenantCode(userSession.getTenantCode());
            rsResourceGoods.setAppmanageIcode(userSession.getAppmanageIcode());
            this.setSpecValueList(rsResourceGoods);
            List<Object> skuList = new ArrayList();
            if (StringUtils.isEmpty((String)rsResourceGoods.getPropertieList())) {
                RsSkuDomain sku = new RsSkuDomain();
                List skuValueList = (List)JsonUtil.buildNormalBinder().getJsonToList(rsResourceGoods.getSkus(), String.class);
                String[] skuValue = ((String)skuValueList.get(1)).split(",");
                sku.setSkuName(skuValue[0]);
                sku.setPricesetNprice(BigDecimal.valueOf(Double.valueOf(skuValue[1])));
                sku.setPricesetMakeprice(BigDecimal.valueOf(Double.valueOf(skuValue[2])));
                sku.setPricesetBaseprice(BigDecimal.valueOf(Double.valueOf(skuValue[3])));
                sku.setGoodsNum(BigDecimal.valueOf(Double.valueOf(skuValue[4])));
                sku.setSpuCode(rsResourceGoods.getSpuCode());
                sku.setSaleChannel(rsResourceGoods.getSaleChannel());
                rsResourceGoods.setGoodsNum(sku.getGoodsNum());
                rsResourceGoods.setPricesetNprice(sku.getPricesetMakeprice());
                rsResourceGoods.setPricesetAsprice(sku.getPricesetMakeprice());
                sku.setGoodsNo(skuValue[5]);
                sku.setSkuBarcode(skuValue[6]);
                skuList.add(sku);
            } else {
                skuList = this.generateSkuList(rsResourceGoods);
            }
            if (skuList != null) {
                rsResourceGoods.setSkuList(skuList);
            }
            rsResourceGoods.setSkuList(skuList);
            String goodsCode = this.repository.saveResourceGoodsReCode(rsResourceGoods);
            ArrayList<FileDomain> fileList = new ArrayList<FileDomain>();
            MultipartFile[] multipartFileArray = file;
            int n = file.length;
            int n2 = 0;
            while (n2 < n) {
                MultipartFile multipartFile = multipartFileArray[n2];
                if (!multipartFile.isEmpty()) {
                    if (multipartFile.getSize() > 0x200000L) {
                        return new HtmlJsonReBean("error", "\u56fe\u7247\u5927\u5c0f\u4e0d\u80fd\u5927\u4e8e2M");
                    }
                    FileDomain fileDomain = this.fileRepository.saveFile(multipartFile, this.getUserSession(request).getTenantCode(), "file_03", goodsCode);
                    fileList.add(fileDomain);
                }
                ++n2;
            }
            RsResourceGoodsReDomain rsResourceGoodsRe = this.repository.getResourceGoodsByCode(rsResourceGoods.getTenantCode(), goodsCode);
            rsResourceGoodsRe.setDataPicpath(String.valueOf(((FileDomain)fileList.get(0)).getFileUrl()) + "/" + ((FileDomain)fileList.get(0)).getFileCode() + "." + ((FileDomain)fileList.get(0)).getFileCtype());
            this.repository.updateResourceGoods((RsResourceGoodsDomain)rsResourceGoodsRe);
            return new HtmlJsonReBean((Object)"success");
        }
        catch (SupperSysException e) {
            return new HtmlJsonReBean("error", e.getErrMsg());
        }
    }

    @RequestMapping(value={"searchResource"})
    public Map<String, Object> searchResource(HttpServletRequest request, String bizType, Map<String, Object> searchmap) {
        SearchDomain searchDomain = new SearchDomain();
        searchDomain.setBizType(bizType);
        Map pageMap = HtmlUtil.buildPage((HttpServletRequest)request);
        searchDomain.setPageMap(pageMap);
        searchDomain.setSearchObj((Object)JsonUtil.buildNormalBinder().toJson(searchmap.get("AllText")));
        ArrayList<AccurateQueryDomain> accurateQueryList = new ArrayList<AccurateQueryDomain>();
        AccurateQueryDomain accurateQueryDomain = (AccurateQueryDomain)searchmap.get("AccurateText");
        if (accurateQueryDomain != null && !accurateQueryDomain.equals("")) {
            accurateQueryList.add((AccurateQueryDomain)searchmap.get("AccurateText"));
            searchDomain.setAccurateQueryList(accurateQueryList);
        }
        ArrayList<HighLightFieldDomain> highLightFieldList = new ArrayList<HighLightFieldDomain>();
        HighLightFieldDomain highLightFieldDomain = new HighLightFieldDomain();
        highLightFieldDomain.setHighLightField("goodsName");
        highLightFieldList.add(highLightFieldDomain);
        searchDomain.setHighLightFieldList(highLightFieldList);
        return this.searchRepository.tosearch(null, null, searchDomain);
    }

    @RequestMapping(value={"deleteResource.json"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean deleteResource(HttpServletRequest request, String goodsIds) {
        try {
            List resourceList = this.repository.queryResourceGoodsByIds(goodsIds);
            ArrayList<Integer> idList = new ArrayList<Integer>();
            if (resourceList != null && !resourceList.isEmpty()) {
                String tenantCode = this.getTenantCode(request);
                String userPcode = this.getUserSession(request).getUserPcode();
                for (RsResourceGoodsReDomain rsResourceGoodsReDomain : resourceList) {
                    if (!userPcode.equals(rsResourceGoodsReDomain.getMemberCode()) || !tenantCode.equals(rsResourceGoodsReDomain.getTenantCode())) {
                        return new HtmlJsonReBean("error", "\u6570\u636e\u5f02\u5e38");
                    }
                    idList.add(rsResourceGoodsReDomain.getGoodsId());
                }
            }
            return this.repository.deleteResourceGoods(idList);
        }
        catch (SupperSysException e) {
            return new HtmlJsonReBean("error", e.getErrMsg());
        }
    }

    @RequestMapping(value={"commitResource.json"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean commitResource(HttpServletRequest request, String goodsIds) {
        try {
            if (!this.checkGoodsIds(request, goodsIds)) {
                return new HtmlJsonReBean("error", "\u6570\u636e\u5f02\u5e38!");
            }
            List resourceGoodsList = this.repository.queryResourceGoodsByIds(goodsIds);
            if (resourceGoodsList == null || resourceGoodsList.isEmpty()) {
                return new HtmlJsonReBean("error", "\u8d44\u6e90\u4e0d\u5b58\u5728!");
            }
            for (RsResourceGoodsReDomain rsResourceGoods : resourceGoodsList) {
                if (rsResourceGoods.getDataState() != 0) {
                    return new HtmlJsonReBean("error", "\u8d44\u6e90\u72b6\u6001\u4e0d\u6b63\u786e!");
                }
                BigDecimal goodsHangnum = rsResourceGoods.getGoodsHangnum();
                BigDecimal goodsHangweight = rsResourceGoods.getGoodsHangweight();
                BigDecimal goodsNum = rsResourceGoods.getGoodsNum();
                BigDecimal goodsWeight = rsResourceGoods.getGoodsWeight();
                goodsWeight = goodsWeight == null ? BigDecimal.ZERO : goodsWeight;
                goodsHangnum = goodsHangnum == null ? BigDecimal.ZERO : goodsHangnum;
                goodsHangweight = goodsHangweight == null ? BigDecimal.ZERO : goodsHangweight;
                rsResourceGoods.setGoodsAhnum(goodsNum);
                rsResourceGoods.setGoodsAhweight(goodsWeight);
                rsResourceGoods.setGoodsNum(goodsNum.subtract(goodsNum));
                rsResourceGoods.setGoodsWeight(goodsWeight.subtract(goodsWeight));
            }
            ArrayList<Integer> idList = new ArrayList<Integer>();
            int i = 0;
            while (i < goodsIds.split(",").length) {
                idList.add(Integer.parseInt(goodsIds.split(",")[i]));
                ++i;
            }
            UserSession userSession = this.getUserSession(request);
            return this.repository.updateAhResourceList(resourceGoodsList, idList, userSession);
        }
        catch (SupperSysException e) {
            return new HtmlJsonReBean("error", e.getErrMsg());
        }
    }

    @RequestMapping(value={"cancelResource.json"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean cancelResource(HttpServletRequest request, String goodsIds) {
        try {
            if (!this.checkGoodsIds(request, goodsIds)) {
                return new HtmlJsonReBean("error", "\u6570\u636e\u5f02\u5e38");
            }
            ArrayList<Integer> idList = new ArrayList<Integer>();
            int i = 0;
            while (i < goodsIds.split(",").length) {
                idList.add(Integer.parseInt(goodsIds.split(",")[i]));
                ++i;
            }
            return this.repository.cancelResource(idList);
        }
        catch (SupperSysException e) {
            return new HtmlJsonReBean("error", e.getErrMsg());
        }
    }

    private String checkResourceGoods(RsResourceGoodsDomain rsResourceGoodsDomain) {
        if (rsResourceGoodsDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)rsResourceGoodsDomain.getGoodsName())) {
            msg = String.valueOf(msg) + "\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a!";
        }
        return msg;
    }

    private List<CmsAdvertise> getAdvertise(String advertisePlaceNow) {
        SupQueryResult advertise = this.cmsRepository.queryAdvertisePage(advertisePlaceNow);
        if (advertise != null) {
            return advertise.getList();
        }
        return null;
    }

    public HtmlJsonReBean saveReview(HttpServletRequest request, RsResourceGoodsDomain resourceGoodsDomain) {
        UserSession userSession = this.getUserSession(request);
        resourceGoodsDomain.setDataOpbillstate(Integer.valueOf(0));
        resourceGoodsDomain.setGoodsHdate(new Date());
        resourceGoodsDomain.setGoodsOneweight(BigDecimal.ZERO);
        resourceGoodsDomain.setTenantCode(userSession.getTenantCode());
        resourceGoodsDomain.setAppmanageIcode(userSession.getAppmanageIcode());
        if (resourceGoodsDomain.getGoodsType().equals("1")) {
            resourceGoodsDomain.setDataOpbillstate(Integer.valueOf(2));
        }
        resourceGoodsDomain.setMemberCode("system");
        return this.repository.saveResourceGoods(resourceGoodsDomain);
    }

    private boolean checkGoodsIds(HttpServletRequest request, String goodsIds) {
        List resourceGoodsList = this.repository.queryResourceGoodsByIds(goodsIds);
        if (resourceGoodsList == null || resourceGoodsList.isEmpty()) {
            return false;
        }
        String tenantCode = this.getTenantCode(request);
        for (RsResourceGoodsReDomain rsResourceGoods : resourceGoodsList) {
            if (tenantCode.equals(rsResourceGoods.getTenantCode())) continue;
            return false;
        }
        return true;
    }

    @RequestMapping(value={"getSpuContainChild.json"}, produces={"application/json"})
    @ResponseBody
    public Object getSpuContainChild(HttpServletRequest request, String pntreeCode, String brandCode, String type, String spuCode) {
        try {
            RsSpuDomain spu = null;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("tenantCode", this.getTenantCode(request));
            if (StringUtils.isNotBlank((String)pntreeCode) && StringUtils.isNotBlank((String)brandCode)) {
                map.put("pntreeCode", pntreeCode);
                map.put("brandCode", brandCode);
                map.put("tenantCode", this.getTenantCode(request));
                spu = this.spuRepository.getSpuContainChild(map);
            } else if (StringUtils.isNotBlank((String)spuCode)) {
                map.put("spuCode", spuCode);
                spu = this.spuRepository.getSpuContainChild(map);
            }
            if (spu != null) {
                HashMap<String, String> pmap = new HashMap<String, String>();
                pmap.put("spuCode", spu.getSpuCode());
                pmap.put("tenantCode", this.getTenantCode(request));
                List rsSpecValueDomainList = this.specRepository.querySpecValuePage(pmap).getList();
                if (rsSpecValueDomainList != null && spu.getSpecList() != null) {
                    for (RsSpecDomain spec : spu.getSpecList()) {
                        for (RsSpecValueDomain rsSpecValue : rsSpecValueDomainList) {
                            if (!spec.getSpecCode().equals(rsSpecValue.getSpecCode())) continue;
                            spec.setSpecValue(rsSpecValue.getSpecValueValue());
                        }
                    }
                }
                return spu;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "{}";
    }

    @RequestMapping(value={"getBrandByPntree.json"}, produces={"application/json"})
    @ResponseBody
    public Object getBrandByPntree(HttpServletRequest request, String pntreeCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pntreeCode", pntreeCode);
        map.put("tenantCode", this.getTenantCode(request));
        List brandList = this.baseRepository.getBrandByPntree(map);
        return brandList;
    }

    @RequestMapping(value={"getPropertiesByPntree.json"}, produces={"application/json"})
    @ResponseBody
    public Object getProperties(HttpServletRequest request, String pntreeCode, String goodsCode) {
        block7: {
            if (!StringUtil.isBlank((String)pntreeCode)) break block7;
            return "{}";
        }
        try {
            List propertiesValueList;
            String tenantCode = this.getTenantCode(request);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pntreeCode", pntreeCode);
            map.put("tenantCode", tenantCode);
            List propertiesList = this.propertiesRepository.queryPropertiesByPntree(map);
            if (StringUtils.isNotBlank((String)goodsCode) && (propertiesValueList = this.propertiesRepository.queryPropertiesValueByGoods(goodsCode, tenantCode)) != null && !propertiesValueList.isEmpty() && !propertiesList.isEmpty() && propertiesList != null) {
                for (RsPropertiesDomain rsProperties : propertiesList) {
                    List propertiesOptionList = rsProperties.getPropertiesOptionList();
                    if (propertiesOptionList == null) continue;
                    for (RsPropertiesOptionDomain rsPropertiesOptionDomain : propertiesOptionList) {
                        for (String value : propertiesValueList) {
                            if (!rsPropertiesOptionDomain.getPropertiesOptionName().equals(value)) continue;
                            rsPropertiesOptionDomain.setClick(true);
                        }
                    }
                }
            }
            return propertiesList;
        }
        catch (Exception exception) {
            return "{}";
        }
    }

    @RequestMapping(value={"generateProperties.json"}, produces={"application/json"})
    @ResponseBody
    public Object generateProperties(HttpServletRequest request, String propertieList) {
        List list = (List)JsonUtil.buildNormalBinder().getJsonToList(propertieList, Properties.class);
        if (list == null || list.isEmpty()) {
            return "{}";
        }
        ArrayList<String[]> skuList = new ArrayList<String[]>();
        List<String> reList = this.generateSku(list, 0);
        for (String re : reList) {
            String[] values = re.split(",");
            skuList.add(values);
        }
        return skuList;
    }

    @RequestMapping(value={"querySkuList.json"}, produces={"application/json"})
    @ResponseBody
    public Object querySkuList(HttpServletRequest request, String goodsCode) {
        RsResourceGoodsReDomain goodsReDomain = this.repository.getResourceGoodsByCode(this.getTenantCode(request), goodsCode);
        List skuList = this.skuRepository.querySkuByGoods(goodsCode, this.getTenantCode(request), goodsReDomain.getDataState());
        if (!skuList.isEmpty()) {
            for (RsSkuReDomain rsSkuReDomain : skuList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("skuCode", rsSkuReDomain.getSkuCode());
                map.put("tenantCode", rsSkuReDomain.getTenantCode());
                List propertiesValueList = this.propertiesRepository.queryPropertiesValuePage(map).getList();
                if (propertiesValueList.isEmpty()) continue;
                ArrayList<String> value = new ArrayList<String>();
                for (RsPropertiesValueDomain rsPropertiesValueDomain : propertiesValueList) {
                    value.add(rsPropertiesValueDomain.getPropertiesValueValue());
                }
                rsSkuReDomain.setSkuProperties(value);
            }
            return skuList;
        }
        return null;
    }

    @RequestMapping(value={"delSku.json"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean delSku(HttpServletRequest request, String skuCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("skuCode", skuCode);
        map.put("tenantCode", this.getTenantCode(request));
        RsSkuDomain sku = this.skuRepository.getSku(map);
        return this.skuRepository.deleteSku(sku.getSkuId());
    }

    private List<String> generateSku(List<Properties> list, int i) {
        String res = "";
        ArrayList<String> relist = new ArrayList<String>();
        List value = list.get(i).getPropertiesvalue();
        int j = 0;
        while (j < value.size()) {
            this.generateSku(list, i + 1, String.valueOf(res) + (String)value.get(j) + ",", relist);
            ++j;
        }
        return relist;
    }

    private void generateSku(List<Properties> list, int i, String res, List<String> reList) {
        if (i == list.size()) {
            reList.add(res);
        } else {
            List value = list.get(i).getPropertiesvalue();
            int j = 0;
            while (j < value.size()) {
                if (i == list.size() - 1) {
                    reList.add(String.valueOf(res) + (String)value.get(j));
                } else {
                    this.generateSku(list, i + 1, String.valueOf(res) + (String)value.get(j) + ",", reList);
                }
                ++j;
            }
        }
    }

    @RequestMapping(value={"updateResource.json"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean updateResource(@RequestParam(value="file") MultipartFile[] file, HttpServletRequest request, RsResourceGoodsDomain rsResourceGoods) {
        try {
            rsResourceGoods.setTenantCode(this.getTenantCode(request));
            String msg = this.checkResourceGoods(rsResourceGoods);
            if (StringUtils.isNotBlank((String)msg)) {
                return new HtmlJsonReBean("error", msg);
            }
            FileDomain fileDomain = null;
            String[] imgId = rsResourceGoods.getImgId();
            String[] imgData = rsResourceGoods.getImgData();
            ArrayList<FileDomain> fileList = new ArrayList<FileDomain>();
            int i = 0;
            while (i < file.length) {
                if (!file[i].isEmpty()) {
                    if (file[i].getSize() > 0x200000L) {
                        return new HtmlJsonReBean("error", "\u56fe\u7247\u5927\u5c0f\u4e0d\u80fd\u5927\u4e8e2M");
                    }
                    fileDomain = this.fileRepository.saveFile(file[i], this.getUserSession(request).getTenantCode(), "file_03", rsResourceGoods.getGoodsCode());
                    fileList.add(fileDomain);
                }
                if (!imgId[i].isEmpty() && imgData[i].equals("1")) {
                    FileDomain fileDomainRe = this.fileRepository.getFileById(Integer.valueOf(Integer.parseInt(imgId[i])));
                    fileDomain.setGmtCreate(fileDomainRe.getGmtCreate());
                    this.fileRepository.updateFileByCode(fileDomain);
                    this.fileRepository.deleteFile(fileDomainRe.getFileId());
                }
                if (!imgId[i].isEmpty() && imgData[i].equals("2")) {
                    this.fileRepository.deleteFile(Integer.valueOf(Integer.parseInt(imgId[i])));
                }
                ++i;
            }
            if (fileList != null && !fileList.isEmpty()) {
                if (!file[0].isEmpty()) {
                    rsResourceGoods.setDataPicpath(String.valueOf(((FileDomain)fileList.get(0)).getFileUrl()) + "/" + ((FileDomain)fileList.get(0)).getFileCode() + "." + ((FileDomain)fileList.get(0)).getFileCtype());
                }
                if (file[0].isEmpty() && imgData[0].equals("2")) {
                    List list = this.fileRepository.queryFile("file_03", rsResourceGoods.getTenantCode(), rsResourceGoods.getGoodsCode());
                    String key = "filePath";
                    String settingType = "0";
                    String httpPath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(String.valueOf(rsResourceGoods.getGoodsCode()) + "-" + settingType + "-" + key));
                    String fileUrl = ((FileDomain)list.get(0)).getFileUrl();
                    if (StringUtils.isNotBlank((String)fileUrl)) {
                        fileUrl = String.valueOf(httpPath) + System.getProperties().getProperty("file.separator") + fileUrl;
                    }
                    rsResourceGoods.setDataPicpath(String.valueOf(fileUrl) + "/" + ((FileDomain)list.get(0)).getFileCode() + "." + ((FileDomain)list.get(0)).getFileCtype());
                }
            }
            if (StringUtils.isNotBlank((String)msg)) {
                return new HtmlJsonReBean("error", msg);
            }
            this.setSpecValueList(rsResourceGoods);
            if (rsResourceGoods.getDeleteSkus() != null) {
                String[] skuCodes;
                String[] stringArray = skuCodes = rsResourceGoods.getDeleteSkus().trim().split(",");
                int n = skuCodes.length;
                int n2 = 0;
                while (n2 < n) {
                    RsSkuReDomain sku;
                    String skuCode = stringArray[n2];
                    if (StringUtils.isNotBlank((String)skuCode) && (sku = this.skuRepository.getSkuByCode(this.getTenantCode(request), skuCode)) != null) {
                        this.skuRepository.updateSkuState(sku.getSkuId(), Integer.valueOf(-1), Integer.valueOf(0));
                    }
                    ++n2;
                }
            }
            List<Object> skulist = new ArrayList();
            if (StringUtils.isNotBlank((String)rsResourceGoods.getNewData())) {
                this.skuRepository.updateSkuStateByGoods(rsResourceGoods.getGoodsCode(), rsResourceGoods.getTenantCode());
                this.propertiesRepository.deletePropertiesValueByGoods(rsResourceGoods.getGoodsCode(), rsResourceGoods.getTenantCode());
                skulist = this.generateSkuList(rsResourceGoods);
            } else {
                skulist = this.updateSkuList(rsResourceGoods);
            }
            rsResourceGoods.setSkuList(skulist);
            return this.repository.updateResourceGoods(rsResourceGoods);
        }
        catch (SupperSysException e) {
            return new HtmlJsonReBean("error", e.getErrMsg());
        }
    }

    private List<RsSkuDomain> generateSkuList(RsResourceGoodsDomain rsResourceGoods) {
        if (rsResourceGoods == null) {
            return null;
        }
        String skus = rsResourceGoods.getSkus();
        String skuPropertie = rsResourceGoods.getSkuPropertie();
        String propertieList = rsResourceGoods.getPropertieList();
        String spuCode = rsResourceGoods.getSpuCode();
        String tenantCode = rsResourceGoods.getTenantCode();
        String saleChannel = rsResourceGoods.getSaleChannel();
        BigDecimal goodsNum = BigDecimal.ZERO;
        BigDecimal pricesetNprice = BigDecimal.ZERO;
        BigDecimal pricesetAsprice = BigDecimal.ZERO;
        if (StringUtils.isNotBlank((String)skus) && StringUtils.isNotBlank((String)propertieList) && StringUtils.isNotBlank((String)skuPropertie)) {
            List propertiesList = (List)JsonUtil.buildNormalBinder().getJsonToList(propertieList, Properties.class);
            List skuList = (List)JsonUtil.buildNormalBinder().getJsonToList(skus, String.class);
            List skuProperties = (List)JsonUtil.buildNormalBinder().getJsonToList(skuPropertie, String.class);
            ArrayList<RsSkuDomain> skuDomainList = new ArrayList<RsSkuDomain>();
            int i = 1;
            while (i < skuList.size()) {
                if (StringUtils.isNotBlank((String)((String)skuList.get(i)))) {
                    RsSkuDomain skuDomain = new RsSkuDomain();
                    String[] sku = ((String)skuList.get(i)).split(",");
                    skuDomain.setSkuName(sku[0]);
                    skuDomain.setPricesetNprice(BigDecimal.valueOf(Double.valueOf(sku[1])));
                    skuDomain.setPricesetMakeprice(BigDecimal.valueOf(Double.valueOf(sku[2])));
                    skuDomain.setPricesetBaseprice(BigDecimal.valueOf(Double.valueOf(sku[3])));
                    skuDomain.setGoodsNum(BigDecimal.valueOf(Double.valueOf(sku[4])));
                    skuDomain.setSpuCode(spuCode);
                    skuDomain.setSaleChannel(saleChannel);
                    if (skuDomain.getPricesetMakeprice().compareTo(pricesetNprice) == 1) {
                        pricesetNprice = skuDomain.getPricesetMakeprice();
                        rsResourceGoods.setPricesetNprice(pricesetNprice);
                    }
                    if (pricesetAsprice.compareTo(BigDecimal.ZERO) == 0 || skuDomain.getPricesetMakeprice().compareTo(pricesetAsprice) == -1 && pricesetAsprice.compareTo(BigDecimal.ZERO) != 0) {
                        pricesetAsprice = skuDomain.getPricesetMakeprice();
                        rsResourceGoods.setPricesetAsprice(pricesetAsprice);
                    }
                    goodsNum = goodsNum.add(skuDomain.getGoodsNum());
                    skuDomain.setGoodsNo(sku[5]);
                    skuDomain.setSkuBarcode(sku[6]);
                    ArrayList<RsPropertiesValueDomain> propertiesValues = new ArrayList<RsPropertiesValueDomain>();
                    String[] propertie = ((String)skuProperties.get(i)).split(",");
                    int k = 0;
                    while (k < propertie.length) {
                        RsPropertiesValueDomain propertiesValueDomain = new RsPropertiesValueDomain();
                        propertiesValueDomain.setPropertiesCode(((Properties)propertiesList.get(k)).getPropertiesCode());
                        propertiesValueDomain.setPropertiesValueValue(propertie[k]);
                        propertiesValueDomain.setPropertiesValueType("0");
                        propertiesValueDomain.setTenantCode(tenantCode);
                        propertiesValues.add(propertiesValueDomain);
                        ++k;
                    }
                    skuDomain.setPropertiesList(propertiesValues);
                    skuDomainList.add(skuDomain);
                }
                ++i;
            }
            rsResourceGoods.setGoodsNum(goodsNum);
            return skuDomainList;
        }
        return null;
    }

    private List<RsSkuDomain> updateSkuList(RsResourceGoodsDomain rsResourceGoods) {
        if (rsResourceGoods == null) {
            return null;
        }
        String skus = rsResourceGoods.getSkus();
        String tenantCode = rsResourceGoods.getTenantCode();
        String saleChannel = rsResourceGoods.getSaleChannel();
        BigDecimal goodsNum = BigDecimal.ZERO;
        BigDecimal pricesetNprice = BigDecimal.ZERO;
        BigDecimal pricesetAsprice = BigDecimal.ZERO;
        if (StringUtils.isNotBlank((String)skus)) {
            List skuList = (List)JsonUtil.buildNormalBinder().getJsonToList(skus, String.class);
            ArrayList<RsSkuDomain> updateSkuList = new ArrayList<RsSkuDomain>();
            int i = 1;
            while (i < skuList.size()) {
                String[] sku = ((String)skuList.get(i)).split(",");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("skuCode", sku[0]);
                map.put("tenantCode", tenantCode);
                RsSkuDomain skuDomain = this.skuRepository.getSku(map);
                skuDomain.setSkuName(sku[1]);
                skuDomain.setPricesetNprice(BigDecimal.valueOf(Double.valueOf(sku[2])));
                skuDomain.setPricesetMakeprice(BigDecimal.valueOf(Double.valueOf(sku[3])));
                skuDomain.setPricesetBaseprice(BigDecimal.valueOf(Double.valueOf(sku[4])));
                skuDomain.setGoodsNum(BigDecimal.valueOf(Double.valueOf(sku[5])));
                skuDomain.setSaleChannel(saleChannel);
                if (skuDomain.getPricesetMakeprice().compareTo(pricesetNprice) == 1) {
                    pricesetNprice = skuDomain.getPricesetMakeprice();
                    rsResourceGoods.setPricesetNprice(pricesetNprice);
                }
                if (pricesetAsprice.compareTo(BigDecimal.ZERO) == 0 || skuDomain.getPricesetMakeprice().compareTo(pricesetAsprice) == -1 && pricesetAsprice.compareTo(BigDecimal.ZERO) != 0) {
                    pricesetAsprice = skuDomain.getPricesetMakeprice();
                    rsResourceGoods.setPricesetAsprice(pricesetAsprice);
                }
                goodsNum = goodsNum.add(skuDomain.getGoodsNum());
                skuDomain.setGoodsNo(sku[6]);
                skuDomain.setSkuBarcode(sku[7]);
                updateSkuList.add(skuDomain);
                ++i;
            }
            rsResourceGoods.setGoodsNum(goodsNum);
            return updateSkuList;
        }
        return null;
    }

    private void setSpecValueList(RsResourceGoodsDomain rsResourceGoods) {
        RsSpecValueDomain specValueDomain;
        int n;
        int n2;
        String[] stringArray;
        ArrayList<RsSpecValueDomain> rsSpecValueList = new ArrayList<RsSpecValueDomain>();
        if (StringUtils.isNotBlank((String)rsResourceGoods.getRadioOption())) {
            String[] radioOption;
            stringArray = radioOption = rsResourceGoods.getRadioOption().trim().split(";");
            n2 = radioOption.length;
            n = 0;
            while (n < n2) {
                String radios = stringArray[n];
                String[] radio = radios.trim().split(",");
                specValueDomain = new RsSpecValueDomain();
                specValueDomain.setSpuCode(rsResourceGoods.getSpuCode());
                specValueDomain.setSpecGroupCode(radio[0]);
                specValueDomain.setSpecCode(radio[1]);
                specValueDomain.setSpecValueValue(radio[2]);
                specValueDomain.setTenantCode(rsResourceGoods.getTenantCode());
                specValueDomain.setSpecValueType("0");
                specValueDomain.setSpecValueFlag("1");
                rsSpecValueList.add(specValueDomain);
                ++n;
            }
            rsResourceGoods.setRsSpecValueList(rsSpecValueList);
        }
        if (StringUtils.isNotBlank((String)rsResourceGoods.getInputOption())) {
            String[] inputOption;
            stringArray = inputOption = rsResourceGoods.getInputOption().trim().split(";");
            n2 = inputOption.length;
            n = 0;
            while (n < n2) {
                String inputs = stringArray[n];
                String[] input = inputs.trim().split(",");
                specValueDomain = new RsSpecValueDomain();
                specValueDomain.setSpuCode(rsResourceGoods.getSpuCode());
                specValueDomain.setSpecGroupCode(input[0]);
                specValueDomain.setSpecCode(input[1]);
                specValueDomain.setSpecValueValue(input[2]);
                specValueDomain.setTenantCode(rsResourceGoods.getTenantCode());
                specValueDomain.setSpecValueType("1");
                specValueDomain.setSpecValueFlag("1");
                rsSpecValueList.add(specValueDomain);
                ++n;
            }
            rsResourceGoods.setRsSpecValueList(rsSpecValueList);
        }
    }
}

