/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.goods.controller;

import com.yqbsoft.laser.html.annotation.Layout;
import com.yqbsoft.laser.html.core.auth.UserSession;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.bm.repository.BaseRepository;
import com.yqbsoft.laser.html.facade.bm.repository.CmsRepository;
import com.yqbsoft.laser.html.facade.esclient.repository.SearchRepository;
import com.yqbsoft.laser.html.facade.exchange.bean.OcContract;
import com.yqbsoft.laser.html.facade.exchange.domian.OcContractGoodsDomain;
import com.yqbsoft.laser.html.facade.exchange.domian.OcPackageDomain;
import com.yqbsoft.laser.html.facade.exchange.repository.ContractRepository;
import com.yqbsoft.laser.html.facade.exchange.repository.ResourceRepository;
import com.yqbsoft.laser.html.facade.fm.repository.FileRepository;
import com.yqbsoft.laser.html.facade.mm.repository.MmUserRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/indent"})
@Layout(frameName="shenruiapplication")
public class ResourceIndentCon
extends SpringmvcController {
    @Autowired
    FileRepository fileRepository;
    @Autowired
    ResourceRepository repository;
    @Autowired
    private CmsRepository cmsRepository;
    @Autowired
    private SearchRepository searchRepository;
    @Autowired
    private ContractRepository contractRepository;
    @Autowired
    private BaseRepository baseRepository;
    @Autowired
    private MmUserRepository userRepository;

    @Autowired
    protected String getContext() {
        return "indent";
    }

    @RequestMapping(value={"index"})
    public String getResource(HttpServletRequest request, ModelMap map, String contractBillcode, String contractTypepro, String contractRemark) {
        UserSession user = this.getUserSession(request);
        Map postmap = HtmlUtil.buildPageMap((HttpServletRequest)request);
        postmap.put("tenantCode", user.getTenantCode());
        postmap.put("memberBcode", user.getUserPcode());
        if (StringUtils.isBlank((String)contractTypepro)) {
            postmap.put("contractTypepro", "2");
        }
        ArrayList<Integer> dataquery = new ArrayList<Integer>();
        dataquery.add(6);
        dataquery.add(7);
        postmap.put("dataList", dataquery);
        postmap.put("order", true);
        SupQueryResult rs = this.contractRepository.queryContractPage(postmap);
        if (rs != null && rs.getList() != null) {
            map.addAttribute("list", (Object)rs.getList());
            map.addAttribute("pageTools", (Object)this.buildPage(rs.getPageTools(), request));
        }
        map.addAttribute("contractBillcode", (Object)contractBillcode);
        map.addAttribute("contractTypepro", (Object)contractTypepro);
        map.addAttribute("contractRemark", (Object)contractRemark);
        return String.valueOf(this.getFtlTempPath(request)) + "index";
    }

    @RequestMapping(value={"goodsReceipt.json"})
    @ResponseBody
    public HtmlJsonReBean goodsReceipt(HttpServletRequest request, String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode)) {
            return new HtmlJsonReBean("error", "\u53c2\u6570\u4e3a\u7a7a");
        }
        UserSession user = this.getUserSession(request);
        HashMap<String, Object> postmap = new HashMap<String, Object>();
        postmap.put("tenantCode", user.getTenantCode());
        postmap.put("contractBillcode", contractBillcode);
        postmap.put("childFlag", true);
        SupQueryResult rs = this.contractRepository.queryContractPage(postmap);
        if (rs == null || rs.getList() == null || rs.getList().size() != 1) {
            return new HtmlJsonReBean("error", "\u8ba2\u5355\u4fe1\u606f\u9519\u8bef");
        }
        OcContract oc = (OcContract)rs.getList().get(0);
        if (oc.getDataState() != 6) {
            return new HtmlJsonReBean("error", "\u8ba2\u5355\u4fe1\u606f\u9519\u8bef");
        }
        String skuCodes = "";
        String goodsNums = "";
        for (OcPackageDomain pack : oc.getPackageList()) {
            if (pack.getContractGoodsList() == null) continue;
            for (OcContractGoodsDomain goods : pack.getContractGoodsList()) {
                skuCodes = String.valueOf(skuCodes) + goods.getGoodsCode() + ",";
                goodsNums = String.valueOf(goodsNums) + goods.getGoodsCamount() + ",";
            }
        }
        this.repository.saveSkuManager(skuCodes, goodsNums, user.getUserPcode(), user.getTenantCode());
        oc.setDataState(Integer.valueOf(7));
        oc.setContractEffectivedate(new Date());
        this.contractRepository.updateContract(oc);
        return this.contractRepository.updateContractDataState(oc.getContractId(), Integer.valueOf(7), Integer.valueOf(6));
    }

    @RequestMapping(value={"getIndentInfo.json"})
    @ResponseBody
    public HtmlJsonReBean contractInfo(HttpServletRequest request, String contractBillcode) {
        UserSession user = this.getUserSession(request);
        HashMap<String, Object> postmap = new HashMap<String, Object>();
        postmap.put("tenantCode", user.getTenantCode());
        postmap.put("contractBillcode", contractBillcode);
        postmap.put("childFlag", true);
        SupQueryResult rs = this.contractRepository.queryContractPage(postmap);
        if (rs == null || rs.getList() == null || rs.getList().size() != 1) {
            return new HtmlJsonReBean((Object)"\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u5237\u65b0\u518d\u8bd5");
        }
        OcContract oc = (OcContract)rs.getList().get(0);
        return new HtmlJsonReBean((Object)oc);
    }
}

