/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.goods.controller;

import com.yqbsoft.laser.html.annotation.Layout;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.facade.bm.repository.BaseRepository;
import com.yqbsoft.laser.html.facade.exchange.bean.RsResourceGoodsDomain;
import com.yqbsoft.laser.html.facade.exchange.bean.RsResourceGoodsReDomain;
import com.yqbsoft.laser.html.facade.exchange.constant.DisChannelEnum;
import com.yqbsoft.laser.html.facade.exchange.constant.GoodsProEnum;
import com.yqbsoft.laser.html.facade.exchange.domian.RsSkuDomain;
import com.yqbsoft.laser.html.facade.exchange.repository.ResourceRepository;
import com.yqbsoft.laser.html.facade.exchange.repository.SkuRepository;
import com.yqbsoft.laser.html.goods.controller.ResourceCon;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jsoup.helper.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/rs/shopresource"})
@Layout(frameName="application")
public class ShopResourceCon
extends SpringmvcController {
    @Autowired
    private BaseRepository baseRepository;
    @Autowired
    private SkuRepository skuRepository;
    @Autowired
    ResourceRepository repository;
    @Autowired
    private ResourceCon resourceCon;

    @Autowired
    protected String getContext() {
        return "shopresource";
    }

    @RequestMapping(value={"getResource"})
    public String getResource(HttpServletRequest request, ModelMap map, Integer goodsId) {
        this.resourceCon.getResource(request, map, goodsId);
        return String.valueOf(this.getFtlTempPath(request)) + "updateResource";
    }

    @RequestMapping(value={"resourcelist"})
    public String resourcelist(HttpServletRequest request, ModelMap map) {
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("memberCode", this.getUserSession(request).getUserPcode());
        pmap.put("channelCode", DisChannelEnum.PLATFORM_GOODS.getCode());
        pmap.put("goodsPro", GoodsProEnum.sp.getCode());
        pmap.put("children", true);
        pmap.put("order", true);
        SupQueryResult<RsResourceGoodsReDomain> supQueryResult = this.resourceCon.queryResourcePage(request, pmap);
        map.addAttribute("resourcelist", (Object)supQueryResult.getList());
        map.addAttribute("pageTools", (Object)this.buildPage(supQueryResult.getPageTools(), request));
        return String.valueOf(this.getFtlTempPath(request)) + "shopresource";
    }

    @RequestMapping(value={"commitResource.json"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean commitResource(HttpServletRequest request, String goodsIds) {
        return this.resourceCon.commitResource(request, goodsIds);
    }

    @RequestMapping(value={"cancelResource.json"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean cancelResource(HttpServletRequest request, String goodsIds) {
        return this.resourceCon.cancelResource(request, goodsIds);
    }

    @RequestMapping(value={"updateSkuprice.json"}, produces={"application/json"})
    @ResponseBody
    public HtmlJsonReBean updateSkuprice(HttpServletRequest request, String skusJson, Integer goodsId) {
        try {
            if (StringUtil.isBlank((String)skusJson) || goodsId == null) {
                return new HtmlJsonReBean("error", "\u53c2\u6570\u4e3a\u7a7a!");
            }
            List skuList = (List)JsonUtil.buildNormalBinder().getJsonToList(skusJson, RsSkuDomain.class);
            if (skuList == null || skuList.isEmpty()) {
                return new HtmlJsonReBean("error", "\u6570\u636e\u4e3a\u7a7a!");
            }
            RsResourceGoodsReDomain resourceGoods = this.repository.getResourceGoodsById(goodsId);
            if (resourceGoods == null) {
                return new HtmlJsonReBean("error", "\u5546\u54c1\u6570\u636e\u4e0d\u5b58\u5728!");
            }
            BigDecimal pricesetNprice = BigDecimal.ZERO;
            BigDecimal pricesetAsprice = BigDecimal.ZERO;
            for (RsSkuDomain rsSkuDomain : skuList) {
                BigDecimal makeprice = rsSkuDomain.getPricesetMakeprice();
                if (makeprice.compareTo(pricesetNprice) == 1) {
                    pricesetNprice = makeprice;
                    resourceGoods.setPricesetNprice(makeprice);
                }
                if (makeprice.compareTo(pricesetAsprice) != -1 && pricesetAsprice.compareTo(BigDecimal.ZERO) != 0) continue;
                pricesetAsprice = makeprice;
                resourceGoods.setPricesetAsprice(makeprice);
            }
            if (skuList.size() == 1) {
                resourceGoods.setPricesetAsprice(resourceGoods.getPricesetNprice());
            }
            this.repository.updateResourceGoods((RsResourceGoodsDomain)resourceGoods);
            return this.skuRepository.updateSkuList(skuList);
        }
        catch (Exception e) {
            return new HtmlJsonReBean("error", "\u64cd\u4f5c\u5f02\u5e38!");
        }
    }
}

