/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.oauthserver.controller;

import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.ar.domain.os.OsOAuthConfigDomain;
import com.yqbsoft.laser.html.facade.ar.repository.os.OsOAuthConfigRepository;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/os/oAuthConfig"})
public class OAuthConfigCon
extends SpringmvcController {
    private static String CODE = "os.oAuthConfig.con";
    @Autowired
    private OsOAuthConfigRepository authConfigRepository;

    protected String getContext() {
        return "oAuthConfig";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(OsOAuthConfigDomain oAuthConfigBean) {
        if (null == oAuthConfigBean) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.authConfigRepository.saveOAuthConfig(oAuthConfigBean);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, String oauthConfigId, ModelMap modelMap) {
        modelMap.put((Object)"oAuthConfigReBean", (Object)this.getOAuthConfig(oauthConfigId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, OsOAuthConfigDomain oAuthConfigBean) {
        if (null == oAuthConfigBean) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.authConfigRepository.updateOAuthConfig(oAuthConfigBean);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, String oauthConfigId) {
        if (StringUtils.isBlank((String)oauthConfigId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.authConfigRepository.deleteOAuthConfig(Integer.valueOf(Integer.parseInt(oauthConfigId)));
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, String oauthConfigId, String dataState, String oldDataState) {
        if (StringUtils.isBlank((String)oauthConfigId) || StringUtils.isBlank((String)dataState) || StringUtils.isBlank((String)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.authConfigRepository.updateOAuthConfigState(oauthConfigId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, String oauthConfigId, ModelMap modelMap) {
        modelMap.put((Object)"oAuthConfigReBean", (Object)this.getOAuthConfig(oauthConfigId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getOAuthConfig(String oauthConfigId) {
        String rs = "{}";
        if (StringUtils.isBlank((String)oauthConfigId)) {
            this.logger.error(CODE + ".getOAuthConfig", (Object)"oauthConfigId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.authConfigRepository.getOAuthConfig(Integer.valueOf(Integer.parseInt(oauthConfigId))));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
            param.put("fuzzy", true);
        }
        return this.authConfigRepository.queryOAuthConfigPage(param);
    }
}

