/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.oauthserver.controller;

import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.facade.ar.domain.os.OsOAuthConfigListDomain;
import com.yqbsoft.laser.html.facade.ar.repository.os.OsOAuthConfigRepository;
import com.yqbsoft.laser.html.oauthserver.bean.OAuthConfigListBean;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/os/oAuthConfigList"})
public class OAuthConfigListCon
extends SpringmvcController {
    private static String CODE = "os.oAuthConfigList.con";
    @Autowired
    private OsOAuthConfigRepository osOAuthConfigRepository;

    protected String getContext() {
        return "oAuthConfigList";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request, OAuthConfigListBean oAuthConfigListBean, ModelMap modelMap) {
        modelMap.put((Object)"oAuthConfigListReBean", (Object)JsonUtil.buildNormalBinder().toJson((Object)oAuthConfigListBean));
        return this.getFtlTempPath(request) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(OsOAuthConfigListDomain oAuthConfigListBean) {
        if (null == oAuthConfigListBean) {
            this.logger.error(CODE + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.osOAuthConfigRepository.saveOAuthConfigList(oAuthConfigListBean);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, String oauthConfigListId, ModelMap modelMap) {
        modelMap.put((Object)"oAuthConfigListReBean", (Object)this.getOAuthConfigList(oauthConfigListId));
        return this.getFtlTempPath(request) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, OsOAuthConfigListDomain oAuthConfigListBean) {
        if (null == oAuthConfigListBean) {
            this.logger.error(CODE + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.osOAuthConfigRepository.updateOAuthConfigList(oAuthConfigListBean);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, String oauthConfigListId) {
        if (StringUtils.isBlank((String)oauthConfigListId)) {
            this.logger.error(CODE + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.osOAuthConfigRepository.deleteOAuthConfigList(Integer.valueOf(oauthConfigListId));
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, String oauthConfigListId, String dataState, String oldDataState) {
        if (StringUtils.isBlank((String)oauthConfigListId) || StringUtils.isBlank((String)dataState) || StringUtils.isBlank((String)oldDataState)) {
            this.logger.error(CODE + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        return this.osOAuthConfigRepository.updateOAuthConfigListState(oauthConfigListId, dataState, oldDataState);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, String oauthConfigListId, ModelMap modelMap) {
        modelMap.put((Object)"oAuthConfigListReBean", (Object)this.getOAuthConfigList(oauthConfigListId));
        return this.getFtlTempPath(request) + "view";
    }

    private String getOAuthConfigList(String oauthConfigListId) {
        String rs = "{}";
        if (StringUtils.isBlank((String)oauthConfigListId)) {
            this.logger.error(CODE + ".getOAuthConfigList", (Object)"oauthConfigListId is null");
        } else {
            rs = JsonUtil.buildNormalBinder().toJson((Object)this.osOAuthConfigRepository.getOAuthConfigList(Integer.valueOf(Integer.parseInt(oauthConfigListId))));
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return this.getFtlTempPath(request) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        SupQueryResult supQueryResult;
        Map param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (null != param) {
            param.put("order", true);
        }
        if (null == (supQueryResult = this.osOAuthConfigRepository.queryOAuthConfigListPage(param))) {
            return null;
        }
        return supQueryResult.getRows();
    }
}

