/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.html.recharge.controller;

import com.yqbsoft.laser.html.common.send.PostParamMap;
import com.yqbsoft.laser.html.core.bean.HtmlJsonReBean;
import com.yqbsoft.laser.html.core.util.HtmlUtil;
import com.yqbsoft.laser.html.recharge.bean.RechargeBean;
import com.yqbsoft.laser.html.springmvc.SpringmvcController;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/web/cp/recharge"})
public class RechargeCon
extends SpringmvcController {
    private static String CODE = "cp.recharge.con";

    protected String getContext() {
        return "recharge";
    }

    @RequestMapping(value={"add"})
    public String add(HttpServletRequest request) {
        return String.valueOf(this.getFtlTempPath(request)) + "add";
    }

    @RequestMapping(value={"addSave.json"})
    @ResponseBody
    public HtmlJsonReBean addSave(RechargeBean rechargeBean) {
        if (rechargeBean == null) {
            this.logger.error(String.valueOf(CODE) + ".addSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PostParamMap pmap = new PostParamMap("cp.recharge.saveRecharge");
        pmap.putParamToJson("cpRechargeDomain", (Object)rechargeBean);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    @RequestMapping(value={"edit"})
    public String edit(HttpServletRequest request, String rechargeId, ModelMap modelMap) {
        modelMap.put((Object)"rechargeReBean", (Object)this.getRecharge(rechargeId));
        return String.valueOf(this.getFtlTempPath(request)) + "edit";
    }

    @RequestMapping(value={"editSave.json"})
    @ResponseBody
    public HtmlJsonReBean editSave(HttpServletRequest request, RechargeBean rechargeBean) {
        if (rechargeBean == null) {
            this.logger.error(String.valueOf(CODE) + ".editSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PostParamMap pmap = new PostParamMap("cp.recharge.updateRecharge");
        pmap.putParamToJson("cpRechargeDomain", (Object)rechargeBean);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    @RequestMapping(value={"delSave.json"})
    @ResponseBody
    public HtmlJsonReBean delSave(HttpServletRequest request, String rechargeId) {
        if (StringUtils.isBlank((String)rechargeId)) {
            this.logger.error(String.valueOf(CODE) + ".delSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PostParamMap pmap = new PostParamMap("cp.recharge.deleteRecharge");
        pmap.putParam("rechargeId", (Object)rechargeId);
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    @RequestMapping(value={"stateSave.json"})
    @ResponseBody
    public HtmlJsonReBean startSave(HttpServletRequest request, String rechargeId, String dataState, String oldDataState) {
        if (StringUtils.isBlank((String)rechargeId) || StringUtils.isBlank((String)dataState) || StringUtils.isBlank((String)oldDataState)) {
            this.logger.error(String.valueOf(CODE) + ".startSave", (Object)"param is null");
            return new HtmlJsonReBean(HtmlJsonReBean.ERRORCODE, "null");
        }
        PostParamMap pmap = new PostParamMap("cp.recharge.updateRechargeState");
        pmap.putParam("rechargeId", (Object)Integer.valueOf(rechargeId));
        pmap.putParam("dataState", (Object)Integer.valueOf(dataState));
        pmap.putParam("oldDataState", (Object)Integer.valueOf(oldDataState));
        return this.htmlIBaseService.sendMesReBean(pmap);
    }

    @RequestMapping(value={"view"})
    public String view(HttpServletRequest request, String rechargeId, ModelMap modelMap) {
        modelMap.put((Object)"rechargeReBean", (Object)this.getRecharge(rechargeId));
        return String.valueOf(this.getFtlTempPath(request)) + "view";
    }

    private String getRecharge(String rechargeId) {
        String rs = "{}";
        if (StringUtils.isBlank((String)rechargeId)) {
            this.logger.error(String.valueOf(CODE) + ".getRecharge", (Object)"rechargeId is null");
        } else {
            PostParamMap pmap = new PostParamMap("cp.recharge.getRecharge");
            pmap.putParam("rechargeId", (Object)rechargeId);
            rs = this.htmlIBaseService.sendMesReJson(pmap);
        }
        return rs;
    }

    @RequestMapping(value={"list"})
    public String list(HttpServletRequest request) {
        return String.valueOf(this.getFtlTempPath(request)) + "list";
    }

    @RequestMapping(value={"listQuery.json"})
    @ResponseBody
    public Object listQuery(HttpServletRequest request) {
        PostParamMap pmap = new PostParamMap("cp.recharge.queryRechargePage");
        HashMap<String, Boolean> param = HtmlUtil.tranMap((Map)request.getParameterMap());
        if (param == null) {
            param = new HashMap<String, Boolean>();
            param.put("tenantCode", (Boolean)((Object)""));
            param.put("appmanageIcode", (Boolean)((Object)ServletMain.getAppName()));
        }
        param.put("order", true);
        param.put("fuzzy", true);
        pmap.putParamToJson("map", param);
        return this.htmlIBaseService.senBySupRq(pmap, (Object)new SupQueryResult());
    }
}

