<#include '/layout/listHead.ftl' />
<table id="rechargeList"></table>
<div id="rechargeList_window" class="easyui-window" closed="true">
</div>
<div id="rechargeList_tb" style="padding:5px;height:auto">
	<div style="margin-bottom:5px">
		<a href="#" class="easyui-linkbutton" id="btnadd" iconCls="icon-add" plain="true" onclick="javascript:rechargeList_add('');" >新增</a>
		<a href="#" class="easyui-linkbutton" id="btnedit" iconCls="icon-edit" plain="true" onclick="javascript:rechargeList_edit('');">修改</a>
		<a href="#" class="easyui-linkbutton" id="btnremove" iconCls="icon-no" plain="true" onclick="javascript:rechargeList_remove('');">删除</a>
		<a href="#" class="easyui-linkbutton" id="btnenable" iconCls="icon-ok" plain="true" onclick="javascript:rechargeList_enable('');">提交</a>
		<a href="#" class="easyui-linkbutton" id="btnmore" iconCls="icon-more" plain="true" onclick="javascript:rechargeList_more('');">查看</a>
	</div>
	<form name="rechargeList_searchform" method="post" action="" id ="rechargeList_searchform">
	<div>
		日期 : <input class="easyui-datebox" data-options="formatter:common_myformatter,parser:common_myparser" name="startDate" style="width:100px">
		To: <input class="easyui-datebox" data-options="formatter:common_myformatter,parser:common_myparser" name="endDate"  style="width:100px">
		流水号: <input class="easyui-textbox" name="rechargeCode"  style="width:100px">
		<a href="#" class="easyui-linkbutton" iconCls="icon-search" onclick="javascript:rechargeList_reload('');">查询</a>
	</div>
	</form>
</div>
<script type="text/javascript">
var _datagrid='rechargeList';
var _windowid='rechargeList_window';

function rechargeList_enable(dataObject){
	$('#btnenable').linkbutton('disable');
	if(!dataObject){
		dataObject = rechargeList_getselected();
	}
	if(!dataObject){
		common_alertInfo("请选择数据");
		$('#btnenable').linkbutton('enable');
		return;
	}
	common_alertConfirm("是否要提交？",function(data){
		if(data){
			var data=new Object();
			data.rechargeId=dataObject.rechargeId;
			data.dataState=1;
			data.oldDataState=0;
			common_ajax(_sysAppContextPath+'/web/cp/recharge/stateSave.json',data,function(data){
		                if(data){
		                common_alertInfo(data.msg);
		                }
		            });
		     $('#btnenable').linkbutton('enable');
		}else{
			$('#btnenable').linkbutton('enable');
			return;
		}
	});
}

function rechargeList_add(dataObject){
	common_window({
		id:_windowid,
		title:'新增',
		href:_sysAppContextPath+'/web/cp/recharge/add'
	});
}
function rechargeList_getselected(){
	return $('#'+_datagrid).datagrid('getSelected');
}
function rechargeList_edit(dataObject){
	$('#btnedit').linkbutton('disable');
	if(!dataObject){
		dataObject = rechargeList_getselected();
	}
	if(!dataObject){
		common_alertInfo("请选择数据");
		$('#btnedit').linkbutton('enable');
		return;
	}
	common_window({
		id:_windowid,
		title:'修改',
		iconCls:'icon-edit',
		href:_sysAppContextPath+'/web/cp/recharge/edit?rechargeId='+dataObject.rechargeId
	});
	$('#btnedit').linkbutton('enable');
}
function rechargeList_more(dataObject){
	$('#btnmore').linkbutton('disable');
	if(!dataObject){
		dataObject = rechargeList_getselected();
	}
	if(!dataObject){
		common_alertInfo("请选择数据");
		$('#btnmore').linkbutton('enable');
		return;
	}
	common_window({
		id:_windowid,
		title:'查看',
		iconCls:'icon-more',
		href:_sysAppContextPath+'/web/cp/recharge/view?rechargeId='+dataObject.rechargeId
	});
	$('#btnmore').linkbutton('enable');
}
function rechargeList_remove(dataObject){
	$('#btnremove').linkbutton('disable');
	if(!dataObject){
		dataObject = rechargeList_getselected();
	}
	if(!dataObject){
		common_alertInfo("请选择数据");
		$('#btnremove').linkbutton('enable');
		return;
	}
	common_alertConfirm("是否要删除？",function(data){
		if(data){
			var data=new Object();
			data.rechargeId=dataObject.rechargeId;
			common_ajax(_sysAppContextPath+'/web/cp/recharge/delSave.json',data,function(data){
		                if(data){
		                common_alertInfo(data.msg);
		                }
		            });
		     $('#btnremove').linkbutton('enable');
		}else{
			$('#btnremove').linkbutton('enable');
			return;
		}
	});
}
function rechargeList_search(dataObject){
	return common_formtojson('rechargeList_searchform');
}
function rechargeList_reload(dataObject){
	$('#'+_datagrid).datagrid('options').queryParams = rechargeList_search(dataObject);  
	$('#'+_datagrid).datagrid('reload');  
}

common_datagrid({
	id:_datagrid,
	url:'listQuery.json',
	btnaddFun:function(dataObject){
		rechargeList_add(dataObject);
	},btneditFun:function(dataObject){
		rechargeList_edit(dataObject);
	},btnremoveFun:function(dataObject){
		rechargeList_remove(dataObject);
	},btnmoreFun:function(dataObject){
		rechargeList_more(dataObject);
	},btnsearchFun:function(dataObject){
		rechargeList_search(dataObject);
	},btnenableFun:function(dataObject){
		rechargeList_enable(dataObject);
	},btndisablesFun:function(dataObject){
		rechargeList_disables(dataObject);
	},
	divtoolbar:'#rechargeList_tb',
	columns:[[
			 {field:'rechargeCode',title:'流水号',width:20},
			 {field:'usercode',title:'用户代码',width:20},
			 {field:'username',title:'用户名称',width:20},
			 {field:'rechargeChannel',title:'充值渠道',width:20},
			 {field:'rechargeName',title:'充值对方名称',width:20},
			 {field:'rechargeMode',title:'充值模式(线上/线下)',width:20},
			 {field:'rechargeType',title:'充值类型',width:20},
			 {field:'rechargeMethod',title:'充值方式(PC/app)',width:20},
			 {field:'rechargeCategory',title:'充值类别(个人/企业)',width:20},
			 {field:'rechargeMoney',title:'充值金额',width:20},
			 {field:'rechargeRemark',title:'充值说明',width:20},
			 {field:'rechargeState',title:'充值状态',width:20},
			 {field:'tenantCode',title:'租户ID',width:20},
			 {field:'appmanageIcode',title:'appcode',width:20}
        ]]
})
</script>
<#include '/layout/listFoot.ftl' />

