<#include '/layout/listHead.ftl' />
<table id="rechargeAuditList"></table>
<div id="rechargeAuditList_window" class="easyui-window" closed="true">
</div>
<div id="rechargeAuditList_tb" style="padding:5px;height:auto">
	<div style="margin-bottom:5px">
		
		<a href="#" class="easyui-linkbutton" id="btnenable" iconCls="icon-ok" plain="true" onclick="javascript:rechargeAuditList_enable('');">审核通过</a>
		<a href="#" class="easyui-linkbutton" id="btndisables" iconCls="icon-remove" plain="true" onclick="javascript:rechargeAuditList_disables('');">审核退回</a>
		<a href="#" class="easyui-linkbutton" id="btnmore" iconCls="icon-more" plain="true" onclick="javascript:rechargeAuditList_more('');">查看</a>
	</div>
	
	<form name="rechargeAuditList_searchform" method="post" action="" id ="rechargeAuditList_searchform">
	<div>
		日期 : <input class="easyui-datebox" data-options="formatter:common_myformatter,parser:common_myparser" name="startDate" style="width:100px">
		To: <input class="easyui-datebox" data-options="formatter:common_myformatter,parser:common_myparser" name="endDate"  style="width:100px">
		流水号: <input class="easyui-textbox" name="rechargeCode"  style="width:100px">
		<a href="#" class="easyui-linkbutton" iconCls="icon-search" onclick="javascript:rechargeAuditList_reload('');">查询</a>
	</div>
	</form>
</div>
<script type="text/javascript">
var _datagrid='rechargeAuditList';
var _windowid='rechargeAuditList_window';

function rechargeAuditList_disables(dataObject){
	$('#btndisables').linkbutton('disable');
	if(!dataObject){
		dataObject = rechargeAuditList_getselected();
	}
	if(!dataObject){
		common_alertInfo("请选择数据");
		$('#btndisables').linkbutton('enable');
		return;
	}
	common_alertConfirm("是否要审核退回？",function(data){
		if(data){
			var data=new Object();
			data.rechargeId=dataObject.rechargeId;
			data.dataState=0;
			data.oldDataState=1;
			common_ajax(_sysAppContextPath+'/web/cp/rechargeAudit/stateSave.json',data,function(data){
		                if(data){
		                common_alertInfo(data.msg);
		                }
		            });
		     $('#btndisables').linkbutton('enable');
		}else{
			$('#btndisables').linkbutton('enable');
			return;
		}
	});
}

function rechargeAuditList_enable(dataObject){
	$('#btnenable').linkbutton('disable');
	if(!dataObject){
		dataObject = rechargeAuditList_getselected();
	}
	if(!dataObject){
		common_alertInfo("请选择数据");
		$('#btnenable').linkbutton('enable');
		return;
	}
	common_alertConfirm("是否要审核通过？",function(data){
		if(data){
			var data=new Object();
			data.rechargeId=dataObject.rechargeId;
			data.dataState=2;
			data.oldDataState=1;
			common_ajax(_sysAppContextPath+'/web/cp/rechargeAudit/stateSave.json',data,function(data){
		                if(data){
		                common_alertInfo(data.msg);
		                }
		            });
		     $('#btnenable').linkbutton('enable');
		}else{
			$('#btnenable').linkbutton('enable');
			return;
		}
	});
}

 
function rechargeAuditList_getselected(){
	return $('#'+_datagrid).datagrid('getSelected');
}
 
function rechargeAuditList_more(dataObject){
	$('#btnmore').linkbutton('disable');
	if(!dataObject){
		dataObject = rechargeAuditList_getselected();
	}
	if(!dataObject){
		common_alertInfo("请选择数据");
		$('#btnmore').linkbutton('enable');
		return;
	}
	common_window({
		id:_windowid,
		title:'查看',
		iconCls:'icon-more',
		href:_sysAppContextPath+'/web/cp/rechargeAudit/view?rechargeId='+dataObject.rechargeId
	});
	$('#btnmore').linkbutton('enable');
}
 
function rechargeAuditList_search(dataObject){
	return common_formtojson('rechargeAuditList_searchform');
}
function rechargeAuditList_reload(dataObject){
	$('#'+_datagrid).datagrid('options').queryParams = rechargeAuditList_search(dataObject);  
	$('#'+_datagrid).datagrid('reload');  
}

common_datagrid({
	id:_datagrid,
	url:'listQuery.json',
	btnaddFun:function(dataObject){
		rechargeAuditList_add(dataObject);
	},btneditFun:function(dataObject){
		rechargeAuditList_edit(dataObject);
	},btnremoveFun:function(dataObject){
		rechargeAuditList_remove(dataObject);
	},btnmoreFun:function(dataObject){
		rechargeAuditList_more(dataObject);
	},btnsearchFun:function(dataObject){
		rechargeAuditList_search(dataObject);
	},btnenableFun:function(dataObject){
		rechargeAuditList_enable(dataObject);
	},btndisablesFun:function(dataObject){
		rechargeAuditList_disables(dataObject);
	},
	divtoolbar:'#rechargeAuditList_tb',
	columns:[[
			 {field:'rechargeCode',title:'流水号',width:20},
			 {field:'usercode',title:'用户代码',width:20},
			 {field:'username',title:'用户名称',width:20},
			 {field:'rechargeChannel',title:'充值渠道',width:20},
			 {field:'rechargeName',title:'充值对方名称',width:20},
			 {field:'rechargeMode',title:'充值模式(线上/线下)',width:20},
			 {field:'rechargeType',title:'充值类型',width:20},
			 {field:'rechargeMethod',title:'充值方式(PC/app)',width:20},
			 {field:'rechargeCategory',title:'充值类别(个人/企业)',width:20},
			 {field:'rechargeMoney',title:'充值金额',width:20},
			 {field:'rechargeRemark',title:'充值说明',width:20},
			 {field:'rechargeState',title:'充值状态',width:20},
			 {field:'tenantCode',title:'租户ID',width:20},
			 {field:'appmanageIcode',title:'appcode',width:20}
        ]]
})
</script>
<#include '/layout/listFoot.ftl' />

