/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.service.impl;

import com.qianjiang.comment.bean.Comment;
import com.qianjiang.customer.bean.CustomerPoint;
import com.qianjiang.customer.dao.CustomerMapper;
import com.qianjiang.customer.dao.CustomerOrderMapper;
import com.qianjiang.customer.dao.CustomerPointMapper;
import com.qianjiang.customer.service.CustomerOrderService;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.mgoods.bean.GoodsBean;
import com.qianjiang.morder.bean.Order;
import com.qianjiang.morder.dao.OrderMapper;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="customerOrderService")
public class CustomerOrderServiceImpl
implements CustomerOrderService {
    private CustomerOrderMapper customerOrderMapper;
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Resource(name="customerMapper")
    private CustomerMapper customerMapper;
    @Resource(name="customerPointMapper")
    private CustomerPointMapper customerPointMapper;
    @Resource(name="OrderMapper2")
    private OrderMapper orderMapper;

    @Override
    public PageBean queryAllMyOrders(Map<String, Object> paramMap, PageBean pb) {
        Long count = this.customerOrderMapper.searchTotalCount(paramMap);
        pb.setRows(Integer.parseInt(count == null ? "0" : count.toString()));
        pb.setPageSize(4);
        paramMap.put("startRowNum", pb.getStartRowNum());
        paramMap.put("endRowNum", pb.getEndRowNum());
        pb.setList(this.customerOrderMapper.queryAllMyOrders(paramMap));
        return pb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object queryOrderByCustIdAndOrderId(Long orderId, Long customerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put("customerId", customerId);
            paramMap.put("orderId", orderId);
            Object object = this.customerOrderMapper.queryOrderByParamMap(paramMap);
            return object;
        }
        finally {
            paramMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> selectNotice(Long customerId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put("customerId", customerId);
            paramMap.put("flag", 0);
            resultMap.put("pendingNum", this.customerOrderMapper.selectpendingOrderNotice(paramMap));
            paramMap.put("flag", 1);
            resultMap.put("commentNum", this.customerOrderMapper.selectpendingOrderNotice(paramMap));
            HashMap<String, Object> hashMap = resultMap;
            return hashMap;
        }
        finally {
            resultMap = null;
            paramMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cancelOrder(Long orderId, String reason) {
        int result = 0;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            Order order;
            paramMap.put("orderId", orderId);
            paramMap.put("reason", reason);
            result = this.customerOrderMapper.cancelOrder(paramMap);
            if (result == 1 && (order = this.orderMapper.orderDetail(orderId)).getOrderIntegral() != null && !"".equals(order.getOrderIntegral())) {
                CustomerPoint point = new CustomerPoint();
                point.setPointDetail("\u8ba2\u5355\u53d6\u6d88\u8fd4\u56de\u79ef\u5206");
                point.setPoint(order.getOrderIntegral().intValue());
                point.setPointType("1");
                point.setDelFlag("0");
                point.setCreateTime(new Date());
                point.setCustomerId(order.getCustomerId());
                this.customerMapper.insertSelective(point);
                if (order.getCustomerId() != null && !"".equals(order.getCustomerId())) {
                    HashMap<String, Object> pointparamMap = new HashMap<String, Object>();
                    pointparamMap.put("customerId", order.getCustomerId());
                    CustomerPoint customerPoint = this.customerMapper.selectCustomerPointByCustomerId(pointparamMap);
                    if (customerPoint != null && customerPoint.getPointSum() != null && !"".equals(customerPoint.getPointSum())) {
                        customerPoint.setPointSum(customerPoint.getPointSum() + order.getOrderIntegral());
                        result = this.customerMapper.updateCustomerPoint(customerPoint);
                    }
                }
            }
        }
        finally {
            paramMap = null;
        }
        return result;
    }

    @Override
    public int comfirmofGoods(Long orderId) {
        return this.customerOrderMapper.comfirmofGoods(orderId);
    }

    @Override
    public int addGoodsComment(Comment comment) {
        return this.customerOrderMapper.addGoodsComment(comment);
    }

    @Override
    public int addGoodsComment(String ip, Comment comment, Long orderId) {
        int flag = 0;
        comment.setIsConsult("0");
        comment.setPublishTime(new Date());
        comment.setIsDisplay("1");
        comment.setDelFlag("0");
        comment.setPublishIp(ip);
        int score = Integer.parseInt(comment.getCommentScore().toString());
        if (score < 2) {
            comment.setCommentType("2");
        } else if (2 <= score && score <= 3) {
            comment.setCommentType("1");
        } else {
            comment.setCommentType("0");
        }
        this.setThirdIdForComment(comment);
        flag = this.customerOrderMapper.addGoodsComment(comment);
        this.customerPointServiceMapper.addIntegralByType(comment.getCustomerId(), "4");
        GoodsBean goodsBean = new GoodsBean();
        goodsBean.setCommentId(comment.getCommentId());
        goodsBean.setEvaluateFlag("1");
        goodsBean.setOrderId(orderId);
        goodsBean.setGoodsId(comment.getGoodsId());
        this.customerOrderMapper.updateOrderGoods(goodsBean);
        return flag;
    }

    private void setThirdIdForComment(Comment comment) {
        comment.setThirdId(this.customerOrderMapper.queryThirdIdByGoodsInfoId(comment.getGoodsId()));
    }

    @Override
    public com.qianjiang.other.bean.GoodsBean selectByOrderIdAndGoodsId(Long customerId, Long goodsId, Long orderId, Long commentId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("customerId", customerId);
        paramMap.put("goodsInfoId", goodsId);
        paramMap.put("orderId", orderId);
        paramMap.put("commentId", commentId);
        return this.customerOrderMapper.selectByOrderIdAndGoodsId(paramMap);
    }

    @Override
    public List<GoodsBean> selectByOrderId(Long orderId) {
        return this.customerOrderMapper.selectByOrderId(orderId);
    }

    @Override
    public Long searchOrderCountByCount(String orderType) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("type", orderType);
        return this.customerOrderMapper.searchTotalCount(paramMap);
    }

    @Override
    public int queryNoMoneyOrderCount(String paramString, String type, Long customerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("paramString", paramString);
        paramMap.put("type", type);
        paramMap.put("customerId", customerId);
        paramMap.put("date", null);
        int count = this.customerOrderMapper.searchTotalCount(paramMap).intValue();
        return count;
    }

    @Override
    public int queryNoShowHuoOrderCount(String paramString, String type, Long customerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("paramString", paramString);
        paramMap.put("type", type);
        paramMap.put("customerId", customerId);
        paramMap.put("date", null);
        int count = this.customerOrderMapper.searchTotalCount(paramMap).intValue();
        return count;
    }

    @Override
    public int queryNoCommentOrderCount(String paramString, String type, Long customerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("paramString", paramString);
        paramMap.put("type", type);
        paramMap.put("customerId", customerId);
        paramMap.put("date", null);
        int count = this.customerOrderMapper.searchTotalCount(paramMap).intValue();
        return count;
    }

    @Override
    public int queryCancleOrderCount(String paramString, String type, Long customerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("paramString", paramString);
        paramMap.put("type", type);
        paramMap.put("customerId", customerId);
        int count = this.customerOrderMapper.searchTotalCount(paramMap).intValue();
        return count;
    }

    public CustomerOrderMapper getCustomerOrderMapper() {
        return this.customerOrderMapper;
    }

    @Resource(name="customerOrderMapperM")
    public void setCustomerOrderMapper(CustomerOrderMapper customerOrderMapper) {
        this.customerOrderMapper = customerOrderMapper;
    }

    public CustomerPointServiceMapper getCustomerPointServiceMapper() {
        return this.customerPointServiceMapper;
    }

    @Resource(name="customerPointServiceMapper")
    public void setCustomerPointServiceMapper(CustomerPointServiceMapper customerPointServiceMapper) {
        this.customerPointServiceMapper = customerPointServiceMapper;
    }
}

