/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.bean.CustomerPointLevel;
import com.qianjiang.customer.dao.CustomerMapper;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.CustomerService;
import com.qianjiang.customer.vo.CustomerAllInfo;
import com.qianjiang.other.bean.OrderInfoBean;
import com.qianjiang.system.bean.SMSConf;
import com.qianjiang.system.bean.SMSModel;
import com.qianjiang.system.dao.SMSConfMapper;
import com.qianjiang.system.dao.SMSModelMapper;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.sms.SmsUtil;
import com.qianjiang.utils.SecurityUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customerServiceM")
public class CustomerServiceImpl
implements CustomerService {
    private static final String UTYPE = "uType";
    public static final MyLogger LOGGER = new MyLogger(CustomerServiceImpl.class);
    private CustomerMapper customerMapper;
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Autowired
    private SMSConfMapper smsConfMapper;
    @Autowired
    private SMSModelMapper smsModelMapper;

    @Override
    public CustomerAllInfo selectByPrimaryKey(Long customerId) {
        CustomerAllInfo customerAllInfo = this.customerMapper.selectByPrimaryKey(customerId);
        if (null != customerAllInfo) {
            customerAllInfo.setInfoPointSum(this.customerPointServiceMapper.getCustomerAllPoint(customerId + ""));
            CustomerPointLevel customerPointLevel = this.customerPointServiceMapper.getCustomerPointLevelByPoint(customerAllInfo.getInfoPointSum());
            if (null != customerPointLevel) {
                customerAllInfo.setPointLevelName(customerPointLevel.getPointLevelName());
            }
        }
        return customerAllInfo;
    }

    @Override
    public Map sendPost(String mobile, String sessionCodeName, String sessionMobileName) {
        LOGGER.info("\u8c03\u7528\u53d1\u9001\u77ed\u4fe1\u63a5\u53e3\u5f00\u59cb param mobile[" + mobile + "]");
        String code = SmsUtil.getCode();
        JSONObject modelParam = new JSONObject();
        modelParam.put("code", (Object)code);
        String smsModelType = "1";
        HashMap<String, Object> codeMap = new HashMap<String, Object>();
        try {
            LOGGER.info("\u67e5\u8be2\u963f\u91cc\u5927\u4e8e\u77ed\u4fe1\u901a\u77e5\u8bbe\u7f6e");
            SMSConf smsConf = this.smsConfMapper.querySmsConf();
            if (smsConf == null || smsConf != null && "0".equals(smsConf.getSmsIsOpen())) {
                return codeMap;
            }
            String smsAppKey = smsConf.getSmsAppKey();
            String smsSerect = smsConf.getSmsSerect();
            String smsSign = smsConf.getSmsSign();
            String smsVersion = smsConf.getSmsVersion();
            SMSModel smsModel = this.smsModelMapper.querySmsModelByModelType(smsModelType);
            String smsModelId = smsModel.getSmsModelId().trim();
            LOGGER.info("\u5f00\u59cb\u53d1\u9001\u77ed\u4fe1mobile[" + mobile + "];\u9a8c\u8bc1\u7801\u662f[" + code + "]");
            boolean isSuccess = false;
            if ("0".equals(smsVersion)) {
                isSuccess = SmsUtil.sendMsgCode((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (JSONObject)modelParam, (String)smsModelType, (String)mobile);
            } else if ("1".equals(smsVersion)) {
                isSuccess = SmsUtil.sendSms((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (JSONObject)modelParam, (String)smsModelType, (String)mobile);
            }
            if (isSuccess) {
                LOGGER.info("\u53d1\u9001\u77ed\u4fe1\u6210\u529f");
                codeMap.put("isSuccess", 1);
                if (!StringUtils.isEmpty((String)sessionCodeName)) {
                    codeMap.put(sessionCodeName, code);
                } else {
                    codeMap.put("mcCode", code);
                }
                if (!StringUtils.isEmpty((String)sessionMobileName)) {
                    codeMap.put(sessionMobileName, mobile);
                } else {
                    codeMap.put("userMobile", mobile);
                }
                return codeMap;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25" + e);
        }
        LOGGER.info("\u53d1\u9001\u77ed\u4fe1\u5931\u8d25");
        return codeMap;
    }

    @Override
    public int getMCode(String mcCode, String code) {
        if (code.equals(mcCode)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int updateCusomerPwd(String userMobile, String userKey) {
        CustomerAllInfo allInfo = new CustomerAllInfo();
        allInfo.setInfoMobile(userMobile);
        allInfo.setCustomerPassword(userKey);
        int result = this.customerMapper.updateCusomerPwd(allInfo);
        return result;
    }

    @Override
    public PageBean selectAllCustomerPoint(Long customerId, PageBean pb, Long date, String type) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("customerId", customerId);
        paramMap.put("date", date);
        paramMap.put("pointType", type);
        int count = this.customerMapper.queryPointMCount(paramMap).intValue();
        if (count > 0) {
            pb.setRows(count);
        } else {
            pb.setRows(0);
        }
        pb.setPageSize(15);
        paramMap.put("startRowNum", 0);
        paramMap.put("endRowNum", count);
        pb.setList(this.customerMapper.queryAllPointMList(paramMap));
        return pb;
    }

    public CustomerMapper getCustomerMapper() {
        return this.customerMapper;
    }

    @Resource(name="customerMapper")
    public void setCustomerMapper(CustomerMapper customerMapper) {
        this.customerMapper = customerMapper;
    }

    public CustomerPointServiceMapper getCustomerPointServiceMapper() {
        return this.customerPointServiceMapper;
    }

    @Resource(name="customerPointServiceMapper")
    public void setCustomerPointServiceMapper(CustomerPointServiceMapper customerPointServiceMapper) {
        this.customerPointServiceMapper = customerPointServiceMapper;
    }

    @Override
    public int updateCustomer(Customer customer) {
        return this.customerMapper.updateByPrimaryKeySelective(customer);
    }

    @Override
    public int updateCustomerInfo(CustomerAllInfo customer) {
        return this.customerMapper.updateCustomerInfo(customer);
    }

    @Override
    public Map<String, Object> modifyPassword(long customerId, String password, String newPassword) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        int retTag = 0;
        CustomerAllInfo customerInfo = this.customerMapper.selectByPrimaryKey(customerId);
        String encodePwd = SecurityUtil.getStoreLogpwd(customerInfo.getUniqueCode(), password, customerInfo.getSaltVal());
        if (!encodePwd.equals(customerInfo.getCustomerPassword())) {
            paramMap.put("retTag", 2);
        } else {
            String newPwd = SecurityUtil.getStoreLogpwd(customerInfo.getUniqueCode(), newPassword, customerInfo.getSaltVal());
            Customer cus = new Customer();
            cus.setCustomerId(customerInfo.getCustomerId());
            cus.setCustomerPassword(newPwd);
            paramMap.put("newPwd", newPwd);
            retTag = this.customerMapper.updateByPrimaryKeySelective(cus);
            paramMap.put("retTag", retTag);
        }
        return paramMap;
    }

    @Override
    public Map<String, Object> modifyPayPassword(long customerId, String password, String newPassword) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        int retTag = 0;
        CustomerAllInfo customerInfo = this.customerMapper.selectByPrimaryKey(customerId);
        String encodePwd = SecurityUtil.getStoreLogpwd(customerInfo.getUniqueCode(), password, customerInfo.getSaltVal());
        if (!encodePwd.equals(customerInfo.getPayPassword())) {
            paramMap.put("retTag", 2);
        } else {
            String newPwd = SecurityUtil.getStoreLogpwd(customerInfo.getUniqueCode(), newPassword, customerInfo.getSaltVal());
            Customer cus = new Customer();
            cus.setCustomerId(customerInfo.getCustomerId());
            cus.setPayPassword(newPwd);
            cus.setPaypwdFlag(1L);
            paramMap.put("newPwd", newPwd);
            retTag = this.customerMapper.updateByPrimaryKeySelective(cus);
            paramMap.put("retTag", retTag);
        }
        return paramMap;
    }

    @Override
    public BigDecimal queryCustomerPointDiscountByCustId(Long customerId) {
        return this.customerMapper.queryCustomerPointDiscountByCustId(customerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrderInfoBean queryOrderByCustIdAndOrderId(Long orderId, Long customerId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            paramMap.put("customerId", customerId);
            paramMap.put("orderId", orderId);
            OrderInfoBean orderInfoBean = this.customerMapper.queryOrderByParamMap(paramMap);
            return orderInfoBean;
        }
        finally {
            paramMap = null;
        }
    }

    @Override
    public int checkIdentity(String patchca, Long customerId, String valiCode, String password) {
        if (valiCode != null && !"".equals(valiCode) && !patchca.equals(valiCode)) {
            return 2;
        }
        CustomerAllInfo customerInfo = this.customerMapper.selectByPrimaryKey(customerId);
        String newPwd = SecurityUtil.getStoreLogpwd(customerInfo.getUniqueCode(), password, customerInfo.getSaltVal());
        if (!newPwd.equals(customerInfo.getCustomerPassword())) {
            return 3;
        }
        return 1;
    }

    @Override
    public Customer selectCustomerByNamePwd(Map<String, Object> paramMap) {
        return this.customerMapper.selectCustomerByNamePwd(paramMap);
    }

    @Override
    public Map sendPayCode(Long customerId) {
        String code = SmsUtil.getCode();
        JSONObject modelParam = new JSONObject();
        modelParam.put("code", (Object)code);
        String smsModelType = "1";
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            CustomerAllInfo customerAllInfo = this.customerMapper.selectByPrimaryKey(customerId);
            if (customerAllInfo == null || StringUtils.isEmpty((String)customerAllInfo.getInfoMobile())) {
                return resultMap;
            }
            SMSConf smsConf = this.smsConfMapper.querySmsConf();
            if (smsConf == null || smsConf != null && "0".equals(smsConf.getSmsIsOpen())) {
                return resultMap;
            }
            String smsAppKey = smsConf.getSmsAppKey();
            String smsSerect = smsConf.getSmsSerect();
            String smsSign = smsConf.getSmsSign();
            String smsVersion = smsConf.getSmsVersion();
            SMSModel smsModel = this.smsModelMapper.querySmsModelByModelType(smsModelType);
            String smsModelId = smsModel.getSmsModelId();
            boolean isSuccess = false;
            if ("0".equals(smsVersion)) {
                isSuccess = SmsUtil.sendMsgCode((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (JSONObject)modelParam, (String)smsModelType, (String)customerAllInfo.getInfoMobile());
            } else if ("1".equals(smsVersion)) {
                isSuccess = SmsUtil.sendSms((String)smsAppKey, (String)smsSerect, (String)smsSign, (String)smsModelId, (JSONObject)modelParam, (String)smsModelType, (String)customerAllInfo.getInfoMobile());
            }
            if (isSuccess) {
                resultMap.put("payCode", code);
                resultMap.put("userMobile", customerAllInfo.getInfoMobile());
                return resultMap;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("", e);
        }
        return resultMap;
    }

    @Override
    @Transactional
    public int addCustomer(CustomerAllInfo allinfo) {
        if (allinfo.getCustomerNickname() == null) {
            allinfo.setCustomerNickname(allinfo.getCustomerUsername());
        }
        allinfo.setInfoMobile(allinfo.getCustomerUsername());
        allinfo.setCustomerNickname(allinfo.getCustomerUsername());
        allinfo.setCustomerUsername(allinfo.getCustomerUsername());
        UUID uuid = UUID.randomUUID();
        allinfo.setLoginKey(uuid.toString());
        return this.customerMapper.addCustomer(allinfo);
    }

    @Override
    public int countFans(Long customerId) {
        return this.customerMapper.countFans(customerId).intValue();
    }

    @Override
    public PageBean listMyFans(Long customerId, PageBean pb) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("customerId", customerId);
        int count = this.customerMapper.countFans(customerId).intValue();
        if (count > 0) {
            pb.setRows(count);
        } else {
            pb.setRows(0);
        }
        pb.setPageSize(5);
        paramMap.put("startRowNum", 0);
        paramMap.put("endRowNum", count);
        pb.setList(this.customerMapper.listMyFans(paramMap));
        return pb;
    }

    @Override
    public Customer selectCustomerImgByCustomerId(Long customerId) {
        Customer customer = new Customer();
        String customerImg = this.customerMapper.selectCustomerImgByCustomerId(customerId);
        if (StringUtils.isNotBlank((String)customerImg)) {
            customer.setCustomerImg(customerImg);
            return customer;
        }
        return null;
    }

    @Override
    public Customer selectCustomerPartInfoByCustomeId(Long customerId) {
        return this.customerMapper.queryCustomerById(customerId);
    }

    @Override
    public int updateCustomerTotalPrice(Map<String, Object> map) {
        return this.customerMapper.updateCustomerTotalPrice(map);
    }
}

