/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.service.impl;

import com.qianjiang.customer.bean.WxBill;
import com.qianjiang.customer.dao.WxBillMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.customer.service.WxBillService;
import com.qianjiang.system.bean.Pay;
import com.qianjiang.system.dao.PayMapper;
import com.qianjiang.util.MapUtil;
import com.qianjiang.util.PageBean;
import com.qianjiang.utils.HttpUtil;
import com.qianjiang.utils.PayCommonUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wxBillServiceImpl")
public class WxBillServiceImpl
implements WxBillService {
    private static Logger logger = Logger.getLogger(WxBillServiceImpl.class);
    @Autowired
    private WxBillMapper wxBillMapper;
    @Autowired
    private PayMapper payMapper;
    @Autowired
    private CustomerServiceMapper customerServiceMapper;
    private PayCommonUtil payCommonUtil;
    private HttpUtil httpUtil;

    @Override
    public int addWxBill(WxBill wxBill) {
        return this.wxBillMapper.addWxBill(wxBill);
    }

    public void timedByWxBill() {
        logger.debug((Object)"--------\u5f00\u59cb\u6267\u884c\u8c03\u7528\u5fae\u4fe1\u8d26\u5355\u63a5\u53e3----------------");
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, -1);
        date = calendar.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        String dateString = formatter.format(date);
        int buildRandom = PayCommonUtil.buildRandom(10);
        String nonce_str = buildRandom + "";
        Pay pay = this.payMapper.selectByPrimaryKey(Long.valueOf(37L));
        String appid = pay.getApiKey();
        String mch_id = pay.getPartner();
        String key = pay.getPartnerKey();
        TreeMap<Object, Object> packageParams = new TreeMap<Object, Object>();
        packageParams.put("appid", appid);
        packageParams.put("bill_date", dateString);
        packageParams.put("bill_type", "ALL");
        packageParams.put("mch_id", mch_id);
        packageParams.put("nonce_str", nonce_str);
        String sign = PayCommonUtil.createSign("UTF-8", packageParams, key);
        TreeMap<Object, Object> params = new TreeMap<Object, Object>();
        packageParams.put("appid", appid);
        params.put("bill_date", dateString);
        params.put("bill_type", "ALL");
        packageParams.put("mch_id", mch_id);
        params.put("nonce_str", nonce_str);
        params.put("sign", sign);
        String requestXml = PayCommonUtil.getRequestXml(params);
        String postData = HttpUtil.postData("https://api.mch.weixin.qq.com/pay/downloadbill", requestXml, null);
        ArrayList<WxBill> list = new ArrayList<WxBill>();
        try {
            if (postData != null) {
                String[] split = postData.split("\n");
                for (int i = 1; i < split.length - 2; ++i) {
                    String back_status;
                    String trade_status;
                    String bill_price;
                    String goods_name;
                    String me_code;
                    String wx_code;
                    String[] split2 = split[i].split(",");
                    WxBill wxBill = new WxBill();
                    String trade_date = split2[0].substring(1);
                    if (!trade_date.equals("")) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        Date tradedate = sdf.parse(trade_date);
                        wxBill.setTradeDate(tradedate);
                    }
                    if (!(wx_code = split2[5].substring(1)).equals("")) {
                        wxBill.setWxCode(wx_code);
                    }
                    if (!(me_code = split2[6].substring(1)).equals("")) {
                        wxBill.setMeCode(me_code);
                    }
                    if (!(goods_name = split2[20].substring(1)).equals("")) {
                        wxBill.setGoodsName(goods_name);
                    }
                    if (!(bill_price = split2[12].substring(1)).equals("")) {
                        wxBill.setBillPrice(new BigDecimal(bill_price));
                    }
                    if (!(trade_status = split2[9].substring(1)).equals("")) {
                        wxBill.setTradeStatus(trade_status);
                        if ("SUCCESS".equals(trade_status)) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            Date success_date = sdf.parse(trade_date);
                            wxBill.setSuccessDate(success_date);
                        }
                    }
                    if (!(back_status = split2[19].substring(1)).equals("")) {
                        wxBill.setBackStatus(back_status);
                        if ("SUCCESS".equals(back_status)) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            Date back_date = sdf.parse(trade_date);
                            wxBill.setBackDate(back_date);
                            wxBill.setWxBackcode(split2[14].substring(1));
                            wxBill.setMeBackcode(split2[15].substring(1));
                            wxBill.setBillPrice(new BigDecimal(split2[16].substring(1)));
                        }
                    }
                    list.add(wxBill);
                }
                int rows = this.customerServiceMapper.addWxBill(list);
                if (rows == 1) {
                    logger.debug((Object)"--------\u5bfc\u5165\u5fae\u4fe1\u8d26\u5355\u5230\u6570\u636e\u5e93\u6210\u529f----------------");
                    System.out.println("-------------------------------OK-------------------------------");
                } else {
                    logger.debug((Object)"--------\u5bfc\u5165\u5fae\u4fe1\u8d26\u5355\u5230\u6570\u636e\u5e93\u5931\u8d25----------------");
                }
                logger.debug((Object)"--------\u7ed3\u675f\u6267\u884c\u8c03\u7528\u5fae\u4fe1\u8d26\u5355\u63a5\u53e3----------------");
            } else {
                logger.debug((Object)"--------\u65e0\u8d26\u5355\u4fe1\u606f----------------");
            }
        }
        catch (Exception e) {
            logger.debug((Object)"--------\u65e0\u8d26\u5355\u4fe1\u606f----------------");
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, Object> selectWxBillList(WxBill wxBill, PageBean pageBean) {
        Map paramMap = MapUtil.getParamsMap((Object)wxBill);
        HashMap<String, Object> map = new HashMap<String, Object>();
        paramMap.put("start", pageBean.getStartRowNum());
        paramMap.put("number", pageBean.getEndRowNum());
        List<Object> obj = this.wxBillMapper.searchBillList(paramMap);
        int count = this.wxBillMapper.searchBillCount(paramMap);
        pageBean.setRows(count);
        pageBean.setList(obj);
        map.put("pageBean", pageBean);
        return map;
    }

    @Override
    public WxBill selectSumWxBill() {
        return this.wxBillMapper.selectSumWxBill();
    }

    @Override
    public int checkRepeat(WxBill bill) {
        return this.wxBillMapper.checkRepeat(bill);
    }
}

