/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.utils;

import com.qianjiang.util.MyLogger;
import com.qianjiang.utils.UUID;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public abstract class UIDFactory {
    public static final MyLogger LOGGER = new MyLogger(UIDFactory.class);
    public static final String UID_GUID = "GUID";
    public static final String UID_UUID = "UUID";
    protected static final long EPOCH = System.currentTimeMillis();
    protected static final long JVMHASH = Integer.MIN_VALUE;
    protected static final long MACHINEID = UIDFactory.getMachineID();
    protected static final Random M_RANDOM = new Random(EPOCH);
    private static MessageDigest md5;
    private boolean isMd5 = false;

    public static UIDFactory getDefault() {
        return UUID.getInstance();
    }

    public static UIDFactory getInstance(String uidfactory) throws Exception {
        if (uidfactory.equalsIgnoreCase(UID_UUID)) {
            return UUID.getInstance();
        }
        throw new Exception(uidfactory + " Not Found!");
    }

    public abstract String getNextUID();

    public abstract String getUID();

    public boolean isMD5() {
        return this.isMd5;
    }

    public void setMD5(boolean flag) {
        this.isMd5 = flag;
    }

    public abstract void setUID(String var1) throws Exception;

    public abstract String toPrintableString();

    protected static byte[] toMD5(byte[] bytes) {
        return md5.digest(bytes);
    }

    private static long getMachineID() {
        long i = 0L;
        try {
            InetAddress inetaddress = InetAddress.getLocalHost();
            byte[] abyte0 = inetaddress.getAddress();
            i = UIDFactory.toInt(abyte0);
        }
        catch (Exception ex) {
            LOGGER.info(ex);
        }
        return i;
    }

    private static int toInt(byte[] abyte0) {
        int i = abyte0[0] << 24 & 0xFF000000 | abyte0[1] << 16 & 0xFF0000 | abyte0[2] << 8 & 0xFF00 | abyte0[3] & 0xFF;
        return i;
    }

    static {
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.info(ex);
        }
    }
}

